/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.XmlValidatorParser;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.jena.N3Parser;
import org.apache.juneau.jena.N3Serializer;
import org.apache.juneau.jena.NTripleParser;
import org.apache.juneau.jena.NTripleSerializer;
import org.apache.juneau.jena.RdfXmlAbbrevSerializer;
import org.apache.juneau.jena.RdfXmlParser;
import org.apache.juneau.jena.RdfXmlSerializer;
import org.apache.juneau.jena.TurtleParser;
import org.apache.juneau.jena.TurtleSerializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xmlschema.XmlSchemaSerializer;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class RoundTripTest {
    protected Serializer s;
    protected Parser p;
    private boolean validateXmlWhitespace;
    protected boolean returnOriginalObject;
    private boolean validateXml;
    protected String label;
    public boolean debug = false;

    @Parameterized.Parameters
    public static Collection<Object[]> getPairs() {
        return Arrays.asList({"Json - default", JsonSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), JsonParser.create(), 0}, {"Json - lax", JsonSerializer.create().ssq().trimNullProperties(false).addBeanTypes().addRootType(), JsonParser.create(), 0}, {"Json - lax, readable", JsonSerializer.create().ssq().ws().trimNullProperties(false).addBeanTypes().addRootType(), JsonParser.create(), 0}, {"Xml - namespaces, validation, readable", XmlSerializer.create().ns().sq().trimNullProperties(false).addNamespaceUrisToRoot().useWhitespace().addBeanTypes().addRootType(), XmlParser.create(), Flags.CHECK_XML_WHITESPACE | Flags.VALIDATE_XML}, {"Xml - no namespaces, validation", XmlSerializer.create().sq().trimNullProperties(false).addBeanTypes().addRootType(), XmlParser.create(), Flags.CHECK_XML_WHITESPACE}, {"Html - default", HtmlSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), HtmlParser.create(), Flags.CHECK_XML_WHITESPACE}, {"Html - readable", HtmlSerializer.create().sq().ws().trimNullProperties(false).addBeanTypes().addRootType(), HtmlParser.create(), Flags.CHECK_XML_WHITESPACE}, {"Html - with key/value headers", HtmlSerializer.create().addKeyValueTableHeaders().addBeanTypes().addRootType(), HtmlParser.create(), Flags.CHECK_XML_WHITESPACE}, {"Uon - default", UonSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), UonParser.create(), 0}, {"Uon - readable", UonSerializer.create().ws().trimNullProperties(false).addBeanTypes().addRootType(), UonParser.create(), 0}, {"Uon - encoded", UonSerializer.create().encoding().trimNullProperties(false).addBeanTypes().addRootType(), UonParser.create().decoding(), 0}, {"UrlEncoding - default", UrlEncodingSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), UrlEncodingParser.create(), 0}, {"UrlEncoding - readable", UrlEncodingSerializer.create().ws().trimNullProperties(false).addBeanTypes().addRootType(), UrlEncodingParser.create(), 0}, {"UrlEncoding - expanded params", UrlEncodingSerializer.create().expandedParams().addBeanTypes().addRootType(), UrlEncodingParser.create().expandedParams(true), 0}, {"Rdf.Xml", RdfXmlSerializer.create().trimNullProperties(false).addLiteralTypes().addBeanTypes().addRootType(), RdfXmlParser.create(), 0}, {"Rdf.XmlAbbrev", RdfXmlAbbrevSerializer.create().trimNullProperties(false).addLiteralTypes().addBeanTypes().addRootType(), RdfXmlParser.create(), 0}, {"Rdf.Turtle", TurtleSerializer.create().trimNullProperties(false).addLiteralTypes().addBeanTypes().addRootType(), TurtleParser.create(), 0}, {"Rdf.NTriple", NTripleSerializer.create().trimNullProperties(false).addLiteralTypes().addBeanTypes().addRootType(), NTripleParser.create(), 0}, {"Rdf.N3", N3Serializer.create().trimNullProperties(false).addLiteralTypes().addBeanTypes().addRootType(), N3Parser.create(), 0}, {"MsgPack", MsgPackSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), MsgPackParser.create(), 0}, {"Json schema", JsonSchemaSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), null, Flags.RETURN_ORIGINAL_OBJECT}, {"Xml schema", XmlSchemaSerializer.create().trimNullProperties(false).addBeanTypes().addRootType(), XmlValidatorParser.create(), Flags.RETURN_ORIGINAL_OBJECT | Flags.CHECK_XML_WHITESPACE});
    }

    public RoundTripTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        this.label = label;
        Map m = this.getImplClasses();
        if (m != null) {
            for (Map.Entry e : m.entrySet()) {
                s.implClass(e.getKey(), e.getValue());
                if (p == null) continue;
                p.implClass(e.getKey(), e.getValue());
            }
        }
        this.s = s.beanFilters((Class[])this.getBeanFilters()).pojoSwaps((Class[])this.getPojoSwaps()).dictionary((Object[])this.getDictionary()).add((Map)this.getProperties()).build();
        this.p = p == null ? null : p.beanFilters((Class[])this.getBeanFilters()).pojoSwaps((Class[])this.getPojoSwaps()).dictionary((Object[])this.getDictionary()).add((Map)this.getProperties()).build();
        this.validateXmlWhitespace = (flags & Flags.CHECK_XML_WHITESPACE) > 0;
        this.validateXml = (flags & Flags.VALIDATE_XML) > 0;
        this.returnOriginalObject = (flags & Flags.RETURN_ORIGINAL_OBJECT) > 0;
    }

    public Class<?>[] getBeanFilters() {
        return new Class[0];
    }

    public Class<?>[] getPojoSwaps() {
        return new Class[0];
    }

    public Class<?>[] getDictionary() {
        return new Class[0];
    }

    public ObjectMap getProperties() {
        return ObjectMap.EMPTY_MAP;
    }

    public <T> Map<Class<T>, Class<? extends T>> getImplClasses() {
        return null;
    }

    public <T> T roundTrip(T object, Type c, Type ... args) throws Exception {
        Object out = this.serialize(object, this.s);
        if (this.p == null) {
            return object;
        }
        Object o = this.p.parse(out, c, args);
        return (T)(this.returnOriginalObject ? object : o);
    }

    public <T> T roundTrip(T object) throws Exception {
        return this.roundTrip(object, this.s, this.p);
    }

    public <T> T roundTrip(T object, Serializer serializer, Parser parser) throws Exception {
        Object out = this.serialize(object, serializer);
        if (parser == null) {
            return object;
        }
        Object o = parser.parse(out, object == null ? Object.class : object.getClass(), new Type[0]);
        return (T)(this.returnOriginalObject ? object : o);
    }

    public Serializer getSerializer() {
        return this.s;
    }

    public Parser getParser() {
        return this.p;
    }

    protected void beanFilters(Class<?> ... c) {
        this.s = this.s.builder().beanFilters((Class[])c).build();
        if (this.p != null) {
            this.p = this.p.builder().beanFilters((Class[])c).build();
        }
    }

    protected void pojoSwaps(Class<?> ... c) {
        this.s = this.s.builder().pojoSwaps((Class[])c).build();
        if (this.p != null) {
            this.p = this.p.builder().pojoSwaps((Class[])c).build();
        }
    }

    protected void dictionary(Object ... c) {
        this.s = this.s.builder().dictionary(c).build();
        if (this.p != null) {
            this.p = this.p.builder().dictionary(c).build();
        }
    }

    protected void applyAnnotations(Class<?> ... fromClasses) {
        this.s = this.s.builder().applyAnnotations((Class[])fromClasses).build();
        if (this.p != null) {
            this.p = this.p.builder().applyAnnotations((Class[])fromClasses).build();
        }
    }

    public boolean isValidationOnly() {
        return this.returnOriginalObject;
    }

    public <T> Object serialize(T object, Serializer s) throws Exception {
        Object out = null;
        out = s.isWriterSerializer() ? ((WriterSerializer)s).serialize(object) : (Object)((OutputStreamSerializer)s).serialize(object);
        if (this.debug) {
            System.err.println("Serialized contents from [" + this.label + "]...\n---START---\n" + (out instanceof byte[] ? TestUtils.toReadableBytes((byte[])out) : out) + "\n---END---\n");
        }
        if (this.validateXmlWhitespace) {
            TestUtils.checkXmlWhitespace(out.toString());
        }
        if (this.validateXml) {
            TestUtils.validateXml(object, (XmlSerializer)s);
        }
        return out;
    }

    public static class Flags {
        public static int CHECK_XML_WHITESPACE = 1;
        public static int VALIDATE_XML = 2;
        public static int SERIALIZE_SCHEMA = 4;
        public static int RETURN_ORIGINAL_OBJECT = 8;
    }
}

