/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripSimpleObjectsTest
extends RoundTripTest {
    public RoundTripSimpleObjectsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testNull() throws Exception {
        String t = null;
        t = this.roundTrip(t);
        Assert.assertNull((Object)t);
    }

    @Test
    public void testOptional() throws Exception {
        Optional o = Optional.empty();
        o = this.roundTrip(o);
        Assert.assertFalse((boolean)o.isPresent());
    }

    @Test
    public void testString() throws Exception {
        String t = "foobar";
        t = this.roundTrip(t);
        Assert.assertEquals((Object)"foobar", (Object)t);
        t = "";
        t = this.roundTrip(t);
        Assert.assertEquals((Object)"", (Object)t);
    }

    @Test
    public void testOptionalContainingString() throws Exception {
        Optional<String> o = Optional.of("foobar");
        o = this.roundTrip(o);
        Assert.assertEquals((Object)"foobar", (Object)o.get());
        o = Optional.of("");
        o = this.roundTrip(o);
        Assert.assertEquals((Object)"", (Object)o.get());
    }

    @Test
    public void testStringArray() throws Exception {
        String[] t = new String[]{"foo", null, "null", ""};
        t = this.roundTrip(t, (Type)((Object)String[].class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t[0]);
        Assert.assertNull((Object)t[1]);
        Assert.assertEquals((Object)"null", (Object)t[2]);
        Assert.assertEquals((Object)"", (Object)t[3]);
    }

    @Test
    public void testString2dArray() throws Exception {
        String[][] t = new String[][]{{"foo", null, "null", ""}, null};
        t = this.roundTrip(t, (Type)((Object)String[][].class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertEquals((Object)"null", (Object)t[0][2]);
        Assert.assertEquals((Object)"", (Object)t[0][3]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testInt() throws Exception {
        int t = 123;
        t = this.roundTrip(t);
        Assert.assertEquals((long)123L, (long)t);
    }

    @Test
    public void testIntArray() throws Exception {
        int[] t = this.roundTrip(new int[]{1, 2, 3}, (Type)((Object)int[].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0]);
        Assert.assertEquals((long)2L, (long)t[1]);
        Assert.assertEquals((long)3L, (long)t[2]);
    }

    @Test
    public void testInt2dArray() throws Exception {
        Object t = new int[][]{{1, 2, 3}, null};
        t = this.roundTrip(t, (Type)((Object)int[][].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0][0]);
        Assert.assertEquals((long)2L, (long)t[0][1]);
        Assert.assertEquals((long)3L, (long)t[0][2]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testInt3dArray() throws Exception {
        Object t = new int[][][]{new int[][]{{1, 2, 3}, {4, 5, 6}, null}, null};
        t = this.roundTrip(t, (Type)((Object)int[][][].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0][0][0]);
        Assert.assertEquals((long)2L, (long)t[0][0][1]);
        Assert.assertEquals((long)3L, (long)t[0][0][2]);
        Assert.assertEquals((long)4L, (long)t[0][1][0]);
        Assert.assertEquals((long)5L, (long)t[0][1][1]);
        Assert.assertEquals((long)6L, (long)t[0][1][2]);
        Assert.assertNull((Object)t[0][2]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testBoolean() throws Exception {
        boolean t = true;
        t = this.roundTrip(t);
        Assert.assertTrue((boolean)t);
        t = false;
        t = this.roundTrip(t);
        Assert.assertFalse((boolean)t);
    }

    @Test
    public void testBooleanArray() throws Exception {
        boolean[] t = new boolean[]{true, false};
        t = this.roundTrip(t, (Type)((Object)boolean[].class), new Type[0]);
        Assert.assertTrue((boolean)t[0]);
        Assert.assertFalse((boolean)t[1]);
    }

    @Test
    public void testBoolean2dArray() throws Exception {
        Object t = new boolean[][]{{true, false}, null};
        t = this.roundTrip(t, (Type)((Object)boolean[][].class), new Type[0]);
        Assert.assertTrue((boolean)t[0][0]);
        Assert.assertFalse((boolean)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testChar() throws Exception {
        char t = 'a';
        t = this.roundTrip(Character.valueOf(t), Character.TYPE, new Type[0]).charValue();
        Assert.assertEquals((long)97L, (long)t);
    }

    @Test
    public void testCharArray() throws Exception {
        char[] t = new char[]{'a', '\u0000'};
        t = this.roundTrip(t, (Type)((Object)char[].class), new Type[0]);
        Assert.assertEquals((long)97L, (long)t[0]);
        Assert.assertEquals((long)0L, (long)t[1]);
    }

    @Test
    public void testChar2dArray() throws Exception {
        Object t = new char[][]{{'a', '\u0000'}, null};
        t = this.roundTrip(t, (Type)((Object)char[][].class), new Type[0]);
        Assert.assertEquals((long)97L, (long)t[0][0]);
        Assert.assertEquals((long)0L, (long)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testFloat() throws Exception {
        float t = 1.0f;
        t = this.roundTrip(Float.valueOf(t), Float.TYPE, new Type[0]).floatValue();
        Assert.assertEquals((float)1.0f, (float)t, (float)0.1f);
    }

    @Test
    public void testFloatArray() throws Exception {
        float[] t = new float[]{1.0f};
        t = this.roundTrip(t, (Type)((Object)float[].class), new Type[0]);
        Assert.assertEquals((float)1.0f, (float)t[0], (float)0.1f);
    }

    @Test
    public void testFloat2dArray() throws Exception {
        Object t = new float[][]{{1.0f}, null};
        t = this.roundTrip(t, (Type)((Object)float[][].class), new Type[0]);
        Assert.assertEquals((float)1.0f, (float)t[0][0], (float)0.1f);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testDouble() throws Exception {
        double t = 1.0;
        t = this.roundTrip(Double.valueOf(t), Double.TYPE, new Type[0]);
        Assert.assertEquals((double)1.0, (double)t, (double)0.1f);
    }

    @Test
    public void testDoubleArray() throws Exception {
        double[] t = new double[]{1.0};
        t = this.roundTrip(t, (Type)((Object)double[].class), new Type[0]);
        Assert.assertEquals((double)1.0, (double)t[0], (double)0.1f);
    }

    @Test
    public void testDouble2dArray() throws Exception {
        Object t = new double[][]{{1.0}, null};
        t = this.roundTrip(t, (Type)((Object)double[][].class), new Type[0]);
        Assert.assertEquals((double)1.0, (double)t[0][0], (double)0.1f);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testLong() throws Exception {
        long t = 1L;
        t = this.roundTrip(Long.valueOf(t), Long.TYPE, new Type[0]);
        Assert.assertEquals((long)1L, (long)t);
    }

    @Test
    public void testLongArray() throws Exception {
        long[] t = new long[]{1L};
        t = this.roundTrip(t, (Type)((Object)long[].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0]);
    }

    @Test
    public void testLong2dArray() throws Exception {
        Object t = new long[][]{{1L}, null};
        t = this.roundTrip(t, (Type)((Object)long[][].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0][0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testShort() throws Exception {
        short t = 1;
        t = this.roundTrip(Short.valueOf(t), Short.TYPE, new Type[0]);
        Assert.assertEquals((long)1L, (long)t);
    }

    @Test
    public void testShortArray() throws Exception {
        short[] t = new short[]{1};
        t = this.roundTrip(t, (Type)((Object)short[].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0]);
    }

    @Test
    public void testShort2dArray() throws Exception {
        Object t = new short[][]{{1}, null};
        t = this.roundTrip(t, (Type)((Object)short[][].class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t[0][0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testInteger() throws Exception {
        Integer t = 123;
        t = this.roundTrip(t, (Type)((Object)Integer.class), new Type[0]);
        Assert.assertEquals((Object)new Integer(123), (Object)t);
    }

    @Test
    public void testIntegerArray() throws Exception {
        Integer[] t = new Integer[]{123, null};
        t = this.roundTrip(t, (Type)((Object)Integer[].class), new Type[0]);
        Assert.assertEquals((Object)new Integer(123), (Object)t[0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testInteger2dArray() throws Exception {
        Integer[][] t = new Integer[][]{{123, null}, null};
        t = this.roundTrip(t, (Type)((Object)Integer[][].class), new Type[0]);
        Assert.assertEquals((Object)new Integer(123), (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testInteger3dArray() throws Exception {
        Integer[][][] t = new Integer[][][]{{{123, null}, null}, null};
        t = this.roundTrip(t, (Type)((Object)Integer[][][].class), new Type[0]);
        Assert.assertEquals((Object)new Integer(123), (Object)t[0][0][0]);
        Assert.assertNull((Object)t[0][0][1]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testBooleanObject() throws Exception {
        Boolean t = Boolean.TRUE;
        t = this.roundTrip(t, (Type)((Object)Boolean.class), new Type[0]);
        Assert.assertTrue((boolean)t);
        t = Boolean.FALSE;
        t = this.roundTrip(t, (Type)((Object)Boolean.class), new Type[0]);
        Assert.assertFalse((boolean)t);
    }

    @Test
    public void testBooleanObjectArray() throws Exception {
        Boolean[] t = new Boolean[]{true, false, null};
        t = this.roundTrip(t, (Type)((Object)Boolean[].class), new Type[0]);
        Assert.assertTrue((boolean)t[0]);
        Assert.assertFalse((boolean)t[1]);
        Assert.assertNull((Object)t[2]);
    }

    @Test
    public void testBooleanObject2dArray() throws Exception {
        Boolean[][] t = new Boolean[][]{{true, false, null}, null};
        t = this.roundTrip(t, (Type)((Object)Boolean[][].class), new Type[0]);
        Assert.assertTrue((boolean)t[0][0]);
        Assert.assertFalse((boolean)t[0][1]);
        Assert.assertNull((Object)t[0][2]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testCharacter() throws Exception {
        Character t = Character.valueOf('a');
        t = this.roundTrip(t, (Type)((Object)Character.class), new Type[0]);
        Assert.assertEquals((Object)new Character('a'), (Object)t);
    }

    @Test
    public void testCharacterArray() throws Exception {
        Character[] t = new Character[]{Character.valueOf('a'), null};
        t = this.roundTrip(t, (Type)((Object)Character[].class), new Type[0]);
        Assert.assertEquals((Object)new Character('a'), (Object)t[0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testCharacter2dArray() throws Exception {
        Character[][] t = new Character[][]{{Character.valueOf('a'), null}, null};
        t = this.roundTrip(t, (Type)((Object)Character[][].class), new Type[0]);
        Assert.assertEquals((Object)new Character('a'), (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testFloatObject() throws Exception {
        Float t = Float.valueOf(1.0f);
        t = this.roundTrip(t, (Type)((Object)Float.class), new Type[0]);
        Assert.assertEquals((Object)new Float(1.0f), (Object)t);
    }

    @Test
    public void testFloatObjectArray() throws Exception {
        Float[] t = new Float[]{Float.valueOf(1.0f), null};
        t = this.roundTrip(t, (Type)((Object)Float[].class), new Type[0]);
        Assert.assertEquals((Object)new Float(1.0f), (Object)t[0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testFloatObject2dArray() throws Exception {
        Float[][] t = new Float[][]{{Float.valueOf(1.0f), null}, null};
        t = this.roundTrip(t, (Type)((Object)Float[][].class), new Type[0]);
        Assert.assertEquals((Object)new Float(1.0f), (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testDoubleObject() throws Exception {
        Double t = 1.0;
        t = this.roundTrip(t, (Type)((Object)Double.class), new Type[0]);
        Assert.assertEquals((Object)new Double(1.0), (Object)t);
    }

    @Test
    public void testDoubleObjectArray() throws Exception {
        Double[] t = new Double[]{1.0, null};
        t = this.roundTrip(t, (Type)((Object)Double[].class), new Type[0]);
        Assert.assertEquals((Object)new Double(1.0), (Object)t[0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testDoubleObject2dArray() throws Exception {
        Double[][] t = new Double[][]{{1.0, null}, null};
        t = this.roundTrip(t, (Type)((Object)Double[][].class), new Type[0]);
        Assert.assertEquals((Object)new Double(1.0), (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testLongObject() throws Exception {
        Long t = 1L;
        t = this.roundTrip(t, (Type)((Object)Long.class), new Type[0]);
        Assert.assertEquals((Object)new Long(1L), (Object)t);
    }

    @Test
    public void testLongObjectArray() throws Exception {
        Long[] t = new Long[]{1L, null};
        t = this.roundTrip(t, (Type)((Object)Long[].class), new Type[0]);
        Assert.assertEquals((Object)new Long(1L), (Object)t[0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testLongObject2dArray() throws Exception {
        Long[][] t = new Long[][]{{1L, null}, null};
        t = this.roundTrip(t, (Type)((Object)Long[][].class), new Type[0]);
        Assert.assertEquals((Object)new Long(1L), (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testShortObject() throws Exception {
        Short t = 1;
        t = this.roundTrip(t, (Type)((Object)Short.class), new Type[0]);
        Assert.assertEquals((Object)new Short(1), (Object)t);
    }

    @Test
    public void testShortObjectArray() throws Exception {
        Short[] t = new Short[]{(short)1, null};
        t = this.roundTrip(t, (Type)((Object)Short[].class), new Type[0]);
        Assert.assertEquals((Object)new Short(1), (Object)t[0]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testShortObject2dArray() throws Exception {
        Short[][] t = new Short[][]{{(short)1, null}, null};
        t = this.roundTrip(t, (Type)((Object)Short[][].class), new Type[0]);
        Assert.assertEquals((Object)new Short(1), (Object)t[0][0]);
        Assert.assertNull((Object)t[0][1]);
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testObjectMap() throws Exception {
        ObjectMap t = new ObjectMap((CharSequence)"{a:'b',c:123,d:false,e:null,f:[123,'abc',true,false,null]}");
        t = this.roundTrip(t);
        Assert.assertEquals((Object)"b", (Object)t.get((Object)"a"));
        Assert.assertEquals((Object)123, (Object)t.get((Object)"c"));
        Assert.assertEquals((Object)false, (Object)t.get((Object)"d"));
        Assert.assertNull((Object)t.get((Object)"e"));
        List l = (List)t.get((Object)"f");
        Assert.assertEquals((Object)123, l.get(0));
        Assert.assertEquals((Object)"abc", l.get(1));
        Assert.assertEquals((Object)true, l.get(2));
        Assert.assertEquals((Object)false, l.get(3));
        Assert.assertNull(l.get(4));
    }

    @Test
    public void testObjectList() throws Exception {
        ObjectList t = new ObjectList((CharSequence)"['abc',123,true,false,null,{a:'b'}]");
        t = this.roundTrip(t);
        Assert.assertEquals((Object)"abc", (Object)t.get(0));
        Assert.assertEquals((Object)123, (Object)t.get(1));
        Assert.assertEquals((Object)true, (Object)t.get(2));
        Assert.assertEquals((Object)false, (Object)t.get(3));
        Assert.assertNull((Object)t.get(4));
        Map m = (Map)t.get(5);
        Assert.assertEquals((Object)"b", m.get("a"));
    }

    @Test
    public void testTreeMap() throws Exception {
        TreeMap<String, Object> t = new TreeMap<String, Object>();
        t.put("a", 1);
        t.put("b", 2);
        t.put("c", 3);
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[0]);
        Assert.assertEquals((Object)1, t.get("a"));
        Assert.assertEquals((Object)2, t.get("b"));
        Assert.assertEquals((Object)3, t.get("c"));
        t = new TreeMap();
        t.put("a", true);
        t.put("b", false);
        t.put("c", null);
        t.put("d", "foo");
        t.put("null", "baz");
        t.put("a\"a", "a\"a");
        t.put("b'b", "b'b");
        t.put("\"cc\"", "\"cc\"");
        t.put("'dd'", "'dd'");
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[0]);
        Assert.assertEquals((Object)true, t.get("a"));
        Assert.assertEquals((Object)false, t.get("b"));
        Assert.assertNull(t.get("c"));
        Assert.assertEquals((Object)"foo", t.get("d"));
        Assert.assertEquals((Object)"baz", t.get("null"));
        Assert.assertEquals((Object)"a\"a", t.get("a\"a"));
        Assert.assertEquals((Object)"b'b", t.get("b'b"));
        Assert.assertEquals((Object)"\"cc\"", t.get("\"cc\""));
        Assert.assertEquals((Object)"'dd'", t.get("'dd'"));
    }

    @Test
    public void testLinkedHashMap() throws Exception {
        LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>();
        t.put("a", true);
        t.put("b", false);
        t.put("c", null);
        t.put("d", "foo");
        t.put(null, "bar");
        t.put("null", "null");
        t.put("true", "true");
        t.put("false", "false");
        t.put("a\"a", "a\"a");
        t.put("b'b", "b'b");
        t.put("\"cc\"", "\"cc\"");
        t.put("'dd'", "'dd'");
        t.put("<ee>", "<ee>");
        t.put("<ff/>", "<ff/>");
        t.put("</gg>", "</gg>");
        t.put("<>", "<>");
        t.put("{}", "{}");
        t.put("[]", "[]");
        t.put("&", "&");
        t.put("?", "?");
        t.put("/", "/");
        t.put("\b", "\b");
        t.put("\\b", "\\b");
        t.put("\n", "\n");
        t.put("\\n", "\\n");
        t.put("\t", "\t");
        t.put("\\t", "\\t");
        t.put("\f", "\f");
        t.put("\\f", "\\f");
        t.put("\\", "\\");
        t.put("\\\\", "\\\\");
        t.put("\u2345", "\u2345");
        t.put("\\u2345", "\\u2345");
        t.put("\\\u2345", "\\\u2345");
        t.put("<>{}[]&?/\b\n\t\f\\\\\u2345", "<>{}[]&?/\b\n\t\f\\\\\u2345");
        t = this.roundTrip(t, (Type)((Object)LinkedHashMap.class), new Type[0]);
        Assert.assertEquals((Object)true, t.get("a"));
        Assert.assertEquals((Object)false, t.get("b"));
        Assert.assertNull(t.get("c"));
        Assert.assertEquals((Object)"foo", t.get("d"));
        Assert.assertEquals((Object)"bar", t.get(null));
        Assert.assertEquals((Object)"null", t.get("null"));
        Assert.assertEquals((Object)"true", t.get("true"));
        Assert.assertEquals((Object)"false", t.get("false"));
        Assert.assertEquals((Object)"a\"a", t.get("a\"a"));
        Assert.assertEquals((Object)"b'b", t.get("b'b"));
        Assert.assertEquals((Object)"\"cc\"", t.get("\"cc\""));
        Assert.assertEquals((Object)"'dd'", t.get("'dd'"));
        Assert.assertEquals((Object)"<ee>", t.get("<ee>"));
        Assert.assertEquals((Object)"<ff/>", t.get("<ff/>"));
        Assert.assertEquals((Object)"</gg>", t.get("</gg>"));
        Assert.assertEquals((Object)"<>", t.get("<>"));
        Assert.assertEquals((Object)"{}", t.get("{}"));
        Assert.assertEquals((Object)"[]", t.get("[]"));
        Assert.assertEquals((Object)"&", t.get("&"));
        Assert.assertEquals((Object)"?", t.get("?"));
        Assert.assertEquals((Object)"/", t.get("/"));
        Assert.assertEquals((Object)"\b", t.get("\b"));
        Assert.assertEquals((Object)"\\b", t.get("\\b"));
        Assert.assertEquals((Object)"\n", t.get("\n"));
        Assert.assertEquals((Object)"\\n", t.get("\\n"));
        Assert.assertEquals((Object)"\t", t.get("\t"));
        Assert.assertEquals((Object)"\\t", t.get("\\t"));
        Assert.assertEquals((Object)"\f", t.get("\f"));
        Assert.assertEquals((Object)"\\f", t.get("\\f"));
        Assert.assertEquals((Object)"\\", t.get("\\"));
        Assert.assertEquals((Object)"\\\\", t.get("\\\\"));
        Assert.assertEquals((Object)"\u2345", t.get("\u2345"));
        Assert.assertEquals((Object)"\\u2345", t.get("\\u2345"));
        Assert.assertEquals((Object)"\\\u2345", t.get("\\\u2345"));
        Assert.assertEquals((Object)"<>{}[]&?/\b\n\t\f\\\\\u2345", t.get("<>{}[]&?/\b\n\t\f\\\\\u2345"));
    }

    @Test
    public void testVector() throws Exception {
        Vector<Integer> t = new Vector<Integer>();
        t.add(1);
        t.add(2);
        t.add(3);
        t = this.roundTrip(t, (Type)((Object)Vector.class), new Type[]{Integer.class});
    }

    @Test
    public void testExtendedUnicode() throws Exception {
        String t = "\ud852\udf62\ud852\udf62";
        t = this.roundTrip(t);
        Assert.assertEquals((Object)"\ud852\udf62\ud852\udf62", (Object)t);
    }
}

