/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripReadOnlyBeansTest
extends RoundTripTest {
    public RoundTripReadOnlyBeansTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void test() throws Exception {
        B t1 = new B(1, "a");
        B t2 = new B(2, "b");
        A t3 = new A(t1, t2);
        t3 = this.roundTrip(t3, (Type)((Object)A.class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t3.getF1().getF1());
        Assert.assertEquals((Object)"a", (Object)t3.getF1().getF2());
        Assert.assertEquals((long)2L, (long)t3.getF2().getF1());
        Assert.assertEquals((Object)"b", (Object)t3.getF2().getF2());
    }

    public static class B {
        private int f1;
        private final String f2;

        @Beanc(properties="f2")
        public B(String sField) {
            this.f2 = sField;
        }

        public B(int iField, String sField) {
            this.f1 = iField;
            this.f2 = sField;
        }

        public int getF1() {
            return this.f1;
        }

        public void setF1(int f1) {
            this.f1 = f1;
        }

        public String getF2() {
            return this.f2;
        }
    }

    public static class A {
        private B f1;
        private final B f2;

        @Beanc(properties="f2")
        public A(B f2) {
            this.f2 = f2;
        }

        public A(B f1, B f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        public B getF1() {
            return this.f1;
        }

        public void setF1(B f1) {
            this.f1 = f1;
        }

        public B getF2() {
            return this.f2;
        }
    }
}

