/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripPrimitivesBeansTest
extends RoundTripTest {
    public RoundTripPrimitivesBeansTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testPrimitivesBean() throws Exception {
        PrimitivesBean t = new PrimitivesBean().init();
        t = this.roundTrip(t, (Type)((Object)PrimitivesBean.class), new Type[0]);
        Assert.assertEquals((Object)true, (Object)t.pBoolean);
        Assert.assertEquals((long)1L, (long)t.pByte);
        Assert.assertEquals((long)97L, (long)t.pChar);
        Assert.assertEquals((long)2L, (long)t.pShort);
        Assert.assertEquals((long)3L, (long)t.pInt);
        Assert.assertEquals((long)4L, (long)t.pLong);
        Assert.assertEquals((float)5.0f, (float)t.pFloat, (float)0.1f);
        Assert.assertEquals((double)6.0, (double)t.pDouble, (double)0.1f);
        Assert.assertEquals((Object)false, (Object)t.puBoolean);
        Assert.assertEquals((long)0L, (long)t.puByte);
        Assert.assertEquals((long)0L, (long)t.puChar);
        Assert.assertEquals((long)0L, (long)t.puShort);
        Assert.assertEquals((long)0L, (long)t.puInt);
        Assert.assertEquals((long)0L, (long)t.puLong);
        Assert.assertEquals((float)0.0f, (float)t.puFloat, (float)0.1f);
        Assert.assertEquals((double)0.0, (double)t.puDouble, (double)0.1f);
        Assert.assertEquals((Object)false, (Object)t.paBoolean[1][0]);
        Assert.assertEquals((long)2L, (long)t.paByte[1][0]);
        Assert.assertEquals((long)98L, (long)t.paChar[1][0]);
        Assert.assertEquals((long)2L, (long)t.paShort[1][0]);
        Assert.assertEquals((long)2L, (long)t.paInt[1][0]);
        Assert.assertEquals((long)2L, (long)t.paLong[1][0]);
        Assert.assertEquals((float)2.0f, (float)t.paFloat[1][0], (float)0.1f);
        Assert.assertEquals((double)2.0, (double)t.paDouble[1][0], (double)0.1f);
        Assert.assertNull((Object)t.paBoolean[2]);
        Assert.assertNull((Object)t.paByte[2]);
        Assert.assertNull((Object)t.paChar[2]);
        Assert.assertNull((Object)t.paShort[2]);
        Assert.assertNull((Object)t.paInt[2]);
        Assert.assertNull((Object)t.paLong[2]);
        Assert.assertNull((Object)t.paFloat[2]);
        Assert.assertNull((Object)t.paDouble[2]);
        Assert.assertNull((Object)t.pauBoolean);
        Assert.assertNull((Object)t.pauByte);
        Assert.assertNull((Object)t.pauChar);
        Assert.assertNull((Object)t.pauShort);
        Assert.assertNull((Object)t.pauInt);
        Assert.assertNull((Object)t.pauLong);
        Assert.assertNull((Object)t.pauFloat);
        Assert.assertNull((Object)t.pauDouble);
        Assert.assertEquals((Object)true, (Object)t.palBoolean.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.palByte.get(0)[0]);
        Assert.assertEquals((long)97L, (long)t.palChar.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.palShort.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.palInt.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.palLong.get(0)[0]);
        Assert.assertEquals((float)1.0f, (float)t.palFloat.get(0)[0], (float)0.1f);
        Assert.assertEquals((double)1.0, (double)t.palDouble.get(0)[0], (double)0.1f);
        Assert.assertNull((Object)t.palBoolean.get(1));
        Assert.assertNull((Object)t.palByte.get(1));
        Assert.assertNull((Object)t.palChar.get(1));
        Assert.assertNull((Object)t.palShort.get(1));
        Assert.assertNull((Object)t.palInt.get(1));
        Assert.assertNull((Object)t.palLong.get(1));
        Assert.assertNull((Object)t.palFloat.get(1));
        Assert.assertNull((Object)t.palDouble.get(1));
        Assert.assertEquals((Object)true, (Object)t.plBoolean.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.plByte.get(0)[0]);
        Assert.assertEquals((long)97L, (long)t.plChar.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.plShort.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.plInt.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.plLong.get(0)[0]);
        Assert.assertEquals((float)1.0f, (float)t.plFloat.get(0)[0], (float)0.1f);
        Assert.assertEquals((double)1.0, (double)t.plDouble.get(0)[0], (double)0.1f);
        Assert.assertNull((Object)t.plBoolean.get(1));
        Assert.assertNull((Object)t.plByte.get(1));
        Assert.assertNull((Object)t.plChar.get(1));
        Assert.assertNull((Object)t.plShort.get(1));
        Assert.assertNull((Object)t.plInt.get(1));
        Assert.assertNull((Object)t.plLong.get(1));
        Assert.assertNull((Object)t.plFloat.get(1));
        Assert.assertNull((Object)t.plDouble.get(1));
    }

    @Test
    public void testPrimitivesBeanList() throws Exception {
        Object t = new AList().append((Object)new PrimitivesBean().init()).append(null).append((Object)new PrimitivesBean().init());
        if (this.p == null) {
            return;
        }
        t = (List)this.roundTrip(t, (Type)((Object)List.class), new Type[]{PrimitivesBean.class});
        PrimitivesBean t2 = (PrimitivesBean)t.get(2);
        Assert.assertEquals((Object)true, (Object)t2.pBoolean);
        Assert.assertEquals((long)1L, (long)t2.pByte);
        Assert.assertEquals((long)97L, (long)t2.pChar);
        Assert.assertEquals((long)2L, (long)t2.pShort);
        Assert.assertEquals((long)3L, (long)t2.pInt);
        Assert.assertEquals((long)4L, (long)t2.pLong);
        Assert.assertEquals((float)5.0f, (float)t2.pFloat, (float)0.1f);
        Assert.assertEquals((double)6.0, (double)t2.pDouble, (double)0.1f);
        Assert.assertEquals((Object)false, (Object)t2.puBoolean);
        Assert.assertEquals((long)0L, (long)t2.puByte);
        Assert.assertEquals((long)0L, (long)t2.puChar);
        Assert.assertEquals((long)0L, (long)t2.puShort);
        Assert.assertEquals((long)0L, (long)t2.puInt);
        Assert.assertEquals((long)0L, (long)t2.puLong);
        Assert.assertEquals((float)0.0f, (float)t2.puFloat, (float)0.1f);
        Assert.assertEquals((double)0.0, (double)t2.puDouble, (double)0.1f);
        Assert.assertEquals((Object)false, (Object)t2.paBoolean[1][0]);
        Assert.assertEquals((long)2L, (long)t2.paByte[1][0]);
        Assert.assertEquals((long)98L, (long)t2.paChar[1][0]);
        Assert.assertEquals((long)2L, (long)t2.paShort[1][0]);
        Assert.assertEquals((long)2L, (long)t2.paInt[1][0]);
        Assert.assertEquals((long)2L, (long)t2.paLong[1][0]);
        Assert.assertEquals((float)2.0f, (float)t2.paFloat[1][0], (float)0.1f);
        Assert.assertEquals((double)2.0, (double)t2.paDouble[1][0], (double)0.1f);
        Assert.assertNull((Object)t2.paBoolean[2]);
        Assert.assertNull((Object)t2.paByte[2]);
        Assert.assertNull((Object)t2.paChar[2]);
        Assert.assertNull((Object)t2.paShort[2]);
        Assert.assertNull((Object)t2.paInt[2]);
        Assert.assertNull((Object)t2.paLong[2]);
        Assert.assertNull((Object)t2.paFloat[2]);
        Assert.assertNull((Object)t2.paDouble[2]);
        Assert.assertNull((Object)t2.pauBoolean);
        Assert.assertNull((Object)t2.pauByte);
        Assert.assertNull((Object)t2.pauChar);
        Assert.assertNull((Object)t2.pauShort);
        Assert.assertNull((Object)t2.pauInt);
        Assert.assertNull((Object)t2.pauLong);
        Assert.assertNull((Object)t2.pauFloat);
        Assert.assertNull((Object)t2.pauDouble);
        Assert.assertEquals((Object)true, (Object)t2.palBoolean.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.palByte.get(0)[0]);
        Assert.assertEquals((long)97L, (long)t2.palChar.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.palShort.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.palInt.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.palLong.get(0)[0]);
        Assert.assertEquals((float)1.0f, (float)t2.palFloat.get(0)[0], (float)0.1f);
        Assert.assertEquals((double)1.0, (double)t2.palDouble.get(0)[0], (double)0.1f);
        Assert.assertNull((Object)t2.palBoolean.get(1));
        Assert.assertNull((Object)t2.palByte.get(1));
        Assert.assertNull((Object)t2.palChar.get(1));
        Assert.assertNull((Object)t2.palShort.get(1));
        Assert.assertNull((Object)t2.palInt.get(1));
        Assert.assertNull((Object)t2.palLong.get(1));
        Assert.assertNull((Object)t2.palFloat.get(1));
        Assert.assertNull((Object)t2.palDouble.get(1));
        Assert.assertEquals((Object)true, (Object)t2.plBoolean.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.plByte.get(0)[0]);
        Assert.assertEquals((long)97L, (long)t2.plChar.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.plShort.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.plInt.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t2.plLong.get(0)[0]);
        Assert.assertEquals((float)1.0f, (float)t2.plFloat.get(0)[0], (float)0.1f);
        Assert.assertEquals((double)1.0, (double)t2.plDouble.get(0)[0], (double)0.1f);
        Assert.assertNull((Object)t2.plBoolean.get(1));
        Assert.assertNull((Object)t2.plByte.get(1));
        Assert.assertNull((Object)t2.plChar.get(1));
        Assert.assertNull((Object)t2.plShort.get(1));
        Assert.assertNull((Object)t2.plInt.get(1));
        Assert.assertNull((Object)t2.plLong.get(1));
        Assert.assertNull((Object)t2.plFloat.get(1));
        Assert.assertNull((Object)t2.plDouble.get(1));
        Assert.assertNull(t.get(1));
    }

    public static class PrimitivesBean {
        public boolean pBoolean;
        public byte pByte;
        public char pChar;
        public short pShort;
        public int pInt;
        public long pLong;
        public float pFloat;
        public double pDouble;
        public boolean puBoolean;
        public byte puByte;
        public char puChar;
        public short puShort;
        public int puInt;
        public long puLong;
        public float puFloat;
        public double puDouble;
        public boolean[][] paBoolean;
        public byte[][] paByte;
        public char[][] paChar;
        public short[][] paShort;
        public int[][] paInt;
        public long[][] paLong;
        public float[][] paFloat;
        public double[][] paDouble;
        public boolean[][] pauBoolean;
        public byte[][] pauByte;
        public char[][] pauChar;
        public short[][] pauShort;
        public int[][] pauInt;
        public long[][] pauLong;
        public float[][] pauFloat;
        public double[][] pauDouble;
        public List<boolean[]> plBoolean;
        public List<byte[]> plByte;
        public List<char[]> plChar;
        public List<short[]> plShort;
        public List<int[]> plInt;
        public List<long[]> plLong;
        public List<float[]> plFloat;
        public List<double[]> plDouble;
        public List<boolean[]> palBoolean;
        public List<byte[]> palByte;
        public List<char[]> palChar;
        public List<short[]> palShort;
        public List<int[]> palInt;
        public List<long[]> palLong;
        public List<float[]> palFloat;
        public List<double[]> palDouble;

        public PrimitivesBean init() {
            this.pBoolean = true;
            this.pByte = 1;
            this.pChar = (char)97;
            this.pShort = (short)2;
            this.pInt = 3;
            this.pLong = 4L;
            this.pFloat = 5.0f;
            this.pDouble = 6.0;
            this.paBoolean = new boolean[][]{{true}, {false}, null};
            this.paByte = new byte[][]{{1}, {2}, null};
            this.paChar = new char[][]{{'a'}, {'b'}, null};
            this.paShort = new short[][]{{1}, {2}, null};
            this.paInt = new int[][]{{1}, {2}, null};
            this.paLong = new long[][]{{1L}, {2L}, null};
            this.paFloat = new float[][]{{1.0f}, {2.0f}, null};
            this.paDouble = new double[][]{{1.0}, {2.0}, null};
            this.plBoolean = new AList().append((Object)new boolean[]{true}).append(null);
            this.plByte = new AList().append((Object)new byte[]{1}).append(null);
            this.plChar = new AList().append((Object)new char[]{'a'}).append(null);
            this.plShort = new AList().append((Object)new short[]{1}).append(null);
            this.plInt = new AList().append((Object)new int[]{1}).append(null);
            this.plLong = new AList().append((Object)new long[]{1L}).append(null);
            this.plFloat = new AList().append((Object)new float[]{1.0f}).append(null);
            this.plDouble = new AList().append((Object)new double[]{1.0}).append(null);
            this.palBoolean = new ArrayList<boolean[]>();
            this.palBoolean.add(new boolean[]{true});
            this.palBoolean.add(null);
            this.palByte = new ArrayList<byte[]>();
            this.palByte.add(new byte[]{1});
            this.palByte.add(null);
            this.palChar = new ArrayList<char[]>();
            this.palChar.add(new char[]{'a'});
            this.palChar.add(null);
            this.palShort = new ArrayList<short[]>();
            this.palShort.add(new short[]{1});
            this.palShort.add(null);
            this.palInt = new ArrayList<int[]>();
            this.palInt.add(new int[]{1});
            this.palInt.add(null);
            this.palLong = new ArrayList<long[]>();
            this.palLong.add(new long[]{1L});
            this.palLong.add(null);
            this.palFloat = new ArrayList<float[]>();
            this.palFloat.add(new float[]{1.0f});
            this.palFloat.add(null);
            this.palDouble = new ArrayList<double[]>();
            this.palDouble.add(new double[]{1.0});
            this.palDouble.add(null);
            return this;
        }
    }
}

