/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.pojos.PrimitiveAtomicObjectsBean;
import org.apache.juneau.testutils.pojos.PrimitiveObjectsBean;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripPrimitiveObjectBeansTest
extends RoundTripTest {
    public RoundTripPrimitiveObjectBeansTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testPrimitiveObjectsBean() throws Exception {
        PrimitiveObjectsBean t = new PrimitiveObjectsBean().init();
        t = this.roundTrip(t, (Type)((Object)PrimitiveObjectsBean.class), new Type[0]);
        t = this.roundTrip(t, (Type)((Object)PrimitiveObjectsBean.class), new Type[0]);
        Assert.assertEquals((Object)true, (Object)t.poBoolean);
        Assert.assertEquals((Object)1, (Object)t.poByte);
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)t.poChar);
        Assert.assertEquals((Object)Short.valueOf("2"), (Object)t.poShort);
        Assert.assertEquals((Object)3, (Object)t.poInt);
        Assert.assertEquals((Object)4L, (Object)t.poLong);
        Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)t.poFloat);
        Assert.assertEquals((Object)6.0, (Object)t.poDouble);
        Assert.assertEquals((Object)7, (Object)t.poNumber);
        Assert.assertEquals((long)8L, (long)t.poBigInteger.intValue());
        Assert.assertTrue((t.poBigDecimal.floatValue() == 9.0f ? 1 : 0) != 0);
        Assert.assertNull((Object)t.pouBoolean);
        Assert.assertNull((Object)t.pouByte);
        Assert.assertNull((Object)t.pouChar);
        Assert.assertNull((Object)t.pouShort);
        Assert.assertNull((Object)t.pouInt);
        Assert.assertNull((Object)t.pouLong);
        Assert.assertNull((Object)t.pouFloat);
        Assert.assertNull((Object)t.pouDouble);
        Assert.assertNull((Object)t.pouNumber);
        Assert.assertNull((Object)t.pouBigInteger);
        Assert.assertNull((Object)t.pouBigDecimal);
        Assert.assertEquals((Object)false, (Object)t.poaBoolean[1][0]);
        Assert.assertEquals((Object)2, (Object)t.poaByte[1][0]);
        Assert.assertEquals((Object)Character.valueOf('b'), (Object)t.poaChar[1][0]);
        Assert.assertEquals((Object)Short.valueOf("2"), (Object)t.poaShort[1][0]);
        Assert.assertEquals((Object)2, (Object)t.poaInt[1][0]);
        Assert.assertEquals((Object)2L, (Object)t.poaLong[1][0]);
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)t.poaFloat[1][0]);
        Assert.assertEquals((Object)2.0, (Object)t.poaDouble[1][0]);
        Assert.assertEquals((Object)2, (Object)t.poaNumber[1][0]);
        Assert.assertEquals((long)2L, (long)t.poaBigInteger[1][0].intValue());
        Assert.assertEquals((long)2L, (long)t.poaBigDecimal[1][0].intValue());
        Assert.assertNull((Object)t.poaBoolean[2]);
        Assert.assertNull((Object)t.poaByte[2]);
        Assert.assertNull((Object)t.poaChar[2]);
        Assert.assertNull((Object)t.poaShort[2]);
        Assert.assertNull((Object)t.poaInt[2]);
        Assert.assertNull((Object)t.poaLong[2]);
        Assert.assertNull((Object)t.poaFloat[2]);
        Assert.assertNull((Object)t.poaDouble[2]);
        Assert.assertNull((Object)t.poaNumber[2]);
        Assert.assertNull((Object)t.poaBigInteger[2]);
        Assert.assertNull((Object)t.poaBigDecimal[2]);
        Assert.assertNull((Object)t.poauBoolean);
        Assert.assertNull((Object)t.poauByte);
        Assert.assertNull((Object)t.poauChar);
        Assert.assertNull((Object)t.poauShort);
        Assert.assertNull((Object)t.poauInt);
        Assert.assertNull((Object)t.poauLong);
        Assert.assertNull((Object)t.poauFloat);
        Assert.assertNull((Object)t.poauDouble);
        Assert.assertNull((Object)t.poauNumber);
        Assert.assertNull((Object)t.poauBigInteger);
        Assert.assertNull((Object)t.poauBigDecimal);
        Assert.assertEquals((Object)true, (Object)t.poalBoolean.get(0)[0]);
        Assert.assertEquals((Object)1, (Object)t.poalByte.get(0)[0]);
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)t.poalChar.get(0)[0]);
        Assert.assertEquals((Object)1, (Object)t.poalShort.get(0)[0]);
        Assert.assertEquals((Object)1, (Object)t.poalInt.get(0)[0]);
        Assert.assertEquals((Object)1L, (Object)t.poalLong.get(0)[0]);
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)t.poalFloat.get(0)[0]);
        Assert.assertEquals((Object)1.0, (Object)t.poalDouble.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.poalBigInteger.get(0)[0].intValue());
        Assert.assertEquals((long)1L, (long)t.poalBigDecimal.get(0)[0].intValue());
        Assert.assertNull((Object)t.poalBoolean.get(1));
        Assert.assertNull((Object)t.poalByte.get(1));
        Assert.assertNull((Object)t.poalChar.get(1));
        Assert.assertNull((Object)t.poalShort.get(1));
        Assert.assertNull((Object)t.poalInt.get(1));
        Assert.assertNull((Object)t.poalLong.get(1));
        Assert.assertNull((Object)t.poalFloat.get(1));
        Assert.assertNull((Object)t.poalDouble.get(1));
        Assert.assertNull((Object)t.poalNumber.get(1));
        Assert.assertNull((Object)t.poalBigInteger.get(1));
        Assert.assertNull((Object)t.poalBigDecimal.get(1));
        Assert.assertEquals((Object)true, (Object)t.polBoolean.get(0)[0]);
        Assert.assertEquals((Object)1, (Object)t.polByte.get(0)[0]);
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)t.polChar.get(0)[0]);
        Assert.assertEquals((Object)1, (Object)t.polShort.get(0)[0]);
        Assert.assertEquals((Object)1, (Object)t.polInt.get(0)[0]);
        Assert.assertEquals((Object)1L, (Object)t.polLong.get(0)[0]);
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)t.polFloat.get(0)[0]);
        Assert.assertEquals((Object)1.0, (Object)t.polDouble.get(0)[0]);
        Assert.assertEquals((long)1L, (long)t.polBigInteger.get(0)[0].intValue());
        Assert.assertEquals((long)1L, (long)t.polBigDecimal.get(0)[0].intValue());
        Assert.assertNull((Object)t.polBoolean.get(1));
        Assert.assertNull((Object)t.polByte.get(1));
        Assert.assertNull((Object)t.polChar.get(1));
        Assert.assertNull((Object)t.polShort.get(1));
        Assert.assertNull((Object)t.polInt.get(1));
        Assert.assertNull((Object)t.polLong.get(1));
        Assert.assertNull((Object)t.polFloat.get(1));
        Assert.assertNull((Object)t.polDouble.get(1));
        Assert.assertNull((Object)t.polNumber.get(1));
        Assert.assertNull((Object)t.polBigInteger.get(1));
        Assert.assertNull((Object)t.polBigDecimal.get(1));
    }

    @Test
    public void testPrimitiveAtomicObjectsBean() throws Exception {
        if (this.getSerializer() instanceof RdfSerializer) {
            return;
        }
        PrimitiveAtomicObjectsBean t = new PrimitiveAtomicObjectsBean().init();
        t = this.roundTrip(t, (Type)((Object)PrimitiveAtomicObjectsBean.class), new Type[0]);
        t = this.roundTrip(t, (Type)((Object)PrimitiveAtomicObjectsBean.class), new Type[0]);
        Assert.assertEquals((long)1L, (long)t.poAtomicInteger.intValue());
        Assert.assertEquals((long)2L, (long)t.poAtomicLong.intValue());
        Assert.assertNull((Object)t.pouAtomicInteger);
        Assert.assertNull((Object)t.pouAtomicLong);
        Assert.assertEquals((long)2L, (long)t.poaAtomicInteger[1][0].intValue());
        Assert.assertEquals((long)2L, (long)t.poaAtomicLong[1][0].intValue());
        Assert.assertNull((Object)t.poaAtomicInteger[2]);
        Assert.assertNull((Object)t.poaAtomicLong[2]);
        Assert.assertNull((Object)t.poauAtomicInteger);
        Assert.assertNull((Object)t.poauAtomicLong);
        Assert.assertEquals((long)1L, (long)t.poalAtomicInteger.get(0)[0].intValue());
        Assert.assertEquals((long)1L, (long)t.poalAtomicLong.get(0)[0].intValue());
        Assert.assertNull((Object)t.poalAtomicInteger.get(1));
        Assert.assertNull((Object)t.poalAtomicLong.get(1));
        Assert.assertEquals((long)1L, (long)t.polAtomicInteger.get(0)[0].intValue());
        Assert.assertEquals((long)1L, (long)t.polAtomicLong.get(0)[0].intValue());
        Assert.assertNull((Object)t.polAtomicInteger.get(1));
        Assert.assertNull((Object)t.polAtomicLong.get(1));
    }
}

