/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.util.List;
import java.util.Optional;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class RoundTripOptionalObjectsTest
extends RoundTripTest {
    public RoundTripOptionalObjectsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void a01_emptyOptional() throws Exception {
        Optional o = Optional.empty();
        o = this.roundTrip(o);
        Assert.assertFalse((boolean)o.isPresent());
    }

    @Test
    public void a02_optionalContainingString() throws Exception {
        Optional<String> o = Optional.of("foobar");
        o = this.roundTrip(o);
        Assert.assertEquals((Object)"foobar", (Object)o.get());
        o = Optional.of("");
        o = this.roundTrip(o);
        Assert.assertEquals((Object)"", (Object)o.get());
    }

    @Test
    public void b01a_stringField() throws Exception {
        B01 x = new B01();
        x.f1 = Optional.of("foo");
        x = this.roundTrip(x);
        Assert.assertEquals((Object)"foo", (Object)x.f1.get());
    }

    @Test
    public void b01b_stringField_emptyValue() throws Exception {
        B01 x = new B01();
        x.f1 = Optional.empty();
        x = this.roundTrip(x);
        Assert.assertFalse((boolean)x.f1.isPresent());
    }

    @Test
    public void b01c_stringField_nullField() throws Exception {
        B01 x = new B01();
        x.f1 = null;
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertFalse((boolean)x.f1.isPresent());
    }

    @Test
    public void b02a_integerField() throws Exception {
        B02 x = new B02();
        x.f1 = Optional.of(123);
        x = this.roundTrip(x);
        Assert.assertEquals((long)123L, (long)x.f1.get().intValue());
    }

    @Test
    public void b02b_integerField_emptyValue() throws Exception {
        B02 x = new B02();
        x.f1 = Optional.empty();
        x = this.roundTrip(x);
        Assert.assertFalse((boolean)x.f1.isPresent());
    }

    @Test
    public void b02c_integerField_nullField() throws Exception {
        B02 x = new B02();
        x.f1 = null;
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertFalse((boolean)x.f1.isPresent());
    }

    @Test
    public void b03a_integerListField() throws Exception {
        B03 x = new B03();
        x.f1 = Optional.of(AList.of((Object[])new Integer[]{123}));
        x = this.roundTrip(x);
        Assert.assertEquals((long)123L, (long)x.f1.get().get(0).intValue());
    }

    @Test
    public void b03b_integerListField_listWithNull() throws Exception {
        B03 x = new B03();
        x.f1 = Optional.of(AList.of((Object[])new Integer[]{null}));
        x = this.roundTrip(x);
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertEquals((long)1L, (long)x.f1.get().size());
        Assert.assertNull((Object)x.f1.get().get(0));
    }

    @Test
    public void b03c_integerListField_emptyList() throws Exception {
        B03 x = new B03();
        x.f1 = Optional.of(AList.of((Object[])new Integer[0]));
        x = this.roundTrip(x);
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertEquals((long)0L, (long)x.f1.get().size());
    }

    @Test
    public void b03d_integerListField_emptyValue() throws Exception {
        B03 x = new B03();
        x.f1 = Optional.empty();
        x = this.roundTrip(x);
        Assert.assertFalse((boolean)x.f1.isPresent());
    }

    @Test
    public void b03e_integerListField_nullField() throws Exception {
        B03 x = new B03();
        x.f1 = null;
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertFalse((boolean)x.f1.isPresent());
    }

    @Test
    public void b04a_optionalOptionalInteger() throws Exception {
        B04 x = new B04();
        x.f1 = Optional.of(Optional.of(123));
        x = this.roundTrip(x);
        Assert.assertEquals((long)123L, (long)x.f1.get().get().intValue());
    }

    @Test
    public void b04b_optionalOptionalInteger_emptyInnerValue() throws Exception {
        B04 x = new B04();
        x.f1 = Optional.of(Optional.empty());
        x = this.roundTrip(x);
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertFalse((boolean)x.f1.get().isPresent());
    }

    @Test
    public void b04c_optionalOptionalInteger_emptyOuterValue() throws Exception {
        B04 x = new B04();
        x.f1 = Optional.empty();
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertFalse((boolean)x.f1.get().isPresent());
    }

    @Test
    public void b04d_optionalOptionalInteger_nullField() throws Exception {
        B04 x = new B04();
        x.f1 = null;
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertFalse((boolean)x.f1.get().isPresent());
    }

    @Test
    public void b05a_optionalOptionalBean() throws Exception {
        B05 x = new B05();
        x.f1 = Optional.of(Optional.of(B05B.create()));
        x = this.roundTrip(x);
        Assert.assertEquals((long)123L, (long)x.f1.get().get().f2);
    }

    @Test
    public void b05b_optionalOptionalBean_emptyInnerValue() throws Exception {
        B05 x = new B05();
        x.f1 = Optional.of(Optional.empty());
        x = this.roundTrip(x);
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertFalse((boolean)x.f1.get().isPresent());
    }

    @Test
    public void b05c_optionalOptionalBean_emptyOuterValue() throws Exception {
        B05 x = new B05();
        x.f1 = Optional.empty();
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertFalse((boolean)x.f1.get().isPresent());
    }

    @Test
    public void b05d_optionalOptionalBean_nullField() throws Exception {
        B05 x = new B05();
        x.f1 = null;
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertTrue((boolean)x.f1.isPresent());
        Assert.assertFalse((boolean)x.f1.get().isPresent());
    }

    @Test
    public void b06a_listOfOptionalIntegers() throws Exception {
        B06 x = new B06();
        x.f1 = AList.of((Object[])new Optional[]{Optional.of(123)});
        x = this.roundTrip(x);
        Assert.assertEquals((long)123L, (long)x.f1.get(0).get().intValue());
    }

    @Test
    public void b06b_listOfOptionalIntegers_listWithEmpty() throws Exception {
        B06 x = new B06();
        x.f1 = AList.of((Object[])new Optional[]{Optional.empty()});
        x = this.roundTrip(x);
        Assert.assertEquals((long)1L, (long)x.f1.size());
        Assert.assertFalse((boolean)x.f1.get(0).isPresent());
    }

    @Test
    public void b06c_listOfOptionalIntegers_listWithNull() throws Exception {
        B06 x = new B06();
        x.f1 = AList.of((Object[])new Optional[]{null});
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertEquals((long)1L, (long)x.f1.size());
        Assert.assertFalse((boolean)x.f1.get(0).isPresent());
    }

    @Test
    public void b06d_listOfOptionalIntegers_nullField() throws Exception {
        B06 x = new B06();
        x.f1 = null;
        x = this.roundTrip(x);
        Assert.assertNull(x.f1);
    }

    @Test
    public void b07a_arrayOfOptionalIntegers() throws Exception {
        B07 x = new B07();
        x.f1 = new Optional[]{Optional.of(123)};
        x.f2 = new List[]{AList.create((Object[])new Integer[]{123})};
        x = this.roundTrip(x);
        Assert.assertEquals((long)123L, (long)x.f1[0].get().intValue());
    }

    @Test
    public void b07b_arrayOfOptionalIntegers_listWithEmpty() throws Exception {
        B07 x = new B07();
        x.f1 = new Optional[]{Optional.empty()};
        x = this.roundTrip(x);
        Assert.assertEquals((long)1L, (long)x.f1.length);
        Assert.assertFalse((boolean)x.f1[0].isPresent());
    }

    @Test
    public void b07c_arrayOfOptionalIntegers_listWithNull() throws Exception {
        B07 x = new B07();
        x.f1 = new Optional[]{null};
        x = this.roundTrip(x);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertEquals((long)1L, (long)x.f1.length);
        Assert.assertFalse((boolean)x.f1[0].isPresent());
    }

    @Test
    public void b07d_arrayOfOptionalIntegers_nullField() throws Exception {
        B07 x = new B07();
        x.f1 = null;
        x = this.roundTrip(x);
        Assert.assertNull(x.f1);
    }

    public static class B07 {
        public Optional<Integer>[] f1;
        public List<Integer>[] f2;
    }

    public static class B06 {
        public List<Optional<Integer>> f1;
    }

    public static class B05B {
        public int f2;

        public static B05B create() {
            B05B b = new B05B();
            b.f2 = 123;
            return b;
        }
    }

    public static class B05 {
        public Optional<Optional<B05B>> f1;
    }

    public static class B04 {
        public Optional<Optional<Integer>> f1;
    }

    public static class B03 {
        public Optional<List<Integer>> f1;
    }

    public static class B02 {
        public Optional<Integer> f1;
    }

    public static class B01 {
        public Optional<String> f1;
    }
}

