/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripObjectsWithSpecialMethodsTest
extends RoundTripTest {
    public RoundTripObjectsWithSpecialMethodsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testNameProperty() throws Exception {
        A t = new A().init();
        t = this.roundTrip(t);
        TestUtils.assertObjectEquals("{a2:{f2:2},m:{k1:{f2:2}}}", t);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertEquals((Object)"a2", (Object)t.a2.name);
        Assert.assertEquals((Object)"k1", (Object)t.m.get((Object)"k1").name);
    }

    @Test
    public void testParentProperty() throws Exception {
        B t = new B().init();
        t = this.roundTrip(t);
        if (this.isValidationOnly()) {
            return;
        }
        Assert.assertEquals((long)t.f1, (long)t.b2.parent.f1);
    }

    public static class B2 {
        B parent;
        public int f2;

        @ParentProperty
        protected void setParent(B parent) {
            this.parent = parent;
        }

        B2 init() {
            this.f2 = 2;
            return this;
        }
    }

    public static class B {
        public int f1;
        public B2 b2;

        B init() {
            this.f1 = 1;
            this.b2 = new B2().init();
            return this;
        }
    }

    public static class A2 {
        String name;
        public int f2;

        @NameProperty
        protected void setName(String name) {
            this.name = name;
        }

        A2 init() {
            this.f2 = 2;
            return this;
        }
    }

    public static class A {
        public A2 a2;
        public Map<String, A2> m;

        A init() {
            this.a2 = new A2().init();
            this.m = new LinkedHashMap<String, A2>();
            this.m.put("k1", new A2().init());
            return this;
        }
    }
}

