/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripObjectsAsStringsTest
extends RoundTripTest {
    public RoundTripObjectsAsStringsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testBasic() throws Exception {
        A t = new A().init();
        t = this.roundTrip(t);
        TestUtils.assertObjectEquals("{a1:{f:'1'},a2:{f:'2'},a3:{f:'3'},a4:{f:'4'}}", t);
    }

    @Test
    public void testEnumWithOverriddenStringValue() throws Exception {
        B t = new B().init();
        if (!this.returnOriginalObject) {
            Object r = this.getSerializer().serialize((Object)t);
            Assert.assertTrue((boolean)TestUtils.toString(r).contains("X-2"));
        }
        t = this.roundTrip(t);
        TestUtils.assertObjectEquals("{b1:'X1',b2:'X-2'}", t);
    }

    @Test
    public void testOrdering() throws Exception {
        C t = new C().init();
        t = this.roundTrip(t);
        TestUtils.assertObjectEquals("{c1:{f:'1'},c2:{f:'2'},c3:{f:'3'},c4:{f:'4'}}", t);
    }

    public static class C4 {
        public String f;

        public static C4 parseString(String s) {
            C4 x = new C4();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "C4" + this.f;
        }
    }

    public static class C3 {
        public String f;

        public static C2 parseString(String s) {
            throw new RuntimeException("Shouldn't be called!");
        }

        public static C3 parse(String s) {
            C3 x = new C3();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "C3-" + this.f;
        }
    }

    public static class C2 {
        public String f;

        public static C2 parse(String s) {
            throw new RuntimeException("Shouldn't be called!");
        }

        public static C2 parseString(String s) {
            throw new RuntimeException("Shouldn't be called!");
        }

        public static C2 valueOf(String s) {
            C2 x = new C2();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "C2-" + this.f;
        }
    }

    public static class C1 {
        public String f;

        public static C2 valueOf(String s) {
            throw new RuntimeException("Shouldn't be called!");
        }

        public static C2 parse(String s) {
            throw new RuntimeException("Shouldn't be called!");
        }

        public static C2 parseString(String s) {
            throw new RuntimeException("Shouldn't be called!");
        }

        public static C1 fromString(String s) {
            C1 x = new C1();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "C1-" + this.f;
        }
    }

    public static class C {
        public C1 c1;
        public C2 c2;
        public C3 c3;
        public C4 c4;

        public C init() {
            this.c1 = new C1();
            this.c1.f = "1";
            this.c2 = new C2();
            this.c2.f = "2";
            this.c3 = new C3();
            this.c3.f = "3";
            this.c4 = new C4();
            this.c4.f = "4";
            return this;
        }
    }

    public static enum B2 {
        X1(1),
        X2(2),
        X3(3);

        private int i;

        private B2(int i) {
            this.i = i;
        }

        public String toString() {
            return "X-" + this.i;
        }

        public static B2 fromString(String s) {
            return B2.valueOf("X" + s.substring(2));
        }
    }

    public static enum B1 {
        X1(1),
        X2(2),
        X3(3);

        private int i;

        private B1(int i) {
            this.i = i;
        }
    }

    public static class B {
        public B1 b1;
        public B2 b2;

        public B init() {
            this.b1 = B1.X1;
            this.b2 = B2.X2;
            return this;
        }
    }

    public static class A4 {
        public String f;

        public static A4 parseString(String s) {
            A4 x = new A4();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "A4-" + this.f;
        }
    }

    public static class A3 {
        public String f;

        public static A3 parse(String s) {
            A3 x = new A3();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "A3-" + this.f;
        }
    }

    public static class A2 {
        public String f;

        public static A2 valueOf(String s) {
            A2 x = new A2();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "A2-" + this.f;
        }
    }

    public static class A1 {
        public String f;

        public static A1 fromString(String s) {
            A1 x = new A1();
            x.f = s.substring(3);
            return x;
        }

        public String toString() {
            return "A1-" + this.f;
        }
    }

    public static class A {
        public A1 a1;
        public A2 a2;
        public A3 a3;
        public A4 a4;

        public A init() {
            this.a1 = new A1();
            this.a1.f = "1";
            this.a2 = new A2();
            this.a2.f = "2";
            this.a3 = new A3();
            this.a3.f = "3";
            this.a4 = new A4();
            this.a4.f = "4";
            return this;
        }
    }
}

