/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.transforms.ByteArraySwap;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripMapsTest
extends RoundTripTest {
    public RoundTripMapsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Override
    public Class<?>[] getPojoSwaps() {
        return new Class[]{ByteArraySwap.Base64.class};
    }

    @Test
    public void testMapIntegerString() throws Exception {
        Map<Integer, String> t = new TreeMap<Integer, String>();
        t.put(1, "a");
        t.put(2, null);
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[]{Integer.class, String.class});
        Assert.assertEquals((Object)"a", t.get(1));
        Assert.assertNull(null, t.get(2));
        t = new HashMap();
        t.put(1, "a");
        t.put(2, null);
        t.put(null, "b");
        t = this.roundTrip(t, (Type)((Object)HashMap.class), new Type[]{Integer.class, String.class});
        Assert.assertEquals((Object)"a", t.get(1));
        Assert.assertNull(t.get(2));
        Assert.assertEquals((Object)"b", t.get(null));
    }

    @Test
    public void testMapBooleanString() throws Exception {
        Map<Boolean, String> t = new TreeMap<Boolean, String>();
        t.put(true, "a");
        t.put(false, null);
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[]{Boolean.class, String.class});
        Assert.assertEquals((Object)"a", t.get(true));
        Assert.assertNull(null, t.get(false));
        t = new HashMap();
        t.put(true, "a");
        t.put(false, null);
        t.put(null, "b");
        t = this.roundTrip(t, (Type)((Object)HashMap.class), new Type[]{Boolean.class, String.class});
        Assert.assertEquals((Object)"a", t.get(true));
        Assert.assertNull(t.get(false));
        Assert.assertEquals((Object)"b", t.get(null));
    }

    @Test
    public void testMapByteArrayString() throws Exception {
        LinkedHashMap<byte[], String> t = new LinkedHashMap<byte[], String>();
        t.put(new byte[]{1, 2, 3}, "a");
        t.put(new byte[]{4, 5, 6}, null);
        t.put(null, "b");
        this.s = JsonSerializer.create().ssq().pojoSwaps((Class[])this.getPojoSwaps()).trimNullProperties(false).build();
        String e = "{AQID:'a',BAUG:null,null:'b'}";
        Object r = this.s.serialize(t);
        Assert.assertEquals((Object)e, (Object)r);
        this.s = XmlSerializer.create().ns().sq().pojoSwaps((Class[])this.getPojoSwaps()).trimNullProperties(false).build();
        e = "<object><AQID>a</AQID><BAUG _type='null'/><_x0000_>b</_x0000_></object>";
        r = this.s.serialize(t);
        Assert.assertEquals((Object)e, (Object)r);
        this.s = HtmlSerializer.create().sq().pojoSwaps((Class[])this.getPojoSwaps()).trimNullProperties(false).addKeyValueTableHeaders().build();
        e = "<table><tr><th>key</th><th>value</th></tr><tr><td>AQID</td><td>a</td></tr><tr><td>BAUG</td><td><null/></td></tr><tr><td><null/></td><td>b</td></tr></table>";
        r = this.s.serialize(t);
        Assert.assertEquals((Object)e, (Object)r);
        this.s = UonSerializer.create().encoding().pojoSwaps((Class[])this.getPojoSwaps()).trimNullProperties(false).build();
        e = "(AQID=a,BAUG=null,null=b)";
        r = this.s.serialize(t);
        Assert.assertEquals((Object)e, (Object)r);
        this.s = UrlEncodingSerializer.create().pojoSwaps((Class[])this.getPojoSwaps()).trimNullProperties(false).build();
        e = "AQID=a&BAUG=null&null=b";
        r = this.s.serialize(t);
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testMapDateString() throws Exception {
        Date td1 = new Date(1, 2, 3, 4, 5, 6);
        Date td2 = new Date(2, 3, 4, 5, 6, 7);
        Map<Date, String> t = new TreeMap<Date, String>();
        t.put(td1, "a");
        t.put(td2, null);
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[]{Date.class, String.class});
        Assert.assertEquals((Object)"a", t.get(td1));
        Assert.assertNull(null, t.get(td2));
        t = new HashMap();
        t.put(td1, "a");
        t.put(td2, null);
        t.put(null, "b");
        t = this.roundTrip(t, (Type)((Object)HashMap.class), new Type[]{Date.class, String.class});
        Assert.assertEquals((Object)"a", t.get(td1));
        Assert.assertNull(t.get(td2));
        Assert.assertEquals((Object)"b", t.get(null));
    }

    @Test
    public void testMapCalendarString() throws Exception {
        GregorianCalendar td1 = GregorianCalendar.from(ZonedDateTime.parse("2012-12-21T12:34:56Z"));
        GregorianCalendar td2 = GregorianCalendar.from(ZonedDateTime.parse("2012-12-21T12:34:57Z"));
        Map<GregorianCalendar, String> t = new TreeMap<GregorianCalendar, String>();
        t.put(td1, "a");
        t.put(td2, null);
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[]{GregorianCalendar.class, String.class});
        Assert.assertEquals((Object)"a", t.get(td1));
        Assert.assertNull(null, t.get(td2));
        t = new HashMap();
        t.put(td1, "a");
        t.put(td2, null);
        t.put(null, "b");
        t = this.roundTrip(t, (Type)((Object)HashMap.class), new Type[]{GregorianCalendar.class, String.class});
        Assert.assertEquals((Object)"a", t.get(td1));
        Assert.assertNull(t.get(td2));
        Assert.assertEquals((Object)"b", t.get(null));
    }

    @Test
    public void testMapEnumString() throws Exception {
        Map<TestEnum, String> t = new TreeMap<TestEnum, String>();
        t.put(TestEnum.FOO, "a");
        t.put(TestEnum.BAR, null);
        t = this.roundTrip(t, (Type)((Object)TreeMap.class), new Type[]{TestEnum.class, String.class});
        Assert.assertEquals((Object)"a", t.get((Object)TestEnum.FOO));
        Assert.assertNull(null, t.get((Object)TestEnum.BAR));
        t = new HashMap();
        t.put(TestEnum.FOO, "a");
        t.put(TestEnum.BAR, null);
        t.put(null, "b");
        t = this.roundTrip(t, (Type)((Object)HashMap.class), new Type[]{TestEnum.class, String.class});
        Assert.assertEquals((Object)"a", t.get((Object)TestEnum.FOO));
        Assert.assertNull(t.get((Object)TestEnum.BAR));
        Assert.assertEquals((Object)"b", t.get(null));
    }

    public static enum TestEnum {
        FOO,
        BAR,
        BAZ;

    }
}

