/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;

@Ignore
public class RoundTripLargeObjectsTest
extends RoundTripTest {
    private static final int NUM_RUNS = 10;
    private static final int SIZE_PARAM = 20000;

    public RoundTripLargeObjectsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getPairs() {
        return Arrays.asList({"Json DEFAULT", JsonSerializer.create().trimNullProperties(false), JsonParser.create(), 0}, {"SimpleJson DEFAULT", JsonSerializer.create().ssq().trimNullProperties(false), JsonParser.create(), 0}, {"Json DEFAULT_SQ", JsonSerializer.create().ssq().trimNullProperties(false), JsonParser.create(), 0}, {"Xml DEFAULT w/namespaces,validation", XmlSerializer.create().sq().ns().trimNullProperties(false).addNamespaceUrisToRoot().useWhitespace(), XmlParser.create(), RoundTripTest.Flags.CHECK_XML_WHITESPACE | RoundTripTest.Flags.VALIDATE_XML}, {"Xml DEFAULT wo/namespaces,validation", XmlSerializer.create().sq().trimNullProperties(false), XmlParser.create(), RoundTripTest.Flags.CHECK_XML_WHITESPACE}, {"Html", HtmlSerializer.create().trimNullProperties(false), HtmlParser.create(), RoundTripTest.Flags.CHECK_XML_WHITESPACE}, {"UrlEncoding", UrlEncodingSerializer.create().trimNullProperties(false), UrlEncodingParser.create(), 0}, {"Uon", UonSerializer.create().trimNullProperties(false), UonParser.create(), 0}, {"MsgPack", MsgPackSerializer.create().trimNullProperties(false), MsgPackParser.create(), 0});
    }

    @Test
    public void testLargeMap() throws Exception {
        int i;
        int numRuns = 10;
        A a = A.create();
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        System.err.println("\n---Speed test on " + this.label + "---");
        Object r = "";
        r = s.serialize((Object)a);
        System.err.println(StringUtils.format((String)"Serialized size: {0,number} ", (Object[])new Object[]{r instanceof String ? r.toString().length() : ((byte[])r).length}));
        p.parse(r, A.class);
        long startTime = System.currentTimeMillis();
        for (i = 0; i < numRuns; ++i) {
            r = s.serialize((Object)a);
        }
        System.err.println(StringUtils.format((String)"Average serialize time: {0,number}ms", (Object[])new Object[]{(System.currentTimeMillis() - startTime) / (long)numRuns}));
        startTime = System.currentTimeMillis();
        for (i = 0; i < numRuns; ++i) {
            a = (A)p.parse(r, A.class);
        }
        System.err.println(StringUtils.format((String)"Average parsed time: {0,number}ms", (Object[])new Object[]{(System.currentTimeMillis() - startTime) / (long)numRuns}));
    }

    public static class A1List
    extends LinkedList<A1> {
    }

    public static class A1Map
    extends LinkedHashMap<String, A1> {
    }

    public static class A1 {
        public String f1 = "a123456789b123456789c123456789d123456789e123456789f123456789g123456789h123456789i123456789j123456789";
    }

    public static class A {
        public A1Map a1Map;
        public A1List a1List;
        public A1[] a1Array;

        static A create() {
            A a = new A();
            a.a1Map = new A1Map();
            a.a1List = new A1List();
            for (int i = 0; i < 20000; ++i) {
                a.a1Map.put(String.valueOf(i), new A1());
                a.a1List.add(new A1());
            }
            a.a1Array = a.a1List.toArray(new A1[0]);
            return a;
        }
    }
}

