/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripGenericsTest
extends RoundTripTest {
    public RoundTripGenericsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testBeansWithUnboundTypeVars() throws Exception {
        if (this.returnOriginalObject) {
            return;
        }
        Pair<Source, Target> pair = new Pair<Source, Target>(new Source().init(), new Target().init());
        pair = this.roundTrip(pair);
        TestUtils.assertSortedObjectEquals("{s:{s1:'a1'},t:{t1:'b1'}}", pair);
        Assert.assertEquals((Object)"ObjectMap", (Object)pair.getS().getClass().getSimpleName());
        Assert.assertEquals((Object)"ObjectMap", (Object)pair.getT().getClass().getSimpleName());
        pair = this.roundTrip(pair, (Type)((Object)RealPair.class), new Type[0]);
        TestUtils.assertSortedObjectEquals("{s:{s1:'a1'},t:{t1:'b1'}}", pair);
        Assert.assertEquals((Object)"Source", (Object)pair.getS().getClass().getSimpleName());
        Assert.assertEquals((Object)"Target", (Object)pair.getT().getClass().getSimpleName());
    }

    public static class Target {
        public String t1;

        public Target init() {
            this.t1 = "b1";
            return this;
        }
    }

    public static class Source {
        public String s1;

        public Source init() {
            this.s1 = "a1";
            return this;
        }
    }

    public static class RealPair
    extends Pair<Source, Target> {
    }

    @Bean(bpi="s,t")
    public static class Pair<S, T> {
        private S s;
        private T t;

        public Pair() {
        }

        public Pair(S s, T t) {
            this.s = s;
            this.t = t;
        }

        public S getS() {
            return this.s;
        }

        public void setS(S s) {
            this.s = s;
        }

        public T getT() {
            return this.t;
        }

        public void setT(T t) {
            this.t = t;
        }
    }
}

