/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.ASet;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripEnumTest
extends RoundTripTest {
    public RoundTripEnumTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testEnumA() throws Exception {
        AEnum t = AEnum.FOO;
        TestUtils.assertObjectEquals("'FOO'", (Object)t);
        t = this.roundTrip(t, (Type)((Object)AEnum.class), new Type[0]);
        Assert.assertEquals((Object)((Object)AEnum.FOO), (Object)((Object)t));
    }

    @Test
    public void testEnumB() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().beanFilters((Class[])this.getBeanFilters()).pojoSwaps((Class[])this.getPojoSwaps()).build();
        BEnum t = BEnum.FOO;
        Assert.assertEquals((Object)"'xfoo'", (Object)s.serialize((Object)t));
        t = this.roundTrip(t, (Type)((Object)BEnum.class), new Type[0]);
        Assert.assertEquals((Object)((Object)BEnum.FOO), (Object)((Object)t));
    }

    @Test
    public void testEnumArrayA() throws Exception {
        AEnum[] t = new AEnum[]{AEnum.FOO, AEnum.BAR, null};
        TestUtils.assertObjectEquals("['FOO','BAR',null]", t);
        t = this.roundTrip(t, (Type)((Object)AEnum[].class), new Type[0]);
        Assert.assertEquals((Object)((Object)AEnum.FOO), (Object)((Object)t[0]));
        Assert.assertEquals((Object)((Object)AEnum.BAR), (Object)((Object)t[1]));
        Assert.assertNull((Object)((Object)t[2]));
    }

    @Test
    public void testEnumArrayB() throws Exception {
        BEnum[] t = new BEnum[]{BEnum.FOO, BEnum.BAR, null};
        TestUtils.assertObjectEquals("['xfoo','xbar',null]", t);
        t = this.roundTrip(t, (Type)((Object)BEnum[].class), new Type[0]);
        Assert.assertEquals((Object)((Object)BEnum.FOO), (Object)((Object)t[0]));
        Assert.assertEquals((Object)((Object)BEnum.BAR), (Object)((Object)t[1]));
        Assert.assertNull((Object)((Object)t[2]));
    }

    @Test
    public void testEnum2dArrayA() throws Exception {
        AEnum[][] t = new AEnum[][]{{AEnum.FOO, AEnum.BAR, null}, null};
        TestUtils.assertObjectEquals("[['FOO','BAR',null],null]", t);
        t = this.roundTrip(t, (Type)((Object)AEnum[][].class), new Type[0]);
        Assert.assertEquals((Object)((Object)AEnum.FOO), (Object)((Object)t[0][0]));
        Assert.assertEquals((Object)((Object)AEnum.BAR), (Object)((Object)t[0][1]));
        Assert.assertNull((Object)((Object)t[0][2]));
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testEnum2dArrayB() throws Exception {
        BEnum[][] t = new BEnum[][]{{BEnum.FOO, BEnum.BAR, null}, null};
        TestUtils.assertObjectEquals("[['xfoo','xbar',null],null]", t);
        t = this.roundTrip(t, (Type)((Object)BEnum[][].class), new Type[0]);
        Assert.assertEquals((Object)((Object)BEnum.FOO), (Object)((Object)t[0][0]));
        Assert.assertEquals((Object)((Object)BEnum.BAR), (Object)((Object)t[0][1]));
        Assert.assertNull((Object)((Object)t[0][2]));
        Assert.assertNull((Object)t[1]);
    }

    @Test
    public void testBeansWithEnumA() throws Exception {
        A t1 = new A().init();
        A t2 = this.roundTrip(t1, (Type)((Object)A.class), new Type[0]);
        TestUtils.assertEqualObjects(t1, t2);
        Assert.assertEquals((Object)((Object)AEnum.FOO), (Object)((Object)t2.f3[0]));
        Assert.assertNull((Object)((Object)t2.f3[1]));
        Assert.assertEquals((Object)((Object)AEnum.FOO), (Object)((Object)t2.f4[0][0]));
        Assert.assertNull((Object)((Object)t2.f4[0][1]));
        Assert.assertNull((Object)t2.f4[1]);
    }

    @Test
    public void testBeansWithEnumB() throws Exception {
        B t1 = new B().init();
        B t2 = this.roundTrip(t1, (Type)((Object)B.class), new Type[0]);
        TestUtils.assertEqualObjects(t1, t2);
        Assert.assertEquals((Object)((Object)BEnum.FOO), (Object)((Object)t2.f3[0]));
        Assert.assertNull((Object)((Object)t2.f3[1]));
        Assert.assertEquals((Object)((Object)BEnum.FOO), (Object)((Object)t2.f4[0][0]));
        Assert.assertNull((Object)((Object)t2.f4[0][1]));
        Assert.assertNull((Object)t2.f4[1]);
    }

    public static class B {
        public BEnum f1;
        private BEnum f2;
        public BEnum[] f3;
        public BEnum[][] f4;
        public List<BEnum> f5 = new LinkedList<BEnum>();
        private List<BEnum> f6 = new LinkedList<BEnum>();
        public Set<BEnum> f7 = new HashSet<BEnum>();
        private Set<BEnum> f8 = new HashSet<BEnum>();
        public Map<BEnum, BEnum> f9 = new LinkedHashMap<BEnum, BEnum>();

        public BEnum getF2() {
            return this.f2;
        }

        public void setF2(BEnum f2) {
            this.f2 = f2;
        }

        public List<BEnum> getF6() {
            return this.f6;
        }

        public void setF6(List<BEnum> f6) {
            this.f6 = f6;
        }

        public Set<BEnum> getF8() {
            return this.f8;
        }

        public void setF8(Set<BEnum> f8) {
            this.f8 = f8;
        }

        public B init() {
            this.f1 = BEnum.FOO;
            this.f2 = BEnum.BAR;
            this.f3 = new BEnum[]{BEnum.FOO, null};
            this.f4 = new BEnum[][]{{BEnum.FOO, null}, null};
            this.f5 = new AList().append((Object)BEnum.FOO);
            this.f6 = new AList().append((Object)BEnum.FOO);
            this.f7 = new ASet().append((Object)BEnum.FOO);
            this.f8 = new ASet().append((Object)BEnum.FOO);
            return this;
        }
    }

    public static class A {
        public AEnum f1;
        private AEnum f2;
        public AEnum[] f3;
        public AEnum[][] f4;
        public List<AEnum> f5 = new LinkedList<AEnum>();
        private List<AEnum> f6 = new LinkedList<AEnum>();
        public Set<AEnum> f7 = new HashSet<AEnum>();
        private Set<AEnum> f8 = new HashSet<AEnum>();
        public Map<AEnum, AEnum> f9 = new LinkedHashMap<AEnum, AEnum>();

        public AEnum getF2() {
            return this.f2;
        }

        public void setF2(AEnum f2) {
            this.f2 = f2;
        }

        public List<AEnum> getF6() {
            return this.f6;
        }

        public void setF6(List<AEnum> f6) {
            this.f6 = f6;
        }

        public Set<AEnum> getF8() {
            return this.f8;
        }

        public void setF8(Set<AEnum> f8) {
            this.f8 = f8;
        }

        public A init() {
            this.f1 = AEnum.FOO;
            this.f2 = AEnum.BAR;
            this.f3 = new AEnum[]{AEnum.FOO, null};
            this.f4 = new AEnum[][]{{AEnum.FOO, null}, null};
            this.f5 = new AList().append((Object)AEnum.FOO);
            this.f6 = new AList().append((Object)AEnum.FOO);
            this.f7 = new ASet().append((Object)AEnum.FOO);
            this.f8 = new ASet().append((Object)AEnum.FOO);
            return this;
        }
    }

    public static enum BEnum {
        FOO("xfoo"),
        BAR("xbar"),
        BAZ("xbaz");

        private String val;

        private BEnum(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }

        public static BEnum fromString(String val) {
            if (val.equals("xfoo")) {
                return FOO;
            }
            if (val.equals("xbar")) {
                return BAR;
            }
            if (val.equals("xbaz")) {
                return BAZ;
            }
            return null;
        }
    }

    public static enum AEnum {
        FOO,
        BAR,
        BAZ;

    }
}

