/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.util.List;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.utils.AList;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class RoundTripBeanPropertiesTest
extends RoundTripTest {
    public RoundTripBeanPropertiesTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void a01_arrayOfListOfLongs() throws Exception {
        A01 o = new A01();
        o.f1 = new List[1];
        o.f1[0] = AList.create((Object[])new Long[]{123L});
        o = this.roundTrip(o);
        Assert.assertEquals((long)123L, (long)o.f1[0].get(0).intValue());
        Assert.assertTrue((boolean)(o.f1[0].get(0) instanceof Long));
    }

    @Test
    public void a02_ListOfArrayOfLongs() throws Exception {
        A02 o = new A02();
        o.f1 = AList.create((Object[])new Long[][]{{123L}});
        o = this.roundTrip(o);
        Assert.assertEquals((long)123L, (long)o.f1.get(0)[0].intValue());
        Assert.assertTrue((boolean)(o.f1.get(0)[0] instanceof Long));
    }

    @Test
    public void a03_2dArrayOfListOfLongs() throws Exception {
        A03 o = new A03();
        o.f1 = new List[1][1];
        o.f1[0] = new List[]{AList.create((Object[])new Long[]{123L})};
        o = this.roundTrip(o);
        Assert.assertEquals((long)123L, (long)o.f1[0][0].get(0).intValue());
        Assert.assertTrue((boolean)(o.f1[0][0].get(0) instanceof Long));
    }

    @Test
    public void a04_ListOf2dArrayOfLongs() throws Exception {
        A04 o = new A04();
        o.f1 = AList.create((Object[])new Long[][][]{{{123L}}});
        o = this.roundTrip(o);
        Assert.assertEquals((long)123L, (long)o.f1.get(0)[0][0].intValue());
        Assert.assertTrue((boolean)(o.f1.get(0)[0][0] instanceof Long));
    }

    public static class A04 {
        public List<Long[][]> f1;
    }

    public static class A03 {
        public List<Long>[][] f1;
    }

    public static class A02 {
        public List<Long[]> f1;
    }

    public static class A01 {
        public List<Long>[] f1;
    }
}

