/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.BeanDictionaryMap;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.dto.html5.Head;
import org.apache.juneau.dto.html5.Style;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.annotation.Json;
import org.apache.juneau.json.annotation.JsonConfig;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.InterfaceBeanFilterBuilder;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class RoundTripBeanMapsTest
extends RoundTripTest {
    static Class<?>[] ANNOTATED_CLASSES = new Class[]{L2.class, M2.class};

    public RoundTripBeanMapsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s.applyAnnotations((Class[])ANNOTATED_CLASSES), p == null ? null : p.applyAnnotations((Class[])ANNOTATED_CLASSES), flags);
    }

    public Map<Class<?>, Class<?>> getImplClasses() {
        HashMap m = new HashMap();
        m.put(IBean.class, CBean.class);
        return m;
    }

    @Test
    public void testImplClasses() throws Exception {
        IBean bean = new CBean();
        bean.setF1("bar");
        bean = this.roundTrip(bean, (Type)((Object)IBean.class), new Type[0]);
        Assert.assertEquals((Object)"bar", (Object)bean.getF1());
        bean.setF1("baz");
        bean = this.roundTrip(bean, (Type)((Object)ABean.class), new Type[0]);
        Assert.assertEquals((Object)"baz", (Object)bean.getF1());
        bean.setF1("bing");
        bean = this.roundTrip(bean, (Type)((Object)CBean.class), new Type[0]);
        Assert.assertEquals((Object)"bing", (Object)bean.getF1());
    }

    @Test
    public void testImplArrayClasses() throws Exception {
        IBean[] bean = new CBean[]{new CBean()};
        bean[0].setF1("bar");
        bean = this.roundTrip(bean, (Type)((Object)IBean[].class), new Type[0]);
        Assert.assertEquals((Object)"bar", (Object)bean[0].getF1());
        bean[0].setF1("baz");
        bean = this.roundTrip(bean, (Type)((Object)ABean[].class), new Type[0]);
        Assert.assertEquals((Object)"baz", (Object)bean[0].getF1());
        bean[0].setF1("bing");
        bean = this.roundTrip(bean, (Type)((Object)CBean[].class), new Type[0]);
        Assert.assertEquals((Object)"bing", (Object)bean[0].getF1());
    }

    @Test
    public void testImplListClasses() throws Exception {
        Object l = AList.create((Object[])new IBean[]{new CBean()});
        ((IBean)l.get(0)).setF1("bar");
        l = (List)this.roundTrip(l, (Type)((Object)List.class), new Type[]{IBean.class});
        Assert.assertEquals((Object)"bar", (Object)((IBean)l.get(0)).getF1());
        l = (List)this.roundTrip(l, (Type)((Object)LinkedList.class), new Type[]{IBean.class});
        Assert.assertEquals((Object)"bar", (Object)((IBean)l.get(0)).getF1());
        ((IBean)l.get(0)).setF1("baz");
        l = (List)this.roundTrip(l, (Type)((Object)List.class), new Type[]{ABean.class});
        Assert.assertEquals((Object)"baz", (Object)((IBean)l.get(0)).getF1());
        l = (List)this.roundTrip(l, (Type)((Object)LinkedList.class), new Type[]{ABean.class});
        Assert.assertEquals((Object)"baz", (Object)((IBean)l.get(0)).getF1());
        ((IBean)l.get(0)).setF1("bing");
        l = (List)this.roundTrip(l, (Type)((Object)List.class), new Type[]{CBean.class});
        Assert.assertEquals((Object)"bing", (Object)((IBean)l.get(0)).getF1());
        l = (List)this.roundTrip(l, (Type)((Object)LinkedList.class), new Type[]{CBean.class});
        Assert.assertEquals((Object)"bing", (Object)((IBean)l.get(0)).getF1());
    }

    @Test
    public void testImplMap() throws Exception {
        Object l = new AMap().append((Object)"foo", (Object)new CBean());
        ((IBean)l.get("foo")).setF1("bar");
        l = (Map)this.roundTrip(l, (Type)((Object)Map.class), new Type[]{String.class, IBean.class});
        Assert.assertEquals((Object)"bar", (Object)((IBean)l.get("foo")).getF1());
        l = (Map)this.roundTrip(l, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, IBean.class});
        Assert.assertEquals((Object)"bar", (Object)((IBean)l.get("foo")).getF1());
        ((IBean)l.get("foo")).setF1("baz");
        l = (Map)this.roundTrip(l, (Type)((Object)Map.class), new Type[]{String.class, ABean.class});
        Assert.assertEquals((Object)"baz", (Object)((IBean)l.get("foo")).getF1());
        l = (Map)this.roundTrip(l, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, ABean.class});
        Assert.assertEquals((Object)"baz", (Object)((IBean)l.get("foo")).getF1());
        ((IBean)l.get("foo")).setF1("bing");
        l = (Map)this.roundTrip(l, (Type)((Object)Map.class), new Type[]{String.class, CBean.class});
        Assert.assertEquals((Object)"bing", (Object)((IBean)l.get("foo")).getF1());
        l = (Map)this.roundTrip(l, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, CBean.class});
        Assert.assertEquals((Object)"bing", (Object)((IBean)l.get("foo")).getF1());
    }

    @Test
    public void testImplMap2() throws Exception {
        A b = new A(1);
        b = this.roundTrip(b);
        if (this.returnOriginalObject || this.p == null) {
            return;
        }
        Assert.assertEquals((long)0L, (long)b.f1);
        Assert.assertEquals((long)0L, (long)b.f2);
        Assert.assertEquals((long)1L, (long)b.f3);
        Assert.assertEquals((long)1L, (long)b.f4);
        Assert.assertEquals((long)0L, (long)b.getF5());
        Assert.assertEquals((long)1L, (long)b.getF6());
    }

    @Test
    public void testSubTypesUsingAnnotation() throws Exception {
        JsonSerializer js = JsonSerializer.create().ssq().addBeanTypes().addRootType().build();
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        B1 b1 = B1.create();
        Object r = s.serialize((Object)b1);
        B b = (B)p.parse(r, B.class);
        Assert.assertTrue((boolean)(b instanceof B1));
        TestUtils.assertObjectEquals("{_type:'B1',f0:'f0',f1:'f1'}", b, (WriterSerializer)js);
        B2 b2 = B2.create();
        r = s.serialize((Object)b2);
        b = (B)p.parse(r, B.class);
        Assert.assertTrue((boolean)(b instanceof B2));
        TestUtils.assertObjectEquals("{_type:'B2',f0:'f0',f2:1}", b, (WriterSerializer)js);
        B3 b3 = B3.create();
        r = s.serialize((Object)b3);
        b = (B)p.parse(r, B.class);
        Assert.assertTrue((boolean)(b instanceof B3));
        TestUtils.assertObjectEquals("{_type:'B3',f0:'f0',f3:'2001-01-01T12:34:56.789Z'}", b, (WriterSerializer)js);
    }

    @Test
    public void testSubTypesUsingBeanFilter() throws Exception {
        JsonSerializer js = JsonSerializer.create().ssq().build();
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer().builder().beanFilters(new Class[]{CFilter.class}).build();
        Parser p = this.getParser().builder().beanFilters(new Class[]{CFilter.class}).build();
        C1 c1 = C1.create();
        Object r = s.serialize((Object)c1);
        C c = (C)p.parse(r, C.class);
        Assert.assertTrue((boolean)(c instanceof C1));
        TestUtils.assertObjectEquals("{f0:'f0',f1:'f1'}", c, (WriterSerializer)js);
        C2 c2 = C2.create();
        r = s.serialize((Object)c2);
        c = (C)p.parse(r, C.class);
        Assert.assertTrue((boolean)(c instanceof C2));
        TestUtils.assertObjectEquals("{f0:'f0',f2:1}", c, (WriterSerializer)js);
        C3 c3 = C3.create();
        r = s.serialize((Object)c3);
        c = (C)p.parse(r, C.class);
        Assert.assertTrue((boolean)(c instanceof C3));
        TestUtils.assertObjectEquals("{f0:'f0',f3:'2001-01-01T12:34:56.789Z'}", c, (WriterSerializer)js);
    }

    @Test
    public void testSubTypePropertyWithRealPropertyUsingAnnotation() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        BA1 ba1 = BA1.create();
        Object r = s.serialize((Object)ba1);
        BA b = (BA)p.parse(r, BA.class);
        Assert.assertTrue((boolean)(b instanceof BA1));
        TestUtils.assertObjectEquals("{_type:'BA1',f0a:'f0a',f0b:'f0b',f1:'f1'}", b);
    }

    @Test
    public void testSubTypePropertyWithRealPropertyUsingBeanFilter() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer().builder().beanFilters(new Class[]{CAFilter.class}).build();
        Parser p = this.getParser().builder().beanFilters(new Class[]{CAFilter.class}).build();
        CA1 c1 = CA1.create();
        Object r = s.serialize((Object)c1);
        CA c = (CA)p.parse(r, CA.class);
        Assert.assertTrue((boolean)(c instanceof CA1));
        TestUtils.assertObjectEquals("{f0a:'f0a',f0b:'f0b',f1:'f1'}", c);
    }

    @Test
    public void testPropertiesUsingAnnotation() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        D1 d = new D1().init();
        Object r = s.serialize((Object)d);
        d = (D1)p.parse(r, D1.class);
        Assert.assertNull((Object)d.f1);
        TestUtils.assertObjectEquals("{f3:'f3',f2:'f2'}", d);
    }

    @Test
    public void testPropertiesUsingBeanFilter() throws Exception {
        JsonSerializer js = JsonSerializer.create().ssq().beanFilters(new Class[]{D2Filter.class}).build();
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer().builder().beanFilters(new Class[]{D2Filter.class}).build();
        Parser p = this.getParser().builder().beanFilters(new Class[]{D2Filter.class}).build();
        D2 d = new D2().init();
        Object r = s.serialize((Object)d);
        d = (D2)p.parse(r, D2.class);
        Assert.assertNull((Object)d.f1);
        TestUtils.assertObjectEquals("{f3:'f3',f2:'f2'}", d, (WriterSerializer)js);
    }

    @Test
    public void testExcludePropertiesUsingAnnotation() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        E1 e = new E1().init();
        Object r = s.serialize((Object)e);
        e = (E1)p.parse(r, E1.class);
        TestUtils.assertObjectEquals("{f1:'f1',f3:'f3'}", e);
    }

    @Test
    public void testExcludePropertiesUsingBeanFilter() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer().builder().beanFilters(new Class[]{E2Filter.class}).build();
        Parser p = this.getParser().builder().beanFilters(new Class[]{E2Filter.class}).build();
        E2 e = new E2().init();
        Object r = s.serialize((Object)e);
        e = (E2)p.parse(r, E2.class);
        TestUtils.assertObjectEquals("{f1:'f1',f3:'f3'}", e);
    }

    @Test
    public void testInterfaceClassUsingAnnotation() throws Exception {
        if (this.isValidationOnly()) {
            return;
        }
        Serializer s = this.getSerializer();
        Parser p = this.getParser();
        FA2 t = new FA2().init();
        Object r = s.serialize((Object)t);
        t = (FA2)p.parse(r, FA2.class);
        TestUtils.assertObjectEquals("{f1:'f1'}", t);
    }

    @Test
    public void testInterfaceClassUsingBeanFilter() throws Exception {
        ParserBuilder p;
        SerializerBuilder s = this.getSerializer().builder();
        ParserBuilder parserBuilder = p = this.getParser() == null ? null : this.getParser().builder();
        if (this.isValidationOnly()) {
            return;
        }
        s.beanFilters(new Class[]{FB1Filter.class});
        p.beanFilters(new Class[]{FB1Filter.class});
        FB2 t = new FB2().init();
        Object r = s.build().serialize((Object)t);
        t = (FB2)p.build().parse(r, FB2.class);
        TestUtils.assertObjectEquals("{f1:'f1'}", t);
        s.beanFilters(new Class[]{FB2Filter.class});
        p.beanFilters(new Class[]{FB2Filter.class});
        t = new FB2().init();
        r = s.build().serialize((Object)t);
        t = (FB2)p.build().parse(r, FB2.class);
        TestUtils.assertObjectEquals("{f1:'f1'}", t);
        s.beanFilters(new Class[]{FB1.class});
        p.beanFilters(new Class[]{FB1.class});
        t = new FB2().init();
        r = s.build().serialize((Object)t);
        t = (FB2)p.build().parse(r, FB2.class);
        TestUtils.assertObjectEquals("{f1:'f1'}", t);
    }

    @Test
    public void testMemberClass() throws Exception {
        G t = G.create();
        t = this.roundTrip(t, (Type)((Object)G.class), new Type[0]);
    }

    @Test
    public void testMemberClassWithMapClass() throws Exception {
        H t = H.create();
        t = this.roundTrip(t, (Type)((Object)H.class), new Type[0]);
    }

    @Test
    public void testMemberClassWithListClass() throws Exception {
        I t = I.create();
        t = this.roundTrip(t, (Type)((Object)I.class), new Type[0]);
    }

    @Test
    public void testMemberClassWithStringConstructor() throws Exception {
        J t = J.create();
        t = this.roundTrip(t, (Type)((Object)J.class), new Type[0]);
    }

    @Test
    public void testBeanPropertyPrecedence() throws Exception {
        K t = K.create();
        t = this.roundTrip(t, (Type)((Object)K.class), new Type[0]);
    }

    @Test
    public void testWrapperAttrAnnotationOnBean() throws Exception {
        L t = L.create();
        t = this.roundTrip(t, (Type)((Object)L.class), new Type[0]);
        LinkedHashMap<String, L> m = new LinkedHashMap<String, L>();
        m.put("bar", L.create());
        this.roundTrip(m, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, L.class});
    }

    @Test
    public void testWrapperAttrAnnotationOnBean_usingConfig() throws Exception {
        L2 t = L2.create();
        t = this.roundTrip(t, (Type)((Object)L2.class), new Type[0]);
        LinkedHashMap<String, L2> m = new LinkedHashMap<String, L2>();
        m.put("bar", L2.create());
        this.roundTrip(m, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, L2.class});
    }

    @Test
    public void testWrapperAttrAnnotationOnNonBean() throws Exception {
        M t = M.create();
        t = this.roundTrip(t, (Type)((Object)M.class), new Type[0]);
        LinkedHashMap<String, M> m = new LinkedHashMap<String, M>();
        m.put("bar", M.create());
        this.roundTrip(m, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, M.class});
    }

    @Test
    public void testWrapperAttrAnnotationOnNonBean_usingConfig() throws Exception {
        M2 t = M2.create();
        t = this.roundTrip(t, (Type)((Object)M2.class), new Type[0]);
        LinkedHashMap<String, M2> m = new LinkedHashMap<String, M2>();
        m.put("bar", M2.create());
        this.roundTrip(m, (Type)((Object)LinkedHashMap.class), new Type[]{String.class, M2.class});
    }

    @Test
    public void testBeanPropertyWithBeanWithAttrsField() throws Exception {
        N t = N.create();
        t = this.roundTrip(t, (Type)((Object)N.class), new Type[0]);
        t.f1.type("foo");
        t = this.roundTrip(t, (Type)((Object)N.class), new Type[0]);
        t.f1.attr("foo", (Object)"bar").attrUri("href", (Object)"http://foo");
        t = this.roundTrip(t, (Type)((Object)N.class), new Type[0]);
        Head h = new Head().child((Object)new Style());
        h = this.roundTrip(h, (Type)((Object)Head.class), new Type[0]);
    }

    public static class N {
        public Style f1;

        static N create() {
            N n = new N();
            n.f1 = new Style();
            return n;
        }
    }

    @JsonConfig(applyJson={@Json(on="M2", wrapperAttr="foo")})
    public static class M2 {
        int f1;

        static M2 create() {
            M2 m = new M2();
            m.f1 = 1;
            return m;
        }

        public String toString() {
            return String.valueOf(this.f1);
        }

        public static M2 valueOf(String s) {
            M2 m = new M2();
            m.f1 = Integer.parseInt(s);
            return m;
        }
    }

    @Json(wrapperAttr="foo")
    public static class M {
        int f1;

        static M create() {
            M m = new M();
            m.f1 = 1;
            return m;
        }

        public String toString() {
            return String.valueOf(this.f1);
        }

        public static M valueOf(String s) {
            M m = new M();
            m.f1 = Integer.parseInt(s);
            return m;
        }
    }

    @JsonConfig(applyJson={@Json(on="L2", wrapperAttr="foo")})
    public static class L2 {
        public int f1;

        static L2 create() {
            L2 l = new L2();
            l.f1 = 1;
            return l;
        }
    }

    @Json(wrapperAttr="foo")
    public static class L {
        public int f1;

        static L create() {
            L l = new L();
            l.f1 = 1;
            return l;
        }
    }

    public static class K {
        private KEnum a;
        private KEnum b;
        private KEnum c;

        static K create() {
            K t = new K();
            t.a = KEnum.FOO;
            t.b = KEnum.BAR;
            t.c = KEnum.BAZ;
            return t;
        }

        @BeanIgnore
        public KEnum getA() {
            return KEnum.FOO;
        }

        @Beanp(name="a")
        public String getA2() {
            return this.a.toString();
        }

        public void setA(KEnum a) {
            throw new RuntimeException("Should not be called!");
        }

        public void setA(String a) {
            this.a = KEnum.valueOf(a);
        }

        public KEnum getB() {
            return this.b;
        }

        public void setB(String b) {
            throw new RuntimeException("Should not be called!");
        }

        public void setB(Object b) {
            throw new RuntimeException("Should not be called!");
        }

        public void setB(KEnum b) {
            this.b = b;
        }

        public KEnum getC() {
            return this.c;
        }

        public void setC(KEnum c) {
            this.c = c;
        }

        public void setC(String c) {
            throw new RuntimeException("Should not be called!");
        }

        public void setC(Object c) {
            throw new RuntimeException("Should not be called!");
        }
    }

    public static enum KEnum {
        FOO,
        BAR,
        BAZ;

    }

    public static class J {
        public J2 j2;

        static J create() {
            J j = new J();
            j.init();
            return j;
        }

        private void init() {
            this.j2 = new J2("2");
        }

        public class J2 {
            int a2;

            public J2(String arg) {
                this.a2 = Integer.parseInt(arg);
            }

            public String toString() {
                return String.valueOf(this.a2);
            }
        }
    }

    public static class I
    extends LinkedList<I1> {
        static I create() {
            I i = new I();
            i.add(1, 2);
            return i;
        }

        I add(int a2, int a3) {
            I1 i1 = new I1();
            i1.a2 = a2;
            i1.i2.a3 = a3;
            super.add(i1);
            return this;
        }

        public class I1 {
            public int a2;
            public I2 i2 = new I2();

            public class I2 {
                public int a3;
            }
        }
    }

    public static class H
    extends LinkedHashMap<String, H1> {
        static H create() {
            H h = new H();
            h.add("foo", 1, 2);
            return h;
        }

        H add(String key, int a2, int a3) {
            H1 h1 = new H1();
            h1.a2 = a2;
            h1.h2.a3 = a3;
            this.put(key, h1);
            return this;
        }

        public class H1 {
            public int a2;
            public H2 h2 = new H2();

            public class H2 {
                public int a3;
            }
        }
    }

    public static class G {
        public int a1;
        public G1 g1 = new G1();

        public static G create() {
            G g = new G();
            g.a1 = 1;
            g.g1.a2 = 2;
            g.g1.g2.a3 = 3;
            return g;
        }

        public class G1 {
            public int a2;
            public G2 g2 = new G2();

            public class G2 {
                public int a3;
            }
        }
    }

    public static class FB2Filter
    extends InterfaceBeanFilterBuilder<FB1> {
    }

    public static class FB1Filter
    extends InterfaceBeanFilterBuilder<FB1> {
    }

    public static class FB2
    extends FB1 {
        public String f2;

        public FB2 init() {
            this.f1 = "f1";
            this.f2 = "f2";
            return this;
        }
    }

    public static class FB1 {
        public String f1;
    }

    public static class FA2
    extends FA1 {
        public String f2;

        public FA2 init() {
            this.f1 = "f1";
            this.f2 = "f2";
            return this;
        }
    }

    @Bean(interfaceClass=FA1.class)
    public static class FA1 {
        public String f1;
    }

    public static class E2Filter
    extends BeanFilterBuilder<E2> {
        public E2Filter() {
            this.bpx(new String[]{"f2"});
        }
    }

    public static class E2 {
        public String f1;
        public String f2;
        public String f3;

        public E2 init() {
            this.f1 = "f1";
            this.f2 = "f2";
            this.f3 = "f3";
            return this;
        }
    }

    @Bean(bpx="f2")
    public static class E1 {
        public String f1;
        public String f2;
        public String f3;

        public E1 init() {
            this.f1 = "f1";
            this.f2 = "f2";
            this.f3 = "f3";
            return this;
        }
    }

    public static class D2Filter
    extends BeanFilterBuilder<D2> {
        public D2Filter() {
            this.bpi(new String[]{"f3,f2"});
        }
    }

    public static class D2 {
        public String f1;
        public String f2;
        public String f3;

        public D2 init() {
            this.f1 = "f1";
            this.f2 = "f2";
            this.f3 = "f3";
            return this;
        }
    }

    @Bean(bpi="f3,f2")
    public static class D1 {
        public String f1;
        public String f2;
        public String f3;

        public D1 init() {
            this.f1 = "f1";
            this.f2 = "f2";
            this.f3 = "f3";
            return this;
        }
    }

    public static class CAFilterDictionaryMap
    extends BeanDictionaryMap {
        public CAFilterDictionaryMap() {
            this.addClass("CA1", CA1.class);
            this.addClass("CA2", CA2.class);
        }
    }

    public static class CAFilter
    extends BeanFilterBuilder<CA> {
        public CAFilter() {
            this.dictionary(new Class[]{CAFilterDictionaryMap.class});
        }
    }

    public static class CA2
    extends CA {
        public String f2;
    }

    public static class CA1
    extends CA {
        public String f1;

        public static CA1 create() {
            CA1 c = new CA1();
            c.f0a = "f0a";
            c.f0b = "f0b";
            c.f1 = "f1";
            return c;
        }
    }

    public static abstract class CA {
        public String f0a;
        public String f0b;
    }

    @Bean(typeName="BA2")
    public static class BA2
    extends BA {
        public String f2;
    }

    @Bean(typeName="BA1")
    public static class BA1
    extends BA {
        public String f1;

        public static BA1 create() {
            BA1 b = new BA1();
            b.f0a = "f0a";
            b.f0b = "f0b";
            b.f1 = "f1";
            return b;
        }
    }

    @Bean(dictionary={BA1.class, BA2.class})
    public static abstract class BA {
        public String f0a;
        public String f0b;
    }

    public static class CFilterDictionaryMap
    extends BeanDictionaryMap {
        public CFilterDictionaryMap() {
            this.addClass("C1", C1.class);
            this.addClass("C2", C2.class);
            this.addClass("C3", C3.class);
        }
    }

    public static class CFilter
    extends BeanFilterBuilder<C> {
        public CFilter() {
            this.dictionary(new Class[]{CFilterDictionaryMap.class});
        }
    }

    public static class C3
    extends C {
        public XMLGregorianCalendar f3;

        public static C3 create() throws Exception {
            C3 c = new C3();
            c.f0 = "f0";
            c.f3 = DatatypeFactory.newInstance().newXMLGregorianCalendar("2001-01-01T12:34:56.789Z");
            return c;
        }
    }

    public static class C2
    extends C {
        public int f2;

        public static C2 create() {
            C2 c = new C2();
            c.f0 = "f0";
            c.f2 = 1;
            return c;
        }
    }

    public static class C1
    extends C {
        public String f1;

        public static C1 create() {
            C1 c = new C1();
            c.f0 = "f0";
            c.f1 = "f1";
            return c;
        }
    }

    public static abstract class C {
        public String f0;
    }

    @Bean(typeName="B3")
    public static class B3
    extends B {
        public XMLGregorianCalendar f3;

        public static B3 create() throws Exception {
            B3 b = new B3();
            b.f0 = "f0";
            b.f3 = DatatypeFactory.newInstance().newXMLGregorianCalendar("2001-01-01T12:34:56.789Z");
            return b;
        }
    }

    @Bean(typeName="B2")
    public static class B2
    extends B {
        public int f2;

        public static B2 create() {
            B2 b = new B2();
            b.f0 = "f0";
            b.f2 = 1;
            return b;
        }
    }

    @Bean(typeName="B1")
    public static class B1
    extends B {
        public String f1;

        public static B1 create() {
            B1 b = new B1();
            b.f0 = "f0";
            b.f1 = "f1";
            return b;
        }
    }

    @Bean(dictionary={B1.class, B2.class, B3.class})
    public static abstract class B {
        public String f0 = "f0";
    }

    public static class A {
        @BeanIgnore
        public int f1;
        @BeanIgnore
        public int f2;
        public int f3;
        public int f4;
        private int f5;
        private int f6;

        @BeanIgnore
        public int getF5() {
            return this.f5;
        }

        public void setF5(int f5) {
            this.f5 = f5;
        }

        public int getF6() {
            return this.f6;
        }

        public void setF6(int f6) {
            this.f6 = f6;
        }

        public A() {
        }

        public A(int v) {
            this.f5 = this.f6 = v;
            this.f4 = this.f6;
            this.f3 = this.f6;
            this.f2 = this.f6;
            this.f1 = this.f6;
        }
    }

    public static class CBean
    extends ABean {
        private String f1 = "foo";

        @Override
        public String getF1() {
            return this.f1;
        }

        @Override
        public void setF1(String f1) {
            this.f1 = f1;
        }
    }

    public static abstract class ABean
    implements IBean {
        @Override
        public abstract String getF1();

        @Override
        public abstract void setF1(String var1);
    }

    public static interface IBean {
        public String getF1();

        public void setF1(String var1);
    }
}

