/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class RoundTripBeanInheritanceTest
extends RoundTripTest {
    public RoundTripBeanInheritanceTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Test
    public void testBeanInheritance() throws Exception {
        if (this.returnOriginalObject) {
            return;
        }
        A2 t1 = new A2();
        t1.init();
        A2 t2 = this.roundTrip(t1, (Type)((Object)A2.class), new Type[0]);
        TestUtils.assertEqualObjects(t1, t2);
        A3 t3 = new A3();
        t3.init();
        this.roundTrip(t3, (Type)((Object)A3.class), new Type[0]);
    }

    @Test
    public void testBeanInheritance2() throws Exception {
        B1 t1 = new B1().init();
        B1 t2 = this.roundTrip(t1, (Type)((Object)B1.class), new Type[0]);
        TestUtils.assertEqualObjects(t1, t2);
    }

    public static class B2 {
        private String f1 = null;
        private int f2 = -1;
        private boolean f3 = false;

        public String getF1() {
            return this.f1;
        }

        public void setF1(String f1) {
            this.f1 = f1;
        }

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public boolean isF3() {
            return this.f3;
        }

        public void setF3(boolean f3) {
            this.f3 = f3;
        }

        public String toString() {
            return "B2(f1: " + this.getF1() + ", f2: " + this.getF2() + ")";
        }
    }

    public static class B1
    extends B2 {
        private A2 f4;

        public A2 getF4() {
            return this.f4;
        }

        public void setF4(A2 f4) {
            this.f4 = f4;
        }

        @Override
        public String toString() {
            return super.toString() + " / " + this.f4;
        }

        public B1 init() {
            this.setF1("A1");
            this.setF2(101);
            this.setF3(false);
            this.setF4((A2)new A2().init());
            return this;
        }
    }

    public static class A3
    extends A1 {
        public A3() {
        }

        public A3(String x, String y, String z) {
            super(x, y, z);
        }

        public String isX() {
            throw new RuntimeException("Should not be called!");
        }

        public String isY() {
            throw new RuntimeException("Should not be called!");
        }

        public String isZ() {
            throw new RuntimeException("Should not be called!");
        }
    }

    public static class A2
    extends A1 {
        public A2() {
        }

        public A2(String x, String y, String z) {
            super(x, y, z);
        }

        public String getX() {
            return this.x;
        }

        public String getY() {
            return this.y;
        }

        public String getZ() {
            return this.z;
        }
    }

    public static abstract class A1 {
        protected String x = null;
        protected String y = null;
        protected String z = null;

        public A1() {
            this.x = null;
            this.y = null;
            this.z = null;
        }

        public A1(String x, String y, String z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void setX(String x) {
            this.x = x;
        }

        public void setY(String y) {
            this.y = y;
        }

        public void setZ(String z) {
            this.z = z;
        }

        public String toString() {
            return "A1(x: " + this.x + ", y: " + this.y + ", z: " + this.z + ")";
        }

        public A1 init() {
            this.x = null;
            this.y = "";
            this.z = "z";
            return this;
        }
    }
}

