/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.a.rttests;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.a.rttests.RoundTripTest;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.html.HtmlParserBuilder;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.jena.RdfParserBuilder;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.json.JsonParserBuilder;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.msgpack.MsgPackParserBuilder;
import org.apache.juneau.msgpack.MsgPackSerializerBuilder;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.uon.UonParserBuilder;
import org.apache.juneau.uon.UonSerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingParserBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializerBuilder;
import org.apache.juneau.xml.XmlParserBuilder;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class RoundTripAddClassAttrsTest
extends RoundTripTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getPairs() {
        return Arrays.asList({"JsonSerializer.DEFAULT/JsonParser.DEFAULT", JsonSerializer.create().addBeanTypes(true).addRootType(), new JsonParserBuilder().useInterfaceProxies(false), 0}, {"JsonSerializer.DEFAULT_SIMPLE/JsonParser.DEFAULT", new JsonSerializerBuilder().ssq().addBeanTypes(true).addRootType(), new JsonParserBuilder().useInterfaceProxies(false), 0}, {"JsonSerializer.DEFAULT_SQ/JsonParser.DEFAULT", new JsonSerializerBuilder().ssq().addBeanTypes(true).addRootType(), new JsonParserBuilder().useInterfaceProxies(false), 0}, {"XmlSerializer.DEFAULT/XmlParser.DEFAULT", new XmlSerializerBuilder().addBeanTypes(true).addRootType(), new XmlParserBuilder().useInterfaceProxies(false), RoundTripTest.Flags.CHECK_XML_WHITESPACE | RoundTripTest.Flags.VALIDATE_XML}, {"HtmlSerializer.DEFAULT/HtmlParser.DEFAULT", new HtmlSerializerBuilder().addBeanTypes(true).addRootType(), new HtmlParserBuilder().useInterfaceProxies(false), RoundTripTest.Flags.CHECK_XML_WHITESPACE}, {"UonSerializer.DEFAULT_ENCODING/UonParser.DEFAULT_DECODING", new UonSerializerBuilder().encoding().addBeanTypes(true).addRootType(), new UonParserBuilder().decoding().useInterfaceProxies(false), 0}, {"UonSerializer.DEFAULT/UonParser.DEFAULT", new UonSerializerBuilder().addBeanTypes(true).addRootType(), new UonParserBuilder().useInterfaceProxies(false), 0}, {"UrlEncodingSerializer.DEFAULT/UrlEncodingParser.DEFAULT", new UrlEncodingSerializerBuilder().addBeanTypes(true).addRootType(), new UrlEncodingParserBuilder().useInterfaceProxies(false), 0}, {"RdfSerializer.Xml/RdfParser.Xml", new RdfSerializerBuilder().addBeanTypes(true).addRootType(), new RdfParserBuilder().useInterfaceProxies(false), 0}, {"MsgPackSerializer.DEFAULT/MsgPackParser.DEFAULT", new MsgPackSerializerBuilder().addBeanTypes(true).addRootType(), new MsgPackParserBuilder().useInterfaceProxies(false), 0});
    }

    public RoundTripAddClassAttrsTest(String label, SerializerBuilder s, ParserBuilder p, int flags) throws Exception {
        super(label, s, p, flags);
    }

    @Override
    public Class<?>[] getDictionary() {
        return new Class[]{A.class, B.class, C.class, D.class, E.class, F.class};
    }

    @Test
    public void testBean() throws Exception {
        A t = new A("foo");
        t = this.roundTrip(t, (Type)((Object)A.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.getF1());
        AA ta = this.roundTrip(t, (Type)((Object)AA.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)ta.getF1());
        IA ti = this.roundTrip(t, (Type)((Object)IA.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)ti.getF1());
        t = this.roundTrip(t, (Type)((Object)Object.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.getF1());
    }

    @Test
    public void testBeanArray() throws Exception {
        A[] t = new A[]{new A("foo")};
        t = this.roundTrip(t, (Type)((Object)A[].class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t[0].getF1());
        AA[] ta = this.roundTrip(t, (Type)((Object)AA[].class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)ta[0].getF1());
        IA[] ti = this.roundTrip(t, (Type)((Object)IA[].class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)ti[0].getF1());
    }

    @Test
    public void testBeanWithBeanProps() throws Exception {
        B t = new B("foo");
        t = this.roundTrip(t, (Type)((Object)B.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f2a.getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f2b.getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f2c.getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f2d).getF1());
        t = this.roundTrip(t, (Type)((Object)Object.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f2a.getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f2b.getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f2c.getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f2d).getF1());
    }

    @Test
    public void testMapsWithTypeParams() throws Exception {
        C t = new C("foo");
        t = this.roundTrip(t, (Type)((Object)C.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f3a.get("foo").getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f3b.get("foo").getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f3c.get("foo").getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f3d.get("foo").getF1());
        t = this.roundTrip(t, (Type)((Object)Object.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f3a.get("foo").getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f3b.get("foo").getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f3c.get("foo").getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f3d.get("foo").getF1());
    }

    @Test
    public void testMapsWithoutTypeParams() throws Exception {
        D t = new D("foo");
        t = this.roundTrip(t, (Type)((Object)D.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f4a[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f4b[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f4c[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f4d[0]).getF1());
        t = this.roundTrip(t, (Type)((Object)Object.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f4a[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f4b[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f4c[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f4d[0]).getF1());
    }

    @Test
    public void testBeanWithListProps() throws Exception {
        E t = new E("foo");
        t = this.roundTrip(t, (Type)((Object)E.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f5a.get(0).getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f5b.get(0).getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f5c.get(0).getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f5d.get(0)).getF1());
        t = this.roundTrip(t, (Type)((Object)Object.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f5a.get(0).getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f5b.get(0).getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f5c.get(0).getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f5d.get(0)).getF1());
    }

    @Test
    public void testBeanWithListOfArraysProps() throws Exception {
        F t = new F("foo");
        t = this.roundTrip(t, (Type)((Object)F.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f6a.get(0)[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f6b.get(0)[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f6c.get(0)[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f6d.get(0)[0]).getF1());
        t = this.roundTrip(t, (Type)((Object)Object.class), new Type[0]);
        Assert.assertEquals((Object)"foo", (Object)t.f6a.get(0)[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f6b.get(0)[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)t.f6c.get(0)[0].getF1());
        Assert.assertEquals((Object)"foo", (Object)((A)t.f6d.get(0)[0]).getF1());
    }

    @Bean(typeName="F")
    public static class F {
        public List<A[]> f6a = new LinkedList<A[]>();
        public List<AA[]> f6b = new LinkedList<AA[]>();
        public List<IA[]> f6c = new LinkedList<IA[]>();
        public List<Object[]> f6d = new LinkedList<Object[]>();

        public F() {
        }

        public F(String f1) {
            A[] b = new A[]{new A(f1)};
            this.f6a.add(b);
            this.f6b.add(b);
            this.f6c.add(b);
            this.f6d.add(b);
        }
    }

    @Bean(typeName="E")
    public static class E {
        public List<A> f5a = new LinkedList<A>();
        public List<AA> f5b = new LinkedList<AA>();
        public List<IA> f5c = new LinkedList<IA>();
        public List<Object> f5d = new LinkedList<Object>();

        public E() {
        }

        public E(String f1) {
            A b = new A(f1);
            this.f5a.add(b);
            this.f5b.add(b);
            this.f5c.add(b);
            this.f5d.add(b);
        }
    }

    @Bean(typeName="D")
    public static class D {
        public A[] f4a;
        public AA[] f4b;
        public IA[] f4c;
        public Object[] f4d;

        public D() {
        }

        public D(String f1) {
            A b = new A(f1);
            this.f4a = new A[]{b};
            this.f4b = new AA[]{b};
            this.f4c = new IA[]{b};
            this.f4d = new Object[]{b};
        }
    }

    @Bean(typeName="C")
    public static class C {
        public Map<String, A> f3a = new HashMap<String, A>();
        public Map<String, A> f3b = new HashMap<String, A>();
        public Map<String, A> f3c = new HashMap<String, A>();
        public Map<String, A> f3d = new HashMap<String, A>();

        public C() {
        }

        public C(String f1) {
            A b = new A(f1);
            this.f3a.put("foo", b);
            this.f3b.put("foo", b);
            this.f3c.put("foo", b);
            this.f3d.put("foo", b);
        }
    }

    @Bean(typeName="B")
    public static class B {
        public A f2a;
        public AA f2b;
        public IA f2c;
        public Object f2d;

        public B() {
        }

        public B(String f1) {
            this.f2a = new A(f1);
            this.f2b = this.f2a;
            this.f2c = this.f2a;
            this.f2d = this.f2a;
        }
    }

    @Bean(typeName="A")
    public static class A
    extends AA {
        private String f1;

        @Override
        public String getF1() {
            return this.f1;
        }

        @Override
        public void setF1(String f1) {
            this.f1 = f1;
        }

        public A() {
        }

        public A(String f1) {
            this.f1 = f1;
        }
    }

    public static abstract class AA
    implements IA {
    }

    public static interface IA {
        public String getF1();

        public void setF1(String var1);
    }
}

