/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Map;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class ReadWriteOnlyPropertiesTest {
    @Test
    public void a01_beanpOnPrimitiveFields_serializer() throws Exception {
        TestUtils.assertObjectEquals("{f1:1}", A.create());
    }

    @Test
    public void a02_beanpOnPrimitiveFields_parser() throws Exception {
        A x = (A)SimpleJson.DEFAULT.read("{f1:1,f2:2}", A.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
    }

    @Test
    public void b01_beanAnnotation_serializer() throws Exception {
        TestUtils.assertObjectEquals("{f1:1}", B.create());
    }

    @Test
    public void b02_beanAnnotationParser() throws Exception {
        Bc x = (Bc)JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{Bc.class}).build().parse("{f1:1,f2:2}", Bc.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
    }

    @Test
    public void b01_beanAnnotation_serializer_usingConfig() throws Exception {
        TestUtils.assertObjectEquals("{f1:1}", B.create());
    }

    @Test
    public void b02_beanAnnotationParser_usingConfig() throws Exception {
        B x = (B)SimpleJson.DEFAULT.read("{f1:1,f2:2}", B.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
    }

    @Test
    public void c01_beanContext_serializer() throws Exception {
        JsonSerializer sw = SimpleJsonSerializer.DEFAULT.builder().bpro(C.class.getName(), "f1").bpwo(C.class.getName(), "f2").build();
        Assert.assertEquals((Object)"{f1:1}", (Object)sw.toString((Object)C.create()));
        sw = SimpleJsonSerializer.DEFAULT.builder().bpro("ReadWriteOnlyPropertiesTest$C", "f1").bpwo("ReadWriteOnlyPropertiesTest$C", "f2").build();
        Assert.assertEquals((Object)"{f1:1}", (Object)sw.toString((Object)C.create()));
        sw = SimpleJsonSerializer.DEFAULT.builder().bpro(C.class, "f1").bpwo(C.class, "f2").build();
        Assert.assertEquals((Object)"{f1:1}", (Object)sw.toString((Object)C.create()));
        sw = SimpleJsonSerializer.DEFAULT.builder().bpro((Map)AMap.create((Object)C.class.getName(), (Object)"f1")).bpwo((Map)AMap.create((Object)C.class.getName(), (Object)"f2")).build();
        Assert.assertEquals((Object)"{f1:1}", (Object)sw.toString((Object)C.create()));
        sw = SimpleJsonSerializer.DEFAULT.builder().bpro((Map)AMap.create((Object)"ReadWriteOnlyPropertiesTest$C", (Object)"f1")).bpwo((Map)AMap.create((Object)"ReadWriteOnlyPropertiesTest$C", (Object)"f2")).build();
        Assert.assertEquals((Object)"{f1:1}", (Object)sw.toString((Object)C.create()));
    }

    @Test
    public void c02_beanAnnotationParser() throws Exception {
        JsonParser rp = JsonParser.DEFAULT.builder().bpro(C.class.getName(), "f1").bpwo(C.class.getName(), "f2").build();
        C x = (C)rp.parse("{f1:1,f2:2}", C.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
        rp = JsonParser.DEFAULT.builder().bpro("ReadWriteOnlyPropertiesTest$C", "f1").bpwo("ReadWriteOnlyPropertiesTest$C", "f2").build();
        x = (C)rp.parse("{f1:1,f2:2}", C.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
        rp = JsonParser.DEFAULT.builder().bpro(C.class, "f1").bpwo(C.class, "f2").build();
        x = (C)rp.parse("{f1:1,f2:2}", C.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
        rp = JsonParser.DEFAULT.builder().bpro((Map)AMap.create((Object)C.class.getName(), (Object)"f1")).bpwo((Map)AMap.create((Object)C.class.getName(), (Object)"f2")).build();
        x = (C)rp.parse("{f1:1,f2:2}", C.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
        rp = JsonParser.DEFAULT.builder().bpro((Map)AMap.create((Object)"ReadWriteOnlyPropertiesTest$C", (Object)"f1")).bpwo((Map)AMap.create((Object)"ReadWriteOnlyPropertiesTest$C", (Object)"f2")).build();
        x = (C)rp.parse("{f1:1,f2:2}", C.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
    }

    @Test
    public void d01_beanAnnotation_bproAll_serializer() throws Exception {
        TestUtils.assertObjectEquals("{f1:1,f2:2}", D.create());
    }

    @Test
    public void d02_beanAnnotation_bproAll_Parser() throws Exception {
        D x = (D)SimpleJson.DEFAULT.read("{f1:1,f2:2}", D.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)0L, (long)x.f2);
    }

    @Test
    public void d03_beanAnnotation_bproAll_serializer_usingConfig() throws Exception {
        TestUtils.assertObjectEquals("{f1:1,f2:2}", Dc.create(), (WriterSerializer)SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{Dc.class}).build());
    }

    @Test
    public void d04_beanAnnotation_bproAll_Parser_usingConfig() throws Exception {
        Dc x = (Dc)JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{Dc.class}).build().parse("{f1:1,f2:2}", Dc.class);
        Assert.assertEquals((long)0L, (long)x.f1);
        Assert.assertEquals((long)0L, (long)x.f2);
    }

    @Test
    public void e01_beanAnnotation_bpwoAll_serializer() throws Exception {
        TestUtils.assertObjectEquals("{}", E.create());
    }

    @Test
    public void e02_beanAnnotation_bpwoAll_Parser() throws Exception {
        E x = (E)SimpleJson.DEFAULT.read("{f1:1,f2:2}", E.class);
        Assert.assertEquals((long)1L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
    }

    @Test
    public void e03_beanAnnotation_bpwoAll_serializer_usingConfig() throws Exception {
        TestUtils.assertObjectEquals("{}", E.create(), (WriterSerializer)SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{Ec.class}).build());
    }

    @Test
    public void e04_beanAnnotation_bpwoAll_Parser_usingConfig() throws Exception {
        Ec x = (Ec)JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{Ec.class}).build().parse("{f1:1,f2:2}", Ec.class);
        Assert.assertEquals((long)1L, (long)x.f1);
        Assert.assertEquals((long)2L, (long)x.f2);
    }

    @BeanConfig(applyBean={@Bean(on="Ec", bpwo="*")})
    public static class Ec {
        public int f1;
        public int f2;

        static Ec create() {
            Ec x = new Ec();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    @Bean(bpwo="*")
    public static class E {
        public int f1;
        public int f2;

        static E create() {
            E x = new E();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    @BeanConfig(applyBean={@Bean(on="Dc", bpro="*")})
    public static class Dc {
        public int f1;
        public int f2;

        static Dc create() {
            Dc x = new Dc();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    @Bean(bpro="*")
    public static class D {
        public int f1;
        public int f2;

        static D create() {
            D x = new D();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    public static class C {
        public int f1;
        public int f2;

        static C create() {
            C x = new C();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    @BeanConfig(applyBean={@Bean(on="Bc", bpro="f1", bpwo="f2")}, applyBeanp={@Beanp(on="Bc.f1", ro="true"), @Beanp(on="Bc.f2", wo="true")})
    public static class Bc {
        public int f1;
        public int f2;

        static Bc create() {
            Bc x = new Bc();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    @Bean(bpro="f1", bpwo="f2")
    public static class B {
        @Beanp(ro="true")
        public int f1;
        @Beanp(wo="true")
        public int f2;

        static B create() {
            B x = new B();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }

    public static class A {
        @Beanp(ro="true")
        public int f1;
        @Beanp(wo="true")
        public int f2;

        static A create() {
            A x = new A();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }
    }
}

