/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.json.annotation.Json;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class PropertyStoreTest {
    @Test
    public void testBasic() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set("B.f4.s", (Object)"4");
        b.set("B.f3.s", (Object)"3");
        b.set("A.f2.s", (Object)"2");
        b.set("A.f1.s", (Object)"1");
        TestUtils.assertObjectEquals("{A:{'f1.s':'1','f2.s':'2'},B:{'f3.s':'3','f4.s':'4'}}", b.build());
    }

    @Test
    public void testInvalidKeys() {
        PropertyStoreBuilder b = PropertyStore.create();
        this.testError(b, "A.f1/add", "foo", "Cannot add value 'foo' (String) to property 'f1' (String).");
        this.testError(b, "A.f1/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1' (String).");
        this.testError(b, "A.f1/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1' (String).");
        this.testError(b, "A.f1/remove.123", "foo", "Invalid key specified: 'A.f1/remove.123'");
        this.testError(b, "A.f1.s/addx", "foo", "Invalid key specified: 'A.f1.s/addx'");
        this.testError(b, "A.f1.s/removex", "foo", "Invalid key specified: 'A.f1.s/removex'");
    }

    @Test
    public void testString() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.s", (Object)"1");
        b.set("A.f2.s", (Object)2);
        b.set("A.f3.s", (Object)true);
        b.set("A.f4.s", (Object)new ObjectMap((CharSequence)"{foo:'bar'}"));
        b.set("A.f5.s", (Object)new ObjectList((CharSequence)"[1,2]"));
        b.set("A.f6.s", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.s':'1','f2.s':'2','f3.s':'true','f4.s':'{foo:\\'bar\\'}','f5.s':'[1,2]'}}", ps);
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f1.s"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f2.s"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f3.s"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f4.s"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f5.s"));
        b.clear();
        b.set("A.f1", (Object)"1");
        b.set("A.f2", (Object)2);
        b.set("A.f3", (Object)true);
        b.set("A.f4", (Object)new ObjectMap((CharSequence)"{foo:'bar'}"));
        b.set("A.f5", (Object)new ObjectList((CharSequence)"[1,2]"));
        b.set("A.f6", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{f1:'1',f2:'2',f3:'true',f4:'{foo:\\'bar\\'}',f5:'[1,2]'}}", ps);
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f1"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f2"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f3"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f4"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f5"));
        b.set("A.f1", (Object)"x1");
        b.set("A.f2", null);
        b.set("A.f3", null);
        b.remove("A.f4");
        b.remove("A.f5");
        TestUtils.assertObjectEquals("{A:{f1:'x1'}}", b.build());
        this.testError(b, "A.f1/add", "foo", "Cannot add value 'foo' (String) to property 'f1' (String).");
        this.testError(b, "A.f1/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1' (String).");
        this.testError(b, "A.f1/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1' (String).");
    }

    @Test
    public void testBoolean() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.b", (Object)"true");
        b.set("A.f2.b", (Object)"false");
        b.set("A.f3.b", (Object)new StringBuilder("true"));
        b.set("A.f4.b", (Object)new StringBuilder("foo"));
        b.set("A.f5.b", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.b':true,'f2.b':false,'f3.b':true,'f4.b':false}}", ps);
        TestUtils.assertInstanceOf(Boolean.class, ps.getProperty("A.f1.b"));
        TestUtils.assertInstanceOf(Boolean.class, ps.getProperty("A.f2.b"));
        TestUtils.assertInstanceOf(Boolean.class, ps.getProperty("A.f3.b"));
        TestUtils.assertInstanceOf(Boolean.class, ps.getProperty("A.f4.b"));
        b.set("A.f2.b", null);
        b.set("A.f3.b", null);
        b.remove("A.f4.b");
        b.remove("A.f5.b");
        TestUtils.assertObjectEquals("{A:{'f1.b':true}}", b.build());
        this.testError(b, "A.f1.b/add", "foo", "Cannot add value 'foo' (String) to property 'f1.b' (Boolean).");
        this.testError(b, "A.f1.b/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1.b' (Boolean).");
        this.testError(b, "A.f1.b/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.b' (Boolean).");
    }

    @Test
    public void testInteger() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.i", (Object)123);
        b.set("A.f2.i", (Object)"123");
        b.set("A.f3.i", (Object)new StringBuilder("123"));
        b.set("A.f4.i", (Object)new StringBuilder("-1"));
        b.set("A.f5.i", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.i':123,'f2.i':123,'f3.i':123,'f4.i':-1}}", ps);
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f1.i"));
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f2.i"));
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f3.i"));
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f4.i"));
        b.set("A.f2.i", null);
        b.set("A.f3.i", null);
        b.remove("A.f4.i");
        b.remove("A.f5.i");
        TestUtils.assertObjectEquals("{A:{'f1.i':123}}", b.build());
        this.testError(b, "A.f1.i/add", "foo", "Cannot add value 'foo' (String) to property 'f1.i' (Integer).");
        this.testError(b, "A.f1.i/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1.i' (Integer).");
        this.testError(b, "A.f1.i/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.i' (Integer).");
        this.testError(b, "A.f1.i", "foo", "Value 'foo' (String) cannot be converted to an Integer.");
    }

    @Test
    public void testClass() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.c", String.class);
        b.set("A.f2.c", Integer.class);
        b.set("A.f3.c", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.c':'java.lang.String','f2.c':'java.lang.Integer'}}", ps);
        TestUtils.assertInstanceOf(Class.class, ps.getProperty("A.f1.c"));
        b.set("A.f2.c", null);
        TestUtils.assertObjectEquals("{A:{'f1.c':'java.lang.String'}}", b.build());
        this.testError(b, "A.f1.c/add", "foo", "Cannot add value 'foo' (String) to property 'f1.c' (Class).");
        this.testError(b, "A.f1.c/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1.c' (Class).");
        this.testError(b, "A.f1.c/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.c' (Class).");
        this.testError(b, "A.f1.c", "java.lang.String", "Value 'java.lang.String' (String) cannot be converted to a Class.");
    }

    @Test
    public void testObject() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.o", (Object)123);
        b.set("A.f2.o", (Object)true);
        b.set("A.f3.o", (Object)new StringBuilder("123"));
        b.set("A.f4.o", StringBuilder.class);
        b.set("A.f5.o", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.o':123,'f2.o':true,'f3.o':'123','f4.o':'java.lang.StringBuilder'}}", ps);
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f1.o"));
        TestUtils.assertInstanceOf(Boolean.class, ps.getProperty("A.f2.o"));
        TestUtils.assertInstanceOf(StringBuilder.class, ps.getProperty("A.f3.o"));
        TestUtils.assertInstanceOf(Class.class, ps.getProperty("A.f4.o"));
        b.set("A.f2.o", null);
        b.set("A.f3.o", null);
        b.remove("A.f4.o");
        b.remove("A.f5.o");
        TestUtils.assertObjectEquals("{A:{'f1.o':123}}", b.build());
        this.testError(b, "A.f1.o/add", "foo", "Cannot add value 'foo' (String) to property 'f1.o' (Object).");
        this.testError(b, "A.f1.o/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1.o' (Object).");
        this.testError(b, "A.f1.o/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.o' (Object).");
    }

    @Test
    public void testSetString() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.ss", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar", "bar", null}));
        b.set("A.f2.ss", (Object)new AList().appendAll(new Object[]{123, true, TestEnum.ONE, TestEnum.ONE, null}));
        b.set("A.f3.ss", (Object)new AList().appendAll((Object[])new StringBuilder[]{new StringBuilder("foo"), null}));
        b.set("A.f4.ss", (Object)"['foo',123,true]");
        b.set("A.f5.ss", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.ss':['bar','foo'],'f2.ss':['123','ONE','true'],'f3.ss':['foo'],'f4.ss':['123','foo','true']}}", ps);
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f1.ss"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f2.ss"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f3.ss"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f4.ss"));
        b.clear();
        b.set("A.f1.ss/add", (Object)"foo");
        TestUtils.assertObjectEquals("{A:{'f1.ss':['foo']}}", b.build());
        b.set("A.f1.ss/remove", (Object)"foo");
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.ss/add", (Object)"['foo','bar','baz']");
        b.set("A.f1.ss/add", (Object)"qux");
        b.addTo("A.f1.ss", (Object)"quux");
        TestUtils.assertObjectEquals("{A:{'f1.ss':['bar','baz','foo','quux','qux']}}", b.build());
        b.set("A.f1.ss/remove", (Object)"['foo','bar']");
        b.set("A.f1.ss/remove", (Object)"qux");
        b.removeFrom("A.f1.ss", (Object)"quux");
        TestUtils.assertObjectEquals("{A:{'f1.ss':['baz']}}", b.build());
        b.clear();
        b.set("A.f1.ss/add", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar", "baz"}));
        b.set("A.f1.ss/add", (Object)new AList().appendAll((Object[])new String[]{"qux"}));
        b.addTo("A.f1.ss", (Object)new AList().appendAll((Object[])new String[]{"quux"}));
        TestUtils.assertObjectEquals("{A:{'f1.ss':['bar','baz','foo','quux','qux']}}", b.build());
        b.set("A.f1.ss/remove", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar"}));
        b.set("A.f1.ss/remove", (Object)new AList().appendAll((Object[])new String[]{"qux"}));
        b.removeFrom("A.f1.ss", (Object)new AList().appendAll((Object[])new String[]{"quux"}));
        TestUtils.assertObjectEquals("{A:{'f1.ss':['baz']}}", b.build());
        b.clear();
        b.set("A.f1.ss/add", (Object)new String[]{"foo", "bar", "baz"});
        b.set("A.f1.ss/add", (Object)new String[]{"qux"});
        b.addTo("A.f1.ss", (Object)new String[]{"quux"});
        TestUtils.assertObjectEquals("{A:{'f1.ss':['bar','baz','foo','quux','qux']}}", b.build());
        b.set("A.f1.ss/remove", (Object)new String[]{"foo", "bar"});
        b.set("A.f1.ss/remove", (Object)new String[]{"qux"});
        b.removeFrom("A.f1.ss", (Object)new String[]{"quux"});
        TestUtils.assertObjectEquals("{A:{'f1.ss':['baz']}}", b.build());
        b.set("A.f1.ss", null);
        TestUtils.assertObjectEquals("{}", b.build());
        this.testError(b, "A.f1.ss/add.123", "foo", "Cannot use argument '123' on add command for property 'f1.ss' (Set<String>)");
        try {
            b.addTo("A.f1.ss", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot use argument 'foo' on add command for property 'f1.ss' (Set<String>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetInteger() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.si", (Object)new AList().appendAll((Object[])new Integer[]{3, 2, 1, null}));
        b.set("A.f2.si", (Object)new AList().appendAll(new Object[]{123, "456", null}));
        b.set("A.f3.si", (Object)new AList().appendAll((Object[])new StringBuilder[]{new StringBuilder("123"), null}));
        b.set("A.f4.si", (Object)"[1,2,3]");
        b.set("A.f5.si", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3],'f2.si':[123,456],'f3.si':[123],'f4.si':[1,2,3]}}", ps);
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f1.si"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f2.si"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f3.si"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f4.si"));
        b.clear();
        b.set("A.f1.si/add", (Object)"123");
        TestUtils.assertObjectEquals("{A:{'f1.si':[123]}}", b.build());
        b.set("A.f1.si/remove", (Object)"123");
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.si/add", (Object)"['3','2','1']");
        b.set("A.f1.si/add", (Object)"4");
        b.addTo("A.f1.si", (Object)"5");
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3,4,5]}}", b.build());
        b.set("A.f1.si/remove", (Object)"['1','2']");
        b.set("A.f1.si/remove", (Object)"3");
        b.removeFrom("A.f1.si", (Object)"4");
        TestUtils.assertObjectEquals("{A:{'f1.si':[5]}}", b.build());
        b.clear();
        b.set("A.f1.si/add", (Object)new AList().appendAll((Object[])new String[]{"3", "2", "1"}));
        b.set("A.f1.si/add", (Object)new AList().appendAll((Object[])new String[]{"4"}));
        b.addTo("A.f1.si", (Object)new AList().appendAll((Object[])new String[]{"5"}));
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3,4,5]}}", b.build());
        b.set("A.f1.si/remove", (Object)new AList().appendAll((Object[])new String[]{"1", "2"}));
        b.set("A.f1.si/remove", (Object)new AList().appendAll((Object[])new String[]{"3"}));
        b.removeFrom("A.f1.si", (Object)new AList().appendAll((Object[])new String[]{"4"}));
        TestUtils.assertObjectEquals("{A:{'f1.si':[5]}}", b.build());
        b.clear();
        b.set("A.f1.si/add", (Object)new AList().appendAll((Object[])new Integer[]{1, 2, 3}));
        b.set("A.f1.si/add", (Object)new AList().appendAll((Object[])new Integer[]{4}));
        b.addTo("A.f1.si", (Object)new AList().appendAll((Object[])new Integer[]{5}));
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3,4,5]}}", b.build());
        b.set("A.f1.si/remove", (Object)new AList().appendAll((Object[])new Integer[]{1, 2}));
        b.set("A.f1.si/remove", (Object)new AList().appendAll((Object[])new Integer[]{3}));
        b.removeFrom("A.f1.si", (Object)new AList().appendAll((Object[])new Integer[]{4}));
        TestUtils.assertObjectEquals("{A:{'f1.si':[5]}}", b.build());
        b.clear();
        b.set("A.f1.si/add", (Object)new String[]{"3", "2", "1"});
        b.set("A.f1.si/add", (Object)new String[]{"4"});
        b.addTo("A.f1.si", (Object)new String[]{"5"});
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3,4,5]}}", b.build());
        b.set("A.f1.si/remove", (Object)new String[]{"1", "2"});
        b.set("A.f1.si/remove", (Object)new String[]{"3"});
        b.removeFrom("A.f1.si", (Object)new String[]{"4"});
        TestUtils.assertObjectEquals("{A:{'f1.si':[5]}}", b.build());
        b.clear();
        b.set("A.f1.si/add", (Object)new Integer[]{3, 2, 1});
        b.set("A.f1.si/add", (Object)new Integer[]{4});
        b.addTo("A.f1.si", (Object)new Integer[]{5});
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3,4,5]}}", b.build());
        b.set("A.f1.si/remove", (Object)new Integer[]{1, 2});
        b.set("A.f1.si/remove", (Object)new Integer[]{3});
        b.removeFrom("A.f1.si", (Object)new Integer[]{4});
        TestUtils.assertObjectEquals("{A:{'f1.si':[5]}}", b.build());
        b.clear();
        b.set("A.f1.si/add", (Object)new int[]{3, 2, 1});
        b.set("A.f1.si/add", (Object)new int[]{4});
        b.addTo("A.f1.si", (Object)new int[]{5});
        TestUtils.assertObjectEquals("{A:{'f1.si':[1,2,3,4,5]}}", b.build());
        b.set("A.f1.si/remove", (Object)new int[]{1, 2});
        b.set("A.f1.si/remove", (Object)new int[]{3});
        b.removeFrom("A.f1.si", (Object)new int[]{4});
        TestUtils.assertObjectEquals("{A:{'f1.si':[5]}}", b.build());
        b.set("A.f1.si", null);
        TestUtils.assertObjectEquals("{}", b.build());
        this.testError(b, "A.f1.si/add.123", "foo", "Cannot use argument '123' on add command for property 'f1.si' (Set<Integer>)");
        try {
            b.addTo("A.f1.si", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot use argument 'foo' on add command for property 'f1.si' (Set<Integer>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetClass() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.sc", (Object)new AList().appendAll((Object[])new Class[]{String.class, Integer.class, null}));
        b.set("A.f2.sc", (Object)new AList().appendAll(new Object[]{String.class, Integer.class, null}));
        b.set("A.f3.sc", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.lang.Integer','java.lang.String'],'f2.sc':['java.lang.Integer','java.lang.String']}}", ps);
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f1.sc"));
        TestUtils.assertInstanceOf(Set.class, ps.getProperty("A.f2.sc"));
        TestUtils.assertInstanceOf(Class.class, ((Set)ps.getProperty("A.f1.sc")).iterator().next());
        b.clear();
        b.set("A.f1.sc/add", Integer.class);
        b.addTo("A.f1.sc", String.class);
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.lang.Integer','java.lang.String']}}", b.build());
        b.set("A.f1.sc/remove", Integer.class);
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.lang.String']}}", b.build());
        b.clear();
        this.testError(b, "A.f1.sc/add", "['java.lang.Integer']", "Cannot add value '[\\'java.lang.Integer\\']' (String) to property 'f1.sc' (Set<Class>).  Value 'java.lang.Integer' (String) cannot be converted to a Class.");
        this.testError(b, "A.f1.sc/add", "java.lang.Integer", "Cannot add value 'java.lang.Integer' (String) to property 'f1.sc' (Set<Class>).  Value 'java.lang.Integer' (String) cannot be converted to a Class.");
        b.clear();
        b.set("A.f1.sc/add", (Object)new AList().appendAll((Object[])new Class[]{Integer.class, String.class}));
        b.set("A.f1.sc/add", (Object)new AList().appendAll((Object[])new Class[]{Map.class}));
        b.addTo("A.f1.sc", (Object)new AList().appendAll((Object[])new Class[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.lang.Integer','java.lang.String','java.util.List','java.util.Map']}}", b.build());
        b.set("A.f1.sc/remove", (Object)new AList().appendAll((Object[])new Class[]{Integer.class, String.class}));
        b.removeFrom("A.f1.sc", (Object)new AList().appendAll((Object[])new Class[0]));
        b.removeFrom("A.f1.sc", (Object)new AList().appendAll((Object[])new Class[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.util.Map']}}", b.build());
        b.clear();
        b.set("A.f1.sc/add", (Object)new AList().appendAll(new Object[]{Integer.class, String.class}));
        b.set("A.f1.sc/add", (Object)new AList().appendAll(new Object[]{Map.class}));
        b.addTo("A.f1.sc", (Object)new AList().appendAll(new Object[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.lang.Integer','java.lang.String','java.util.List','java.util.Map']}}", b.build());
        b.set("A.f1.sc/remove", (Object)new AList().appendAll(new Object[]{Integer.class, String.class}));
        b.set("A.f1.sc/remove", (Object)new AList().appendAll(new Object[0]));
        b.removeFrom("A.f1.sc", (Object)new AList().appendAll(new Object[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.util.Map']}}", b.build());
        b.clear();
        b.set("A.f1.sc/add", (Object)new Class[]{Integer.class, String.class});
        b.set("A.f1.sc/add", (Object)new Class[]{Map.class});
        b.addTo("A.f1.sc", (Object)new Class[]{List.class});
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.lang.Integer','java.lang.String','java.util.List','java.util.Map']}}", b.build());
        b.set("A.f1.sc/remove", (Object)new Class[]{Integer.class, String.class});
        b.set("A.f1.sc/remove", (Object)new Class[0]);
        b.removeFrom("A.f1.sc", (Object)new Class[]{List.class});
        TestUtils.assertObjectEquals("{A:{'f1.sc':['java.util.Map']}}", b.build());
        b.set("A.f1.sc", null);
        TestUtils.assertObjectEquals("{}", b.build());
        this.testError(b, "A.f1.sc/add.123", String.class, "Cannot use argument '123' on add command for property 'f1.sc' (Set<Class>)");
        try {
            b.addTo("A.f1.sc", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot use argument 'foo' on add command for property 'f1.sc' (Set<Class>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testListString() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.ls", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar", "bar", null}));
        b.set("A.f2.ls", (Object)new AList().appendAll(new Object[]{123, true, TestEnum.ONE, TestEnum.ONE, null}));
        b.set("A.f3.ls", (Object)new AList().appendAll((Object[])new StringBuilder[]{new StringBuilder("foo"), null}));
        b.set("A.f4.ls", (Object)"['foo',123,true]");
        b.set("A.f5.ls", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.ls':['foo','bar'],'f2.ls':['123','true','ONE'],'f3.ls':['foo'],'f4.ls':['foo','123','true']}}", ps);
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f1.ls"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f2.ls"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f3.ls"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f4.ls"));
        b.clear();
        b.set("A.f1.ls/add", (Object)"foo");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['foo']}}", b.build());
        b.set("A.f1.ls/remove", (Object)"foo");
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.ls/add", (Object)"['foo','bar','baz']");
        b.set("A.f1.ls/add", (Object)"qux");
        b.addTo("A.f1.ls", (Object)"quux");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['quux','qux','foo','bar','baz']}}", b.build());
        b.set("A.f1.ls/remove", (Object)"['foo','bar']");
        b.set("A.f1.ls/remove", (Object)"qux");
        b.removeFrom("A.f1.ls", (Object)"quux");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['baz']}}", b.build());
        b.clear();
        b.set("A.f1.ls/add", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar", "baz"}));
        b.set("A.f1.ls/add", (Object)new AList().appendAll((Object[])new String[]{"qux"}));
        b.addTo("A.f1.ls", (Object)new AList().appendAll((Object[])new String[]{"quux"}));
        TestUtils.assertObjectEquals("{A:{'f1.ls':['quux','qux','foo','bar','baz']}}", b.build());
        b.set("A.f1.ls/remove", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar"}));
        b.set("A.f1.ls/remove", (Object)new AList().appendAll((Object[])new String[]{"qux"}));
        b.removeFrom("A.f1.ls", (Object)new AList().appendAll((Object[])new String[]{"quux"}));
        TestUtils.assertObjectEquals("{A:{'f1.ls':['baz']}}", b.build());
        b.clear();
        b.set("A.f1.ls/add", (Object)new String[]{"foo", "bar", "baz"});
        b.set("A.f1.ls/add", (Object)new String[]{"qux"});
        b.addTo("A.f1.ls", (Object)new String[]{"quux"});
        TestUtils.assertObjectEquals("{A:{'f1.ls':['quux','qux','foo','bar','baz']}}", b.build());
        b.set("A.f1.ls/remove", (Object)new String[]{"foo", "bar"});
        b.set("A.f1.ls/remove", (Object)new String[]{"qux"});
        b.removeFrom("A.f1.ls", (Object)new String[]{"quux"});
        TestUtils.assertObjectEquals("{A:{'f1.ls':['baz']}}", b.build());
        b.set("A.f1.ls", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.ls/add", (Object)"['foo','bar','baz']");
        b.set("A.f1.ls/add.10", (Object)"qux");
        b.set("A.f1.ls/add.1", (Object)"quux");
        b.set("A.f1.ls/add.0", (Object)"quuux");
        b.set("A.f1.ls/add.-10", (Object)"quuuux");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['quuuux','quuux','foo','quux','bar','baz','qux']}}", b.build());
        b.set("A.f1.ls/add.1", (Object)"['1','2']");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['quuuux','1','2','quuux','foo','quux','bar','baz','qux']}}", b.build());
        this.testError(b, "A.f1.ls/add.foo", "foo", "Invalid argument 'foo' on add command for property 'f1.ls' (List<String>)");
        try {
            b.addTo("A.f1.ls", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid argument 'foo' on add command for property 'f1.ls' (List<String>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testListInteger() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.li", (Object)new AList().appendAll((Object[])new Integer[]{1, 2, 3, null}));
        b.set("A.f2.li", (Object)new AList().appendAll(new Object[]{123, "456", null}));
        b.set("A.f3.li", (Object)new AList().appendAll((Object[])new StringBuilder[]{new StringBuilder("123"), null}));
        b.set("A.f4.li", (Object)"[1,2,3]");
        b.set("A.f5.li", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.li':[1,2,3],'f2.li':[123,456],'f3.li':[123],'f4.li':[1,2,3]}}", ps);
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f1.li"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f2.li"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f3.li"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f4.li"));
        b.clear();
        b.set("A.f1.li/add", (Object)"123");
        TestUtils.assertObjectEquals("{A:{'f1.li':[123]}}", b.build());
        b.set("A.f1.li/remove", (Object)"123");
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.li/add", (Object)"['1','2','3']");
        b.set("A.f1.li/add", (Object)"4");
        b.addTo("A.f1.li", (Object)"5");
        TestUtils.assertObjectEquals("{A:{'f1.li':[5,4,1,2,3]}}", b.build());
        b.set("A.f1.li/remove", (Object)"['1','2']");
        b.set("A.f1.li/remove", (Object)"3");
        b.removeFrom("A.f1.li", (Object)"4");
        TestUtils.assertObjectEquals("{A:{'f1.li':[5]}}", b.build());
        b.clear();
        b.set("A.f1.li/add", (Object)new AList().appendAll((Object[])new String[]{"1", "2", "3"}));
        b.set("A.f1.li/add", (Object)new AList().appendAll((Object[])new String[]{"4"}));
        b.addTo("A.f1.li", (Object)new AList().appendAll((Object[])new String[]{"5"}));
        TestUtils.assertObjectEquals("{A:{'f1.li':[5,4,1,2,3]}}", b.build());
        b.set("A.f1.li/remove", (Object)new AList().appendAll((Object[])new String[]{"1", "2"}));
        b.set("A.f1.li/remove", (Object)new AList().appendAll((Object[])new String[]{"3"}));
        b.removeFrom("A.f1.li", (Object)new AList().appendAll((Object[])new String[]{"4"}));
        TestUtils.assertObjectEquals("{A:{'f1.li':[5]}}", b.build());
        b.clear();
        b.set("A.f1.li/add", (Object)new AList().appendAll((Object[])new Integer[]{1, 2, 3}));
        b.set("A.f1.li/add", (Object)new AList().appendAll((Object[])new Integer[]{4}));
        b.addTo("A.f1.li", (Object)new AList().appendAll((Object[])new Integer[]{5}));
        TestUtils.assertObjectEquals("{A:{'f1.li':[5,4,1,2,3]}}", b.build());
        b.set("A.f1.li/remove", (Object)new AList().appendAll((Object[])new Integer[]{1, 2}));
        b.set("A.f1.li/remove", (Object)new AList().appendAll((Object[])new Integer[]{3}));
        b.removeFrom("A.f1.li", (Object)new AList().appendAll((Object[])new Integer[]{4}));
        TestUtils.assertObjectEquals("{A:{'f1.li':[5]}}", b.build());
        b.clear();
        b.set("A.f1.li/add", (Object)new String[]{"1", "2", "3"});
        b.set("A.f1.li/add", (Object)new String[]{"4"});
        b.addTo("A.f1.li", (Object)new String[]{"5"});
        TestUtils.assertObjectEquals("{A:{'f1.li':[5,4,1,2,3]}}", b.build());
        b.set("A.f1.li/remove", (Object)new String[]{"1", "2"});
        b.set("A.f1.li/remove", (Object)new String[]{"3"});
        b.removeFrom("A.f1.li", (Object)new String[]{"4"});
        TestUtils.assertObjectEquals("{A:{'f1.li':[5]}}", b.build());
        b.clear();
        b.set("A.f1.li/add", (Object)new Integer[]{1, 2, 3});
        b.set("A.f1.li/add", (Object)new Integer[]{4});
        b.addTo("A.f1.li", (Object)new Integer[]{5});
        TestUtils.assertObjectEquals("{A:{'f1.li':[5,4,1,2,3]}}", b.build());
        b.set("A.f1.li/remove", (Object)new Integer[]{1, 2});
        b.set("A.f1.li/remove", (Object)new Integer[]{3});
        b.removeFrom("A.f1.li", (Object)new Integer[]{4});
        TestUtils.assertObjectEquals("{A:{'f1.li':[5]}}", b.build());
        b.clear();
        b.set("A.f1.li/add", (Object)new int[]{1, 2, 3});
        b.set("A.f1.li/add", (Object)new int[]{4});
        b.addTo("A.f1.li", (Object)new int[]{5});
        TestUtils.assertObjectEquals("{A:{'f1.li':[5,4,1,2,3]}}", b.build());
        b.set("A.f1.li/remove", (Object)new int[]{1, 2});
        b.set("A.f1.li/remove", (Object)new int[]{3});
        b.removeFrom("A.f1.li", (Object)new int[]{4});
        TestUtils.assertObjectEquals("{A:{'f1.li':[5]}}", b.build());
        b.set("A.f1.li", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.ls/add", (Object)"['1','2','3']");
        b.set("A.f1.ls/add.10", (Object)"4");
        b.set("A.f1.ls/add.1", (Object)"5");
        b.set("A.f1.ls/add.0", (Object)"6");
        b.set("A.f1.ls/add.-10", (Object)"7");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['7','6','1','5','2','3','4']}}", b.build());
        b.set("A.f1.ls/add.1", (Object)"['8','9']");
        TestUtils.assertObjectEquals("{A:{'f1.ls':['7','8','9','6','1','5','2','3','4']}}", b.build());
        this.testError(b, "A.f1.li/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1.li' (List<Integer>).  Value 'foo' (String) cannot be converted to an Integer.");
        try {
            b.addTo("A.f1.li", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid argument 'foo' on add command for property 'f1.li' (List<Integer>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testListClass() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.lc", (Object)new AList().appendAll((Object[])new Class[]{String.class, Integer.class, null}));
        b.set("A.f2.lc", (Object)new AList().appendAll(new Object[]{String.class, Integer.class, null}));
        b.set("A.f3.lc", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.lang.String','java.lang.Integer'],'f2.lc':['java.lang.String','java.lang.Integer']}}", ps);
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f1.lc"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f2.lc"));
        b.clear();
        b.set("A.f1.lc/add", Integer.class);
        b.addTo("A.f1.lc", String.class);
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.lang.String','java.lang.Integer']}}", b.build());
        b.set("A.f1.lc/remove", Integer.class);
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.lang.String']}}", b.build());
        b.clear();
        this.testError(b, "A.f1.lc/add", "['java.lang.Integer']", "Cannot add value '[\\'java.lang.Integer\\']' (String) to property 'f1.lc' (List<Class>).  Value 'java.lang.Integer' (String) cannot be converted to a Class.");
        this.testError(b, "A.f1.lc/add", "java.lang.Integer", "Cannot add value 'java.lang.Integer' (String) to property 'f1.lc' (List<Class>).  Value 'java.lang.Integer' (String) cannot be converted to a Class.");
        b.clear();
        b.set("A.f1.lc/add", (Object)AList.create((Object[])new Class[]{Integer.class, String.class}));
        b.set("A.f1.lc/add", (Object)new AList().appendAll((Object[])new Class[]{Map.class}));
        b.addTo("A.f1.lc", (Object)new AList().appendAll((Object[])new Class[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.util.List','java.util.Map','java.lang.Integer','java.lang.String']}}", b.build());
        b.set("A.f1.lc/remove", (Object)new AList().appendAll((Object[])new Class[]{Integer.class, String.class}));
        b.removeFrom("A.f1.lc", (Object)new AList().appendAll((Object[])new Class[0]));
        b.removeFrom("A.f1.lc", (Object)new AList().appendAll((Object[])new Class[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.util.Map']}}", b.build());
        b.clear();
        b.set("A.f1.lc/add", (Object)new AList().appendAll(new Object[]{Integer.class, String.class}));
        b.set("A.f1.lc/add", (Object)new AList().appendAll(new Object[]{Map.class}));
        b.addTo("A.f1.lc", (Object)new AList().appendAll(new Object[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.util.List','java.util.Map','java.lang.Integer','java.lang.String']}}", b.build());
        b.set("A.f1.lc/remove", (Object)new AList().appendAll(new Object[]{Integer.class, String.class}));
        b.set("A.f1.lc/remove", (Object)new AList().appendAll(new Object[0]));
        b.removeFrom("A.f1.lc", (Object)new AList().appendAll(new Object[]{List.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.util.Map']}}", b.build());
        b.clear();
        b.set("A.f1.lc/add", (Object)new Class[]{Integer.class, String.class});
        b.set("A.f1.lc/add", (Object)new Class[]{Map.class});
        b.addTo("A.f1.lc", (Object)new Class[]{List.class});
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.util.List','java.util.Map','java.lang.Integer','java.lang.String']}}", b.build());
        b.set("A.f1.lc/remove", (Object)new Class[]{Integer.class, String.class});
        b.set("A.f1.lc/remove", (Object)new Class[0]);
        b.removeFrom("A.f1.lc", (Object)new Class[]{List.class});
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.util.Map']}}", b.build());
        b.set("A.f1.lc", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.lc/add", String.class);
        b.set("A.f1.lc/add.10", Integer.class);
        b.set("A.f1.lc/add.1", Map.class);
        b.set("A.f1.lc/add.0", List.class);
        b.set("A.f1.lc/add.-10", Object.class);
        TestUtils.assertObjectEquals("{A:{'f1.lc':['java.lang.Object','java.util.List','java.lang.String','java.util.Map','java.lang.Integer']}}", b.build());
        this.testError(b, "A.f1.lc/add.123", "foo", "Cannot add value 'foo' (String) to property 'f1.lc' (List<Class>).  Value 'foo' (String) cannot be converted to a Class.");
        try {
            b.addTo("A.f1.lc", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid argument 'foo' on add command for property 'f1.lc' (List<Class>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testListObject() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.lo", (Object)new AList().appendAll((Object[])new Class[]{StringBuilder.class, null}));
        b.set("A.f2.lo", (Object)new AList().appendAll(new Object[]{123, true, new StringBuilder(123), StringBuilder.class, null}));
        b.set("A.f3.lo", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.lang.StringBuilder'],'f2.lo':[123,true,'','java.lang.StringBuilder']}}", ps);
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f1.lo"));
        TestUtils.assertInstanceOf(List.class, ps.getProperty("A.f2.lo"));
        TestUtils.assertInstanceOf(Class.class, ((List)ps.getProperty("A.f1.lo")).get(0));
        TestUtils.assertInstanceOf(Integer.class, ((List)ps.getProperty("A.f2.lo")).get(0));
        TestUtils.assertInstanceOf(Boolean.class, ((List)ps.getProperty("A.f2.lo")).get(1));
        TestUtils.assertInstanceOf(StringBuilder.class, ((List)ps.getProperty("A.f2.lo")).get(2));
        TestUtils.assertInstanceOf(Class.class, ((List)ps.getProperty("A.f2.lo")).get(3));
        b.clear();
        b.set("A.f1.lo/add", (Object)1);
        b.addTo("A.f1.lo", (Object)2);
        TestUtils.assertObjectEquals("{A:{'f1.lo':[2,1]}}", b.build());
        b.set("A.f1.lo/remove", (Object)1);
        TestUtils.assertObjectEquals("{A:{'f1.lo':[2]}}", b.build());
        b.clear();
        b.set("A.f1.lo/add", (Object)new AList().appendAll((Object[])new Class[]{StringBuilder.class}));
        b.set("A.f1.lo/add", (Object)new AList().appendAll((Object[])new Class[]{HashMap.class}));
        b.addTo("A.f1.lo", (Object)new AList().appendAll((Object[])new Class[]{LinkedList.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.util.LinkedList','java.util.HashMap','java.lang.StringBuilder']}}", b.build());
        b.set("A.f1.lo/remove", (Object)new AList().appendAll((Object[])new Class[]{HashMap.class}));
        b.removeFrom("A.f1.lo", (Object)new AList().appendAll((Object[])new Class[0]));
        b.removeFrom("A.f1.lo", (Object)new AList().appendAll((Object[])new Class[]{LinkedList.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.lang.StringBuilder']}}", b.build());
        b.clear();
        b.set("A.f1.lo/add", (Object)new AList().appendAll(new Object[]{StringBuilder.class}));
        b.set("A.f1.lo/add", (Object)new AList().appendAll(new Object[]{HashMap.class}));
        b.addTo("A.f1.lo", (Object)new AList().appendAll(new Object[]{LinkedList.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.util.LinkedList','java.util.HashMap','java.lang.StringBuilder']}}", b.build());
        b.set("A.f1.lo/remove", (Object)new AList().appendAll(new Object[]{HashMap.class}));
        b.set("A.f1.lo/remove", (Object)new AList().appendAll(new Object[0]));
        b.removeFrom("A.f1.lo", (Object)new AList().appendAll(new Object[]{LinkedList.class}));
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.lang.StringBuilder']}}", b.build());
        b.clear();
        b.set("A.f1.lo/add", (Object)new Class[]{StringBuilder.class});
        b.set("A.f1.lo/add", (Object)new Class[]{HashMap.class});
        b.addTo("A.f1.lo", (Object)new Class[]{LinkedList.class});
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.util.LinkedList','java.util.HashMap','java.lang.StringBuilder']}}", b.build());
        b.set("A.f1.lo/remove", (Object)new Class[]{HashMap.class});
        b.set("A.f1.lo/remove", (Object)new Class[0]);
        b.removeFrom("A.f1.lo", (Object)new Class[]{LinkedList.class});
        TestUtils.assertObjectEquals("{A:{'f1.lo':['java.lang.StringBuilder']}}", b.build());
        b.set("A.f1.lo", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.lo/add", StringBuilder.class);
        b.set("A.f1.lo/add.10", HashMap.class);
        b.set("A.f1.lo/add.1", LinkedList.class);
        b.set("A.f1.lo/add.0", (Object)TestEnum.ONE);
        b.set("A.f1.lo/add.-10", (Object)TestEnum.TWO);
        TestUtils.assertObjectEquals("{A:{'f1.lo':['TWO','ONE','java.lang.StringBuilder','java.util.LinkedList','java.util.HashMap']}}", b.build());
        try {
            b.addTo("A.f1.lo", "foo", (Object)"bar");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Invalid argument 'foo' on add command for property 'f1.lo' (List<Object>)", (Object)e.getMessage());
        }
    }

    @Test
    public void testMapString() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.sms", (Object)new AMap().append((Object)"foo", (Object)"bar").append((Object)"baz", (Object)"qux").append((Object)"quux", null).append(null, null));
        b.set("A.f2.sms", (Object)new AMap().append((Object)"foo", (Object)123).append((Object)"bar", (Object)true).append((Object)"baz", (Object)TestEnum.ONE).append((Object)"qux", null));
        b.set("A.f3.sms", (Object)new AMap().append((Object)"foo", (Object)new StringBuilder("bar")).append((Object)"baz", null));
        b.set("A.f4.sms", (Object)"{foo:'bar',baz:123,qux:true}");
        b.set("A.f5.sms", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.sms':{baz:'qux',foo:'bar'},'f2.sms':{bar:'true',baz:'ONE',foo:'123'},'f3.sms':{foo:'bar'},'f4.sms':{baz:'123',foo:'bar',qux:'true'}}}", ps);
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f1.sms"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f2.sms"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f3.sms"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f4.sms"));
        b.clear();
        b.set("A.f1.sms/add", (Object)"{foo:'bar'}");
        TestUtils.assertObjectEquals("{A:{'f1.sms':{foo:'bar'}}}", b.build());
        b.clear();
        b.set("A.f1.sms/add.foo", (Object)"bar");
        TestUtils.assertObjectEquals("{A:{'f1.sms':{foo:'bar'}}}", b.build());
        b.set("A.f1.sms/add.foo", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.sms", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.sms", (Object)"{foo:'bar'}");
        this.testError(b, "A.f1.sms/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.sms' (Map<String,String>).");
        try {
            b.removeFrom("A.f1.sms", (Object)"foo");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot remove value 'foo' (String) from property 'f1.sms' (Map<String,String>).", (Object)e.getMessage());
        }
    }

    @Test
    public void testMapInteger() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.smi", (Object)new AMap().append((Object)"foo", (Object)"1").append((Object)"baz", (Object)"2").append((Object)"quux", null).append(null, null));
        b.set("A.f2.smi", (Object)new AMap().append((Object)"foo", (Object)123).append((Object)"bar", (Object)"456").append((Object)"baz", null));
        b.set("A.f3.smi", (Object)new AMap().append((Object)"foo", (Object)new StringBuilder("123")).append((Object)"baz", null));
        b.set("A.f4.smi", (Object)"{foo:'123',baz:456,qux:null}");
        b.set("A.f5.smi", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.smi':{baz:2,foo:1},'f2.smi':{bar:456,foo:123},'f3.smi':{foo:123},'f4.smi':{baz:456,foo:123}}}", ps);
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f1.smi"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f2.smi"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f3.smi"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f4.smi"));
        b.clear();
        b.set("A.f1.smi/add", (Object)"{foo:'123'}");
        TestUtils.assertObjectEquals("{A:{'f1.smi':{foo:123}}}", b.build());
        b.clear();
        b.set("A.f1.smi/add.foo", (Object)"123");
        TestUtils.assertObjectEquals("{A:{'f1.smi':{foo:123}}}", b.build());
        b.set("A.f1.smi/add.foo", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.smi", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.smi", (Object)"{foo:'123'}");
        this.testError(b, "A.f1.smi/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.smi' (Map<String,Integer>).");
        try {
            b.removeFrom("A.f1.smi", (Object)"foo");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot remove value 'foo' (String) from property 'f1.smi' (Map<String,Integer>).", (Object)e.getMessage());
        }
    }

    @Test
    public void testMapClass() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.smc", (Object)new AMap().append((Object)"foo", String.class).append((Object)"baz", Integer.class).append((Object)"quux", null).append(null, null));
        b.set("A.f2.smc", (Object)new AMap().append((Object)"foo", String.class).append((Object)"bar", Integer.class).append((Object)"baz", null));
        b.set("A.f3.smc", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.smc':{baz:'java.lang.Integer',foo:'java.lang.String'},'f2.smc':{bar:'java.lang.Integer',foo:'java.lang.String'}}}", ps);
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f1.smc"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f2.smc"));
        TestUtils.assertInstanceOf(Class.class, ((Map)ps.getProperty("A.f1.smc")).values().iterator().next());
        TestUtils.assertInstanceOf(Class.class, ((Map)ps.getProperty("A.f2.smc")).values().iterator().next());
        b.clear();
        b.set("A.f1.smc/add.foo", String.class);
        TestUtils.assertObjectEquals("{A:{'f1.smc':{foo:'java.lang.String'}}}", b.build());
        b.set("A.f1.smc/add.foo", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.smc", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.smc/add.foo", String.class);
        this.testError(b, "A.f1.smc/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.smc' (Map<String,Class>).");
        try {
            b.removeFrom("A.f1.smc", (Object)"foo");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot remove value 'foo' (String) from property 'f1.smc' (Map<String,Class>).", (Object)e.getMessage());
        }
    }

    @Test
    public void testMapObject() throws Exception {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = null;
        b.set("A.f1.smo", (Object)new AMap().append((Object)"foo", (Object)"1").append((Object)"baz", (Object)"2").append((Object)"quux", null).append(null, null));
        b.set("A.f2.smo", (Object)new AMap().append((Object)"foo", (Object)123).append((Object)"bar", StringBuilder.class).append((Object)"qux", null));
        b.set("A.f3.smo", (Object)new AMap().append((Object)"foo", (Object)new StringBuilder("123")).append((Object)"baz", null));
        b.set("A.f4.smo", (Object)"{foo:'123',baz:456,qux:null}");
        b.set("A.f5.smo", null);
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'f1.smo':{baz:'2',foo:'1'},'f2.smo':{bar:'java.lang.StringBuilder',foo:123},'f3.smo':{foo:'123'},'f4.smo':{baz:456,foo:'123'}}}", ps);
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f1.smo"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f2.smo"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f3.smo"));
        TestUtils.assertInstanceOf(Map.class, ps.getProperty("A.f4.smo"));
        b.clear();
        b.set("A.f1.smo/add", (Object)"{foo:'123'}");
        TestUtils.assertObjectEquals("{A:{'f1.smo':{foo:'123'}}}", b.build());
        b.clear();
        b.set("A.f1.smo/add.foo", (Object)"123");
        TestUtils.assertObjectEquals("{A:{'f1.smo':{foo:'123'}}}", b.build());
        b.set("A.f1.smo/add.foo", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.smo", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.clear();
        b.set("A.f1.smo", (Object)"{foo:'123'}");
        this.testError(b, "A.f1.smo/remove", "foo", "Cannot remove value 'foo' (String) from property 'f1.smo' (Map<String,Object>).");
        try {
            b.removeFrom("A.f1.smo", (Object)"foo");
            Assert.fail((String)"Exception expected.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Cannot remove value 'foo' (String) from property 'f1.smo' (Map<String,Object>).", (Object)e.getMessage());
        }
    }

    @Test
    public void testPropertyTypeStringHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1", (Object)"foo");
        b2.set("A.f1", (Object)new StringBuilder("foo"));
        this.testEquals(b1, b2);
        this.testEquals(b1, b1);
        b1.set("A.f1", (Object)"foo");
        b2.set("A.f1", (Object)new StringBuilder("foox"));
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1", (Object)"foo");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1", (Object)"bar");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testPropertyTypeBooleanHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.b", (Object)true);
        b2.set("A.f1.b", (Object)new StringBuilder("true"));
        this.testEquals(b1, b2);
        this.testEquals(b1, b1);
        b1.set("A.f1.b", (Object)true);
        b2.set("A.f1.b", (Object)new StringBuilder("false"));
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.b", (Object)true);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.b", (Object)false);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testPropertyTypeIntegerHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.i", (Object)1);
        b2.set("A.f1.i", (Object)new StringBuilder("1"));
        this.testEquals(b1, b2);
        this.testEquals(b1, b1);
        b1.set("A.f1.i", (Object)1);
        b2.set("A.f1.i", (Object)new StringBuilder("2"));
        this.testNotEquals(b1, b2);
        Assert.assertTrue((b1.build() != b2.build() ? 1 : 0) != 0);
        ps = b1.build();
        b1.set("A.f1.i", (Object)1);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.i", (Object)2);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testClassHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.c", String.class);
        b2.set("A.f1.c", String.class);
        this.testEquals(b1, b2);
        this.testEquals(b1, b1);
        b1.set("A.f1.c", String.class);
        b2.set("A.f1.c", Integer.class);
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.c", String.class);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.c", Integer.class);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testObjectHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.o", (Object)"foo");
        b2.set("A.f1.o", (Object)"foo");
        this.testEquals(b1, b2);
        this.testEquals(b1, b1);
        b1.set("A.f1.o", (Object)TestEnum.ONE);
        b2.set("A.f1.o", (Object)TestEnum.TWO);
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.o", (Object)TestEnum.ONE);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.o", (Object)TestEnum.TWO);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testSetStringHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.ss", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar"}));
        b2.set("A.f1.ss", (Object)new String[]{"foo", "bar"});
        this.testEquals(b1, b2);
        b2.set("A.f1.ss", (Object)new AList().appendAll(new Object[]{new StringBuilder("bar"), new StringBuilder("foo")}));
        this.testEquals(b1, b2);
        b2.set("A.f1.ss", (Object)new Object[]{new StringBuilder("bar"), new StringBuilder("foo")});
        this.testEquals(b1, b2);
        b1.set("A.f1.ss", (Object)new String[]{"foo"});
        b2.set("A.f1.ss", (Object)new String[]{"foox"});
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.ss", (Object)"['foo']");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.ss", (Object)"['bar']");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testSetIntegerHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.si", (Object)new AList().appendAll((Object[])new String[]{"1", "2"}));
        b2.set("A.f1.si", (Object)new String[]{"1", "2"});
        this.testEquals(b1, b2);
        b2.set("A.f1.si", (Object)new AList().appendAll(new Object[]{new StringBuilder("2"), 1}));
        this.testEquals(b1, b2);
        b2.set("A.f1.si", (Object)new Object[]{new StringBuilder("2"), 1});
        this.testEquals(b1, b2);
        b1.set("A.f1.si", (Object)new String[]{"1"});
        b2.set("A.f1.si", (Object)new String[]{"2"});
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.si", (Object)"['1']");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.si", (Object)"['2']");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testSetClassHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.sc", (Object)new AList().appendAll((Object[])new Class[]{String.class, Integer.class}));
        b2.set("A.f1.sc", (Object)new Class[]{Integer.class, String.class});
        this.testEquals(b1, b2);
        b2.set("A.f1.sc", (Object)new AList().appendAll(new Object[]{Integer.class, String.class}));
        this.testEquals(b1, b2);
        b2.set("A.f1.sc", (Object)new Object[]{String.class, Integer.class});
        this.testEquals(b1, b2);
        b1.set("A.f1.sc", (Object)new Class[]{String.class});
        b2.set("A.f1.sc", (Object)new Class[]{Integer.class});
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.sc", String.class);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.sc", Map.class);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testListStringHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.ls", (Object)new AList().appendAll((Object[])new String[]{"foo", "bar"}));
        b2.set("A.f1.ls", (Object)new String[]{"foo", "bar"});
        this.testEquals(b1, b2);
        b2.set("A.f1.ls", (Object)new AList().appendAll(new Object[]{new StringBuilder("foo"), new StringBuilder("bar")}));
        this.testEquals(b1, b2);
        b2.set("A.f1.ls", (Object)new AList().appendAll(new Object[]{new StringBuilder("bar"), new StringBuilder("foo")}));
        this.testNotEquals(b1, b2);
        b2.set("A.f1.ls", (Object)new Object[]{new StringBuilder("foo"), new StringBuilder("bar")});
        this.testEquals(b1, b2);
        b2.set("A.f1.ls", (Object)new Object[]{new StringBuilder("foo"), new StringBuilder("bar")});
        this.testEquals(b1, b2);
        b1.set("A.f1.ls", (Object)new String[]{"foo"});
        b2.set("A.f1.ls", (Object)new String[]{"foox"});
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.ls", (Object)"['foo']");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.ls", (Object)"['bar']");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testListIntegerHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.li", (Object)new AList().appendAll((Object[])new String[]{"1", "2"}));
        b2.set("A.f1.li", (Object)new String[]{"1", "2"});
        this.testEquals(b1, b2);
        b2.set("A.f1.li", (Object)new String[]{"2", "1"});
        this.testNotEquals(b1, b2);
        b2.set("A.f1.li", (Object)new int[]{1, 2});
        this.testEquals(b1, b2);
        b2.set("A.f1.li", (Object)new AList().appendAll(new Object[]{new StringBuilder("2"), 1}));
        this.testNotEquals(b1, b2);
        b2.set("A.f1.li", (Object)new Object[]{new StringBuilder("1"), 2});
        this.testEquals(b1, b2);
        b1.set("A.f1.li", (Object)new String[]{"1"});
        b2.set("A.f1.li", (Object)new String[]{"2"});
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.li", (Object)"['1']");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.li", (Object)"['2']");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testListClassHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.lc", (Object)new AList().appendAll((Object[])new Class[]{String.class, Integer.class}));
        b2.set("A.f1.lc", (Object)new Class[]{String.class, Integer.class});
        this.testEquals(b1, b2);
        b2.set("A.f1.lc", (Object)new Class[]{Integer.class, String.class});
        this.testNotEquals(b1, b2);
        b2.set("A.f1.lc", (Object)new AList().appendAll(new Object[]{String.class, Integer.class}));
        this.testEquals(b1, b2);
        b2.set("A.f1.lc", (Object)new Object[]{String.class, Integer.class});
        this.testEquals(b1, b2);
        b1.set("A.f1.lc", (Object)new Class[]{String.class});
        b2.set("A.f1.lc", (Object)new Class[]{Integer.class});
        this.testNotEquals(b1, b2);
        ps = b1.build();
        b1.set("A.f1.lc", String.class);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.lc", Map.class);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testListObjectHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.lo", (Object)new AList().appendAll(new Object[]{"foo", 123, true, TestEnum.ONE}));
        b2.set("A.f1.lo", (Object)new AList().appendAll(new Object[]{"foo", 123, true, TestEnum.ONE}));
        this.testEquals(b1, b2);
        b2.set("A.f1.lo", (Object)new AList().appendAll(new Object[]{123, true, TestEnum.ONE, "foo"}));
        this.testNotEquals(b1, b2);
        b2.set("A.f1.lo", (Object)new Object[]{"foo", 123, true, TestEnum.ONE});
        this.testEquals(b1, b2);
        b1.set("A.f1.lo", (Object)new Object[]{StringBuilder.class});
        b2.set("A.f1.lo", (Object)new Object[]{StringBuffer.class});
        this.testNotEquals(b1, b2);
        b1.set("A.f1.lo", (Object)"foo");
        ps = b1.build();
        b1.set("A.f1.lo", (Object)"foo");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.lo", (Object)"bar");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testMapStringHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.sms", (Object)new AMap().append((Object)"foo", (Object)"123").append((Object)"bar", (Object)"true").append((Object)"baz", null).append(null, null));
        b2.set("A.f1.sms", (Object)new AMap().append((Object)"foo", (Object)123).append((Object)"bar", (Object)true).append((Object)"baz", null).append(null, null));
        this.testEquals(b1, b2);
        b2.set("A.f1.sms", (Object)new AMap().append((Object)"foo", (Object)new StringBuilder("123")).append((Object)"bar", (Object)new StringBuilder("true")));
        this.testEquals(b1, b2);
        b2.set("A.f1.sms", (Object)new AMap().append((Object)"bar", (Object)new StringBuilder("true")).append((Object)"foo", (Object)new StringBuilder("123")));
        this.testEquals(b1, b2);
        b2.set("A.f1.sms", (Object)new AMap().append((Object)"bar", (Object)false).append((Object)"foo", (Object)new StringBuilder("123")));
        this.testNotEquals(b1, b2);
        b1.set("A.f1.sms", (Object)"{foo:'bar'}");
        ps = b1.build();
        b1.set("A.f1.sms", (Object)"{foo:'bar'}");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.sms", (Object)"{foo:'baz'}");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testMapIntegerHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.smi", (Object)new AMap().append((Object)"foo", (Object)123).append((Object)"bar", (Object)456).append((Object)"baz", null).append(null, null));
        b2.set("A.f1.smi", (Object)new AMap().append((Object)"foo", (Object)123).append((Object)"bar", (Object)"456").append((Object)"baz", null).append(null, null));
        this.testEquals(b1, b2);
        b2.set("A.f1.smi", (Object)new AMap().append((Object)"foo", (Object)new StringBuilder("123")).append((Object)"bar", (Object)new StringBuilder("456")));
        this.testEquals(b1, b2);
        b2.set("A.f1.smi", (Object)new AMap().append((Object)"bar", (Object)new StringBuilder("456")).append((Object)"foo", (Object)new StringBuilder("123")));
        this.testEquals(b1, b2);
        b2.set("A.f1.smi", (Object)new AMap().append((Object)"bar", (Object)"457").append((Object)"foo", (Object)new StringBuilder("123")));
        this.testNotEquals(b1, b2);
        b1.set("A.f1.smi", (Object)"{foo:'123'}");
        ps = b1.build();
        b1.set("A.f1.smi", (Object)"{foo:'123'}");
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.smi", (Object)"{foo:'456'}");
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testMapClassHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.smc", (Object)new AMap().append((Object)"foo", String.class).append((Object)"bar", Integer.class).append((Object)"baz", null).append(null, null));
        b2.set("A.f1.smc", (Object)new AMap().append((Object)"foo", String.class).append((Object)"bar", Integer.class).append((Object)"baz", null).append(null, null));
        this.testEquals(b1, b2);
        b2.set("A.f1.smc", (Object)new AMap().append((Object)"foo", String.class).append((Object)"bar", Integer.class));
        this.testEquals(b1, b2);
        b2.set("A.f1.smc", (Object)new AMap().append((Object)"bar", Integer.class).append((Object)"foo", String.class));
        this.testEquals(b1, b2);
        b2.set("A.f1.smc", (Object)new AMap().append((Object)"bar", Integer.class).append((Object)"foo", StringBuilder.class));
        this.testNotEquals(b1, b2);
        b1.clear();
        b1.set("A.f1.smc/add.foo", Integer.class);
        ps = b1.build();
        b1.set("A.f1.smc/add.foo", Integer.class);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.smc/add.foo", String.class);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testMapObjectHash() throws Exception {
        PropertyStoreBuilder b1 = PropertyStore.create();
        PropertyStoreBuilder b2 = PropertyStore.create();
        PropertyStore ps = null;
        b1.set("A.f1.smo", (Object)new AMap().append((Object)"foo", (Object)TestEnum.ONE).append((Object)"bar", (Object)TestEnum.TWO).append((Object)"baz", null).append(null, null));
        b2.set("A.f1.smo", (Object)new AMap().append((Object)"foo", (Object)TestEnum.ONE).append((Object)"bar", (Object)TestEnum.TWO).append((Object)"baz", null).append(null, null));
        this.testEquals(b1, b2);
        b2.set("A.f1.smo", (Object)new AMap().append((Object)"foo", (Object)TestEnum.ONE).append((Object)"bar", (Object)TestEnum.TWO));
        this.testEquals(b1, b2);
        b2.set("A.f1.smo", (Object)new AMap().append((Object)"bar", (Object)TestEnum.TWO).append((Object)"foo", (Object)TestEnum.ONE));
        this.testEquals(b1, b2);
        b2.set("A.f1.smo", (Object)new AMap().append((Object)"bar", (Object)TestEnum.ONE).append((Object)"foo", (Object)TestEnum.TWO));
        this.testNotEquals(b1, b2);
        b1.clear();
        b1.set("A.f1.smo/add.foo", (Object)TestEnum.ONE);
        ps = b1.build();
        b1.set("A.f1.smo/add.foo", (Object)TestEnum.ONE);
        Assert.assertTrue((ps == b1.build() ? 1 : 0) != 0);
        b1.set("A.f1.smo/add.foo", (Object)TestEnum.TWO);
        Assert.assertTrue((ps != b1.build() ? 1 : 0) != 0);
        b1.clear();
        b2.clear();
        this.testEquals(b1, b2);
    }

    @Test
    public void testStringDefault() {
        System.setProperty("A.f1", "foo");
        PropertyStore ps = PropertyStore.create().build();
        Assert.assertEquals((Object)"foo", (Object)ps.getProperty("A.f1"));
        System.clearProperty("A.f1");
        ps = PropertyStore.create().build();
        Assert.assertNull((Object)ps.getProperty("A.f1"));
    }

    @Test
    public void testIntegerDefault() {
        System.setProperty("A.f1.i", "1");
        PropertyStore ps = PropertyStore.create().build();
        Assert.assertEquals((Object)1, (Object)ps.getProperty("A.f1.i"));
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f1.i"));
        System.clearProperty("A.f1.i");
        System.setProperty("A.f1", "1");
        ps = PropertyStore.create().build();
        Assert.assertEquals((Object)1, (Object)ps.getProperty("A.f1.i"));
        TestUtils.assertInstanceOf(Integer.class, ps.getProperty("A.f1.i"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.i"));
    }

    @Test
    public void testObjectDefault() {
        System.setProperty("A.f1.o", "123");
        PropertyStore ps = PropertyStore.create().build();
        Assert.assertEquals((Object)"123", (Object)ps.getProperty("A.f1.o"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f1.o"));
        System.clearProperty("A.f1.o");
        System.setProperty("A.f1", "123");
        Assert.assertEquals((Object)"123", (Object)ps.getProperty("A.f1.o"));
        TestUtils.assertInstanceOf(String.class, ps.getProperty("A.f1.o"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.o"));
    }

    @Test
    public void testSetStringDefault() {
        System.setProperty("A.f1.ss", "['foo','bar']");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("['bar','foo']", ps.getProperty("A.f1.ss"));
        System.clearProperty("A.f1.ss");
        System.setProperty("A.f1", "['foo','bar']");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("['bar','foo']", ps.getProperty("A.f1.ss"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.ss"));
    }

    @Test
    public void testSetIntegerDefault() {
        System.setProperty("A.f1.si", "['2','1']");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("[1,2]", ps.getProperty("A.f1.si"));
        System.clearProperty("A.f1.si");
        System.setProperty("A.f1", "['2','1']");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("[1,2]", ps.getProperty("A.f1.si"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.si"));
    }

    @Test
    public void testListStringDefault() {
        System.setProperty("A.f1.ls", "['foo','bar']");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("['foo','bar']", ps.getProperty("A.f1.ls"));
        System.clearProperty("A.f1.ls");
        System.setProperty("A.f1", "['foo','bar']");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("['foo','bar']", ps.getProperty("A.f1.ls"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.ls"));
    }

    @Test
    public void testListIntegerDefault() {
        System.setProperty("A.f1.li", "['2','1']");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("[2,1]", ps.getProperty("A.f1.li"));
        System.clearProperty("A.f1.li");
        System.setProperty("A.f1", "['2','1']");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("[2,1]", ps.getProperty("A.f1.li"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.li"));
    }

    @Test
    public void testMapStringDefault() {
        System.setProperty("A.f1.sms", "{foo:'bar',baz:null}");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("{foo:'bar'}", ps.getProperty("A.f1.sms"));
        System.clearProperty("A.f1.sms");
        System.setProperty("A.f1", "{foo:'bar',baz:null}");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("{foo:'bar'}", ps.getProperty("A.f1.sms"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.sms"));
    }

    @Test
    public void testMapIntegerDefault() {
        System.setProperty("A.f1.smi", "{foo:'123',baz:null}");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("{foo:123}", ps.getProperty("A.f1.smi"));
        System.clearProperty("A.f1.smi");
        System.setProperty("A.f1", "{foo:'123',baz:null}");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("{foo:123}", ps.getProperty("A.f1.smi"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.smi"));
    }

    @Test
    public void testMapObjectDefault() {
        System.setProperty("A.f1.smo", "{foo:123,bar:'baz',qux:true,quux:null}");
        PropertyStore ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("{bar:'baz',foo:123,qux:true}", ps.getProperty("A.f1.smo"));
        System.clearProperty("A.f1.smo");
        System.setProperty("A.f1", "{foo:123,bar:'baz',qux:true,quux:null}");
        ps = PropertyStore.create().build();
        TestUtils.assertObjectEquals("{bar:'baz',foo:123,qux:true}", ps.getProperty("A.f1.smo"));
        System.clearProperty("A.f1");
        Assert.assertNull((Object)ps.getProperty("A.f1.smo"));
    }

    @Test
    public void testBuilderFromStore() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set("A.foo", (Object)"bar");
        PropertyStore ps1 = b.build();
        b = ps1.builder();
        TestUtils.assertObjectEquals("{A:{foo:'bar'}}", b.build());
    }

    @Test
    public void testSet() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set((Map)new ObjectMap().append("A.foo", (Object)"bar"));
        b.set((Map)new ObjectMap().append("A.baz", (Object)"qux"));
        b.add(null);
        TestUtils.assertObjectEquals("{A:{baz:'qux'}}", b.build());
    }

    @Test
    public void testAdd() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.add((Map)new ObjectMap().append("A.foo", (Object)"bar"));
        b.add((Map)new ObjectMap().append("A.baz", (Object)"qux"));
        b.add((Map)new ObjectMap().append("A.quux", null));
        b.add(null);
        TestUtils.assertObjectEquals("{A:{baz:'qux',foo:'bar'}}", b.build());
    }

    @Test
    public void testRemoveNotExisting() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.removeFrom("A.foo.ls", (Object)"bar");
        TestUtils.assertObjectEquals("{}", b.build());
    }

    @Test
    public void testAddToNull() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.addTo("A.foo.ls", null);
        TestUtils.assertObjectEquals("{}", b.build());
    }

    @Test
    public void testRemoveNull() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.removeFrom("A.foo.ss", null);
        TestUtils.assertObjectEquals("{}", b.build());
        b.removeFrom("A.foo.ls", null);
        TestUtils.assertObjectEquals("{}", b.build());
    }

    @Test
    public void testRemoveFromInvalidObjectList() {
        PropertyStoreBuilder b = PropertyStore.create();
        try {
            b.removeFrom("A.foo.ss", (Object)"[xxx]");
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot remove value '[xxx]' (String) from property 'foo.ss' (Set<String>)."));
        }
        try {
            b.removeFrom("A.foo.ls", (Object)"[xxx]");
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot remove value '[xxx]' (String) from property 'foo.ls' (List<String>)."));
        }
    }

    @Test
    public void testAddToInvalidObjectMap() {
        PropertyStoreBuilder b = PropertyStore.create();
        try {
            b.addTo("A.foo.sms", (Object)"{xxx}");
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot add '{xxx}' (String) to property 'foo.sms' (Map<String,String>)."));
        }
        try {
            b.addTo("A.foo.sms", (Object)"xxx");
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Cannot add 'xxx' (String) to property 'foo.sms' (Map<String,String>).", (Object)e.getMessage());
        }
        try {
            b.addTo("A.foo.sms", (Object)new StringBuilder("foo"));
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            Assert.assertEquals((Object)"Cannot add 'foo' (StringBuilder) to property 'foo.sms' (Map<String,String>).", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetNonExistent() {
        PropertyStore b = PropertyStore.create().set("A.foo", (Object)"bar").build();
        Assert.assertNull((Object)b.getProperty("A.baz"));
        Assert.assertNull((Object)b.getProperty("B.foo"));
    }

    @Test
    public void testHashCodes() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set("A.foo", (Object)"bar").set("B.foo", (Object)"bar");
        PropertyStore ps = b.build();
        Assert.assertEquals((Object)ps.hashCode(new String[]{"A", "B", "C", null}), (Object)ps.hashCode(new String[]{"A", "B", "C", null}));
        Assert.assertNotEquals((Object)ps.hashCode(new String[]{"A"}), (Object)ps.hashCode(new String[]{"B"}));
        Assert.assertNotEquals((Object)ps.hashCode(new String[]{"A", "B"}), (Object)ps.hashCode(new String[]{"B", "A"}));
    }

    @Test
    public void testEquals() {
        PropertyStoreBuilder b = PropertyStore.create();
        PropertyStore ps = b.build();
        Assert.assertFalse((boolean)ps.equals((Object)"foo"));
    }

    @Test
    public void testEqualsByGroups() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set("A.foo", (Object)"bar").set("B.foo", (Object)"bar").set("D.foo", (Object)"bar");
        PropertyStore ps1 = b.build();
        b.remove("A.foo").set("C.foo", (Object)"bar").set("D.foo", (Object)"baz");
        PropertyStore ps2 = b.build();
        Assert.assertTrue((boolean)ps1.equals(ps1, new String[]{null, null}));
        Assert.assertTrue((boolean)ps1.equals(ps2, new String[]{null, null}));
        Assert.assertTrue((boolean)ps1.equals(ps2, new String[]{"B"}));
        Assert.assertTrue((boolean)ps1.equals(ps2, new String[]{"X"}));
        Assert.assertFalse((boolean)ps1.equals(ps2, new String[]{"A"}));
        Assert.assertFalse((boolean)ps1.equals(ps2, new String[]{"C"}));
        Assert.assertFalse((boolean)ps1.equals(ps2, new String[]{"D"}));
        Assert.assertFalse((boolean)ps1.equals(ps2, new String[]{"B", "D"}));
    }

    @Test
    public void testKeySet() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set("A.foo", (Object)"bar").set("B.foo", (Object)"bar").set("D.foo", (Object)"bar");
        PropertyStore ps = b.build();
        TestUtils.assertObjectEquals("[]", ps.getPropertyKeys(null));
        TestUtils.assertObjectEquals("['foo']", ps.getPropertyKeys("A"));
        TestUtils.assertObjectEquals("[]", ps.getPropertyKeys("C"));
    }

    @Test
    public void testToMutable() {
        PropertyStoreBuilder b = PropertyStore.create();
        b.set("A.foo.s", (Object)"bar");
        b.set("A.foo.b", (Object)true);
        b.set("A.foo.i", (Object)123);
        b.set("A.foo.c", String.class);
        b.set("A.foo.o", (Object)"bar");
        b.set("A.foo.ss", (Object)"['bar']");
        b.set("A.foo.si", (Object)"[123]");
        b.set("A.foo.sc/add", String.class);
        b.set("A.foo.ls", (Object)"['bar']");
        b.set("A.foo.li", (Object)"[123]");
        b.set("A.foo.lc/add", String.class);
        b.set("A.foo.lo/add", StringBuilder.class);
        b.set("A.foo.sms", (Object)"{foo:'bar'}");
        b.set("A.foo.smi", (Object)"{foo:123}");
        b.set("A.foo.smc/add.foo", String.class);
        b.set("A.foo.smo/add.foo", StringBuilder.class);
        PropertyStore ps = b.build();
        b = ps.builder();
        ps = b.build();
        TestUtils.assertObjectEquals("{A:{'foo.b':true,'foo.c':'java.lang.String','foo.i':123,'foo.lc':['java.lang.String'],'foo.li':[123],'foo.lo':['java.lang.StringBuilder'],'foo.ls':['bar'],'foo.o':'bar','foo.s':'bar','foo.sc':['java.lang.String'],'foo.si':[123],'foo.smc':{foo:'java.lang.String'},'foo.smi':{foo:123},'foo.smo':{foo:'java.lang.StringBuilder'},'foo.sms':{foo:'bar'},'foo.ss':['bar']}}", ps);
    }

    @Test
    public void testToString() {
        PropertyStore p = PropertyStore.create().build();
        Assert.assertEquals((Object)"{}", (Object)p.toString());
    }

    @Test
    public void testNoneOnList() {
        PropertyStoreBuilder psb = PropertyStore.create();
        psb.set("A.foo.ls", (Object)"['foo','bar']");
        psb.set("A.foo.ls", (Object)"NONE");
        Assert.assertEquals((Object)"{}", (Object)psb.build().toString());
    }

    @Test
    public void testNoneOnSet() {
        PropertyStoreBuilder psb = PropertyStore.create();
        psb.set("A.foo.ss", (Object)"['foo','bar']");
        psb.set("A.foo.ss", (Object)"NONE");
        Assert.assertEquals((Object)"{}", (Object)psb.build().toString());
    }

    @Test
    public void testInheritOnList() {
        PropertyStoreBuilder psb = PropertyStore.create();
        psb.set("A.foo.ls", (Object)"['foo','bar']");
        psb.set("A.foo.ls", (Object)"['baz','INHERIT','qux']");
        Assert.assertEquals((Object)"{A:{'foo.ls':['baz','foo','bar','qux']}}", (Object)psb.build().toString());
    }

    @Test
    public void testInheritOnSet() {
        PropertyStoreBuilder psb = PropertyStore.create();
        psb.set("A.foo.ls", (Object)"['foo','bar']");
        psb.set("A.foo.ls", (Object)"['baz','INHERIT','qux']");
        Assert.assertEquals((Object)"{A:{'foo.ls':['baz','foo','bar','qux']}}", (Object)psb.build().toString());
    }

    @Test
    public void testIndexedValuesOnList() {
        PropertyStoreBuilder psb = PropertyStore.create();
        psb.set("A.foo.ls", (Object)"['foo','bar']");
        psb.set("A.foo.ls", (Object)new String[]{"INHERIT", "[0]:baz"});
        Assert.assertEquals((Object)"{A:{'foo.ls':['baz','foo','bar']}}", (Object)psb.build().toString());
        psb.set("A.foo.ls", (Object)new String[]{"INHERIT", "[1]:qux"});
        Assert.assertEquals((Object)"{A:{'foo.ls':['baz','qux','foo','bar']}}", (Object)psb.build().toString());
        psb.set("A.foo.ls", (Object)new String[]{"INHERIT", "[10]:quux"});
        Assert.assertEquals((Object)"{A:{'foo.ls':['baz','qux','foo','bar','quux']}}", (Object)psb.build().toString());
    }

    @Test
    public void testListOfAnnotations() {
        Html html1 = A1.class.getAnnotation(Html.class);
        Html html1a = A1.class.getAnnotation(Html.class);
        Html html2 = A2.class.getAnnotation(Html.class);
        Html html3 = A3.class.getAnnotation(Html.class);
        Json json4 = A4.class.getAnnotation(Json.class);
        PropertyStore ps1 = PropertyStore.create().set("xxx", (Object)AList.create((Object[])new Html[]{html1})).build();
        PropertyStore ps1a = PropertyStore.create().set("xxx", (Object)AList.create((Object[])new Html[]{html1a})).build();
        PropertyStore ps2 = PropertyStore.create().set("xxx", (Object)AList.create((Object[])new Html[]{html2})).build();
        PropertyStore ps3 = PropertyStore.create().set("xxx", (Object)AList.create((Object[])new Html[]{html3})).build();
        PropertyStore ps4 = PropertyStore.create().set("xxx", (Object)AList.create((Object[])new Json[]{json4})).build();
        Assert.assertTrue((boolean)ps1.equals((Object)ps1a));
        Assert.assertTrue((boolean)ps1.equals((Object)ps2));
        Assert.assertFalse((boolean)ps1.equals((Object)ps3));
        Assert.assertFalse((boolean)ps1.equals((Object)ps4));
    }

    @Test
    public void testEqualsWithAnnotations() {
        HtmlSerializer s1 = HtmlSerializer.create().build();
        HtmlSerializer s2 = HtmlSerializer.create().applyAnnotations(new Class[]{B1.class}).build();
        HtmlSerializer s3 = HtmlSerializer.create().applyAnnotations(new Class[]{B1.class}).build();
        HtmlSerializer s4 = HtmlSerializer.create().applyAnnotations(new Class[]{B2.class}).build();
        Assert.assertFalse((boolean)s1.getPropertyStore().equals((Object)s2.getPropertyStore()));
        Assert.assertFalse((boolean)s1.getPropertyStore().equals((Object)s4.getPropertyStore()));
        Assert.assertTrue((boolean)s2.getPropertyStore().equals((Object)s3.getPropertyStore()));
    }

    private void testError(PropertyStoreBuilder b, String key, Object val, String msg) {
        try {
            b.set(key, val);
            Assert.fail((String)"Exception expected.");
        }
        catch (ConfigException e) {
            if ("xxx".equals(msg)) {
                System.err.println(e.getLocalizedMessage());
            }
            Assert.assertEquals((Object)msg, (Object)e.getMessage());
        }
    }

    private void testEquals(PropertyStoreBuilder b1, PropertyStoreBuilder b2) {
        Assert.assertTrue((b1.build() == b2.build() ? 1 : 0) != 0);
    }

    private void testNotEquals(PropertyStoreBuilder b1, PropertyStoreBuilder b2) {
        PropertyStore p2;
        PropertyStore p1 = b1.build();
        Assert.assertTrue((p1 != (p2 = b2.build()) ? 1 : 0) != 0);
        Assert.assertTrue((p1.hashCode() != p2.hashCode() ? 1 : 0) != 0);
    }

    public static enum TestEnum {
        ONE,
        TWO,
        THREE;

    }

    @HtmlConfig(applyHtml={@Html(on="B2", format=HtmlFormat.HTML)})
    public static class B2 {
    }

    @HtmlConfig(applyHtml={@Html(on="B1", format=HtmlFormat.XML)})
    public static class B1 {
    }

    @Json(on="foo")
    public static class A4 {
    }

    @Html(on="bar")
    public static class A3 {
    }

    @Html(on="foo")
    public static class A2 {
    }

    @Html(on="foo")
    public static class A1 {
    }
}

