/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.PropertyNamerDLC;
import org.apache.juneau.PropertyNamerULC;
import org.junit.Assert;
import org.junit.Test;

public class PropertyNamerTest {
    @Test
    public void testDLC() throws Exception {
        PropertyNamerDLC n = new PropertyNamerDLC();
        Assert.assertEquals((Object)"abc", (Object)n.getPropertyName("ABC"));
        Assert.assertEquals((Object)"abc", (Object)n.getPropertyName("abc"));
        Assert.assertEquals((Object)"foo-bar-baz", (Object)n.getPropertyName("FooBarBaz"));
        Assert.assertEquals((Object)"foo-bar-baz", (Object)n.getPropertyName("FooBarBAZ"));
        Assert.assertEquals((Object)"foo-bar-baz", (Object)n.getPropertyName("fooBarBAZ"));
        Assert.assertEquals((Object)"", (Object)n.getPropertyName(""));
        Assert.assertNull((Object)n.getPropertyName(null));
        Assert.assertEquals((Object)"a", (Object)n.getPropertyName("A"));
        Assert.assertEquals((Object)"a", (Object)n.getPropertyName("A"));
    }

    @Test
    public void testULC() throws Exception {
        PropertyNamerULC n = new PropertyNamerULC();
        Assert.assertEquals((Object)"abc", (Object)n.getPropertyName("ABC"));
        Assert.assertEquals((Object)"abc", (Object)n.getPropertyName("abc"));
        Assert.assertEquals((Object)"foo_bar_baz", (Object)n.getPropertyName("FooBarBaz"));
        Assert.assertEquals((Object)"foo_bar_baz", (Object)n.getPropertyName("FooBarBAZ"));
        Assert.assertEquals((Object)"foo_bar_baz", (Object)n.getPropertyName("fooBarBAZ"));
        Assert.assertEquals((Object)"", (Object)n.getPropertyName(""));
        Assert.assertNull((Object)n.getPropertyName(null));
        Assert.assertEquals((Object)"a", (Object)n.getPropertyName("A"));
        Assert.assertEquals((Object)"a", (Object)n.getPropertyName("A"));
    }
}

