/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.StringSwap;
import org.junit.Assert;
import org.junit.Test;

public class PojoSwapTest {
    @Test
    public void testSameType() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().pojoSwaps(new Class[]{ASwap.class}).build();
        JsonParser p = JsonParser.create().pojoSwaps(new Class[]{ASwap.class}).build();
        String r = s.serialize((Object)"foobar");
        Assert.assertEquals((Object)"'xfoobarx'", (Object)r);
        r = (String)p.parse(r, String.class);
        Assert.assertEquals((Object)"foobar", (Object)r);
        ObjectMap m = new ObjectMap((CharSequence)"{foo:'bar'}");
        r = s.serialize((Object)m);
        Assert.assertEquals((Object)"{xfoox:'xbarx'}", (Object)r);
    }

    public static class ASwap
    extends StringSwap<String> {
        public String swap(BeanSession session, String o) throws SerializeException {
            return "x" + o + "x";
        }

        public String unswap(BeanSession session, String f, ClassMeta<?> hint) throws ParseException {
            return f.substring(1, f.length() - 1);
        }
    }
}

