/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Example;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Test;

public class PojoExamplesTest {
    @Test
    public void testProperty() throws Exception {
        BeanSession bs = BeanContext.create().example(A.class, (Object)new A().init()).build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1a'}", bs.getClassMeta(A.class).getExample(bs));
    }

    @Test
    public void testExampleField() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1b'}", bs.getClassMeta(B1.class).getExample(bs));
    }

    @Test
    public void testExampleField_usingConfig() throws Exception {
        BeanSession bs = BeanContext.create().applyAnnotations(new Class[]{B1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1b'}", bs.getClassMeta(B1c.class).getExample(bs));
    }

    @Test
    public void testExampleFieldPrivate() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1b'}", bs.getClassMeta(B2.class).getExample(bs));
    }

    @Test
    public void testExampleFieldPrivate_usingConfig() throws Exception {
        BeanSession bs = BeanContext.create().applyAnnotations(new Class[]{B2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1b'}", bs.getClassMeta(B2c.class).getExample(bs));
    }

    @Test
    public void testExampleOnPublicNoArgMethod() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1c'}", bs.getClassMeta(C1.class).getExample(bs));
    }

    @Test
    public void testExampleOnPublicNoArgMethod_usingConfig() throws Exception {
        BeanSession bs = BeanContext.create().applyAnnotations(new Class[]{C1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1c'}", bs.getClassMeta(C1c.class).getExample(bs));
    }

    @Test
    public void testExampleOnPrivateNoArgMethod() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1c'}", bs.getClassMeta(C2.class).getExample(bs));
    }

    @Test
    public void testExampleOnPrivateNoArgMethod_usingConfig() throws Exception {
        BeanSession bs = BeanContext.create().applyAnnotations(new Class[]{C2c.class}).build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1c'}", bs.getClassMeta(C2c.class).getExample(bs));
    }

    @Test
    public void testExampleOnPublicOneArgMethod() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1d'}", bs.getClassMeta(D1.class).getExample(bs));
    }

    @Test
    public void testExampleOnPublicOneArgMethod_usingConfig() throws Exception {
        BeanSession bs = BeanContext.create().applyAnnotations(new Class[]{D1c.class}).build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1d'}", bs.getClassMeta(D1c.class).getExample(bs));
    }

    @Test
    public void testExampleMethod() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1e'}", bs.getClassMeta(E1.class).getExample(bs));
    }

    @Test
    public void testExampleBeanSessionMethod() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        TestUtils.assertObjectEquals("{f1:'f1e'}", bs.getClassMeta(E2.class).getExample(bs));
    }

    @Test
    public void testInvalidUsesOfExample() throws Exception {
        BeanSession bs = BeanContext.create().build().createSession();
        try {
            bs.getClassMeta(F1.class);
        }
        catch (Exception e) {
            TestUtils.assertContains(e.getMessage(), "@Example used on invalid method 'example(String)'");
        }
        try {
            bs.getClassMeta(F2.class);
        }
        catch (Exception e) {
            TestUtils.assertContains(e.getMessage(), "@Example used on invalid method 'example()'");
        }
        try {
            bs.getClassMeta(F3.class);
        }
        catch (Exception e) {
            TestUtils.assertContains(e.getMessage(), "@Example used on invalid field 'org.apache.juneau.PojoExamplesTest$F3.F3'");
        }
        try {
            bs.getClassMeta(F4.class);
        }
        catch (Exception e) {
            TestUtils.assertContains(e.getMessage(), "@Example used on invalid field 'org.apache.juneau.PojoExamplesTest$F4.f4'");
        }
    }

    public static class F4 {
        @Example
        public F4 f4 = new F4();
    }

    public static class F3 {
        @Example
        public static String F3 = "foo";
    }

    public static class F2 {
        @Example
        public F2 example() {
            return null;
        }
    }

    public static class F1 {
        @Example
        public static F1 example(String s) {
            return null;
        }
    }

    public static class E2 {
        public String f1;

        public E2 init() {
            this.f1 = "f1e";
            return this;
        }

        public static E2 example(BeanSession bs) {
            return new E2().init();
        }
    }

    public static class E1 {
        public String f1;

        public E1 init() {
            this.f1 = "f1e";
            return this;
        }

        public static E1 example() {
            return new E1().init();
        }
    }

    @BeanConfig(applyExample={@Example(on="D1c.x(BeanSession)")})
    public static class D1c {
        public String f1;

        public D1c init() {
            this.f1 = "f1d";
            return this;
        }

        public static D1c x(BeanSession bs) {
            return new D1c().init();
        }
    }

    public static class D1 {
        public String f1;

        public D1 init() {
            this.f1 = "f1d";
            return this;
        }

        @Example
        public static D1 x(BeanSession bs) {
            return new D1().init();
        }
    }

    @BeanConfig(applyExample={@Example(on="C2c.x")})
    public static class C2c {
        public String f1;

        public C2c init() {
            this.f1 = "f1c";
            return this;
        }

        private static C2c x() {
            return new C2c().init();
        }
    }

    public static class C2 {
        public String f1;

        public C2 init() {
            this.f1 = "f1c";
            return this;
        }

        @Example
        private static C2 x() {
            return new C2().init();
        }
    }

    @BeanConfig(applyExample={@Example(on="C1c.x")})
    public static class C1c {
        public String f1;

        public C1c init() {
            this.f1 = "f1c";
            return this;
        }

        public static C1c x() {
            return new C1c().init();
        }
    }

    public static class C1 {
        public String f1;

        public C1 init() {
            this.f1 = "f1c";
            return this;
        }

        @Example
        public static C1 x() {
            return new C1().init();
        }
    }

    @BeanConfig(applyExample={@Example(on="B2c.EXAMPLE")})
    public static class B2c {
        public String f1;
        private static B2c EXAMPLE = new B2c().init();

        public B2c init() {
            this.f1 = "f1b";
            return this;
        }
    }

    public static class B2 {
        public String f1;
        @Example
        private static B2 EXAMPLE = new B2().init();

        public B2 init() {
            this.f1 = "f1b";
            return this;
        }
    }

    @BeanConfig(applyExample={@Example(on="B1c.EXAMPLE")})
    public static class B1c {
        public String f1;
        public static B1c EXAMPLE = new B1c().init();

        public B1c init() {
            this.f1 = "f1b";
            return this;
        }
    }

    public static class B1 {
        public String f1;
        @Example
        public static B1 EXAMPLE = new B1().init();

        public B1 init() {
            this.f1 = "f1b";
            return this;
        }
    }

    public static class A {
        public String f1;

        public A init() {
            this.f1 = "f1a";
            return this;
        }
    }
}

