/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.junit.Assert;
import org.junit.Test;

public class ParserReaderTest {
    @Test
    public void testBasic() throws Exception {
        String t = "01234567890123456789012345678901234567890123456789";
        ParserReader pr = this.createParserReader(t);
        String r = this.read(pr);
        Assert.assertEquals((Object)t, (Object)r);
        pr.close();
        pr = this.createParserReader(t);
        pr.read();
        pr.unread();
        r = this.read(pr);
        Assert.assertEquals((Object)t, (Object)r);
        pr.close();
        pr = this.createParserReader(t);
        Assert.assertEquals((long)48L, (long)((char)pr.peek()));
        Assert.assertEquals((long)48L, (long)((char)pr.peek()));
        r = this.read(pr);
        Assert.assertEquals((Object)t, (Object)r);
        pr = this.createParserReader(t);
        pr.read();
        pr.unread();
        try {
            pr.unread();
            Assert.fail((String)"Exception expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMarking() throws Exception {
        String t = "a123456789b123456789c123456789d123456789e123456789f123456789g123456789h123456789i123456789j123456789";
        String r = null;
        ParserReader pr = this.createParserReader(t);
        this.read(pr, 5);
        pr.mark();
        this.read(pr, 10);
        r = pr.getMarked();
        Assert.assertEquals((Object)"56789b1234", (Object)r);
        r = this.read(pr);
        Assert.assertEquals((Object)"56789c123456789d123456789e123456789f123456789g123456789h123456789i123456789j123456789", (Object)r);
        pr = this.createParserReader(t);
        this.read(pr, 5);
        pr.mark();
        this.read(pr, 20);
        r = pr.getMarked();
        Assert.assertEquals((Object)"56789b123456789c1234", (Object)r);
        r = this.read(pr);
        Assert.assertEquals((Object)"56789d123456789e123456789f123456789g123456789h123456789i123456789j123456789", (Object)r);
    }

    @Test
    public void testReadStrings() throws Exception {
        String t = "a123456789b123456789c123456789d123456789e123456789f123456789g123456789h123456789i123456789j123456789";
        ParserReader pr = this.createParserReader(t);
        Assert.assertEquals((Object)"a123456789", (Object)pr.read(10));
        pr.mark();
        Assert.assertEquals((Object)"b123456789c123456789", (Object)pr.read(20));
        Assert.assertEquals((Object)"d123456789e123456789f123456789", (Object)pr.read(30));
        Assert.assertEquals((Object)"123456789c123456789d123456789e123456789f12345678", (Object)pr.getMarked(1, -1));
        Assert.assertEquals((Object)"g123456789h123456789i123456789j123456789", (Object)pr.read(100));
        Assert.assertEquals((Object)"", (Object)pr.read(100));
        pr.close();
    }

    @Test
    public void testReplace() throws Exception {
        String t = "a123456789b123456789c123456789d123456789e123456789f123456789g123456789h123456789i123456789j123456789";
        ParserReader pr = this.createParserReader(t);
        Assert.assertEquals((Object)"a123456789", (Object)pr.read(10));
        pr.mark();
        Assert.assertEquals((Object)"b123456789", (Object)pr.read(10));
        pr.replace('x');
        Assert.assertEquals((Object)"c123456789", (Object)pr.read(10));
        Assert.assertEquals((Object)"b12345678xc123456789", (Object)pr.getMarked());
        pr.close();
        pr = this.createParserReader(t);
        Assert.assertEquals((Object)"a123456789", (Object)pr.read(10));
        pr.mark();
        Assert.assertEquals((Object)"b123456789", (Object)pr.read(10));
        pr.replace(120, 5);
        Assert.assertEquals((Object)"c123456789", (Object)pr.read(10));
        Assert.assertEquals((Object)"b1234xc123456789", (Object)pr.getMarked());
        pr.close();
    }

    @Test
    public void testDelete() throws Exception {
        String t = "a123456789b123456789c123456789d123456789e123456789f123456789g123456789h123456789i123456789j123456789";
        ParserReader pr = this.createParserReader(t);
        Assert.assertEquals((Object)"a123456789", (Object)pr.read(10));
        pr.mark();
        Assert.assertEquals((Object)"b123456789", (Object)pr.read(10));
        pr.delete();
        Assert.assertEquals((Object)"c123456789", (Object)pr.read(10));
        Assert.assertEquals((Object)"b12345678c123456789", (Object)pr.getMarked());
        pr.close();
        pr = this.createParserReader(t);
        Assert.assertEquals((Object)"a123456789", (Object)pr.read(10));
        pr.mark();
        Assert.assertEquals((Object)"b123456789", (Object)pr.read(10));
        pr.delete(5);
        Assert.assertEquals((Object)"c123456789", (Object)pr.read(10));
        Assert.assertEquals((Object)"b1234c123456789", (Object)pr.getMarked());
        pr.close();
    }

    private String read(ParserReader r) throws IOException {
        return this.read(r, Integer.MAX_VALUE);
    }

    private String read(ParserReader r, int length) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int c = r.read();
            if (c == -1) {
                return sb.toString();
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private ParserReader createParserReader(Object in) throws Exception {
        return new ParserReader(new ParserPipe(in));
    }
}

