/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.json.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class ParserGenericsTest {
    @Test
    public void testMap() throws Exception {
        JsonParser p = JsonParser.DEFAULT;
        String t = "{foo:{bar:'baz'}}";
        Map r1 = (Map)p.parse(t, TestMap1.class);
        Assert.assertEquals(TestMap1.class, r1.getClass());
        Assert.assertEquals(TreeMap.class, ((TreeMap)r1.get("foo")).getClass());
        t = "{foo:[1,2,3]}";
        Map r2 = (Map)p.parse(t, TestMap2.class);
        Assert.assertEquals(TestMap2.class, r2.getClass());
        Assert.assertEquals(LinkedList.class, ((LinkedList)r2.get("foo")).getClass());
        Assert.assertEquals(Integer.class, ((Integer)((LinkedList)r2.get("foo")).get(0)).getClass());
    }

    @Test
    public void testCollection() throws Exception {
        JsonParser p = JsonParser.DEFAULT;
        String t = "[{foo:{bar:'baz'}}]";
        List r1 = (List)p.parse(t, TestCollection1.class);
        Assert.assertEquals(TestCollection1.class, r1.getClass());
        Assert.assertEquals(TestMap1.class, ((TestMap1)r1.get(0)).getClass());
        Assert.assertEquals(TreeMap.class, ((TreeMap)((TestMap1)r1.get(0)).get("foo")).getClass());
        t = "[{foo:[1,2,3]}]";
        List r2 = (List)p.parse(t, TestCollection2.class);
        Assert.assertEquals(TestCollection2.class, r2.getClass());
        Assert.assertEquals(TestMap2.class, ((TestMap2)r2.get(0)).getClass());
        Assert.assertEquals(LinkedList.class, ((LinkedList)((TestMap2)r2.get(0)).get("foo")).getClass());
        Assert.assertEquals(Integer.class, ((Integer)((LinkedList)((TestMap2)r2.get(0)).get("foo")).get(0)).getClass());
    }

    public static class TestCollection2
    extends LinkedList<TestMap2> {
    }

    public static class TestCollection1
    extends LinkedList<TestMap1> {
    }

    public static class TestMap2
    extends LinkedHashMap<String, LinkedList<Integer>> {
    }

    public static class TestMap1
    extends LinkedHashMap<String, TreeMap<String, String>> {
    }
}

