/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.utils.PojoRest;
import org.junit.Assert;
import org.junit.Test;

public class ObjectMapTest {
    @Test
    public void testBasic() throws Exception {
        String in = "{A:'asdf'}";
        this.checkStep(1, in, new ObjectMap((CharSequence)in).getString("A"), "asdf");
        in = "{A:{B:'asdf'}}";
        this.checkStep(2, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B"), "asdf");
        this.checkStep(3, in, new ObjectMap((CharSequence)in).getString("A"), "{B:'asdf'}");
        in = "{A:{B:'asdf'+\"asdf\"}}";
        this.checkStep(4, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B"), "asdfasdf");
        this.checkStep(5, in, new ObjectMap((CharSequence)in).getString("A"), "{B:'asdfasdf'}");
        in = "{A:{B:'asdf' + \n\t \"asdf\"}}";
        this.checkStep(6, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B"), "asdfasdf");
        this.checkStep(7, in, new ObjectMap((CharSequence)in).getString("A"), "{B:'asdfasdf'}");
        in = "{A:{B:'asdf\"asdf', C:\"asdf'asdf\", D : \"asdf\\\"asdf\", E: 'asdf\\'asdf', F:\"asdf\\'asdf\", G:'asdf\\\"asdf'}}";
        this.checkStep(8, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B"), "asdf\"asdf");
        this.checkStep(9, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/C"), "asdf'asdf");
        this.checkStep(10, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/D"), "asdf\"asdf");
        this.checkStep(11, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/E"), "asdf'asdf");
        this.checkStep(12, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/F"), "asdf'asdf");
        this.checkStep(13, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/G"), "asdf\"asdf");
        in = "{A:123, B: 123}";
        this.checkStep(16, in, new Integer(new ObjectMap((CharSequence)in).getInt("A")).toString(), "123");
        this.checkStep(17, in, new Integer(new ObjectMap((CharSequence)in).getInt("B")).toString(), "123");
        in = "{A:true, B: true, C:false, D: false}";
        this.checkStep(18, in, new Boolean(new ObjectMap((CharSequence)in).getBoolean("A")).toString(), "true");
        this.checkStep(19, in, new Boolean(new ObjectMap((CharSequence)in).getBoolean("B")).toString(), "true");
        this.checkStep(20, in, new Boolean(new ObjectMap((CharSequence)in).getBoolean("C")).toString(), "false");
        this.checkStep(21, in, new Boolean(new ObjectMap((CharSequence)in).getBoolean("D")).toString(), "false");
        in = "{'AAA':{\"BBB\":\"CCC\",'DDD':false}}";
        this.checkStep(31, in, this.getDeepString(new ObjectMap((CharSequence)in), "AAA/BBB"), "CCC");
        this.checkStep(32, in, this.getDeepBoolean(new ObjectMap((CharSequence)in), "AAA/DDD").toString(), "false");
        in = " \n\n\t {  'AAA' : { \"BBB\" : \"CCC\" , 'DDD' : false } } \n\t";
        this.checkStep(33, in, this.getDeepString(new ObjectMap((CharSequence)in), "AAA/BBB"), "CCC");
        this.checkStep(34, in, this.getDeepBoolean(new ObjectMap((CharSequence)in), "AAA/DDD").toString(), "false");
        in = "/*x*/{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(100, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{/*x*/A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(101, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A/*x*/:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(102, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:/*x*/'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(103, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:'/*x*/B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(104, in, new ObjectMap((CharSequence)in).getString("A"), "/*x*/B");
        in = "{A:'B/*x*/','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(105, in, new ObjectMap((CharSequence)in).getString("A"), "B/*x*/");
        in = "{A:'B'/*x*/,'C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(106, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:'B',/*x*/'C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(107, in, new ObjectMap((CharSequence)in).getString("C"), "1");
        in = "{A:'B','C':/*x*/1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(108, in, new ObjectMap((CharSequence)in).getString("C"), "1");
        in = "{A:'B','C':1/*x*/,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(109, in, new ObjectMap((CharSequence)in).getString("C"), "1");
        in = "{A:'B','C':1,/*x*/\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(110, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"/*x*/E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(111, in, new ObjectMap((CharSequence)in).getObjectList("/*x*/E").getString(0), "1");
        in = "{A:'B','C':1,\"E/*x*/\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(112, in, new ObjectMap((CharSequence)in).getObjectList("E/*x*/").getString(0), "1");
        in = "{A:'B','C':1,\"E\"/*x*/:[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(113, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":/*x*/[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(114, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":[/*x*/1,2,3],G:['g1','g2','g3']}";
        this.checkStep(115, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":[1/*x*/,2,3],G:['g1','g2','g3']}";
        this.checkStep(116, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":[1,/*x*/2,3],G:['g1','g2','g3']}";
        this.checkStep(117, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(1), "2");
        in = "{A:'B','C':1,\"E\":[1,2/*x*/,3],G:['g1','g2','g3']}";
        this.checkStep(118, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(1), "2");
        in = "{A:'B','C':1,\"E\":[1,2,/*x*/3],G:['g1','g2','g3']}";
        this.checkStep(119, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(2), "3");
        in = "{A:'B','C':1,\"E\":[1,2,3]/*x*/,G:['g1','g2','g3']}";
        this.checkStep(120, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(2), "3");
        in = "{A:'B','C':1,\"E\":[1,2,3],/*x*/G:['g1','g2','g3']}";
        this.checkStep(121, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:[/*x*/'g1','g2','g3']}";
        this.checkStep(122, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['/*x*/g1','g2','g3']}";
        this.checkStep(123, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "/*x*/g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1'/*x*/,'g2','g3']}";
        this.checkStep(124, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1',/*x*/'g2','g3']}";
        this.checkStep(125, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2'/*x*/,'g3']}";
        this.checkStep(126, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2',/*x*/'g3']}";
        this.checkStep(127, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3'/*x*/]}";
        this.checkStep(128, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']/*x*/}";
        this.checkStep(129, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}/*x*/";
        this.checkStep(130, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "/*\tx\t*///\tx\t\n\t/*\tx\t*/{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(201, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{/*\tx\t*///\tx\t\n\t/*\tx\t*/A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(202, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A/*\tx\t*///\tx\t\n\t/*\tx\t*/:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(203, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:/*\tx\t*///\tx\t\n\t/*\tx\t*/'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(204, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:'/*\tx\t*///\tx\t\n\t/*\tx\t*/B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(205, in, new ObjectMap((CharSequence)in).getString("A"), "/*\tx\t*///\tx\t\n\t/*\tx\t*/B");
        in = "{A:'B/*\tx\t*///\tx\t\n\t/*\tx\t*/','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(206, in, new ObjectMap((CharSequence)in).getString("A"), "B/*\tx\t*///\tx\t\n\t/*\tx\t*/");
        in = "{A:'B'/*\tx\t*///\tx\t\n\t/*\tx\t*/,'C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(207, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:'B',/*\tx\t*///\tx\t\n\t/*\tx\t*/'C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(208, in, new ObjectMap((CharSequence)in).getString("C"), "1");
        in = "{A:'B','C':/*\tx\t*///\tx\t\n\t/*\tx\t*/1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(209, in, new ObjectMap((CharSequence)in).getString("C"), "1");
        in = "{A:'B','C':1/*\tx\t*///\tx\t\n\t/*\tx\t*/,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(210, in, new ObjectMap((CharSequence)in).getString("C"), "1");
        in = "{A:'B','C':1,/*\tx\t*///\tx\t\n\t/*\tx\t*/\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(211, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"/*\tx\t*///\tx\t\n\t/*\tx\t*/E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(212, in, new ObjectMap((CharSequence)in).getObjectList("/*\tx\t*///\tx\t\n\t/*\tx\t*/E").getString(0), "1");
        in = "{A:'B','C':1,\"E/*\tx\t*///\tx\t\n\t/*\tx\t*/\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(213, in, new ObjectMap((CharSequence)in).getObjectList("E/*\tx\t*///\tx\t\n\t/*\tx\t*/").getString(0), "1");
        in = "{A:'B','C':1,\"E\"/*\tx\t*///\tx\t\n\t/*\tx\t*/:[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(214, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":/*\tx\t*///\tx\t\n\t/*\tx\t*/[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(215, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":[/*\tx\t*///\tx\t\n\t/*\tx\t*/1,2,3],G:['g1','g2','g3']}";
        this.checkStep(216, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":[1/*\tx\t*///\tx\t\n\t/*\tx\t*/,2,3],G:['g1','g2','g3']}";
        this.checkStep(217, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "1");
        in = "{A:'B','C':1,\"E\":[1,/*\tx\t*///\tx\t\n\t/*\tx\t*/2,3],G:['g1','g2','g3']}";
        this.checkStep(218, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(1), "2");
        in = "{A:'B','C':1,\"E\":[1,2/*\tx\t*///\tx\t\n\t/*\tx\t*/,3],G:['g1','g2','g3']}";
        this.checkStep(219, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(1), "2");
        in = "{A:'B','C':1,\"E\":[1,2,/*\tx\t*///\tx\t\n\t/*\tx\t*/3],G:['g1','g2','g3']}";
        this.checkStep(220, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(2), "3");
        in = "{A:'B','C':1,\"E\":[1,2,3]/*\tx\t*///\tx\t\n\t/*\tx\t*/,G:['g1','g2','g3']}";
        this.checkStep(221, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(2), "3");
        in = "{A:'B','C':1,\"E\":[1,2,3],/*\tx\t*///\tx\t\n\t/*\tx\t*/G:['g1','g2','g3']}";
        this.checkStep(222, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:[/*\tx\t*///\tx\t\n\t/*\tx\t*/'g1','g2','g3']}";
        this.checkStep(223, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['/*\tx\t*///\tx\t\n\t/*\tx\t*/g1','g2','g3']}";
        this.checkStep(224, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "/*\tx\t*///\tx\t\n\t/*\tx\t*/g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1'/*\tx\t*///\tx\t\n\t/*\tx\t*/,'g2','g3']}";
        this.checkStep(225, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g1");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1',/*\tx\t*///\tx\t\n\t/*\tx\t*/'g2','g3']}";
        this.checkStep(226, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2'/*\tx\t*///\tx\t\n\t/*\tx\t*/,'g3']}";
        this.checkStep(227, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2',/*\tx\t*///\tx\t\n\t/*\tx\t*/'g3']}";
        this.checkStep(228, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3'/*\tx\t*///\tx\t\n\t/*\tx\t*/]}";
        this.checkStep(229, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']/*\tx\t*///\tx\t\n\t/*\tx\t*/}";
        this.checkStep(230, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}/*\tx\t*///\tx\t\n\t/*\tx\t*/";
        this.checkStep(231, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(2), "g3");
        in = "{  /*  x  */  //  x  \n  /*  x  */  A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(240, in, new ObjectMap((CharSequence)in).getString("A"), "B");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(301, in, new ObjectMap((CharSequence)in).getString("A", "default"), "B");
        in = "{/*A:'B',*/'C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(302, in, new ObjectMap((CharSequence)in).getString("A", "default"), "default");
        in = "{A:'B',/*'C':1,*/\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(303, in, new ObjectMap((CharSequence)in).getString("C", "default"), "default");
        in = "{A:'B','C':1,/*\"E\":[1,2,3],*/G:['g1','g2','g3']}";
        this.checkStep(304, in, new ObjectMap((CharSequence)in).getString("E", "default"), "default");
        in = "{A:'B','C':1,\"E\":[/*1,*/2,3],G:['g1','g2','g3']}";
        this.checkStep(305, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(0), "2");
        in = "{A:'B','C':1,\"E\":[1,/*2,*/3],G:['g1','g2','g3']}";
        this.checkStep(306, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(1), "3");
        in = "{A:'B','C':1,\"E\":[1,2/*,3*/],G:['g1','g2','g3']}";
        this.checkStep(307, in, new ObjectMap((CharSequence)in).getObjectList("E").getString(1), "2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:[/*'g1',*/'g2','g3']}";
        this.checkStep(308, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(0), "g2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1'/*,'g2'*/,'g3']}";
        this.checkStep(309, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g3");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2'/*,'g3'*/]}";
        this.checkStep(310, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g2");
        in = "{A:'B','C':1,\"E\":[1,2,3],G:['g1','g2','g3']}";
        this.checkStep(310, in, new ObjectMap((CharSequence)in).getObjectList("G").getString(1), "g2");
        in = "{A:{B:[{C:'c0'},{C:'c1'},{C:'c2'}]}}";
        this.checkStep(401, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B/0/C"), "c0");
        this.checkStep(402, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B/1/C"), "c1");
        this.checkStep(403, in, this.getDeepString(new ObjectMap((CharSequence)in), "A/B/2/C"), "c2");
        in = "{'\ud852\udf62\ud852\udf62':'\ud852\udf62\ud852\udf62'}";
        this.checkStep(1, in, new ObjectMap((CharSequence)in).getString("\ud852\udf62\ud852\udf62"), "\ud852\udf62\ud852\udf62");
    }

    private String getDeepString(ObjectMap m, String url) {
        PojoRest r = new PojoRest((Object)m);
        return (String)r.get(url);
    }

    private Boolean getDeepBoolean(ObjectMap m, String url) {
        PojoRest r = new PojoRest((Object)m);
        return (Boolean)r.get(url);
    }

    private void checkStep(int step, String input, String output, String expectedValue) {
        if (!output.equals(expectedValue)) {
            String msg = "Step #" + step + " failed: [" + input + "]->[" + output + "]...Expected value=[" + expectedValue + "]";
            Assert.fail((String)msg);
        }
    }

    @Test
    public void testComparison() throws Exception {
        ObjectMap m1 = new ObjectMap((CharSequence)"{ firstName:'John', lastName:'Smith', age:123, isDeceased:false }");
        ObjectMap m2 = new ObjectMap((CharSequence)"{ age:123, isDeceased:false, lastName:'Smith', firstName:'John' }");
        Assert.assertTrue((boolean)m1.equals((Object)m2));
    }

    @Test
    public void testParent() throws Exception {
        ObjectMap m1 = new ObjectMap((CharSequence)"{a:1}");
        ObjectMap m2 = new ObjectMap((CharSequence)"{b:2}").setInner((Map)m1);
        Assert.assertEquals((Object)new Integer(1), (Object)m2.getInt("a"));
    }

    @Test
    public void testUpdatability() throws Exception {
        ObjectMap m = new ObjectMap((CharSequence)"{a:[{b:'c'}]}");
        ObjectList l = m.getObjectList("a");
        ObjectMap m2 = l.getObjectMap(0);
        m2.put((Object)"b", (Object)"x");
        TestUtils.assertObjectEquals("{a:[{b:'x'}]}", m);
        m = new ObjectMap((CharSequence)"{a:[{b:'c'}]}");
        for (ObjectMap m3 : m.getObjectList("a").elements(ObjectMap.class)) {
            m3.put((Object)"b", (Object)"y");
        }
        TestUtils.assertObjectEquals("{a:[{b:'y'}]}", m);
    }

    @Test
    public void testAtMethods() throws Exception {
        ObjectMap m = new ObjectMap((CharSequence)"{a:[{b:'c'}]}");
        String r = (String)m.getAt("a/0/b", String.class);
        Assert.assertEquals((Object)"c", (Object)r);
        m.putAt("a/0/b", (Object)"d");
        r = (String)m.getAt("a/0/b", String.class);
        Assert.assertEquals((Object)"d", (Object)r);
        m.postAt("a", (Object)"e");
        r = (String)m.getAt("a/1", String.class);
        Assert.assertEquals((Object)"e", (Object)r);
        m.deleteAt("a/1");
        Assert.assertEquals((Object)"{a:[{b:'d'}]}", (Object)m.toString());
    }

    @Test
    public void testFromReader() throws Exception {
        TestUtils.assertObjectEquals("{foo:'bar'}", new ObjectMap((Reader)new StringReader("{foo:'bar'}")));
    }

    @Test
    public void testGetMap() throws Exception {
        ObjectMap m = new ObjectMap((CharSequence)"{a:{1:'true',2:'false'}}");
        Map m2 = m.getMap("a", Integer.class, Boolean.class, null);
        TestUtils.assertObjectEquals("{'1':true,'2':false}", m2);
        Assert.assertEquals(Integer.class, ((Integer)m2.keySet().iterator().next()).getClass());
        Assert.assertEquals(Boolean.class, ((Boolean)m2.values().iterator().next()).getClass());
        m2 = m.getMap("b", Integer.class, Boolean.class, null);
        Assert.assertNull((Object)m2);
        m2 = (Map)m.get("a", Map.class, new Type[]{Integer.class, Boolean.class});
        TestUtils.assertObjectEquals("{'1':true,'2':false}", m2);
        Assert.assertEquals(Integer.class, ((Integer)m2.keySet().iterator().next()).getClass());
        Assert.assertEquals(Boolean.class, ((Boolean)m2.values().iterator().next()).getClass());
        m2 = (Map)m.get("b", Map.class, new Type[]{Integer.class, Boolean.class});
        Assert.assertNull((Object)m2);
    }

    @Test
    public void testGetList() throws Exception {
        ObjectMap m = new ObjectMap((CharSequence)"{a:['123','456']}");
        List l2 = m.getList("a", Integer.class, null);
        TestUtils.assertObjectEquals("[123,456]", l2);
        Assert.assertEquals(Integer.class, ((Integer)l2.iterator().next()).getClass());
        l2 = m.getList("b", Integer.class, null);
        Assert.assertNull((Object)l2);
        l2 = (List)m.get("a", List.class, new Type[]{Integer.class});
        TestUtils.assertObjectEquals("[123,456]", l2);
        Assert.assertEquals(Integer.class, ((Integer)l2.iterator().next()).getClass());
        l2 = (List)m.get("b", List.class, new Type[]{Integer.class});
        Assert.assertNull((Object)l2);
    }
}

