/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ObjectListTest {
    @Test
    public void testBasic() throws Exception {
        Assert.assertEquals((Object)"['A','B','C']", (Object)new ObjectList((Object[])new String[]{"A", "B", "C"}).toString());
        Assert.assertEquals((Object)"['A','B','C']", (Object)new ObjectList(new Object[]{"A", "B", "C"}).toString());
        Assert.assertEquals((Object)"['A','B','C']", (Object)new ObjectList(Arrays.asList("A", "B", "C")).toString());
    }

    @Test
    public void testIterateAs() throws Exception {
        ObjectList l = new ObjectList((CharSequence)"[{foo:'bar'},{baz:123}]");
        Iterator i1 = l.elements(ObjectMap.class).iterator();
        Assert.assertEquals((Object)"bar", (Object)((ObjectMap)i1.next()).getString("foo"));
        Assert.assertEquals((long)123L, (long)((ObjectMap)i1.next()).getInt("baz").intValue());
        l = new ObjectList((CharSequence)"[1,2,3]");
        Iterator i2 = l.elements(Integer.class).iterator();
        Assert.assertEquals((long)1L, (long)((Integer)i2.next()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)i2.next()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)i2.next()).intValue());
        l = new ObjectList((CharSequence)"[{name:'John Smith',age:45}]");
        Iterator i3 = l.elements(Person.class).iterator();
        Assert.assertEquals((Object)"John Smith", (Object)((Person)i3.next()).name);
    }

    @Test
    public void testAtMethods() throws Exception {
        ObjectList l = new ObjectList((CharSequence)"[{foo:'bar'},{baz:123}]");
        String r = (String)l.getAt("0/foo", String.class);
        Assert.assertEquals((Object)"bar", (Object)r);
        l.putAt("0/foo", (Object)"bing");
        r = (String)l.getAt("0/foo", String.class);
        Assert.assertEquals((Object)"bing", (Object)r);
        l.postAt("", (Object)new ObjectMap((CharSequence)"{a:'b'}"));
        r = (String)l.getAt("2/a", String.class);
        Assert.assertEquals((Object)"b", (Object)r);
        l.deleteAt("2");
        Assert.assertEquals((Object)"[{foo:'bing'},{baz:123}]", (Object)l.toString());
    }

    @Test
    public void testFromReader() throws Exception {
        TestUtils.assertObjectEquals("[1,2,3]", new ObjectList((Reader)new StringReader("[1,2,3]")));
    }

    @Test
    public void testGetMap() throws Exception {
        ObjectList l = new ObjectList((CharSequence)"[{1:'true',2:'false'}]");
        Map m2 = l.getMap(0, Integer.class, Boolean.class);
        TestUtils.assertObjectEquals("{'1':true,'2':false}", m2);
        Assert.assertEquals(Integer.class, ((Integer)m2.keySet().iterator().next()).getClass());
        Assert.assertEquals(Boolean.class, ((Boolean)m2.values().iterator().next()).getClass());
        m2 = (Map)l.get(0, Map.class, new Type[]{Integer.class, Boolean.class});
        TestUtils.assertObjectEquals("{'1':true,'2':false}", m2);
        Assert.assertEquals(Integer.class, ((Integer)m2.keySet().iterator().next()).getClass());
        Assert.assertEquals(Boolean.class, ((Boolean)m2.values().iterator().next()).getClass());
    }

    @Test
    public void testGetList() throws Exception {
        ObjectList l = new ObjectList((CharSequence)"[['123','456']]");
        List l2 = l.getList(0, Integer.class);
        TestUtils.assertObjectEquals("[123,456]", l2);
        Assert.assertEquals(Integer.class, ((Integer)l2.iterator().next()).getClass());
        l2 = (List)l.get(0, List.class, new Type[]{Integer.class});
        TestUtils.assertObjectEquals("[123,456]", l2);
        Assert.assertEquals(Integer.class, ((Integer)l2.iterator().next()).getClass());
    }

    public static class Person {
        public String name;
        public int age;
    }
}

