/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.testutils.pojos.ABean;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class MaxIndentTest {
    Input input;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new Input("List1dOfBeans-0", new List1dOfBeans().init1(), 0, "[{a:1, b:'foo'}]", "<array><object><a>1</a><b>foo</b></object></array>\n", "<table _type='array'><tr><th>a</th><th>b</th></tr><tr><td>1</td><td>foo</td></tr></table>\n", "@((a=1,b=foo))", "0=(a=1,b=foo)")}, {new Input("List1dOfBeans-1", new List1dOfBeans().init1(), 1, "[\n\t{a:1, b:'foo'}\n]", "<array>\n\t<object><a>1</a><b>foo</b></object>\n</array>\n", "<table _type='array'>\n\t<tr><th>a</th><th>b</th></tr>\n\t<tr><td>1</td><td>foo</td></tr>\n</table>\n", "@(\n\t(a=1,b=foo)\n)", "0=(\n\ta=1,\n\tb=foo\n)")}, {new Input("List1dOfBeans-2", new List1dOfBeans().init1(), 2, "[\n\t{\n\t\ta: 1,\n\t\tb: 'foo'\n\t}\n]", "<array>\n\t<object>\n\t\t<a>1</a>\n\t\t<b>foo</b>\n\t</object>\n</array>\n", "<table _type='array'>\n\t<tr>\n\t\t<th>a</th>\n\t\t<th>b</th>\n\t</tr>\n\t<tr>\n\t\t<td>1</td>\n\t\t<td>foo</td>\n\t</tr>\n</table>\n", "@(\n\t(\n\t\ta=1,\n\t\tb=foo\n\t)\n)", "0=(\n\ta=1,\n\tb=foo\n)")}, {new Input("List2dOfBeans-0", new List2dOfBeans().init2(), 0, "[[{a:1, b:'foo'}]]", "<array><array><object><a>1</a><b>foo</b></object></array></array>\n", "<ul><li><table _type='array'><tr><th>a</th><th>b</th></tr><tr><td>1</td><td>foo</td></tr></table></li></ul>\n", "@(@((a=1,b=foo)))", "0=@((a=1,b=foo))")}, {new Input("List2dOfBeans-1", new List2dOfBeans().init2(), 1, "[\n\t[{a:1, b:'foo'}]\n]", "<array>\n\t<array><object><a>1</a><b>foo</b></object></array>\n</array>\n", "<ul>\n\t<li><table _type='array'><tr><th>a</th><th>b</th></tr><tr><td>1</td><td>foo</td></tr></table></li>\n</ul>\n", "@(\n\t@((a=1,b=foo))\n)", "0=@(\n\t(a=1,b=foo)\n)")}, {new Input("List2dOfBeans-2", new List2dOfBeans().init2(), 2, "[\n\t[\n\t\t{a:1, b:'foo'}\n\t]\n]", "<array>\n\t<array>\n\t\t<object><a>1</a><b>foo</b></object>\n\t</array>\n</array>\n", "<ul>\n\t<li>\n\t\t<table _type='array'><tr><th>a</th><th>b</th></tr><tr><td>1</td><td>foo</td></tr></table>\n\t</li>\n</ul>\n", "@(\n\t@(\n\t\t(a=1,b=foo)\n\t)\n)", "0=@(\n\t(\n\t\ta=1,\n\t\tb=foo\n\t)\n)")}, {new Input("List2dOfBeans-3", new List2dOfBeans().init2(), 3, "[\n\t[\n\t\t{\n\t\t\ta: 1,\n\t\t\tb: 'foo'\n\t\t}\n\t]\n]", "<array>\n\t<array>\n\t\t<object>\n\t\t\t<a>1</a>\n\t\t\t<b>foo</b>\n\t\t</object>\n\t</array>\n</array>\n", "<ul>\n\t<li>\n\t\t<table _type='array'>\n\t\t\t<tr><th>a</th><th>b</th></tr>\n\t\t\t<tr><td>1</td><td>foo</td></tr>\n\t\t</table>\n\t</li>\n</ul>\n", "@(\n\t@(\n\t\t(\n\t\t\ta=1,\n\t\t\tb=foo\n\t\t)\n\t)\n)", "0=@(\n\t(\n\t\ta=1,\n\t\tb=foo\n\t)\n)")}, {new Input("Map1dOfBeans-0", new Map1dOfBeans().init1(), 0, "{a:{a:1, b:'foo'}}", "<object><a><a>1</a><b>foo</b></a></object>\n", "<table><tr><td>a</td><td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td></tr></table>\n", "(a=(a=1,b=foo))", "a=(a=1,b=foo)")}, {new Input("Map1dOfBeans-1", new Map1dOfBeans().init1(), 1, "{\n\ta: {a:1, b:'foo'}\n}", "<object>\n\t<a><a>1</a><b>foo</b></a>\n</object>\n", "<table>\n\t<tr><td>a</td><td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td></tr>\n</table>\n", "(\n\ta=(a=1,b=foo)\n)", "a=(\n\ta=1,\n\tb=foo\n)")}, {new Input("Map1dOfBeans-2", new Map1dOfBeans().init1(), 2, "{\n\ta: {\n\t\ta: 1,\n\t\tb: 'foo'\n\t}\n}", "<object>\n\t<a>\n\t\t<a>1</a>\n\t\t<b>foo</b>\n\t</a>\n</object>\n", "<table>\n\t<tr>\n\t\t<td>a</td>\n\t\t<td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td>\n\t</tr>\n</table>\n", "(\n\ta=(\n\t\ta=1,\n\t\tb=foo\n\t)\n)", "a=(\n\ta=1,\n\tb=foo\n)")}, {new Input("Map2dOfBeans-0", new Map2dOfBeans().init2(), 0, "{b:{a:{a:1, b:'foo'}}}", "<object><b><a><a>1</a><b>foo</b></a></b></object>\n", "<table><tr><td>b</td><td><table><tr><td>a</td><td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td></tr></table>\n", "(b=(a=(a=1,b=foo)))", "b=(a=(a=1,b=foo))")}, {new Input("Map2dOfBeans-1", new Map2dOfBeans().init2(), 1, "{\n\tb: {a:{a:1, b:'foo'}}\n}", "<object>\n\t<b><a><a>1</a><b>foo</b></a></b>\n</object>\n", "<table>\n\t<tr><td>b</td><td><table><tr><td>a</td><td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td></tr>\n</table>\n", "(\n\tb=(a=(a=1,b=foo))\n)", "b=(\n\ta=(a=1,b=foo)\n)")}, {new Input("Map2dOfBeans-2", new Map2dOfBeans().init2(), 2, "{\n\tb: {\n\t\ta: {a:1, b:'foo'}\n\t}\n}", "<object>\n\t<b>\n\t\t<a><a>1</a><b>foo</b></a>\n\t</b>\n</object>\n", "<table>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td><table><tr><td>a</td><td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td></tr></table></td>\n\t</tr>\n</table>\n", "(\n\tb=(\n\t\ta=(a=1,b=foo)\n\t)\n)", "b=(\n\ta=(\n\t\ta=1,\n\t\tb=foo\n\t)\n)")}, {new Input("Map2dOfBeans-3", new Map2dOfBeans().init2(), 3, "{\n\tb: {\n\t\ta: {\n\t\t\ta: 1,\n\t\t\tb: 'foo'\n\t\t}\n\t}\n}", "<object>\n\t<b>\n\t\t<a>\n\t\t\t<a>1</a>\n\t\t\t<b>foo</b>\n\t\t</a>\n\t</b>\n</object>\n", "<table>\n\t<tr>\n\t\t<td>b</td>\n\t\t<td>\n\t\t\t<table><tr><td>a</td><td><table><tr><td>a</td><td>1</td></tr><tr><td>b</td><td>foo</td></tr></table></td></tr></table>\n\t\t</td>\n\t</tr>\n</table>\n", "(\n\tb=(\n\t\ta=(\n\t\t\ta=1,\n\t\t\tb=foo\n\t\t)\n\t)\n)", "b=(\n\ta=(\n\t\ta=1,\n\t\tb=foo\n\t)\n)")});
    }

    public MaxIndentTest(Input input) {
        this.input = input;
    }

    @Test
    public void a1_serializeJson() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT_READABLE.builder().maxIndent(this.input.maxDepth).build();
        this.testSerialize("json", (Serializer)s, this.input.json);
    }

    @Test
    public void b11_serializeXml() throws Exception {
        XmlSerializer s = XmlSerializer.DEFAULT_SQ_READABLE.builder().maxIndent(this.input.maxDepth).build();
        this.testSerialize("xml", (Serializer)s, this.input.xml);
    }

    @Test
    public void c11_serializeHtml() throws Exception {
        HtmlSerializer s = HtmlSerializer.DEFAULT_SQ_READABLE.builder().maxIndent(this.input.maxDepth).build();
        this.testSerialize("html", (Serializer)s, this.input.html);
    }

    @Test
    public void d11_serializeUon() throws Exception {
        UonSerializer s = UonSerializer.DEFAULT_READABLE.builder().maxIndent(this.input.maxDepth).build();
        this.testSerialize("uon", (Serializer)s, this.input.uon);
    }

    @Test
    public void e11_serializeUrlEncoding() throws Exception {
        UrlEncodingSerializer s = UrlEncodingSerializer.DEFAULT_READABLE.builder().maxIndent(this.input.maxDepth).build();
        this.testSerialize("urlEncoding", (Serializer)s, this.input.urlEnc);
    }

    private void testSerialize(String testName, Serializer s, String expected) throws Exception {
        try {
            String r = s.serializeToString(this.input.in);
            if (expected.equals("xxx")) {
                System.out.println(this.input.label + "/" + testName + "=\n" + r.replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
                System.out.println(r);
                return;
            }
            TestUtils.assertEquals(expected, r, "{0}/{1} parse-normal failed", this.input.label, testName);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)(this.input.label + "/" + testName + " failed.  exception=" + e.getLocalizedMessage()));
        }
    }

    public static class Map2dOfBeans
    extends LinkedHashMap<String, Map1dOfBeans> {
        public Map2dOfBeans init2() {
            this.put("b", new Map1dOfBeans().init1());
            return this;
        }
    }

    public static class Map1dOfBeans
    extends LinkedHashMap<String, ABean> {
        public Map1dOfBeans init1() {
            this.put("a", new ABean().init());
            return this;
        }
    }

    public static class List2dOfBeans
    extends LinkedList<List1dOfBeans> {
        public List2dOfBeans init2() {
            this.add(new List1dOfBeans().init1());
            return this;
        }
    }

    public static class List1dOfBeans
    extends LinkedList<ABean> {
        public List1dOfBeans init1() {
            this.add(new ABean().init());
            return this;
        }
    }

    static class Input {
        String label;
        Object in;
        int maxDepth;
        String json;
        String xml;
        String html;
        String uon;
        String urlEnc;

        Input(String label, Object in, int maxDepth, String json, String xml, String html, String uon, String urlEnc) {
            this.label = label;
            this.in = in;
            this.maxDepth = maxDepth;
            this.json = json;
            this.xml = xml;
            this.html = html;
            this.uon = uon;
            this.urlEnc = urlEnc;
        }
    }
}

