/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.File;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class IgnoredClassesTest {
    @Test
    public void testFilesRenderedAsStrings() throws Exception {
        Assume.assumeTrue((boolean)System.getProperty("os.name").toLowerCase().startsWith("win"));
        File f = new File("C:/temp");
        TestUtils.assertObjectEquals("'C:\\\\temp'", f);
    }

    @Test
    public void testIgnorePackages() throws Exception {
        A a = new A();
        JsonSerializerBuilder s = JsonSerializer.create().ssq();
        Assert.assertEquals((Object)"{f1:'isBean'}", (Object)s.build().serialize((Object)a));
        s.notBeanPackages(new String[]{"org.apache.juneau"});
        Assert.assertEquals((Object)"'isNotBean'", (Object)s.build().serialize((Object)a));
        s.notBeanPackagesRemove(new String[]{"org.apache.juneau"});
        Assert.assertEquals((Object)"{f1:'isBean'}", (Object)s.build().serialize((Object)a));
        s.notBeanPackages(new String[]{"org.apache.juneau.*"});
        Assert.assertEquals((Object)"'isNotBean'", (Object)s.build().serialize((Object)a));
        s.notBeanPackagesRemove(new String[]{"org.apache.juneau.*"});
        Assert.assertEquals((Object)"{f1:'isBean'}", (Object)s.build().serialize((Object)a));
        s.notBeanPackages(new String[]{"org.apache.juneau.*"});
        Assert.assertEquals((Object)"'isNotBean'", (Object)s.build().serialize((Object)a));
        s.notBeanPackagesRemove(new String[]{"org.apache.juneau.*"});
        Assert.assertEquals((Object)"{f1:'isBean'}", (Object)s.build().serialize((Object)a));
        s.notBeanPackages(new String[]{"org.apache.juneau"});
        Assert.assertEquals((Object)"'isNotBean'", (Object)s.build().serialize((Object)a));
        s.notBeanPackages(new String[]{"org.apache.juneau.x"});
        Assert.assertEquals((Object)"'isNotBean'", (Object)s.build().serialize((Object)a));
    }

    public static class A {
        public String f1 = "isBean";

        public String toString() {
            return "isNotBean";
        }
    }
}

