/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.ComboInput;
import org.apache.juneau.ComboRoundTripTest;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DynaBeanComboTest
extends ComboRoundTripTest {
    private static Calendar singleDate = new GregorianCalendar(TimeZone.getTimeZone("PST"));

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({new ComboInput<BeanWithDynaField>("BeanWithDynaField", BeanWithDynaField.class, new BeanWithDynaField().init(), "{f1:1,f2a:'a',f2b:'b',f3:3}", "{f1:1,f2a:'a',f2b:'b',f3:3}", "{\n\tf1: 1,\n\tf2a: 'a',\n\tf2b: 'b',\n\tf3: 3\n}", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object>\n\t<f1>1</f1>\n\t<f2a>a</f2a>\n\t<f2b>b</f2b>\n\t<f3>3</f3>\n</object>\n", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f1</td>\n\t\t<td>1</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2a</td>\n\t\t<td>a</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2b</td>\n\t\t<td>b</td>\n\t</tr>\n\t<tr>\n\t\t<td>f3</td>\n\t\t<td>3</td>\n\t</tr>\n</table>\n", "(f1=1,f2a=a,f2b=b,f3=3)", "(f1=1,f2a=a,f2b=b,f3=3)", "(\n\tf1=1,\n\tf2a=a,\n\tf2b=b,\n\tf3=3\n)", "f1=1&f2a=a&f2b=b&f3=3", "f1=1&f2a=a&f2b=b&f3=3", "f1=1\n&f2a=a\n&f2b=b\n&f3=3", "84A2663101A3663261A161A3663262A162A2663303", "84A2663101A3663261A161A3663262A162A2663303", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f1>1</jp:f1>\n    <jp:f2a>a</jp:f2a>\n    <jp:f2b>b</jp:f2b>\n    <jp:f3>3</jp:f3>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithDynaField o) {
                TestUtils.assertInstanceOf(BeanWithDynaField.class, o);
            }
        }}, {new ComboInput<BeanWithDynaMethods>("BeanWithDynaMethods", BeanWithDynaMethods.class, new BeanWithDynaMethods().init(), "{f1:1,f2a:'a',f2b:'b',f3:3}", "{f1:1,f2a:'a',f2b:'b',f3:3}", "{\n\tf1: 1,\n\tf2a: 'a',\n\tf2b: 'b',\n\tf3: 3\n}", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object>\n\t<f1>1</f1>\n\t<f2a>a</f2a>\n\t<f2b>b</f2b>\n\t<f3>3</f3>\n</object>\n", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f1</td>\n\t\t<td>1</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2a</td>\n\t\t<td>a</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2b</td>\n\t\t<td>b</td>\n\t</tr>\n\t<tr>\n\t\t<td>f3</td>\n\t\t<td>3</td>\n\t</tr>\n</table>\n", "(f1=1,f2a=a,f2b=b,f3=3)", "(f1=1,f2a=a,f2b=b,f3=3)", "(\n\tf1=1,\n\tf2a=a,\n\tf2b=b,\n\tf3=3\n)", "f1=1&f2a=a&f2b=b&f3=3", "f1=1&f2a=a&f2b=b&f3=3", "f1=1\n&f2a=a\n&f2b=b\n&f3=3", "84A2663101A3663261A161A3663262A162A2663303", "84A2663101A3663261A161A3663262A162A2663303", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f1>1</jp:f1>\n    <jp:f2a>a</jp:f2a>\n    <jp:f2b>b</jp:f2b>\n    <jp:f3>3</jp:f3>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithDynaMethods o) {
                TestUtils.assertInstanceOf(BeanWithDynaMethods.class, o);
                Assert.assertTrue((boolean)o.setterCalled);
            }
        }}, {new ComboInput<BeanWithDynaGetterOnly>("BeanWithDynaGetterOnly", BeanWithDynaGetterOnly.class, new BeanWithDynaGetterOnly().init(), "{f1:1,f2a:'a',f2b:'b',f3:3}", "{f1:1,f2a:'a',f2b:'b',f3:3}", "{\n\tf1: 1,\n\tf2a: 'a',\n\tf2b: 'b',\n\tf3: 3\n}", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object>\n\t<f1>1</f1>\n\t<f2a>a</f2a>\n\t<f2b>b</f2b>\n\t<f3>3</f3>\n</object>\n", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f1</td>\n\t\t<td>1</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2a</td>\n\t\t<td>a</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2b</td>\n\t\t<td>b</td>\n\t</tr>\n\t<tr>\n\t\t<td>f3</td>\n\t\t<td>3</td>\n\t</tr>\n</table>\n", "(f1=1,f2a=a,f2b=b,f3=3)", "(f1=1,f2a=a,f2b=b,f3=3)", "(\n\tf1=1,\n\tf2a=a,\n\tf2b=b,\n\tf3=3\n)", "f1=1&f2a=a&f2b=b&f3=3", "f1=1&f2a=a&f2b=b&f3=3", "f1=1\n&f2a=a\n&f2b=b\n&f3=3", "84A2663101A3663261A161A3663262A162A2663303", "84A2663101A3663261A161A3663262A162A2663303", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f1>1</jp:f1>\n    <jp:f2a>a</jp:f2a>\n    <jp:f2b>b</jp:f2b>\n    <jp:f3>3</jp:f3>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithDynaGetterOnly o) {
                TestUtils.assertInstanceOf(BeanWithDynaGetterOnly.class, o);
            }
        }}, {new ComboInput<BeanWithDynaFieldSwapped>("BeanWithDynaFieldSwapped", BeanWithDynaFieldSwapped.class, new BeanWithDynaFieldSwapped().init(), "{f1a:'1901-03-03T18:11:12Z'}", "{f1a:'1901-03-03T18:11:12Z'}", "{\n\tf1a: '1901-03-03T18:11:12Z'\n}", "<object><f1a>1901-03-03T18:11:12Z</f1a></object>", "<object><f1a>1901-03-03T18:11:12Z</f1a></object>", "<object>\n\t<f1a>1901-03-03T18:11:12Z</f1a>\n</object>\n", "<object><f1a>1901-03-03T18:11:12Z</f1a></object>", "<table><tr><td>f1a</td><td>1901-03-03T18:11:12Z</td></tr></table>", "<table><tr><td>f1a</td><td>1901-03-03T18:11:12Z</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f1a</td>\n\t\t<td>1901-03-03T18:11:12Z</td>\n\t</tr>\n</table>\n", "(f1a=1901-03-03T18:11:12Z)", "(f1a=1901-03-03T18:11:12Z)", "(\n\tf1a=1901-03-03T18:11:12Z\n)", "f1a=1901-03-03T18:11:12Z", "f1a=1901-03-03T18:11:12Z", "f1a=1901-03-03T18:11:12Z", "81A3663161B4313930312D30332D30335431383A31313A31325A", "81A3663161B4313930312D30332D30335431383A31313A31325A", "<rdf:RDF>\n<rdf:Description>\n<jp:f1a>1901-03-03T18:11:12Z</jp:f1a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f1a>1901-03-03T18:11:12Z</jp:f1a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f1a>1901-03-03T18:11:12Z</jp:f1a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithDynaFieldSwapped o) {
                TestUtils.assertInstanceOf(BeanWithDynaFieldSwapped.class, o);
                TestUtils.assertInstanceOf(Calendar.class, o.f1.get("f1a"));
            }
        }}, {new ComboInput<BeanWithDynaFieldStringList>("BeanWithDynaFieldStringList", BeanWithDynaFieldStringList.class, new BeanWithDynaFieldStringList().init(), "{f1a:['foo','bar']}", "{f1a:['foo','bar']}", "{\n\tf1a: [\n\t\t'foo',\n\t\t'bar'\n\t]\n}", "<object><f1a><string>foo</string><string>bar</string></f1a></object>", "<object><f1a><string>foo</string><string>bar</string></f1a></object>", "<object>\n\t<f1a>\n\t\t<string>foo</string>\n\t\t<string>bar</string>\n\t</f1a>\n</object>\n", "<object><f1a><string>foo</string><string>bar</string></f1a></object>", "<table><tr><td>f1a</td><td><ul><li>foo</li><li>bar</li></ul></td></tr></table>", "<table><tr><td>f1a</td><td><ul><li>foo</li><li>bar</li></ul></td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f1a</td>\n\t\t<td>\n\t\t\t<ul>\n\t\t\t\t<li>foo</li>\n\t\t\t\t<li>bar</li>\n\t\t\t</ul>\n\t\t</td>\n\t</tr>\n</table>\n", "(f1a=@(foo,bar))", "(f1a=@(foo,bar))", "(\n\tf1a=@(\n\t\tfoo,\n\t\tbar\n\t)\n)", "f1a=@(foo,bar)", "f1a=@(foo,bar)", "f1a=@(\n\tfoo,\n\tbar\n)", "81A366316192A3666F6FA3626172", "81A366316192A3666F6FA3626172", "<rdf:RDF>\n<rdf:Description>\n<jp:f1a>\n<rdf:Seq>\n<rdf:li>foo</rdf:li>\n<rdf:li>bar</rdf:li>\n</rdf:Seq>\n</jp:f1a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f1a>\n<rdf:Seq>\n<rdf:li>foo</rdf:li>\n<rdf:li>bar</rdf:li>\n</rdf:Seq>\n</jp:f1a>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f1a>\n      <rdf:Seq>\n        <rdf:li>foo</rdf:li>\n        <rdf:li>bar</rdf:li>\n      </rdf:Seq>\n    </jp:f1a>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithDynaFieldStringList o) {
                TestUtils.assertInstanceOf(BeanWithDynaFieldStringList.class, o);
            }
        }}, {new ComboInput<BeanWithDynaMethodsAndExtraKeys>("BeanWithDynaMethodsAndExtraKeys", BeanWithDynaMethodsAndExtraKeys.class, new BeanWithDynaMethodsAndExtraKeys().init(), "{f1:1,f2a:'a',f2b:'b',f3:3}", "{f1:1,f2a:'a',f2b:'b',f3:3}", "{\n\tf1: 1,\n\tf2a: 'a',\n\tf2b: 'b',\n\tf3: 3\n}", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<object>\n\t<f1>1</f1>\n\t<f2a>a</f2a>\n\t<f2b>b</f2b>\n\t<f3>3</f3>\n</object>\n", "<object><f1>1</f1><f2a>a</f2a><f2b>b</f2b><f3>3</f3></object>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table><tr><td>f1</td><td>1</td></tr><tr><td>f2a</td><td>a</td></tr><tr><td>f2b</td><td>b</td></tr><tr><td>f3</td><td>3</td></tr></table>", "<table>\n\t<tr>\n\t\t<td>f1</td>\n\t\t<td>1</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2a</td>\n\t\t<td>a</td>\n\t</tr>\n\t<tr>\n\t\t<td>f2b</td>\n\t\t<td>b</td>\n\t</tr>\n\t<tr>\n\t\t<td>f3</td>\n\t\t<td>3</td>\n\t</tr>\n</table>\n", "(f1=1,f2a=a,f2b=b,f3=3)", "(f1=1,f2a=a,f2b=b,f3=3)", "(\n\tf1=1,\n\tf2a=a,\n\tf2b=b,\n\tf3=3\n)", "f1=1&f2a=a&f2b=b&f3=3", "f1=1&f2a=a&f2b=b&f3=3", "f1=1\n&f2a=a\n&f2b=b\n&f3=3", "84A2663101A3663261A161A3663262A162A2663303", "84A2663101A3663261A161A3663262A162A2663303", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n<rdf:Description>\n<jp:f1>1</jp:f1>\n<jp:f2a>a</jp:f2a>\n<jp:f2b>b</jp:f2b>\n<jp:f3>3</jp:f3>\n</rdf:Description>\n</rdf:RDF>\n", "<rdf:RDF>\n  <rdf:Description>\n    <jp:f1>1</jp:f1>\n    <jp:f2a>a</jp:f2a>\n    <jp:f2b>b</jp:f2b>\n    <jp:f3>3</jp:f3>\n  </rdf:Description>\n</rdf:RDF>\n"){

            @Override
            public void verify(BeanWithDynaMethodsAndExtraKeys o) {
                TestUtils.assertInstanceOf(BeanWithDynaMethodsAndExtraKeys.class, o);
                Assert.assertTrue((boolean)o.setterCalled);
            }
        }});
    }

    public DynaBeanComboTest(ComboInput<?> comboInput) {
        super(comboInput);
    }

    @Override
    protected Serializer applySettings(Serializer s) throws Exception {
        return s.builder().trimNullProperties(false).build();
    }

    @Override
    protected Parser applySettings(Parser p) throws Exception {
        return p.builder().build();
    }

    static {
        singleDate.setTimeInMillis(0L);
        singleDate.set(1901, 2, 3, 10, 11, 12);
    }

    @Bean(sort=true)
    public static class BeanWithDynaFieldStringList {
        @Beanp(name="*")
        public Map<String, List<String>> f1 = new LinkedHashMap<String, List<String>>();

        public BeanWithDynaFieldStringList init() {
            this.f1.put("f1a", Arrays.asList("foo", "bar"));
            return this;
        }
    }

    @Bean(sort=true)
    public static class BeanWithDynaFieldSwapped {
        @Beanp(name="*")
        @Swap(value=TemporalCalendarSwap.IsoInstant.class)
        public Map<String, Calendar> f1 = new LinkedHashMap<String, Calendar>();

        public BeanWithDynaFieldSwapped init() {
            this.f1.put("f1a", singleDate);
            return this;
        }
    }

    @Bean(sort=true)
    public static class BeanWithDynaGetterOnly {
        private int f1;
        private int f3;
        private Map<String, Object> f2 = new LinkedHashMap<String, Object>();

        public int getF1() {
            return this.f1;
        }

        public void setF1(int f1) {
            this.f1 = f1;
        }

        public int getF3() {
            return this.f3;
        }

        public void setF3(int f3) {
            this.f3 = f3;
        }

        @Beanp(name="*")
        public Map<String, Object> xxx() {
            return this.f2;
        }

        public BeanWithDynaGetterOnly init() {
            this.f1 = 1;
            this.f2 = new ObjectMap().append("f2a", (Object)"a").append("f2b", (Object)"b");
            this.f3 = 3;
            return this;
        }
    }

    @Bean(sort=true)
    public static class BeanWithDynaMethodsAndExtraKeys {
        private int f1;
        private int f3;
        private Map<String, Object> f2 = new LinkedHashMap<String, Object>();
        private boolean setterCalled = false;

        public int getF1() {
            return this.f1;
        }

        public void setF1(int f1) {
            this.f1 = f1;
        }

        public int getF3() {
            return this.f3;
        }

        public void setF3(int f3) {
            this.f3 = f3;
        }

        @Beanp(name="*")
        public Object get(String name) {
            return this.f2.get(name);
        }

        @Beanp(name="*")
        public void set(String name, Object o) {
            this.setterCalled = true;
            this.f2.put(name, o);
        }

        @Beanp(name="*")
        public Collection<String> getExtraKeys() {
            return this.f2.keySet();
        }

        public BeanWithDynaMethodsAndExtraKeys init() {
            this.f1 = 1;
            this.f2 = new ObjectMap().append("f2a", (Object)"a").append("f2b", (Object)"b");
            this.f3 = 3;
            return this;
        }
    }

    @Bean(sort=true)
    public static class BeanWithDynaMethods {
        private int f1;
        private int f3;
        private Map<String, Object> f2 = new LinkedHashMap<String, Object>();
        private boolean setterCalled = false;

        public int getF1() {
            return this.f1;
        }

        public void setF1(int f1) {
            this.f1 = f1;
        }

        public int getF3() {
            return this.f3;
        }

        public void setF3(int f3) {
            this.f3 = f3;
        }

        @Beanp(name="*")
        public Map<String, Object> xxx() {
            return this.f2;
        }

        @Beanp(name="*")
        public void setYYY(String name, Object o) {
            this.setterCalled = true;
            this.f2.put(name, o);
        }

        public BeanWithDynaMethods init() {
            this.f1 = 1;
            this.f2 = new ObjectMap().append("f2a", (Object)"a").append("f2b", (Object)"b");
            this.f3 = 3;
            return this;
        }
    }

    @Bean(sort=true)
    public static class BeanWithDynaField {
        public int f1;
        @Beanp(name="*")
        public Map<String, Object> f2 = new LinkedHashMap<String, Object>();
        public int f3;

        public BeanWithDynaField init() {
            this.f1 = 1;
            this.f2 = new ObjectMap().append("f2a", (Object)"a").append("f2b", (Object)"b");
            this.f3 = 3;
            return this;
        }
    }
}

