/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.testutils.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataConversionTest {
    @Before
    public void beforeTest() {
        TestUtils.setLocale(Locale.US);
    }

    @After
    public void afterTest() {
        TestUtils.unsetLocale();
    }

    @Test
    public void testBasic() throws Exception {
        ObjectMap m = new ObjectMap();
        m.put((Object)"x", (Object)123);
        Assert.assertEquals((long)m.getInt("x").intValue(), (long)123L);
        Assert.assertEquals((long)m.getLong("x"), (long)123L);
        m.put((Object)"x", (Object)true);
        Assert.assertEquals((Object)m.getBoolean("x"), (Object)true);
        m.put((Object)"x", null);
        Assert.assertNull((Object)m.getString("x"));
        Assert.assertNull((Object)m.getInt("x"));
        Assert.assertNull((Object)m.getLong("x"));
        Assert.assertNull((Object)m.getBoolean("x"));
        Assert.assertNull((Object)m.getMap("x"));
        Assert.assertNull((Object)m.getObjectMap("x"));
        Assert.assertNull((Object)m.getList("x"));
        Assert.assertNull((Object)m.getObjectList("x"));
        m.put((Object)"x", new HashMap());
        Assert.assertEquals((Object)m.getString("x"), (Object)"{}");
        m.put((Object)"x", (Object)new ObjectMap((CharSequence)"{foo:123}"));
        Assert.assertEquals((Object)m.getString("x"), (Object)"{foo:123}");
        HashSet<Integer> s = new HashSet<Integer>();
        s.add(123);
        m.put((Object)"x", s);
        Assert.assertEquals((Object)m.getString("x"), (Object)"[123]");
        m.put((Object)"x", (Object)new ObjectList((CharSequence)"[123]"));
        Assert.assertEquals((Object)m.getString("x"), (Object)"[123]");
        Assert.assertEquals((long)m.getList("x").size(), (long)1L);
        Assert.assertEquals((long)m.getObjectList("x").size(), (long)1L);
        m.put((Object)"x", (Object)new Integer[]{123});
        Assert.assertEquals((Object)m.getString("x"), (Object)"[123]");
        Assert.assertEquals((long)m.getList("x").size(), (long)1L);
        Assert.assertEquals((long)m.getObjectList("x").size(), (long)1L);
        m.put((Object)"x", (Object)TestEnum.ENUM2);
        Assert.assertEquals((Object)m.getString("x"), (Object)"ENUM2");
        Assert.assertFalse((boolean)m.getBoolean("x"));
        try {
            m.getMap("x");
            Assert.fail((String)"Invalid conversion from Enum to Map");
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            m.getObjectMap("x");
            Assert.fail((String)"Invalid conversion from Enum to ObjectMap");
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        m.put((Object)"x", (Object)new NotABean("foo"));
        Assert.assertEquals((Object)m.getString("x"), (Object)"foo");
        try {
            m.getInt("x");
            Assert.fail((String)"Invalid conversion from NotABean to Integer");
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            m.getLong("x");
            Assert.fail((String)"Invalid conversion from NotABean to Long");
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)m.getBoolean("x"));
        try {
            m.getMap("x");
            Assert.fail((String)"Invalid conversion from NotABean to Map");
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
        try {
            m.getObjectMap("x");
            Assert.fail((String)"Invalid conversion from NotABean to ObjectMap");
        }
        catch (InvalidDataConversionException invalidDataConversionException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectSwaps() throws Exception {
        String s = "2001-12-21T12:34:56Z";
        BeanSession session = BeanContext.create().build().createSession();
        Calendar c = (Calendar)session.convertToType((Object)s, GregorianCalendar.class);
        Assert.assertEquals((long)2001L, (long)c.get(1));
        c = (Calendar)session.convertToType((Object)s, Calendar.class);
        Assert.assertEquals((long)2001L, (long)c.get(1));
        s = (String)session.convertToType((Object)c, String.class);
        Assert.assertEquals((Object)"2001-12-21T12:34:56Z", (Object)s);
    }

    public class NotABean {
        private String arg;

        public NotABean(String arg) {
            this.arg = arg;
        }

        public String toString() {
            return this.arg;
        }
    }

    public static enum TestEnum {
        ENUM0,
        ENUM1,
        ENUM2;

    }
}

