/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.Context;
import org.apache.juneau.ContextCache;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.Session;
import org.apache.juneau.SessionArgs;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ContextCacheTest {
    @Test
    public void testBasic() {
        PropertyStoreBuilder psb = PropertyStore.create();
        PropertyStore ps = psb.build();
        A a = (A)ContextCache.INSTANCE.create(A.class, ps);
        B b = (B)ContextCache.INSTANCE.create(B.class, ps);
        C c = (C)ContextCache.INSTANCE.create(C.class, ps);
        TestUtils.assertObjectEquals("{f1:'xxx'}", (Object)a);
        TestUtils.assertObjectEquals("{f1:'xxx',f2:-1}", (Object)b);
        TestUtils.assertObjectEquals("{f1:'xxx',f2:-1,f3:false}", (Object)c);
        A a2 = (A)ContextCache.INSTANCE.create(A.class, ps);
        B b2 = (B)ContextCache.INSTANCE.create(B.class, ps);
        C c2 = (C)ContextCache.INSTANCE.create(C.class, ps);
        Assert.assertTrue((a == a2 ? 1 : 0) != 0);
        Assert.assertTrue((b == b2 ? 1 : 0) != 0);
        Assert.assertTrue((c == c2 ? 1 : 0) != 0);
        psb.set("A.f1", (Object)"foo");
        ps = psb.build();
        a2 = (A)ContextCache.INSTANCE.create(A.class, ps);
        b2 = (B)ContextCache.INSTANCE.create(B.class, ps);
        c2 = (C)ContextCache.INSTANCE.create(C.class, ps);
        TestUtils.assertObjectEquals("{f1:'foo'}", (Object)a2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:-1}", (Object)b2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:-1,f3:false}", (Object)c2);
        Assert.assertTrue((a != a2 ? 1 : 0) != 0);
        Assert.assertTrue((b != b2 ? 1 : 0) != 0);
        Assert.assertTrue((c != c2 ? 1 : 0) != 0);
        a = a2;
        b = b2;
        c = c2;
        ps = psb.set("B.f2.i", (Object)123).build();
        a2 = (A)ContextCache.INSTANCE.create(A.class, ps);
        b2 = (B)ContextCache.INSTANCE.create(B.class, ps);
        c2 = (C)ContextCache.INSTANCE.create(C.class, ps);
        TestUtils.assertObjectEquals("{f1:'foo'}", (Object)a2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:123}", (Object)b2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:123,f3:false}", (Object)c2);
        Assert.assertTrue((a == a2 ? 1 : 0) != 0);
        Assert.assertTrue((b != b2 ? 1 : 0) != 0);
        Assert.assertTrue((c != c2 ? 1 : 0) != 0);
        a = a2;
        b = b2;
        c = c2;
        ps = psb.set("C.f3.b", (Object)true).build();
        a2 = (A)ContextCache.INSTANCE.create(A.class, ps);
        b2 = (B)ContextCache.INSTANCE.create(B.class, ps);
        c2 = (C)ContextCache.INSTANCE.create(C.class, ps);
        TestUtils.assertObjectEquals("{f1:'foo'}", (Object)a2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:123}", (Object)b2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:123,f3:true}", (Object)c2);
        Assert.assertTrue((a == a2 ? 1 : 0) != 0);
        Assert.assertTrue((b == b2 ? 1 : 0) != 0);
        Assert.assertTrue((c != c2 ? 1 : 0) != 0);
        a = a2;
        b = b2;
        c = c2;
        ps = psb.set("D.bad.o", (Object)"xxx").build();
        a2 = (A)ContextCache.INSTANCE.create(A.class, ps);
        b2 = (B)ContextCache.INSTANCE.create(B.class, ps);
        c2 = (C)ContextCache.INSTANCE.create(C.class, ps);
        TestUtils.assertObjectEquals("{f1:'foo'}", (Object)a2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:123}", (Object)b2);
        TestUtils.assertObjectEquals("{f1:'foo',f2:123,f3:true}", (Object)c2);
        Assert.assertTrue((a == a2 ? 1 : 0) != 0);
        Assert.assertTrue((b == b2 ? 1 : 0) != 0);
        Assert.assertTrue((c == c2 ? 1 : 0) != 0);
        Assert.assertTrue((a.getPropertyStore() == a2.getPropertyStore() ? 1 : 0) != 0);
        Assert.assertTrue((b.getPropertyStore() == b2.getPropertyStore() ? 1 : 0) != 0);
        Assert.assertTrue((c.getPropertyStore() == c2.getPropertyStore() ? 1 : 0) != 0);
        a2 = (A)ContextCache.INSTANCE.create(A.class, a.getPropertyStore().builder().set("A.f1", (Object)"foo").build());
        Assert.assertTrue((a == a2 ? 1 : 0) != 0);
        a2 = (A)ContextCache.INSTANCE.create(A.class, a.getPropertyStore().builder().set("A.f1", (Object)"bar").build());
        Assert.assertTrue((a != a2 ? 1 : 0) != 0);
    }

    @Test
    public void testBadConstructor() {
        PropertyStoreBuilder psb = PropertyStore.create();
        PropertyStore ps = psb.build();
        try {
            ContextCache.INSTANCE.create(D1.class, ps);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Could not create instance of class 'org.apache.juneau.ContextCacheTest$D1'", (Object)e.getLocalizedMessage());
        }
        try {
            ContextCache.INSTANCE.create(D2.class, ps);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Could not create instance of class 'org.apache.juneau.ContextCacheTest$D2'", (Object)e.getLocalizedMessage());
        }
    }

    public static class D2
    extends A {
        public D2(PropertyStore ps) {
            super(ps);
            throw new RuntimeException("Error!");
        }
    }

    public static class D1
    extends A {
        protected D1(PropertyStore ps) {
            super(ps);
        }
    }

    @ConfigurableContext
    public static class C
    extends B {
        public boolean f3 = this.getBooleanProperty("C.f3.b", false);

        public C(PropertyStore ps) {
            super(ps);
        }

        @Override
        public ObjectMap toMap() {
            return super.toMap().append("f3", (Object)this.f3);
        }
    }

    @ConfigurableContext
    public static class B
    extends A {
        public int f2 = this.getIntegerProperty("B.f2.i", -1);

        public B(PropertyStore ps) {
            super(ps);
        }

        @Override
        public ObjectMap toMap() {
            return super.toMap().append("f2", (Object)this.f2);
        }
    }

    @ConfigurableContext
    public static class A
    extends Context {
        public final String f1 = this.getStringProperty("A.f1", "xxx");

        public A(PropertyStore ps) {
            super(ps, true);
        }

        public Session createSession(SessionArgs args) {
            return null;
        }

        public SessionArgs createDefaultSessionArgs() {
            return null;
        }

        public ObjectMap toMap() {
            return new ObjectMap().append("f1", (Object)this.f1);
        }
    }
}

