/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.ComboInput;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfXmlAbbrevSerializer;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ComboSerializeTest {
    private final ComboInput comboInput;
    private static final String[] runTests = new String[]{"serializeJson", "serializeJsonT", "serializeJsonR", "serializeXml", "serializeXmlT", "serializeXmlR", "serializeXmlNs", "serializeHtml", "serializeHtmlT", "serializeHtmlR", "serializeUon", "serializeUonT", "serializeUonR", "serializeUrlEncoding", "serializeUrlEncodingT", "serializeUrlEncodingR", "serializeMsgPack", "serializeMsgPackT", "serializeRdfXml", "serializeRdfXmlT", "serializeRdfXmlR"};
    private static final Set<String> runTestsSet = new HashSet<String>(Arrays.asList(runTests));
    private final boolean SKIP_RDF_TESTS = Boolean.getBoolean("skipRdfTests");
    private Map<Serializer, Serializer> serializerMap = new IdentityHashMap<Serializer, Serializer>();
    WriterSerializer sJson = SimpleJsonSerializer.DEFAULT;
    WriterSerializer sJsonT = JsonSerializer.create().ssq().beanTypePropertyName("t").build();
    WriterSerializer sJsonR = SimpleJsonSerializer.DEFAULT_READABLE;
    WriterSerializer sXml = XmlSerializer.DEFAULT_SQ;
    WriterSerializer sXmlT = XmlSerializer.create().sq().beanTypePropertyName("t").build();
    WriterSerializer sXmlR = XmlSerializer.DEFAULT_SQ_READABLE;
    WriterSerializer sXmlNs = XmlSerializer.DEFAULT_NS_SQ;
    WriterSerializer sHtml = HtmlSerializer.DEFAULT_SQ;
    WriterSerializer sHtmlT = HtmlSerializer.create().sq().beanTypePropertyName("t").build();
    WriterSerializer sHtmlR = HtmlSerializer.DEFAULT_SQ_READABLE;
    WriterSerializer sUon = UonSerializer.DEFAULT;
    WriterSerializer sUonT = UonSerializer.create().beanTypePropertyName("t").build();
    WriterSerializer sUonR = UonSerializer.DEFAULT_READABLE;
    WriterSerializer sUrlEncoding = UrlEncodingSerializer.DEFAULT;
    WriterSerializer sUrlEncodingT = UrlEncodingSerializer.create().beanTypePropertyName("t").build();
    WriterSerializer sUrlEncodingR = UrlEncodingSerializer.DEFAULT_READABLE;
    OutputStreamSerializer sMsgPack = MsgPackSerializer.DEFAULT;
    OutputStreamSerializer sMsgPackT = MsgPackSerializer.create().beanTypePropertyName("t").build();
    WriterSerializer sRdfXml = RdfXmlAbbrevSerializer.DEFAULT;
    WriterSerializer sRdfXmlT = RdfXmlAbbrevSerializer.create().beanTypePropertyName("t").build();
    WriterSerializer sRdfXmlR = RdfXmlAbbrevSerializer.create().ws().build();

    public ComboSerializeTest(ComboInput<?> comboInput) {
        this.comboInput = comboInput;
    }

    private Serializer getSerializer(Serializer s) throws Exception {
        Serializer s2 = this.serializerMap.get(s);
        if (s2 == null) {
            s2 = this.applySettings(s);
            this.serializerMap.put(s, s2);
        }
        return s2;
    }

    private void testSerialize(String testName, Serializer s, String expected) throws Exception {
        try {
            s = this.getSerializer(s);
            boolean isRdf = s instanceof RdfSerializer;
            if (isRdf && this.SKIP_RDF_TESTS || expected.equals("SKIP") || !runTestsSet.contains(testName)) {
                System.err.println(this.comboInput.label + "/" + testName + " for " + s.getClass().getSimpleName() + " skipped.");
                return;
            }
            String r = s.serializeToString(this.comboInput.getInput());
            if (isRdf) {
                r = r.replaceAll("<rdf:RDF[^>]*>", "<rdf:RDF>").replace('\"', '\'');
            }
            if (expected.equals("xxx")) {
                System.out.println(this.comboInput.label + "/" + testName + "=\n" + r.replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
                System.out.println(r);
                if (s instanceof MsgPackSerializer) {
                    System.out.println("decoded=[" + new String(StringUtils.fromHex((String)r)) + "]");
                }
            }
            if (isRdf) {
                TestUtils.assertEqualsAfterSort(expected, r, "{0}/{1} serialize-normal failed", this.comboInput.label, testName);
            } else {
                TestUtils.assertEquals(expected, r, "{0}/{1} serialize-normal failed", this.comboInput.label, testName);
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)(this.comboInput.label + "/" + testName + " failed.  exception=" + e.getLocalizedMessage()));
        }
    }

    protected Serializer applySettings(Serializer s) throws Exception {
        return s;
    }

    @Test
    public void a11_serializeJson() throws Exception {
        this.testSerialize("serializeJson", (Serializer)this.sJson, this.comboInput.json);
    }

    @Test
    public void a21_serializeJsonT() throws Exception {
        this.testSerialize("serializeJsonT", (Serializer)this.sJsonT, this.comboInput.jsonT);
    }

    @Test
    public void a31_serializeJsonR() throws Exception {
        this.testSerialize("serializeJsonR", (Serializer)this.sJsonR, this.comboInput.jsonR);
    }

    @Test
    public void b11_serializeXml() throws Exception {
        this.testSerialize("serializeXml", (Serializer)this.sXml, this.comboInput.xml);
    }

    @Test
    public void b21_serializeXmlT() throws Exception {
        this.testSerialize("serializeXmlT", (Serializer)this.sXmlT, this.comboInput.xmlT);
    }

    @Test
    public void b31_serializeXmlR() throws Exception {
        this.testSerialize("serializeXmlR", (Serializer)this.sXmlR, this.comboInput.xmlR);
    }

    @Test
    public void b41_serializeXmlNs() throws Exception {
        this.testSerialize("serializeXmlNs", (Serializer)this.sXmlNs, this.comboInput.xmlNs);
    }

    @Test
    public void c11_serializeHtml() throws Exception {
        this.testSerialize("serializeHtml", (Serializer)this.sHtml, this.comboInput.html);
    }

    @Test
    public void c21_serializeHtmlT() throws Exception {
        this.testSerialize("serializeHtmlT", (Serializer)this.sHtmlT, this.comboInput.htmlT);
    }

    @Test
    public void c31_serializeHtmlR() throws Exception {
        this.testSerialize("serializeHtmlR", (Serializer)this.sHtmlR, this.comboInput.htmlR);
    }

    @Test
    public void d11_serializeUon() throws Exception {
        this.testSerialize("serializeUon", (Serializer)this.sUon, this.comboInput.uon);
    }

    @Test
    public void d21_serializeUonT() throws Exception {
        this.testSerialize("serializeUonT", (Serializer)this.sUonT, this.comboInput.uonT);
    }

    @Test
    public void d31_serializeUonR() throws Exception {
        this.testSerialize("serializeUonR", (Serializer)this.sUonR, this.comboInput.uonR);
    }

    @Test
    public void e11_serializeUrlEncoding() throws Exception {
        this.testSerialize("serializeUrlEncoding", (Serializer)this.sUrlEncoding, this.comboInput.urlEncoding);
    }

    @Test
    public void e21_serializeUrlEncodingT() throws Exception {
        this.testSerialize("serializeUrlEncodingT", (Serializer)this.sUrlEncodingT, this.comboInput.urlEncodingT);
    }

    @Test
    public void e31_serializeUrlEncodingR() throws Exception {
        this.testSerialize("serializeUrlEncodingR", (Serializer)this.sUrlEncodingR, this.comboInput.urlEncodingR);
    }

    @Test
    public void f11_serializeMsgPack() throws Exception {
        this.testSerialize("serializeMsgPack", (Serializer)this.sMsgPack, this.comboInput.msgPack);
    }

    @Test
    public void f21_serializeMsgPackT() throws Exception {
        this.testSerialize("serializeMsgPackT", (Serializer)this.sMsgPackT, this.comboInput.msgPackT);
    }

    @Test
    public void g11_serializeRdfXml() throws Exception {
        this.testSerialize("serializeRdfXml", (Serializer)this.sRdfXml, this.comboInput.rdfXml);
    }

    @Test
    public void g21_serializeRdfXmlT() throws Exception {
        this.testSerialize("serializeRdfXmlT", (Serializer)this.sRdfXmlT, this.comboInput.rdfXmlT);
    }

    @Test
    public void g31_serializeRdfXmlR() throws Exception {
        this.testSerialize("serializeRdfXmlR", (Serializer)this.sRdfXmlR, this.comboInput.rdfXmlR);
    }
}

