/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.ComboInput;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.jena.RdfXmlAbbrevSerializer;
import org.apache.juneau.jena.RdfXmlParser;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ComboRoundTripTest {
    private final ComboInput comboInput;
    private static final String[] runTests = new String[]{"serializeJson", "parseJson", "serializeJsonT", "parseJsonT", "serializeJsonR", "parseJsonR", "serializeXml", "parseXml", "serializeXmlT", "parseXmlT", "serializeXmlR", "parseXmlR", "serializeXmlNs", "parseXmlNs", "serializeHtml", "parseHtml", "serializeHtmlT", "parseHtmlT", "serializeHtmlR", "parseHtmlR", "serializeUon", "parseUon", "serializeUonT", "parseUonT", "serializeUonR", "parseUonR", "serializeUrlEncoding", "parseUrlEncoding", "serializeUrlEncodingT", "parseUrlEncodingT", "serializeUrlEncodingR", "parseUrlEncodingR", "serializeMsgPack", "parseMsgPack", "parseMsgPackJsonEquivalency", "serializeMsgPackT", "parseMsgPackT", "parseMsgPackTJsonEquivalency", "serializeRdfXml", "parseRdfXml", "serializeRdfXmlT", "parseRdfXmlT", "serializeRdfXmlR", "parseRdfXmlR"};
    private static final Set<String> runTestsSet = new HashSet<String>(Arrays.asList(runTests));
    private final boolean SKIP_RDF_TESTS = Boolean.getBoolean("skipRdfTests");
    private Map<Serializer, Serializer> serializerMap = new IdentityHashMap<Serializer, Serializer>();
    private Map<Parser, Parser> parserMap = new IdentityHashMap<Parser, Parser>();
    WriterSerializer sJson = SimpleJsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
    ReaderParser pJson = JsonParser.DEFAULT;
    WriterSerializer sJsonT = JsonSerializer.create().ssq().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    ReaderParser pJsonT = JsonParser.create().beanTypePropertyName("t").build();
    WriterSerializer sJsonR = SimpleJsonSerializer.DEFAULT_READABLE.builder().addBeanTypes().addRootType().build();
    ReaderParser pJsonR = JsonParser.DEFAULT;
    WriterSerializer sXml = XmlSerializer.DEFAULT_SQ.builder().addBeanTypes().addRootType().build();
    ReaderParser pXml = XmlParser.DEFAULT;
    WriterSerializer sXmlT = XmlSerializer.create().sq().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    ReaderParser pXmlT = XmlParser.create().beanTypePropertyName("t").build();
    WriterSerializer sXmlR = XmlSerializer.DEFAULT_SQ_READABLE.builder().addBeanTypes().addRootType().build();
    ReaderParser pXmlR = XmlParser.DEFAULT;
    WriterSerializer sXmlNs = XmlSerializer.DEFAULT_NS_SQ.builder().addBeanTypes().addRootType().build();
    ReaderParser pXmlNs = XmlParser.DEFAULT;
    WriterSerializer sHtml = HtmlSerializer.DEFAULT_SQ.builder().addBeanTypes().addRootType().build();
    ReaderParser pHtml = HtmlParser.DEFAULT;
    WriterSerializer sHtmlT = HtmlSerializer.create().sq().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    ReaderParser pHtmlT = HtmlParser.create().beanTypePropertyName("t").build();
    WriterSerializer sHtmlR = HtmlSerializer.DEFAULT_SQ_READABLE.builder().addBeanTypes().addRootType().build();
    ReaderParser pHtmlR = HtmlParser.DEFAULT;
    WriterSerializer sUon = UonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
    ReaderParser pUon = UonParser.DEFAULT;
    WriterSerializer sUonT = UonSerializer.create().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    ReaderParser pUonT = UonParser.create().beanTypePropertyName("t").build();
    WriterSerializer sUonR = UonSerializer.DEFAULT_READABLE.builder().addBeanTypes().addRootType().build();
    ReaderParser pUonR = UonParser.DEFAULT;
    WriterSerializer sUrlEncoding = UrlEncodingSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
    ReaderParser pUrlEncoding = UrlEncodingParser.DEFAULT;
    WriterSerializer sUrlEncodingT = UrlEncodingSerializer.create().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    ReaderParser pUrlEncodingT = UrlEncodingParser.create().beanTypePropertyName("t").build();
    WriterSerializer sUrlEncodingR = UrlEncodingSerializer.DEFAULT_READABLE.builder().addBeanTypes().addRootType().build();
    ReaderParser pUrlEncodingR = UrlEncodingParser.DEFAULT;
    OutputStreamSerializer sMsgPack = MsgPackSerializer.create().addBeanTypes().addRootType().build();
    InputStreamParser pMsgPack = MsgPackParser.DEFAULT;
    OutputStreamSerializer sMsgPackT = MsgPackSerializer.create().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    InputStreamParser pMsgPackT = MsgPackParser.create().beanTypePropertyName("t").build();
    WriterSerializer sRdfXml = RdfXmlAbbrevSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
    ReaderParser pRdfXml = RdfXmlParser.DEFAULT;
    WriterSerializer sRdfXmlT = RdfXmlAbbrevSerializer.create().beanTypePropertyName("t").addBeanTypes().addRootType().build();
    ReaderParser pRdfXmlT = RdfXmlParser.create().beanTypePropertyName("t").build();
    WriterSerializer sRdfXmlR = RdfXmlAbbrevSerializer.create().ws().addBeanTypes().addRootType().build();
    ReaderParser pRdfXmlR = RdfXmlParser.DEFAULT;

    public ComboRoundTripTest(ComboInput<?> comboInput) {
        this.comboInput = comboInput;
    }

    private Serializer getSerializer(Serializer s) throws Exception {
        Serializer s2 = this.serializerMap.get(s);
        if (s2 == null) {
            s2 = this.applySettings(s);
            this.serializerMap.put(s, s2);
        }
        return s2;
    }

    private Parser getParser(Parser p) throws Exception {
        Parser p2 = this.parserMap.get(p);
        if (p2 == null) {
            p2 = this.applySettings(p);
            this.parserMap.put(p, p2);
        }
        return p2;
    }

    private void testSerialize(String testName, Serializer s, String expected) throws Exception {
        try {
            s = this.getSerializer(s);
            boolean isRdf = s instanceof RdfSerializer;
            if (isRdf && this.SKIP_RDF_TESTS || expected.isEmpty() || !runTestsSet.contains(testName)) {
                System.err.println(this.comboInput.label + "/" + testName + " for " + s.getClass().getSimpleName() + " skipped.");
                return;
            }
            String r = s.serializeToString(this.comboInput.getInput());
            if (isRdf) {
                r = r.replaceAll("<rdf:RDF[^>]*>", "<rdf:RDF>").replace('\"', '\'');
            }
            if (expected.equals("xxx")) {
                System.out.println(this.comboInput.label + "/" + testName + "=\n" + r.replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
                System.out.println(r);
            }
            if (isRdf) {
                TestUtils.assertEqualsAfterSort(expected, r, "{0}/{1} parse-normal failed", this.comboInput.label, testName);
            } else {
                TestUtils.assertEquals(expected, r, "{0}/{1} parse-normal failed", this.comboInput.label, testName);
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)(this.comboInput.label + "/" + testName + " failed.  exception=" + e.getLocalizedMessage()));
        }
    }

    private void testParse(String testName, Serializer s, Parser p, String expected) throws Exception {
        try {
            s = this.getSerializer(s);
            p = this.getParser(p);
            boolean isRdf = s instanceof RdfSerializer;
            if (isRdf && this.SKIP_RDF_TESTS || expected.isEmpty() || !runTestsSet.contains(testName)) {
                System.err.println(this.comboInput.label + "/" + testName + " for " + s.getClass().getSimpleName() + " skipped.");
                return;
            }
            String r = s.serializeToString(this.comboInput.getInput());
            Object o = p.parse(r, this.comboInput.type, new Type[0]);
            r = s.serializeToString(o);
            if (isRdf) {
                r = r.replaceAll("<rdf:RDF[^>]*>", "<rdf:RDF>").replace('\"', '\'');
            }
            if (isRdf) {
                TestUtils.assertEqualsAfterSort(expected, r, "{0}/{1} parse-normal failed", this.comboInput.label, testName);
            } else {
                TestUtils.assertEquals(expected, r, "{0}/{1} parse-normal failed", this.comboInput.label, testName);
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(this.comboInput.label + "/" + testName + " failed.", e);
        }
    }

    private void testParseVerify(String testName, Serializer s, Parser p) throws Exception {
        try {
            s = this.getSerializer(s);
            p = this.getParser(p);
            String r = s.serializeToString(this.comboInput.getInput());
            Object o = p.parse(r, this.comboInput.type, new Type[0]);
            this.comboInput.verify(o);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(this.comboInput.label + "/" + testName + " failed.", e);
        }
    }

    private void testParseJsonEquivalency(String testName, OutputStreamSerializer s, InputStreamParser p, String expected) throws Exception {
        try {
            s = (OutputStreamSerializer)this.getSerializer((Serializer)s);
            p = (InputStreamParser)this.getParser((Parser)p);
            WriterSerializer sJson = (WriterSerializer)this.getSerializer((Serializer)this.sJson);
            String r = s.serializeToString(this.comboInput.getInput());
            Object o = p.parse(r, this.comboInput.type, new Type[0]);
            r = sJson.serialize(o);
            Assert.assertEquals((String)(this.comboInput.label + "/" + testName + " parse-normal failed on JSON equivalency"), (Object)expected, (Object)r);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(this.comboInput.label + "/" + testName + " failed.", e);
        }
    }

    protected Serializer applySettings(Serializer s) throws Exception {
        return s;
    }

    protected Parser applySettings(Parser p) throws Exception {
        return p;
    }

    @Test
    public void a11_serializeJson() throws Exception {
        this.testSerialize("serializeJson", (Serializer)this.sJson, this.comboInput.json);
    }

    @Test
    public void a12_parseJson() throws Exception {
        this.testParse("parseJson", (Serializer)this.sJson, (Parser)this.pJson, this.comboInput.json);
    }

    @Test
    public void a13_verifyJson() throws Exception {
        this.testParseVerify("verifyJson", (Serializer)this.sJson, (Parser)this.pJson);
    }

    @Test
    public void a21_serializeJsonT() throws Exception {
        this.testSerialize("serializeJsonT", (Serializer)this.sJsonT, this.comboInput.jsonT);
    }

    @Test
    public void a22_parseJsonT() throws Exception {
        this.testParse("parseJsonT", (Serializer)this.sJsonT, (Parser)this.pJsonT, this.comboInput.jsonT);
    }

    @Test
    public void a23_verifyJsonT() throws Exception {
        this.testParseVerify("verifyJsonT", (Serializer)this.sJsonT, (Parser)this.pJsonT);
    }

    @Test
    public void a31_serializeJsonR() throws Exception {
        this.testSerialize("serializeJsonR", (Serializer)this.sJsonR, this.comboInput.jsonR);
    }

    @Test
    public void a32_parseJsonR() throws Exception {
        this.testParse("parseJsonR", (Serializer)this.sJsonR, (Parser)this.pJsonR, this.comboInput.jsonR);
    }

    @Test
    public void a33_verifyJsonR() throws Exception {
        this.testParseVerify("verifyJsonR", (Serializer)this.sJsonR, (Parser)this.pJsonR);
    }

    @Test
    public void b11_serializeXml() throws Exception {
        this.testSerialize("serializeXml", (Serializer)this.sXml, this.comboInput.xml);
    }

    @Test
    public void b12_parseXml() throws Exception {
        this.testParse("parseXml", (Serializer)this.sXml, (Parser)this.pXml, this.comboInput.xml);
    }

    @Test
    public void b13_verifyXml() throws Exception {
        this.testParseVerify("verifyXml", (Serializer)this.sXml, (Parser)this.pXml);
    }

    @Test
    public void b21_serializeXmlT() throws Exception {
        this.testSerialize("serializeXmlT", (Serializer)this.sXmlT, this.comboInput.xmlT);
    }

    @Test
    public void b22_parseXmlT() throws Exception {
        this.testParse("parseXmlT", (Serializer)this.sXmlT, (Parser)this.pXmlT, this.comboInput.xmlT);
    }

    @Test
    public void b23_verifyXmlT() throws Exception {
        this.testParseVerify("parseXmlTVerify", (Serializer)this.sXmlT, (Parser)this.pXmlT);
    }

    @Test
    public void b31_serializeXmlR() throws Exception {
        this.testSerialize("serializeXmlR", (Serializer)this.sXmlR, this.comboInput.xmlR);
    }

    @Test
    public void b32_parseXmlR() throws Exception {
        this.testParse("parseXmlR", (Serializer)this.sXmlR, (Parser)this.pXmlR, this.comboInput.xmlR);
    }

    @Test
    public void b33_verifyXmlR() throws Exception {
        this.testParseVerify("parseXmlRVerify", (Serializer)this.sXmlR, (Parser)this.pXmlR);
    }

    @Test
    public void b41_serializeXmlNs() throws Exception {
        this.testSerialize("serializeXmlNs", (Serializer)this.sXmlNs, this.comboInput.xmlNs);
    }

    @Test
    public void b42_parseXmlNs() throws Exception {
        this.testParse("parseXmlNs", (Serializer)this.sXmlNs, (Parser)this.pXmlNs, this.comboInput.xmlNs);
    }

    @Test
    public void b43_verifyXmlNs() throws Exception {
        this.testParseVerify("verifyXmlNs", (Serializer)this.sXmlNs, (Parser)this.pXmlNs);
    }

    @Test
    public void c11_serializeHtml() throws Exception {
        this.testSerialize("serializeHtml", (Serializer)this.sHtml, this.comboInput.html);
    }

    @Test
    public void c12_parseHtml() throws Exception {
        this.testParse("parseHtml", (Serializer)this.sHtml, (Parser)this.pHtml, this.comboInput.html);
    }

    @Test
    public void c13_verifyHtml() throws Exception {
        this.testParseVerify("verifyHtml", (Serializer)this.sHtml, (Parser)this.pHtml);
    }

    @Test
    public void c21_serializeHtmlT() throws Exception {
        this.testSerialize("serializeHtmlT", (Serializer)this.sHtmlT, this.comboInput.htmlT);
    }

    @Test
    public void c22_parseHtmlT() throws Exception {
        this.testParse("parseHtmlT", (Serializer)this.sHtmlT, (Parser)this.pHtmlT, this.comboInput.htmlT);
    }

    @Test
    public void c23_verifyHtmlT() throws Exception {
        this.testParseVerify("verifyHtmlT", (Serializer)this.sHtmlT, (Parser)this.pHtmlT);
    }

    @Test
    public void c31_serializeHtmlR() throws Exception {
        this.testSerialize("serializeHtmlR", (Serializer)this.sHtmlR, this.comboInput.htmlR);
    }

    @Test
    public void c32_parseHtmlR() throws Exception {
        this.testParse("parseHtmlR", (Serializer)this.sHtmlR, (Parser)this.pHtmlR, this.comboInput.htmlR);
    }

    @Test
    public void c33_verifyHtmlR() throws Exception {
        this.testParseVerify("verifyHtmlR", (Serializer)this.sHtmlR, (Parser)this.pHtmlR);
    }

    @Test
    public void d11_serializeUon() throws Exception {
        this.testSerialize("serializeUon", (Serializer)this.sUon, this.comboInput.uon);
    }

    @Test
    public void d12_parseUon() throws Exception {
        this.testParse("parseUon", (Serializer)this.sUon, (Parser)this.pUon, this.comboInput.uon);
    }

    @Test
    public void d13_verifyUon() throws Exception {
        this.testParseVerify("verifyUon", (Serializer)this.sUon, (Parser)this.pUon);
    }

    @Test
    public void d21_serializeUonT() throws Exception {
        this.testSerialize("serializeUonT", (Serializer)this.sUonT, this.comboInput.uonT);
    }

    @Test
    public void d22_parseUonT() throws Exception {
        this.testParse("parseUonT", (Serializer)this.sUonT, (Parser)this.pUonT, this.comboInput.uonT);
    }

    @Test
    public void d23_verifyUonT() throws Exception {
        this.testParseVerify("verifyUonT", (Serializer)this.sUonT, (Parser)this.pUonT);
    }

    @Test
    public void d31_serializeUonR() throws Exception {
        this.testSerialize("serializeUonR", (Serializer)this.sUonR, this.comboInput.uonR);
    }

    @Test
    public void d32_parseUonR() throws Exception {
        this.testParse("parseUonR", (Serializer)this.sUonR, (Parser)this.pUonR, this.comboInput.uonR);
    }

    @Test
    public void d33_verifyUonR() throws Exception {
        this.testParseVerify("verifyUonR", (Serializer)this.sUonR, (Parser)this.pUonR);
    }

    @Test
    public void e11_serializeUrlEncoding() throws Exception {
        this.testSerialize("serializeUrlEncoding", (Serializer)this.sUrlEncoding, this.comboInput.urlEncoding);
    }

    @Test
    public void e12_parseUrlEncoding() throws Exception {
        this.testParse("parseUrlEncoding", (Serializer)this.sUrlEncoding, (Parser)this.pUrlEncoding, this.comboInput.urlEncoding);
    }

    @Test
    public void e13_verifyUrlEncoding() throws Exception {
        this.testParseVerify("verifyUrlEncoding", (Serializer)this.sUrlEncoding, (Parser)this.pUrlEncoding);
    }

    @Test
    public void e21_serializeUrlEncodingT() throws Exception {
        this.testSerialize("serializeUrlEncodingT", (Serializer)this.sUrlEncodingT, this.comboInput.urlEncodingT);
    }

    @Test
    public void e22_parseUrlEncodingT() throws Exception {
        this.testParse("parseUrlEncodingT", (Serializer)this.sUrlEncodingT, (Parser)this.pUrlEncodingT, this.comboInput.urlEncodingT);
    }

    @Test
    public void e23_verifyUrlEncodingT() throws Exception {
        this.testParseVerify("verifyUrlEncodingT", (Serializer)this.sUrlEncodingT, (Parser)this.pUrlEncodingT);
    }

    @Test
    public void e31_serializeUrlEncodingR() throws Exception {
        this.testSerialize("serializeUrlEncodingR", (Serializer)this.sUrlEncodingR, this.comboInput.urlEncodingR);
    }

    @Test
    public void e32_parseUrlEncodingR() throws Exception {
        this.testParse("parseUrlEncodingR", (Serializer)this.sUrlEncodingR, (Parser)this.pUrlEncodingR, this.comboInput.urlEncodingR);
    }

    @Test
    public void e33_verifyUrlEncodingR() throws Exception {
        this.testParseVerify("verifyUrlEncodingR", (Serializer)this.sUrlEncodingR, (Parser)this.pUrlEncodingR);
    }

    @Test
    public void f11_serializeMsgPack() throws Exception {
        this.testSerialize("serializeMsgPack", (Serializer)this.sMsgPack, this.comboInput.msgPack);
    }

    @Test
    public void f12_parseMsgPack() throws Exception {
        this.testParse("parseMsgPack", (Serializer)this.sMsgPack, (Parser)this.pMsgPack, this.comboInput.msgPack);
    }

    @Test
    public void f13_parseMsgPackJsonEquivalency() throws Exception {
        this.testParseJsonEquivalency("parseMsgPackJsonEquivalency", this.sMsgPack, this.pMsgPack, this.comboInput.json);
    }

    @Test
    public void f14_verifyMsgPack() throws Exception {
        this.testParseVerify("verifyMsgPack", (Serializer)this.sMsgPack, (Parser)this.pMsgPack);
    }

    @Test
    public void f21_serializeMsgPackT() throws Exception {
        this.testSerialize("serializeMsgPackT", (Serializer)this.sMsgPackT, this.comboInput.msgPackT);
    }

    @Test
    public void f22_parseMsgPackT() throws Exception {
        this.testParse("parseMsgPackT", (Serializer)this.sMsgPackT, (Parser)this.pMsgPackT, this.comboInput.msgPackT);
    }

    @Test
    public void f23_parseMsgPackTJsonEquivalency() throws Exception {
        this.testParseJsonEquivalency("parseMsgPackTJsonEquivalency", this.sMsgPackT, this.pMsgPackT, this.comboInput.json);
    }

    @Test
    public void f24_verifyMsgPackT() throws Exception {
        this.testParseVerify("verifyMsgPackT", (Serializer)this.sMsgPackT, (Parser)this.pMsgPackT);
    }

    @Test
    public void g11_serializeRdfXml() throws Exception {
        this.testSerialize("serializeRdfXml", (Serializer)this.sRdfXml, this.comboInput.rdfXml);
    }

    @Test
    public void g12_parseRdfXml() throws Exception {
        this.testParse("parseRdfXml", (Serializer)this.sRdfXml, (Parser)this.pRdfXml, this.comboInput.rdfXml);
    }

    @Test
    public void g13_verifyRdfXml() throws Exception {
        this.testParseVerify("verifyRdfXml", (Serializer)this.sRdfXml, (Parser)this.pRdfXml);
    }

    @Test
    public void g21_serializeRdfXmlT() throws Exception {
        this.testSerialize("serializeRdfXmlT", (Serializer)this.sRdfXmlT, this.comboInput.rdfXmlT);
    }

    @Test
    public void g22_parseRdfXmlT() throws Exception {
        this.testParse("parseRdfXmlT", (Serializer)this.sRdfXmlT, (Parser)this.pRdfXmlT, this.comboInput.rdfXmlT);
    }

    @Test
    public void g23_verifyRdfXmlT() throws Exception {
        this.testParseVerify("parseRdfXmlTVerify", (Serializer)this.sRdfXmlT, (Parser)this.pRdfXmlT);
    }

    @Test
    public void g31_serializeRdfXmlR() throws Exception {
        this.testSerialize("serializeRdfXmlR", (Serializer)this.sRdfXmlR, this.comboInput.rdfXmlR);
    }

    @Test
    public void g32_parseRdfXmlR() throws Exception {
        this.testParse("parseRdfXmlR", (Serializer)this.sRdfXmlR, (Parser)this.pRdfXmlR, this.comboInput.rdfXmlR);
    }

    @Test
    public void g33_verifyRdfXmlR() throws Exception {
        this.testParseVerify("Verify", (Serializer)this.sRdfXmlR, (Parser)this.pRdfXmlR);
    }
}

