/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.transform.PojoSwap;
import org.junit.Assert;
import org.junit.Test;

public class ClassMetaTest {
    BeanContext bc = BeanContext.DEFAULT;
    public Map<String, String> fa;
    public String fb;
    public Map<String, Map<String, Integer>> fc;
    public List<Map<String, List>> fd;
    public List<? extends String> fe1;
    public List<? super String> fe2;
    public G g;

    @Test
    public void testMap() throws Exception {
        ClassMeta t = this.bc.getClassMeta(this.getClass().getField("fa").getGenericType(), new Type[0]);
        Assert.assertEquals((Object)"java.util.Map<java.lang.String,java.lang.String>", (Object)t.toString());
        Assert.assertTrue((boolean)t.isMap());
        Assert.assertFalse((boolean)t.isCollection());
        Assert.assertNull((Object)t.newInstance());
        Assert.assertEquals(Map.class, (Object)t.getInnerClass());
        Assert.assertEquals(String.class, (Object)t.getKeyType().getInnerClass());
        Assert.assertEquals(String.class, (Object)t.getValueType().getInnerClass());
    }

    @Test
    public void testString() throws Exception {
        ClassMeta t = this.bc.getClassMeta(this.getClass().getField("fb").getGenericType(), new Type[0]);
        Assert.assertEquals(String.class, (Object)t.getInnerClass());
        t = this.bc.getClassMeta(this.getClass().getField("fb").getType());
        Assert.assertEquals(String.class, (Object)t.getInnerClass());
    }

    @Test
    public void testMapWithMapValues() throws Exception {
        ClassMeta t = this.bc.getClassMeta(this.getClass().getField("fc").getGenericType(), new Type[0]);
        Assert.assertEquals((Object)"java.util.Map<java.lang.String,java.util.Map<java.lang.String,java.lang.Integer>>", (Object)t.toString());
        t = this.bc.getClassMeta(this.getClass().getField("fc").getType());
        Assert.assertEquals((Object)"java.util.Map", (Object)t.toString());
    }

    @Test
    public void testListWithMapValues() throws Exception {
        ClassMeta t = this.bc.getClassMeta(this.getClass().getField("fd").getGenericType(), new Type[0]);
        Assert.assertEquals((Object)"java.util.List<java.util.Map<java.lang.String,java.util.List>>", (Object)t.toString());
    }

    @Test
    public void testListWithUpperBoundGenericEntryTypes() throws Exception {
        ClassMeta t = this.bc.getClassMeta(this.getClass().getField("fe1").getGenericType(), new Type[0]);
        Assert.assertEquals((Object)"java.util.List", (Object)t.toString());
        t = this.bc.getClassMeta(this.getClass().getField("fe2").getGenericType(), new Type[0]);
        Assert.assertEquals((Object)"java.util.List", (Object)t.toString());
    }

    @Test
    public void testBeanExtendsMap() throws Exception {
        ClassMeta t = this.bc.getClassMeta(this.getClass().getField("g").getGenericType(), new Type[0]);
        Assert.assertEquals((Object)"org.apache.juneau.ClassMetaTest$G<java.lang.String,java.lang.Object>", (Object)t.toString());
        Assert.assertTrue((boolean)t.isMap());
        Assert.assertFalse((boolean)t.isCollection());
    }

    @Test
    public void testSwaps() throws Exception {
        BeanContext bc = BeanContext.DEFAULT;
        BeanSession bs = bc.createSession();
        ClassMeta ooo = bc.getClassMeta(Object.class);
        ClassMeta hi1 = bc.getClassMeta(HI1.class);
        ClassMeta hc1 = bc.getClassMeta(HC1.class);
        ClassMeta hi2 = bc.getClassMeta(HI2.class);
        ClassMeta hc2 = bc.getClassMeta(HC2.class);
        Assert.assertFalse((boolean)ooo.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hi1.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc1.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hi2.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertNull((Object)hi1.getPojoSwap(bs));
        Assert.assertNull((Object)hc1.getPojoSwap(bs));
        Assert.assertNull((Object)hi2.getPojoSwap(bs));
        Assert.assertNull((Object)hc2.getPojoSwap(bs));
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), HI1.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), HC1.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), HI2.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), HC2.class);
        bc = BeanContext.create().pojoSwaps(new Class[]{HI1Swap.class}).build();
        bs = bc.createSession();
        ooo = bc.getClassMeta(Object.class);
        hi1 = bc.getClassMeta(HI1.class);
        hc1 = bc.getClassMeta(HC1.class);
        hi2 = bc.getClassMeta(HI2.class);
        hc2 = bc.getClassMeta(HC2.class);
        Assert.assertTrue((boolean)ooo.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi1.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc1.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hi2.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertEquals(hi1.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hc1.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hi2.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hc2.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        bc = BeanContext.create().pojoSwaps(new Class[]{HC1Swap.class}).build();
        bs = bc.createSession();
        ooo = bc.getClassMeta(Object.class);
        hi1 = bc.getClassMeta(HI1.class);
        hc1 = bc.getClassMeta(HC1.class);
        hi2 = bc.getClassMeta(HI2.class);
        hc2 = bc.getClassMeta(HC2.class);
        Assert.assertTrue((boolean)ooo.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc1.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hi2.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertNull((Object)hi1.getPojoSwap(bs));
        Assert.assertEquals(hc1.getPojoSwap(bs).getClass(), HC1Swap.class);
        Assert.assertNull((Object)hi2.getPojoSwap(bs));
        Assert.assertEquals(hc2.getPojoSwap(bs).getClass(), HC1Swap.class);
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), HI1.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), HI2.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        bc = BeanContext.create().pojoSwaps(new Class[]{HI2Swap.class}).build();
        bs = bc.createSession();
        ooo = bc.getClassMeta(Object.class);
        hi1 = bc.getClassMeta(HI1.class);
        hc1 = bc.getClassMeta(HC1.class);
        hi2 = bc.getClassMeta(HI2.class);
        hc2 = bc.getClassMeta(HC2.class);
        Assert.assertTrue((boolean)ooo.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi1.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi2.hasChildPojoSwaps());
        Assert.assertFalse((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertNull((Object)hi1.getPojoSwap(bs));
        Assert.assertNull((Object)hc1.getPojoSwap(bs));
        Assert.assertEquals(hi2.getPojoSwap(bs).getClass(), HI2Swap.class);
        Assert.assertEquals(hc2.getPojoSwap(bs).getClass(), HI2Swap.class);
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), HI1.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), HC1.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        bc = BeanContext.create().pojoSwaps(new Class[]{HC2Swap.class}).build();
        bs = bc.createSession();
        ooo = bc.getClassMeta(Object.class);
        hi1 = bc.getClassMeta(HI1.class);
        hc1 = bc.getClassMeta(HC1.class);
        hi2 = bc.getClassMeta(HI2.class);
        hc2 = bc.getClassMeta(HC2.class);
        Assert.assertTrue((boolean)ooo.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi2.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertNull((Object)hi1.getPojoSwap(bs));
        Assert.assertNull((Object)hc1.getPojoSwap(bs));
        Assert.assertNull((Object)hi2.getPojoSwap(bs));
        Assert.assertEquals(hc2.getPojoSwap(bs).getClass(), HC2Swap.class);
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), HI1.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), HC1.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), HI2.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        bc = BeanContext.create().pojoSwaps(new Class[]{HI1Swap.class, HC1Swap.class, HI2Swap.class, HC2Swap.class}).build();
        bs = bc.createSession();
        ooo = bc.getClassMeta(Object.class);
        hi1 = bc.getClassMeta(HI1.class);
        hc1 = bc.getClassMeta(HC1.class);
        hi2 = bc.getClassMeta(HI2.class);
        hc2 = bc.getClassMeta(HC2.class);
        Assert.assertTrue((boolean)ooo.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi2.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertEquals(hi1.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hc1.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hi2.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hc2.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        bc = BeanContext.create().pojoSwaps(new Class[]{HC2Swap.class, HI2Swap.class, HC1Swap.class, HI1Swap.class}).build();
        bs = bc.createSession();
        ooo = bc.getClassMeta(Object.class);
        hi1 = bc.getClassMeta(HI1.class);
        hc1 = bc.getClassMeta(HC1.class);
        hi2 = bc.getClassMeta(HI2.class);
        hc2 = bc.getClassMeta(HC2.class);
        Assert.assertTrue((boolean)ooo.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc1.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hi2.hasChildPojoSwaps());
        Assert.assertTrue((boolean)hc2.hasChildPojoSwaps());
        Assert.assertNull((Object)ooo.getPojoSwap(bs));
        Assert.assertEquals(hi1.getPojoSwap(bs).getClass(), HI1Swap.class);
        Assert.assertEquals(hc1.getPojoSwap(bs).getClass(), HC1Swap.class);
        Assert.assertEquals(hi2.getPojoSwap(bs).getClass(), HI2Swap.class);
        Assert.assertEquals(hc2.getPojoSwap(bs).getClass(), HC2Swap.class);
        Assert.assertEquals((Object)ooo.getSerializedClassMeta(bs).getInnerClass(), Object.class);
        Assert.assertEquals((Object)hi1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc1.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hi2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
        Assert.assertEquals((Object)hc2.getSerializedClassMeta(bs).getInnerClass(), Map.class);
    }

    public static class HI2Swap
    extends PojoSwap<HI2, Map> {
    }

    public static class HC2Swap
    extends PojoSwap<HC2, Map> {
    }

    public static class HI1Swap
    extends PojoSwap<HI1, Map> {
    }

    public static class HC1Swap
    extends PojoSwap<HC1, Map> {
    }

    public class HC2
    extends HC1
    implements HI2 {
    }

    public static interface HI2
    extends HI1 {
    }

    public class HC1
    implements HI1 {
    }

    public static interface HI1 {
    }

    public class G
    extends HashMap<String, Object> {
    }
}

