/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanDictionaryMap;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyNamerDLC;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.testutils.TestUtils;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.PojoIntrospector;
import org.apache.juneau.xml.XmlParser;
import org.junit.Assert;
import org.junit.Test;

public class BeanMapTest {
    JsonSerializer serializer = SimpleJsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
    BeanContext bc = BeanContext.create().dictionary(new Class[]{MyBeanDictionaryMap.class}).build();
    BeanSession session = this.bc.createSession();

    @Test
    public void testPrimitiveFieldProperties() {
        A t = new A();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("i1", null);
        m.put("s1", null);
        m.put("l1", null);
        m.put("d1", null);
        m.put("f1", null);
        m.put("b1", null);
        Assert.assertEquals((Object)new Integer(0), m.get("i1"));
        Assert.assertEquals((Object)new Short(0), m.get("s1"));
        Assert.assertEquals((Object)new Long(0L), m.get("l1"));
        Assert.assertEquals((Object)new Double(0.0), m.get("d1"));
        Assert.assertEquals((Object)new Float(0.0f), m.get("f1"));
        Assert.assertEquals((Object)new Boolean(false), m.get("b1"));
        m.put("i2", null);
        m.put("s2", null);
        m.put("l2", null);
        m.put("d2", null);
        m.put("f2", null);
        m.put("b2", null);
        Assert.assertNull(m.get("i2"));
        Assert.assertNull(m.get("s2"));
        Assert.assertNull(m.get("l2"));
        Assert.assertNull(m.get("d2"));
        Assert.assertNull(m.get("f2"));
        Assert.assertNull(m.get("b2"));
        m.put("i1", 1);
        m.put("s1", 1);
        m.put("l1", 1);
        m.put("d1", 1);
        m.put("f1", 1);
        m.put("i2", 1);
        m.put("s2", 1);
        m.put("l2", 1);
        m.put("d2", 1);
        m.put("f2", 1);
        Assert.assertEquals((Object)new Integer(1), m.get("i1"));
        Assert.assertEquals((Object)new Integer(1), m.get("i2"));
        Assert.assertEquals((Object)new Short(1), m.get("s1"));
        Assert.assertEquals((Object)new Short(1), m.get("s2"));
        Assert.assertEquals((Object)new Long(1L), m.get("l1"));
        Assert.assertEquals((Object)new Long(1L), m.get("l2"));
        Assert.assertEquals((Object)new Double(1.0), m.get("d1"));
        Assert.assertEquals((Object)new Double(1.0), m.get("d2"));
        Assert.assertEquals((Object)new Float(1.0f), m.get("f1"));
        Assert.assertEquals((Object)new Float(1.0f), m.get("f2"));
        m.put("b1", true);
        m.put("b2", new Boolean(true));
        Assert.assertEquals((Object)new Boolean(true), m.get("b1"));
        Assert.assertEquals((Object)new Boolean(true), m.get("b2"));
    }

    @Test
    public void testPrimitiveMethodProperties() {
        B t = new B();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("i1", null);
        m.put("s1", null);
        m.put("l1", null);
        m.put("d1", null);
        m.put("f1", null);
        m.put("b1", null);
        Assert.assertEquals((Object)new Integer(0), m.get("i1"));
        Assert.assertEquals((Object)new Short(0), m.get("s1"));
        Assert.assertEquals((Object)new Long(0L), m.get("l1"));
        Assert.assertEquals((Object)new Double(0.0), m.get("d1"));
        Assert.assertEquals((Object)new Float(0.0f), m.get("f1"));
        Assert.assertEquals((Object)new Boolean(false), m.get("b1"));
        m.put("i2", null);
        m.put("s2", null);
        m.put("l2", null);
        m.put("d2", null);
        m.put("f2", null);
        m.put("b2", null);
        Assert.assertNull(m.get("i2"));
        Assert.assertNull(m.get("s2"));
        Assert.assertNull(m.get("l2"));
        Assert.assertNull(m.get("d2"));
        Assert.assertNull(m.get("f2"));
        Assert.assertNull(m.get("b2"));
        m.put("i1", 1);
        m.put("s1", 1);
        m.put("l1", 1);
        m.put("d1", 1);
        m.put("f1", 1);
        m.put("i2", 1);
        m.put("s2", 1);
        m.put("l2", 1);
        m.put("d2", 1);
        m.put("f2", 1);
        Assert.assertEquals((Object)new Integer(1), m.get("i1"));
        Assert.assertEquals((Object)new Integer(1), m.get("i2"));
        Assert.assertEquals((Object)new Short(1), m.get("s1"));
        Assert.assertEquals((Object)new Short(1), m.get("s2"));
        Assert.assertEquals((Object)new Long(1L), m.get("l1"));
        Assert.assertEquals((Object)new Long(1L), m.get("l2"));
        Assert.assertEquals((Object)new Double(1.0), m.get("d1"));
        Assert.assertEquals((Object)new Double(1.0), m.get("d2"));
        Assert.assertEquals((Object)new Float(1.0f), m.get("f1"));
        Assert.assertEquals((Object)new Float(1.0f), m.get("f2"));
        m.put("b1", true);
        m.put("b2", true);
        Assert.assertEquals((Object)new Boolean(true), m.get("b1"));
        Assert.assertEquals((Object)new Boolean(true), m.get("b2"));
    }

    @Test
    public void testCollectionFieldProperties() throws Exception {
        C t = new C();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("l1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("al1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("ll1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("c1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("jl1", new ObjectList((CharSequence)"[1,2,3]"));
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)m.get("al1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("l1").getClass().getName());
        Assert.assertEquals((Object)LinkedList.class.getName(), (Object)m.get("ll1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("c1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("jl1").getClass().getName());
        m.put("m1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("hm1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("jm1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("tm1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        Assert.assertEquals((Object)TreeMap.class.getName(), (Object)m.get("tm1").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("m1").getClass().getName());
        Assert.assertEquals((Object)HashMap.class.getName(), (Object)m.get("hm1").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("jm1").getClass().getName());
        m.put("l2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("al2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("ll2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("c2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("m2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("hm2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("tm2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("jm2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("jl2", new ObjectList((CharSequence)"[1,2,3]"));
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)m.get("l2").getClass().getName());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)m.get("al2").getClass().getName());
        Assert.assertEquals((Object)LinkedList.class.getName(), (Object)m.get("ll2").getClass().getName());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)m.get("c2").getClass().getName());
        Assert.assertEquals((Object)HashMap.class.getName(), (Object)m.get("m2").getClass().getName());
        Assert.assertEquals((Object)HashMap.class.getName(), (Object)m.get("hm2").getClass().getName());
        Assert.assertEquals((Object)TreeMap.class.getName(), (Object)m.get("tm2").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("jm2").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("jl2").getClass().getName());
    }

    @Test
    public void testCollectionMethodProperties() throws Exception {
        D t = new D();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("l1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("al1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("ll1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("c1", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("jl1", new ObjectList((CharSequence)"[1,2,3]"));
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)m.get("al1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("l1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("ll1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("c1").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("jl1").getClass().getName());
        m.put("m1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("hm1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("jm1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("tm1", new ObjectMap((CharSequence)"{foo:'bar'}"));
        Assert.assertEquals((Object)TreeMap.class.getName(), (Object)m.get("tm1").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("m1").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("hm1").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("jm1").getClass().getName());
        m.put("l2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("al2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("ll2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("c2", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("m2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("hm2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("tm2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("jm2", new ObjectMap((CharSequence)"{foo:'bar'}"));
        m.put("jl2", new ObjectList((CharSequence)"[1,2,3]"));
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("l2").getClass().getName());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)m.get("al2").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("ll2").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("c2").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("m2").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("hm2").getClass().getName());
        Assert.assertEquals((Object)TreeMap.class.getName(), (Object)m.get("tm2").getClass().getName());
        Assert.assertEquals((Object)ObjectMap.class.getName(), (Object)m.get("jm2").getClass().getName());
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)m.get("jl2").getClass().getName());
    }

    @Test
    public void testArrayProperties() throws Exception {
        D1 t = new D1();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("b", new ObjectMap((CharSequence)"{s:'foo'}"));
        Assert.assertNotNull((Object)t.b);
        Assert.assertEquals((Object)"foo", (Object)t.b.s);
        TreeMap<String, String> m2 = new TreeMap<String, String>();
        m2.put("s", "bar");
        m.put("b", m2);
        Assert.assertNotNull((Object)t.b);
        Assert.assertEquals((Object)"bar", (Object)t.b.s);
        m.put("b", new D2());
        Assert.assertEquals((Object)"default", (Object)t.b.s);
        JsonParser p = JsonParser.create().dictionary(new Class[]{D2.class}).build();
        m.put("lb1", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)t.lb1.getClass().getName());
        Assert.assertEquals((Object)D2.class.getName(), (Object)t.lb1.get(0).getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.lb1.get((int)0).s);
        m.put("lb2", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)t.lb2.getClass().getName());
        Assert.assertEquals((Object)D2.class.getName(), (Object)t.lb2.get(0).getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.lb2.get((int)0).s);
        m.put("ab1", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)("[L" + D2.class.getName() + ";"), (Object)t.ab1.getClass().getName());
        Assert.assertEquals((Object)D2.class.getName(), (Object)t.ab1[0].getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.ab1[0].s);
        m.put("ab2", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)("[L" + D2.class.getName() + ";"), (Object)t.ab2.getClass().getName());
        Assert.assertEquals((Object)D2.class.getName(), (Object)t.ab2[0].getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.ab2[0].s);
    }

    @Test
    public void testArrayProperties_usingConfig() throws Exception {
        D1c t = new D1c();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("b", new ObjectMap((CharSequence)"{s:'foo'}"));
        Assert.assertNotNull((Object)t.b);
        Assert.assertEquals((Object)"foo", (Object)t.b.s);
        TreeMap<String, String> m2 = new TreeMap<String, String>();
        m2.put("s", "bar");
        m.put("b", m2);
        Assert.assertNotNull((Object)t.b);
        Assert.assertEquals((Object)"bar", (Object)t.b.s);
        m.put("b", new D2c());
        Assert.assertEquals((Object)"default", (Object)t.b.s);
        JsonParser p = JsonParser.create().dictionary(new Class[]{D2c.class}).applyAnnotations(new Class[]{D1c.class}).build();
        m.put("lb1", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)ObjectList.class.getName(), (Object)t.lb1.getClass().getName());
        Assert.assertEquals((Object)D2c.class.getName(), (Object)t.lb1.get(0).getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.lb1.get((int)0).s);
        m.put("lb2", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)t.lb2.getClass().getName());
        Assert.assertEquals((Object)D2c.class.getName(), (Object)t.lb2.get(0).getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.lb2.get((int)0).s);
        m.put("ab1", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)("[L" + D2c.class.getName() + ";"), (Object)t.ab1.getClass().getName());
        Assert.assertEquals((Object)D2c.class.getName(), (Object)t.ab1[0].getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.ab1[0].s);
        m.put("ab2", new ObjectList((CharSequence)"[{_type:'D2',s:'foobar'}]", (Parser)p));
        Assert.assertEquals((Object)("[L" + D2c.class.getName() + ";"), (Object)t.ab2.getClass().getName());
        Assert.assertEquals((Object)D2c.class.getName(), (Object)t.ab2[0].getClass().getName());
        Assert.assertEquals((Object)"foobar", (Object)t.ab2[0].s);
    }

    @Test
    public void testArrayPropertiesInObjectList() throws Exception {
        E t = new E();
        BeanMap m = this.session.toBeanMap((Object)t);
        m.put("s", new ObjectList((CharSequence)"['foo']"));
        m.put("s2", new ObjectList((CharSequence)"[['foo']]"));
        m.put("i", new ObjectList((CharSequence)"[1,2,3]"));
        m.put("i2", new ObjectList((CharSequence)"[[1,2,3],[4,5,6]]"));
        Assert.assertEquals((Object)"{s:['foo'],s2:[['foo']],i:[1,2,3],i2:[[1,2,3],[4,5,6]]}", (Object)SimpleJsonSerializer.DEFAULT.serialize((Object)t));
        m.put("i", new ObjectList((CharSequence)"[null,null,null]"));
        m.put("i2", new ObjectList((CharSequence)"[[null,null,null],[null,null,null]]"));
        Assert.assertEquals((Object)"{s:['foo'],s2:[['foo']],i:[0,0,0],i2:[[0,0,0],[0,0,0]]}", (Object)SimpleJsonSerializer.DEFAULT.serialize((Object)t));
    }

    @Test
    public void testInvokeMethod() throws Exception {
        F t5 = new F();
        JsonParser p = JsonParser.DEFAULT;
        BeanMap m = this.session.toBeanMap((Object)t5);
        new PojoIntrospector((Object)t5, (ReaderParser)p).invokeMethod("doSetAProperty(java.lang.String)", "['baz']");
        Assert.assertEquals((Object)"baz", (Object)m.get((Object)"prop"));
    }

    @Test
    public void testBeanPropertyAnnotation() throws Exception {
        G1 t6 = new G1();
        BeanMap m = this.session.toBeanMap((Object)t6);
        try {
            m.put("l1", (Object)"[{a:'a',i:1}]");
            throw new Exception("Expected exception on unsettable field.");
        }
        catch (Exception exception) {
            m.put("l2", (Object)"[{a:'a',i:1}]");
            Assert.assertEquals((Object)"java.util.LinkedList", (Object)m.get((Object)"l2").getClass().getName());
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"l2")).get(0).getClass().getName());
            m.put("l3", (Object)"[{a:'a',i:1}]");
            Assert.assertEquals((Object)"org.apache.juneau.ObjectList", (Object)m.get((Object)"l3").getClass().getName());
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"l3")).get(0).getClass().getName());
            m.put("l4", (Object)"[{a:'a',i:1}]");
            Assert.assertEquals((Object)"java.util.LinkedList", (Object)m.get((Object)"l4").getClass().getName());
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"l4")).get(0).getClass().getName());
            try {
                m.put("m1", (Object)"[{a:'a',i:1}]");
                throw new Exception("Expected exception on unsettable field.");
            }
            catch (Exception exception2) {
                m.put("m2", (Object)"[{a:'a',i:1}]");
                Assert.assertEquals((Object)"java.util.LinkedList", (Object)m.get((Object)"m2").getClass().getName());
                Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"m2")).get(0).getClass().getName());
                m.put("m3", (Object)"[{a:'a',i:1}]");
                Assert.assertEquals((Object)"org.apache.juneau.ObjectList", (Object)m.get((Object)"m3").getClass().getName());
                Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"m3")).get(0).getClass().getName());
                m.put("m4", (Object)"[{a:'a',i:1}]");
                Assert.assertEquals((Object)"java.util.LinkedList", (Object)m.get((Object)"m4").getClass().getName());
                Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"m4")).get(0).getClass().getName());
                m.put("m5", (Object)"[{a:'a',i:1}]");
                Assert.assertEquals((Object)"java.util.LinkedList", (Object)m.get((Object)"m5").getClass().getName());
                Assert.assertEquals((Object)"org.apache.juneau.BeanMapTest$G", (Object)((List)m.get((Object)"m5")).get(0).getClass().getName());
                return;
            }
        }
    }

    @Test
    public void testEnum() throws Exception {
        H t7 = new H();
        BeanMap m = this.session.toBeanMap((Object)t7);
        m.put("enum1", (Object)"ONE");
        m.put("enum2", (Object)"TWO");
        Assert.assertEquals((Object)"{_type:'H',enum1:'ONE',enum2:'TWO'}", (Object)this.serializer.serialize((Object)t7));
        Assert.assertEquals((Object)((Object)HEnum.ONE), (Object)((Object)t7.enum1));
        Assert.assertEquals((Object)((Object)HEnum.TWO), (Object)((Object)t7.getEnum2()));
        m = BeanContext.DEFAULT.createSession().newBeanMap(H.class).load("{enum1:'TWO',enum2:'THREE'}");
        Assert.assertEquals((Object)"{_type:'H',enum1:'TWO',enum2:'THREE'}", (Object)this.serializer.serialize(m.getBean()));
        t7 = (H)m.getBean();
        Assert.assertEquals((Object)((Object)HEnum.TWO), (Object)((Object)t7.enum1));
        Assert.assertEquals((Object)((Object)HEnum.THREE), (Object)((Object)t7.getEnum2()));
        JsonParser p = JsonParser.create().dictionary(new Class[]{H.class}).build();
        t7 = (H)p.parse("{_type:'H',enum1:'THREE',enum2:'ONE'}", Object.class);
        Assert.assertEquals((Object)"{_type:'H',enum1:'THREE',enum2:'ONE'}", (Object)this.serializer.serialize((Object)t7));
        Assert.assertEquals((Object)((Object)HEnum.THREE), (Object)((Object)t7.enum1));
        Assert.assertEquals((Object)((Object)HEnum.ONE), (Object)((Object)t7.getEnum2()));
    }

    @Test
    public void testAutomaticDetectionOfGenericTypes() throws Exception {
        BeanMap bm = BeanContext.DEFAULT.createSession().newBeanMap(I.class);
        Assert.assertEquals(String.class, (Object)bm.getProperty("p1").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Integer.class, (Object)bm.getProperty("p2").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Object.class, (Object)bm.getProperty("p3").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(String.class, (Object)bm.getProperty("p4").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Integer.class, (Object)bm.getProperty("p4").getMeta().getClassMeta().getValueType().getInnerClass());
        Assert.assertEquals(String.class, (Object)bm.getProperty("p5").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Integer.class, (Object)bm.getProperty("p5").getMeta().getClassMeta().getValueType().getInnerClass());
        Assert.assertEquals(Object.class, (Object)bm.getProperty("p6").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Object.class, (Object)bm.getProperty("p6").getMeta().getClassMeta().getValueType().getInnerClass());
    }

    @Test
    public void testOverridingDetectionOfGenericTypes() throws Exception {
        BeanMap bm = BeanContext.DEFAULT.createSession().newBeanMap(J.class);
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p1").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p2").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p3").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Object.class, (Object)bm.getProperty("p4").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p4").getMeta().getClassMeta().getValueType().getInnerClass());
        Assert.assertEquals(Object.class, (Object)bm.getProperty("p5").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p5").getMeta().getClassMeta().getValueType().getInnerClass());
        Assert.assertEquals(String.class, (Object)bm.getProperty("p6").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p6").getMeta().getClassMeta().getValueType().getInnerClass());
    }

    @Test
    public void testOverridingDetectionOfGenericTypes2() throws Exception {
        BeanMap bm = this.session.newBeanMap(K.class);
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p1").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p2").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p3").getMeta().getClassMeta().getElementType().getInnerClass());
        Assert.assertEquals(String.class, (Object)bm.getProperty("p4").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p4").getMeta().getClassMeta().getValueType().getInnerClass());
        Assert.assertEquals(String.class, (Object)bm.getProperty("p5").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p5").getMeta().getClassMeta().getValueType().getInnerClass());
        Assert.assertEquals(String.class, (Object)bm.getProperty("p6").getMeta().getClassMeta().getKeyType().getInnerClass());
        Assert.assertEquals(Float.class, (Object)bm.getProperty("p6").getMeta().getClassMeta().getValueType().getInnerClass());
    }

    @Test
    public void testGenericListSubclass() throws Exception {
        BeanMap bm = this.session.newBeanMap(L.class);
        bm.put("list", (Object)"[{name:'1',value:'1'},{name:'2',value:'2'}]");
        L b = (L)bm.getBean();
        Assert.assertEquals((Object)"1", (Object)((L2)b.list.get((int)0)).name);
    }

    @Test
    public void testGenericFields() throws Exception {
        M2 t1 = new M2();
        BeanMap bm = this.session.toBeanMap((Object)t1);
        Assert.assertEquals((Object)1, (Object)bm.get((Object)"x"));
        M3 t2 = new M3();
        BeanMap cm = this.session.toBeanMap((Object)t2);
        Assert.assertEquals((Object)2, (Object)cm.get((Object)"x"));
        M4 t3 = new M4();
        BeanMap dm = this.session.toBeanMap(t3);
        Assert.assertEquals((Object)3, (Object)dm.get((Object)"x"));
        M5 t4 = new M5();
        BeanMap em = this.session.toBeanMap((Object)t4);
        Assert.assertEquals((Object)4, (Object)em.get((Object)"x"));
    }

    @Test
    public void testGenericMethods() throws Exception {
        N2 t1 = new N2();
        BeanMap bm = this.session.toBeanMap((Object)t1);
        Assert.assertEquals((Object)1, (Object)bm.get((Object)"x"));
        N3 t2 = new N3();
        BeanMap cm = this.session.toBeanMap((Object)t2);
        Assert.assertEquals((Object)2, (Object)cm.get((Object)"x"));
        N4 t3 = new N4();
        BeanMap dm = this.session.toBeanMap(t3);
        Assert.assertEquals((Object)3, (Object)dm.get((Object)"x"));
        N5 t4 = new N5();
        BeanMap em = this.session.toBeanMap((Object)t4);
        Assert.assertEquals((Object)4, (Object)em.get((Object)"x"));
    }

    @Test
    public void testIgnoreUnknownBeanPropertiesSetting() throws Exception {
        JsonParser p = null;
        String json = "{baz:789,foo:123,bar:456}";
        p = JsonParser.create().ignoreUnknownBeanProperties().build();
        O t = (O)p.parse(json, O.class);
        Assert.assertEquals((long)123L, (long)t.foo);
        try {
            p = JsonParser.DEFAULT;
            t = (O)p.parse(json, O.class);
            Assert.fail((String)"Expected exception never occurred");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String xml = "<object><baz type='number'>789</baz><foo type='number'>123</foo><bar type='number'>456</bar></object>";
        p = XmlParser.create().ignoreUnknownBeanProperties().build();
        t = (O)p.parse(xml, O.class);
        Assert.assertEquals((long)123L, (long)t.foo);
        try {
            p = XmlParser.DEFAULT;
            t = (O)p.parse(json, O.class);
            Assert.fail((String)"Expected exception never occurred");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String html = "<table _type='object'><tr><th><string>key</string></th><th><string>value</string></th></tr><tr><td><string>baz</string></td><td><number>789</number></td></tr><tr><td><string>foo</string></td><td><number>123</number></td></tr><tr><td><string>bar</string></td><td><number>456</number></td></tr></table>";
        p = HtmlParser.create().ignoreUnknownBeanProperties().build();
        t = (O)p.parse(html, O.class);
        Assert.assertEquals((long)123L, (long)t.foo);
        try {
            p = HtmlParser.DEFAULT;
            t = (O)p.parse(json, O.class);
            Assert.fail((String)"Expected exception never occurred");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String uon = "(baz=789,foo=123,bar=456)";
        p = UonParser.create().ignoreUnknownBeanProperties().build();
        t = (O)p.parse(uon, O.class);
        Assert.assertEquals((long)123L, (long)t.foo);
        try {
            p = UonParser.DEFAULT;
            t = (O)p.parse(json, O.class);
            Assert.fail((String)"Expected exception never occurred");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String urlencoding = "baz=789&foo=123&bar=456";
        p = UrlEncodingParser.create().ignoreUnknownBeanProperties().build();
        t = (O)p.parse(urlencoding, O.class);
        Assert.assertEquals((long)123L, (long)t.foo);
        try {
            p = UrlEncodingParser.DEFAULT;
            t = (O)p.parse(json, O.class);
            Assert.fail((String)"Expected exception never occurred");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPropertyNameFactoryDashedLC1() throws Exception {
        BeanMap m = this.session.newBeanMap(P1.class).load("{'foo':1,'bar-baz':2,'bing-boo-url':3}");
        Assert.assertEquals((Object)1, (Object)m.get((Object)"foo"));
        Assert.assertEquals((Object)2, (Object)m.get((Object)"bar-baz"));
        Assert.assertEquals((Object)3, (Object)m.get((Object)"bing-boo-url"));
        P1 b = (P1)m.getBean();
        Assert.assertEquals((long)1L, (long)b.foo);
        Assert.assertEquals((long)2L, (long)b.barBaz);
        Assert.assertEquals((long)3L, (long)b.bingBooURL);
        m.put("foo", (Object)4);
        m.put("bar-baz", (Object)5);
        m.put("bing-boo-url", (Object)6);
        Assert.assertEquals((long)4L, (long)b.foo);
        Assert.assertEquals((long)5L, (long)b.barBaz);
        Assert.assertEquals((long)6L, (long)b.bingBooURL);
    }

    @Test
    public void testPropertyNameFactoryDashedLC1_usingConfig() throws Exception {
        BeanMap m = this.bc.builder().applyAnnotations(new Class[]{P1c.class}).build().createSession().newBeanMap(P1c.class).load("{'foo':1,'bar-baz':2,'bing-boo-url':3}");
        Assert.assertEquals((Object)1, (Object)m.get((Object)"foo"));
        Assert.assertEquals((Object)2, (Object)m.get((Object)"bar-baz"));
        Assert.assertEquals((Object)3, (Object)m.get((Object)"bing-boo-url"));
        P1c b = (P1c)m.getBean();
        Assert.assertEquals((long)1L, (long)b.foo);
        Assert.assertEquals((long)2L, (long)b.barBaz);
        Assert.assertEquals((long)3L, (long)b.bingBooURL);
        m.put("foo", (Object)4);
        m.put("bar-baz", (Object)5);
        m.put("bing-boo-url", (Object)6);
        Assert.assertEquals((long)4L, (long)b.foo);
        Assert.assertEquals((long)5L, (long)b.barBaz);
        Assert.assertEquals((long)6L, (long)b.bingBooURL);
    }

    @Test
    public void testPropertyNameFactoryDashedLC2() throws Exception {
        BeanSession session = BeanContext.DEFAULT_SORTED.createSession();
        BeanMap m = session.newBeanMap(P2.class).load("{'foo-bar':1,'baz-bing':2}");
        Assert.assertEquals((Object)1, (Object)m.get((Object)"foo-bar"));
        Assert.assertEquals((Object)2, (Object)m.get((Object)"baz-bing"));
        P2 b = (P2)m.getBean();
        Assert.assertEquals((long)1L, (long)b.getFooBar());
        Assert.assertEquals((long)2L, (long)b.getBazBING());
        m.put("foo-bar", (Object)3);
        m.put("baz-bing", (Object)4);
        Assert.assertEquals((long)3L, (long)b.getFooBar());
        Assert.assertEquals((long)4L, (long)b.getBazBING());
    }

    @Test
    public void testBeanWithFluentStyleSetters() throws Exception {
        Q2 t = new Q2();
        BeanMap m = BeanContext.DEFAULT_SORTED.createSession().toBeanMap((Object)t);
        m.put("f1", (Object)1);
        m.put("f2", (Object)2);
        m.put("f3", (Object)3);
        TestUtils.assertSortedObjectEquals("{f1:1,f2:2,f3:0}", m);
    }

    @Test
    public void testCastWithNormalBean() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"R2");
        m.put((Object)"f1", (Object)1);
        m.put((Object)"f2", (Object)"2");
        R2 t = (R2)m.cast(Object.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        t = (R2)m.cast(R1.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Assert.assertEquals((long)2L, (long)t.f2);
        t = (R2)m.cast(this.session.getClassMeta(R1.class));
        Assert.assertEquals((long)1L, (long)t.f1);
        Assert.assertEquals((long)2L, (long)t.f2);
        m = new ObjectMap(this.session);
        m.put((Object)"f1", (Object)1);
        m.put((Object)"f2", (Object)"2");
        m = (ObjectMap)m.cast(Object.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Assert.assertEquals((long)2L, (long)t.f2);
        t = (R2)m.cast(R2.class);
        Assert.assertEquals((long)1L, (long)t.f1);
        Assert.assertEquals((long)2L, (long)t.f2);
        t = (R2)m.cast(this.session.getClassMeta(R2.class));
        Assert.assertEquals((long)1L, (long)t.f1);
        Assert.assertEquals((long)2L, (long)t.f2);
    }

    @Test
    public void testCastWithNestedBean() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"S");
        m.put((Object)"f1", (Object)new ObjectMap(this.session).append("_type", (Object)"R1").append("f1", (Object)1));
        S t = (S)m.cast(Object.class);
        Assert.assertEquals((long)1L, (long)t.f1.f1);
        t = (S)m.cast(S.class);
        Assert.assertEquals((long)1L, (long)t.f1.f1);
        t = (S)m.cast(this.session.getClassMeta(S.class));
        Assert.assertEquals((long)1L, (long)t.f1.f1);
        m = new ObjectMap(this.session);
        m.put((Object)"f1", (Object)new ObjectMap(this.session).append("_type", (Object)R1.class.getName()).append("f1", (Object)1));
        m = (ObjectMap)m.cast(Object.class);
        Assert.assertEquals((long)1L, (long)t.f1.f1);
        t = (S)m.cast(S.class);
        Assert.assertEquals((long)1L, (long)t.f1.f1);
        t = (S)m.cast(this.session.getClassMeta(S.class));
        Assert.assertEquals((long)1L, (long)t.f1.f1);
    }

    @Test
    public void testCastToAnotherMapType() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"TreeMap");
        m.put((Object)"1", (Object)"ONE");
        Map m2 = (Map)m.cast(Object.class);
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(Map.class);
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(this.bc.getClassMeta(TreeMap.class));
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(this.bc.getClassMeta(TreeMap.class, new Type[]{Integer.class, TEnum.class}));
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        Map.Entry e = m2.entrySet().iterator().next();
        Assert.assertTrue((boolean)(e.getKey() instanceof Integer));
        Assert.assertTrue((boolean)(e.getValue() instanceof TEnum));
        Assert.assertEquals((Object)((Object)TEnum.ONE), m2.get(1));
        m2 = (Map)m.cast(this.bc.getClassMeta(TreeMap.class));
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        e = m2.entrySet().iterator().next();
        Assert.assertTrue((boolean)(e.getKey() instanceof String));
        Assert.assertTrue((boolean)(e.getValue() instanceof String));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(this.bc.getClassMeta(HashMap.class, new Type[]{Integer.class, TEnum.class}));
        Assert.assertTrue((boolean)(m2 instanceof HashMap));
        e = m2.entrySet().iterator().next();
        Assert.assertTrue((boolean)(e.getKey() instanceof Integer));
        Assert.assertTrue((boolean)(e.getValue() instanceof TEnum));
        Assert.assertEquals((Object)((Object)TEnum.ONE), m2.get(1));
        m = new ObjectMap();
        m.put((Object)"1", (Object)"ONE");
        m2 = (ObjectMap)m.cast(Object.class);
        Assert.assertTrue((boolean)(m2 instanceof ObjectMap));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(Map.class);
        Assert.assertTrue((boolean)(m2 instanceof ObjectMap));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(this.bc.getClassMeta(TreeMap.class));
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
        m2 = (Map)m.cast(this.bc.getClassMeta(TreeMap.class, new Type[]{Integer.class, TEnum.class}));
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        e = m2.entrySet().iterator().next();
        Assert.assertTrue((boolean)(e.getKey() instanceof Integer));
        Assert.assertTrue((boolean)(e.getValue() instanceof TEnum));
        Assert.assertEquals((Object)((Object)TEnum.ONE), m2.get(1));
        m2 = (Map)m.cast(this.bc.getClassMeta(TreeMap.class));
        Assert.assertTrue((boolean)(m2 instanceof TreeMap));
        e = m2.entrySet().iterator().next();
        Assert.assertTrue((boolean)(e.getKey() instanceof String));
        Assert.assertTrue((boolean)(e.getValue() instanceof String));
        Assert.assertEquals((Object)"ONE", m2.get("1"));
    }

    @Test
    public void testCastToLinkedList() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"LinkedList");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        List l = (List)m.cast(Object.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((Object)"1", l.get(0));
        m = new ObjectMap();
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(LinkedList.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class, new Type[]{Integer.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof Integer));
        Assert.assertEquals((Object)1, l.get(0));
    }

    @Test
    public void testToLinkedListInteger() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"LinkedListOfInts");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        List l = (List)m.cast(Object.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)1, l.get(0));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)1, l.get(0));
        l = (List)m.cast(ArrayList.class);
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((Object)1, l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((Object)1, l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((Object)1, l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class, new Type[]{String.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof String));
        Assert.assertEquals((Object)"1", l.get(0));
        m = new ObjectMap();
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(ArrayList.class);
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((Object)"1", l.get(0));
        l = (List)m.cast(this.bc.getClassMeta(List.class, new Type[]{Integer.class}));
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertTrue((boolean)(l.get(0) instanceof Integer));
        Assert.assertEquals((Object)1, l.get(0));
    }

    @Test
    public void testCastToLinkedListBean() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"LinkedListOfR1");
        m.put((Object)"items", (Object)new ObjectList(this.session).append(new Object[]{"{f1:1}"}));
        List l = (List)m.cast(Object.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof R1));
        Assert.assertEquals((long)1L, (long)((R1)l.get((int)0)).f1);
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof R1));
        Assert.assertEquals((long)1L, (long)((R1)l.get((int)0)).f1);
        l = (List)m.cast(ArrayList.class);
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertTrue((boolean)(l.get(0) instanceof R1));
        Assert.assertEquals((long)1L, (long)((R1)l.get((int)0)).f1);
        l = (List)m.cast(this.session.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof R1));
        Assert.assertEquals((long)1L, (long)((R1)l.get((int)0)).f1);
        l = (List)m.cast(this.session.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertTrue((boolean)(l.get(0) instanceof R1));
        Assert.assertEquals((long)1L, (long)((R1)l.get((int)0)).f1);
        l = (List)m.cast(this.session.getClassMeta(List.class, new Type[]{HashMap.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof HashMap));
        Assert.assertEquals((Object)1, ((Map)l.get(0)).get("f1"));
        m = new ObjectMap(this.session);
        m.put((Object)"items", (Object)new ObjectList(this.session).append(new Object[]{"{f1:1}"}));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertTrue((boolean)(l.get(0) instanceof String));
        Assert.assertEquals((Object)"{f1:1}", l.get(0));
        l = (List)m.cast(ArrayList.class);
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertTrue((boolean)(l.get(0) instanceof String));
        Assert.assertEquals((Object)"{f1:1}", l.get(0));
        l = (List)m.cast(this.session.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof ObjectList));
        Assert.assertTrue((boolean)(l.get(0) instanceof String));
        Assert.assertEquals((Object)"{f1:1}", l.get(0));
        l = (List)m.cast(this.session.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertTrue((boolean)(l.get(0) instanceof String));
        Assert.assertEquals((Object)"{f1:1}", l.get(0));
        l = (List)m.cast(this.session.getClassMeta(List.class, new Type[]{R1.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof R1));
        Assert.assertEquals((long)1L, (long)((R1)l.get((int)0)).f1);
        l = (List)m.cast(this.session.getClassMeta(List.class, new Type[]{HashMap.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof HashMap));
        Assert.assertEquals((Object)1, ((Map)l.get(0)).get("f1"));
        l = (List)m.cast(this.session.getClassMeta(List.class, new Type[]{Map.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof ObjectMap));
        Assert.assertEquals((Object)1, ((Map)l.get(0)).get("f1"));
    }

    @Test
    public void testCastToLinkedListUsingSwap() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"LinkedListOfCalendar");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"2001-07-04T15:30:45Z"}));
        List l = (List)m.cast(Object.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((long)2001L, (long)((Calendar)l.get(0)).get(1));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((long)2001L, (long)((Calendar)l.get(0)).get(1));
        l = (List)m.cast(ArrayList.class);
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((long)2001L, (long)((Calendar)l.get(0)).get(1));
        m.cast(HashSet.class);
        l = (List)m.cast(this.session.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertEquals((long)2001L, (long)((Calendar)l.get(0)).get(1));
        l = (List)m.cast(this.session.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        Assert.assertEquals((long)2001L, (long)((Calendar)l.get(0)).get(1));
        l = (List)m.cast(this.session.getClassMeta(List.class, new Type[]{String.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof String));
        Assert.assertEquals((Object)"2001-07-04T15:30:45Z", l.get(0));
        m = new ObjectMap().setBeanSession(this.session);
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"2001-07-04T15:30:45Z"}));
        l = (List)m.cast(List.class);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        l = (List)m.cast(ArrayList.class);
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        m.cast(HashSet.class);
        l = (List)m.cast(this.session.getClassMeta(List.class));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        l = (List)m.cast(this.session.getClassMeta(ArrayList.class));
        Assert.assertTrue((boolean)(l instanceof ArrayList));
        l = (List)m.cast(this.session.getClassMeta(List.class, new Type[]{Calendar.class}));
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((boolean)(l.get(0) instanceof Calendar));
        Assert.assertEquals((long)2001L, (long)((Calendar)l.get(0)).get(1));
    }

    @Test
    public void testCastToStringArray() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"StringArray");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        String[] l = (String[])m.cast(Object.class);
        Assert.assertEquals((Object)"1", (Object)l[0]);
        l = (String[])m.cast(String[].class);
        Assert.assertEquals((Object)"1", (Object)l[0]);
        StringBuffer[] l2 = (StringBuffer[])m.cast(StringBuffer[].class);
        Assert.assertEquals((Object)"1", (Object)l2[0].toString());
        int[] l3 = (int[])m.cast(int[].class);
        Assert.assertEquals((long)1L, (long)l3[0]);
        l = (String[])m.cast(this.bc.getClassMeta(String[].class));
        Assert.assertEquals((Object)"1", (Object)l[0]);
        l2 = (StringBuffer[])m.cast(this.bc.getClassMeta(StringBuffer[].class));
        Assert.assertEquals((Object)"1", (Object)l2[0].toString());
        l3 = (int[])m.cast(this.bc.getClassMeta(int[].class));
        Assert.assertEquals((Object)"1", (Object)l2[0].toString());
        m = new ObjectMap();
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        l = (String[])m.cast(String[].class);
        Assert.assertEquals((Object)"1", (Object)l[0]);
        l = (String[])m.cast(this.bc.getClassMeta(String[].class));
        Assert.assertEquals((Object)"1", (Object)l[0]);
        l2 = (StringBuffer[])m.cast(this.bc.getClassMeta(StringBuffer[].class));
        Assert.assertEquals((Object)"1", (Object)l[0].toString());
    }

    @Test
    public void testCastToIntArray() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"IntArray");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        int[] l = (int[])m.cast(Object.class);
        Assert.assertEquals((long)1L, (long)l[0]);
        l = (int[])m.cast(int[].class);
        Assert.assertEquals((long)1L, (long)l[0]);
        l = (int[])m.cast(this.bc.getClassMeta(int[].class));
        Assert.assertEquals((long)1L, (long)l[0]);
        long[] l2 = (long[])m.cast(long[].class);
        Assert.assertEquals((long)1L, (long)l2[0]);
        l2 = (long[])m.cast(this.bc.getClassMeta(long[].class));
        Assert.assertEquals((long)1L, (long)l2[0]);
        m = new ObjectMap();
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{"1"}).append(new Object[]{"2"}));
        l = (int[])m.cast(int[].class);
        Assert.assertEquals((long)1L, (long)l[0]);
        l = (int[])m.cast(this.bc.getClassMeta(int[].class));
        Assert.assertEquals((long)1L, (long)l[0]);
        l2 = (long[])m.cast(long[].class);
        Assert.assertEquals((long)1L, (long)l2[0]);
        l2 = (long[])m.cast(this.bc.getClassMeta(long[].class));
        Assert.assertEquals((long)1L, (long)l2[0]);
    }

    @Test
    public void testCastToString2dArray() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"String2dArray");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{new ObjectList().append(new Object[]{"1"})}).append(new Object[]{new ObjectList().append(new Object[]{"2"})}));
        String[][] l = (String[][])m.cast(Object.class);
        Assert.assertEquals((Object)"1", (Object)l[0][0]);
        Assert.assertEquals((Object)"2", (Object)l[1][0]);
        l = (String[][])m.cast(String[][].class);
        Assert.assertEquals((Object)"1", (Object)l[0][0]);
        l = (String[][])m.cast(this.bc.getClassMeta(String[][].class));
        Assert.assertEquals((Object)"2", (Object)l[1][0]);
        m = new ObjectMap();
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{new ObjectList().append(new Object[]{"1"})}).append(new Object[]{new ObjectList().append(new Object[]{"2"})}));
        l = (String[][])m.cast(String[][].class);
        Assert.assertEquals((Object)"1", (Object)l[0][0]);
        l = (String[][])m.cast(this.bc.getClassMeta(String[][].class));
        Assert.assertEquals((Object)"2", (Object)l[1][0]);
    }

    @Test
    public void testCastToInt2dArray() throws Exception {
        ObjectMap m = new ObjectMap(this.session);
        m.put((Object)"_type", (Object)"Int2dArray");
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{new ObjectList().append(new Object[]{"1"})}).append(new Object[]{new ObjectList().append(new Object[]{"2"})}));
        int[][] l = (int[][])m.cast(Object.class);
        Assert.assertEquals((long)1L, (long)l[0][0]);
        Assert.assertEquals((long)2L, (long)l[1][0]);
        l = (int[][])m.cast(int[][].class);
        Assert.assertEquals((long)1L, (long)l[0][0]);
        l = (int[][])m.cast(this.bc.getClassMeta(int[][].class));
        Assert.assertEquals((long)2L, (long)l[1][0]);
        m = new ObjectMap();
        m.put((Object)"items", (Object)new ObjectList().append(new Object[]{new ObjectList().append(new Object[]{"1"})}).append(new Object[]{new ObjectList().append(new Object[]{"2"})}));
        l = (int[][])m.cast(int[][].class);
        Assert.assertEquals((long)1L, (long)l[0][0]);
        l = (int[][])m.cast(this.bc.getClassMeta(int[][].class));
        Assert.assertEquals((long)2L, (long)l[1][0]);
    }

    @Test
    public void testHiddenProperties() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        BeanMeta bm = s.getBeanMeta(U.class);
        Assert.assertNotNull((Object)bm.getPropertyMeta("a"));
        Assert.assertNotNull((Object)bm.getPropertyMeta("b"));
        Assert.assertNull((Object)bm.getPropertyMeta("c"));
        Assert.assertNull((Object)bm.getPropertyMeta("d"));
        U t = new U();
        t.a = "a";
        t.b = "b";
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{a:'a',b:'b'}", (Object)r);
        t = (U)JsonParser.DEFAULT.parse(r, U.class);
        Assert.assertEquals((Object)"b(setter)", (Object)t.b);
    }

    @Test
    public void testHiddenProperties_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().applyAnnotations(new Class[]{Uc.class}).build();
        BeanMeta bm = s.getBeanMeta(U.class);
        Assert.assertNotNull((Object)bm.getPropertyMeta("a"));
        Assert.assertNotNull((Object)bm.getPropertyMeta("b"));
        Assert.assertNull((Object)bm.getPropertyMeta("c"));
        Assert.assertNull((Object)bm.getPropertyMeta("d"));
        Uc t = new Uc();
        t.a = "a";
        t.b = "b";
        String r = s.serialize((Object)t);
        Assert.assertEquals((Object)"{a:'a',b:'b'}", (Object)r);
        t = (Uc)JsonParser.DEFAULT.builder().applyAnnotations(new Class[]{Uc.class}).build().parse(r, Uc.class);
        Assert.assertEquals((Object)"b(setter)", (Object)t.b);
    }

    @Test
    public void testBeanPropertyOrder() throws Exception {
        TestUtils.assertObjectEquals("{a1:'1',a2:'2',a3:'3',a4:'4'}", new V2());
        TestUtils.assertObjectEquals("{a3:'3',a4:'4',a5:'5',a6:'6'}", new V3());
    }

    @Test
    public void testBeanPropertyOrder_usingConfig() throws Exception {
        JsonSerializer ws = JsonSerializer.create().simple().sq().applyAnnotations(new Class[]{Vc.class}).build();
        Assert.assertEquals((Object)"{a1:'1',a2:'2',a3:'3',a4:'4'}", (Object)ws.toString((Object)new V2c()));
        Assert.assertEquals((Object)"{a3:'3',a4:'4',a5:'5',a6:'6'}", (Object)ws.toString((Object)new V3c()));
    }

    @Test
    public void testBeanMethodOrder() throws Exception {
        TestUtils.assertSortedObjectEquals("{a1:'1',a2:'2',a3:'3',a4:'4'}", new W2());
        TestUtils.assertSortedObjectEquals("{a3:'3',a4:'4',a5:'5',a6:'6'}", new W3());
    }

    @Test
    public void testOverriddenPropertyTypes() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT;
        JsonParser p = JsonParser.DEFAULT;
        X1 t1 = X1.create();
        String r = s.serialize((Object)t1);
        Assert.assertEquals((Object)"{f1:'1',f2:'2'}", (Object)r);
        t1 = (X1)p.parse(r, X1.class);
        Assert.assertEquals((Object)"1", (Object)t1.f1);
        Assert.assertEquals((Object)"2", (Object)t1.getF2());
        X2 t2 = X2.create();
        r = s.serialize((Object)t2);
        Assert.assertEquals((Object)"{f1:1,f2:2}", (Object)r);
        t2 = (X2)p.parse(r, X2.class);
        Assert.assertEquals((long)1L, (long)t2.f1.intValue());
        Assert.assertEquals((long)2L, (long)t2.getF2().intValue());
    }

    @Test
    public void testSettingCollectionPropertyMultipleTimes() throws Exception {
        BeanMap m = BeanContext.DEFAULT.createSession().newBeanMap(Y.class);
        m.put("f1", (Object)new ObjectList().append(new Object[]{"a"}));
        m.put("f1", (Object)new ObjectList().append(new Object[]{"b"}));
        Assert.assertEquals((Object)"{f1=[b]}", (Object)m.toString());
    }

    @Test
    public void testIgnoreNulls() {
        Z z = new Z();
        BeanMap bm = BeanContext.DEFAULT.createSession().toBeanMap((Object)z);
        Iterator i = bm.getValues(true, new BeanPropertyValue[0]).iterator();
        Assert.assertFalse((boolean)i.hasNext());
        z.b = "";
        i = bm.getValues(true, new BeanPropertyValue[0]).iterator();
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        Assert.assertFalse((boolean)i.hasNext());
        i = bm.getValues(false, new BeanPropertyValue[0]).iterator();
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testCollectionSetters_preferSetter() throws Exception {
        AA aa = new AA();
        BeanMap bm = BeanContext.DEFAULT.createSession().toBeanMap((Object)aa);
        bm.put("a", (Object)AList.create((Object[])new String[]{"x"}));
        TestUtils.assertObjectEquals("['x']", aa.a);
    }

    public static class AA {
        private List<String> a = new ArrayList<String>();

        public List<String> getA() {
            return Collections.emptyList();
        }

        public void setA(List<String> a) {
            this.a = a;
        }
    }

    public static class Z {
        public String a;
        public String b;
        public String c;
    }

    public static class Y {
        public List<String> f1 = new LinkedList<String>();
    }

    public static class X2
    extends X1 {
        public Integer f1;
        private Integer f2;

        static X2 create() {
            X2 x = new X2();
            x.f1 = 1;
            x.f2 = 2;
            return x;
        }

        @Override
        public Integer getF2() {
            return this.f2;
        }

        public void setF2(Integer f2) {
            this.f2 = f2;
        }
    }

    public static class X1 {
        public Object f1;
        private Object f2;

        static X1 create() {
            X1 x = new X1();
            x.f1 = "1";
            x.f2 = "2";
            return x;
        }

        public Object getF2() {
            return this.f2;
        }

        public void setF2(Object f2) {
            this.f2 = f2;
        }
    }

    @Bean(stopClass=W.class)
    public static class W3
    extends W2 {
        public String getA5() {
            return "5";
        }

        public String getA6() {
            return "6";
        }
    }

    public static class W2
    extends W {
        public String getA3() {
            return "3";
        }

        public String getA4() {
            return "4";
        }
    }

    public static class W {
        public String getA1() {
            return "1";
        }

        public String getA2() {
            return "2";
        }
    }

    public static class V3c
    extends V2c {
        public String a5 = "5";
        public String a6 = "6";
    }

    public static class V2c
    extends Vc {
        public String a3 = "3";
        public String a4 = "4";
    }

    @BeanConfig(applyBean={@Bean(on="V3c", stopClass=Vc.class)})
    public static class Vc {
        public String a1 = "1";
        public String a2 = "2";
    }

    @Bean(stopClass=V.class)
    public static class V3
    extends V2 {
        public String a5 = "5";
        public String a6 = "6";
    }

    public static class V2
    extends V {
        public String a3 = "3";
        public String a4 = "4";
    }

    public static class V {
        public String a1 = "1";
        public String a2 = "2";
    }

    @BeanConfig(applyBeanIgnore={@BeanIgnore(on="Uc.getB,Uc.c,Uc.getD,Uc.setD")})
    public static class Uc {
        public String a;
        public String b;
        @BeanIgnore
        public String c;

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        @BeanIgnore
        public String getB() {
            return this.b;
        }

        public void setB(String b) {
            this.b = b + "(setter)";
        }

        @BeanIgnore
        public String getD() {
            return null;
        }

        @BeanIgnore
        public void setD(String d) {
        }
    }

    public static class U {
        public String a;
        public String b;
        @BeanIgnore
        public String c;

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        @BeanIgnore
        public String getB() {
            return this.b;
        }

        public void setB(String b) {
            this.b = b + "(setter)";
        }

        @BeanIgnore
        public String getD() {
            return null;
        }

        @BeanIgnore
        public void setD(String d) {
        }
    }

    public static enum TEnum {
        ONE,
        TWO,
        THREE;

    }

    public static class S {
        public R1 f1;
    }

    public static class R2
    extends R1 {
        public int f2;
    }

    public static class R1 {
        public int f1;
    }

    public static class Q2
    extends Q1 {
        private int f1;
        private int f2;
        private int f3;

        public Q1 setF1(int f1) {
            this.f1 = f1;
            return this;
        }

        public Q2 setF2(int f2) {
            this.f2 = f2;
            return this;
        }

        public String setF3(int f3) {
            this.f3 = f3;
            return null;
        }

        public int getF1() {
            return this.f1;
        }

        public int getF2() {
            return this.f2;
        }

        public int getF3() {
            return this.f3;
        }
    }

    public static class Q1 {
    }

    @Bean(propertyNamer=PropertyNamerDLC.class)
    public static class P2 {
        private int fooBar;
        private int bazBING;

        public int getFooBar() {
            return this.fooBar;
        }

        public void setFooBar(int fooBar) {
            this.fooBar = fooBar;
        }

        public int getBazBING() {
            return this.bazBING;
        }

        public void setBazBING(int bazBING) {
            this.bazBING = bazBING;
        }
    }

    @BeanConfig(applyBean={@Bean(on="P1c", propertyNamer=PropertyNamerDLC.class)})
    public static class P1c {
        public int foo;
        public int barBaz;
        public int bingBooURL;
    }

    @Bean(propertyNamer=PropertyNamerDLC.class)
    public static class P1 {
        public int foo;
        public int barBaz;
        public int bingBooURL;
    }

    public static class O {
        public int foo;
    }

    public static class N5
    extends N4<Integer> {
        public N5() {
            this.setX(4);
        }
    }

    public static class N4<T extends Number>
    extends N1<T> {
        public N4() {
            this.setX(new Integer(3));
        }
    }

    public static class N3
    extends N2 {
        public N3() {
            this.setX(2);
        }
    }

    public static class N2
    extends N1<Integer> {
        public N2() {
            this.setX(1);
        }
    }

    public static class N1<T> {
        private T x;

        public void setX(T x) {
            this.x = x;
        }

        public T getX() {
            return this.x;
        }
    }

    public static class M5
    extends M4<Integer> {
        public M5() {
            this.x = new Integer(4);
        }
    }

    public static class M4<T extends Number>
    extends M1<T> {
        public M4() {
            this.x = new Integer(3);
        }
    }

    public static class M3
    extends M2 {
        public M3() {
            this.x = 2;
        }
    }

    public static class M2
    extends M1<Integer> {
        public M2() {
            this.x = 1;
        }
    }

    public static class M1<T> {
        public T x;
    }

    public static class L2 {
        public String name;
        public String value;

        public L2() {
        }

        public L2(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class L1
    extends LinkedList<L2> {
    }

    public static class L {
        public L1 list;
    }

    public static class K {
        @Beanp(params={Float.class})
        public List<String> p1;
        @Beanp(params={Float.class})
        public List<? extends Integer> p3;
        @Beanp(params={String.class, Float.class})
        public Map<String, Integer> p4;
        @Beanp(params={String.class, Float.class})
        public Map<String, ? extends Integer> p6;

        @Beanp(params={Float.class})
        public List<Integer> getP2() {
            return null;
        }

        @Beanp(params={String.class, Float.class})
        public Map<String, Integer> getP5() {
            return null;
        }
    }

    public static class J {
        @Beanp(params={Float.class})
        public List<String> p1;
        @Beanp(params={Float.class})
        public List<? extends Integer> p3;
        @Beanp(params={Object.class, Float.class})
        public Map<String, Integer> p4;
        @Beanp(params={String.class, Float.class})
        public Map<String, ? extends Integer> p6;

        @Beanp(params={Float.class})
        public List<Integer> getP2() {
            return null;
        }

        @Beanp(params={Object.class, Float.class})
        public Map<String, Integer> getP5() {
            return null;
        }
    }

    public static class I {
        public List<String> p1;
        public List<? extends Integer> p3;
        public Map<String, Integer> p4;
        public Map<String, ? extends Integer> p6;

        public List<Integer> getP2() {
            return null;
        }

        public Map<String, Integer> getP5() {
            return null;
        }
    }

    @Bean(typeName="H")
    public static class H {
        public HEnum enum1;
        private HEnum enum2;

        public HEnum getEnum2() {
            return this.enum2;
        }

        public void setEnum2(HEnum enum2) {
            this.enum2 = enum2;
        }
    }

    public static enum HEnum {
        ONE,
        TWO,
        THREE;

    }

    public static class G1 {
        public List<G> l1;
        public List<G> l2 = new LinkedList<G>();
        @Beanp(type=List.class, params={G.class})
        public List<G> l3;
        @Beanp(type=LinkedList.class, params={G.class})
        public List<G> l4;
        private List<G> m1;
        private List<G> m2 = new LinkedList<G>();
        private List<G> m3;
        private List<G> m4;
        @Beanp(type=LinkedList.class, params={G.class})
        private List<G> m5;

        public List<G> getM1() {
            return this.m1;
        }

        public void setM1(List<G> m1) {
            this.m1 = m1;
        }

        public List<G> getM2() {
            return this.m2;
        }

        public void setM2(List<G> m2) {
            this.m2 = m2;
        }

        @Beanp(type=List.class, params={G.class})
        public List<G> getM3() {
            return this.m3;
        }

        public void setM3(List<G> m3) {
            this.m3 = m3;
        }

        @Beanp(type=LinkedList.class, params={G.class})
        public List<G> getM4() {
            return this.m4;
        }

        public void setM4(List<G> m4) {
            this.m4 = m4;
        }

        public List<G> getM5() {
            return this.m5;
        }

        public void setM5(List<G> m5) {
            this.m5 = m5;
        }
    }

    public static class G {
        public String a;
        public int i;
    }

    public static class F {
        public String prop;

        public boolean doSetAProperty(String prop) {
            this.prop = prop;
            return true;
        }
    }

    @Bean(bpi="s,s2,i,i2")
    public static class E {
        public String[] s;
        public String[][] s2;
        public int[] i;
        public int[][] i2;
    }

    public static class D2c {
        public String s = "default";
    }

    @BeanConfig(applyBean={@Bean(on="D2c", typeName="D2")})
    public static class D1c {
        public D2c b;
        public List<D2c> lb1;
        public List<D2c> lb2 = new ArrayList<D2c>();
        public D2c[] ab1;
        public D2c[] ab2 = new D2c[0];
    }

    @Bean(typeName="D2")
    public static class D2 {
        public String s = "default";
    }

    public static class D1 {
        public D2 b;
        public List<D2> lb1;
        public List<D2> lb2 = new ArrayList<D2>();
        public D2[] ab1;
        public D2[] ab2 = new D2[0];
    }

    public static class D {
        private List l1;
        private ArrayList al1;
        private LinkedList ll1;
        private Collection c1;
        private Map m1;
        private HashMap hm1;
        private ObjectMap jm1;
        private TreeMap tm1;
        private ObjectList jl1;
        private List l2 = new ArrayList();
        private ArrayList al2 = new ArrayList();
        private LinkedList ll2 = new LinkedList();
        private Collection c2 = new ArrayList();
        private Map m2 = new HashMap();
        private HashMap hm2 = new HashMap();
        private TreeMap tm2 = new TreeMap();
        private ObjectMap jm2 = new ObjectMap();
        private ObjectList jl2 = new ObjectList();

        public List getL1() {
            return this.l1;
        }

        public void setL1(List l1) {
            this.l1 = l1;
        }

        public ArrayList getAl1() {
            return this.al1;
        }

        public void setAl1(ArrayList al1) {
            this.al1 = al1;
        }

        public LinkedList getLl1() {
            return this.ll1;
        }

        public void setLl1(LinkedList ll1) {
            this.ll1 = ll1;
        }

        public Collection getC1() {
            return this.c1;
        }

        public void setC1(Collection c1) {
            this.c1 = c1;
        }

        public Map getM1() {
            return this.m1;
        }

        public void setM1(Map m1) {
            this.m1 = m1;
        }

        public HashMap getHm1() {
            return this.hm1;
        }

        public void setHm1(HashMap hm1) {
            this.hm1 = hm1;
        }

        public ObjectMap getJm1() {
            return this.jm1;
        }

        public void setJm1(ObjectMap jm1) {
            this.jm1 = jm1;
        }

        public TreeMap getTm1() {
            return this.tm1;
        }

        public void setTm1(TreeMap tm1) {
            this.tm1 = tm1;
        }

        public ObjectList getJl1() {
            return this.jl1;
        }

        public void setJl1(ObjectList jl1) {
            this.jl1 = jl1;
        }

        public List getL2() {
            return this.l2;
        }

        public void setL2(List l2) {
            this.l2 = l2;
        }

        public ArrayList getAl2() {
            return this.al2;
        }

        public void setAl2(ArrayList al2) {
            this.al2 = al2;
        }

        public LinkedList getLl2() {
            return this.ll2;
        }

        public void setLl2(LinkedList ll2) {
            this.ll2 = ll2;
        }

        public Collection getC2() {
            return this.c2;
        }

        public void setC2(Collection c2) {
            this.c2 = c2;
        }

        public Map getM2() {
            return this.m2;
        }

        public void setM2(Map m2) {
            this.m2 = m2;
        }

        public HashMap getHm2() {
            return this.hm2;
        }

        public void setHm2(HashMap hm2) {
            this.hm2 = hm2;
        }

        public TreeMap getTm2() {
            return this.tm2;
        }

        public void setTm2(TreeMap tm2) {
            this.tm2 = tm2;
        }

        public ObjectMap getJm2() {
            return this.jm2;
        }

        public void setJm2(ObjectMap jm2) {
            this.jm2 = jm2;
        }

        public ObjectList getJl2() {
            return this.jl2;
        }

        public void setJl2(ObjectList jl2) {
            this.jl2 = jl2;
        }
    }

    public static class C {
        public List l1;
        public ArrayList al1;
        public LinkedList ll1;
        public Collection c1;
        public Map m1;
        public HashMap hm1;
        public ObjectMap jm1;
        public TreeMap tm1;
        public ObjectList jl1;
        public List l2 = new ArrayList();
        public ArrayList al2 = new ArrayList();
        public LinkedList ll2 = new LinkedList();
        public Collection c2 = new ArrayList();
        public Map m2 = new HashMap();
        public HashMap hm2 = new HashMap();
        public TreeMap tm2 = new TreeMap();
        public ObjectMap jm2 = new ObjectMap();
        public ObjectList jl2 = new ObjectList();
    }

    public static class B {
        private int i1;
        private Integer i2;
        private short s1;
        private Short s2;
        private long l1;
        private Long l2;
        private double d1;
        private Double d2;
        private float f1;
        private Float f2;
        private boolean b1;
        private Boolean b2;

        public int getI1() {
            return this.i1;
        }

        public void setI1(int i1) {
            this.i1 = i1;
        }

        public Integer getI2() {
            return this.i2;
        }

        public void setI2(Integer i2) {
            this.i2 = i2;
        }

        public short getS1() {
            return this.s1;
        }

        public void setS1(short s1) {
            this.s1 = s1;
        }

        public Short getS2() {
            return this.s2;
        }

        public void setS2(Short s2) {
            this.s2 = s2;
        }

        public long getL1() {
            return this.l1;
        }

        public void setL1(long l1) {
            this.l1 = l1;
        }

        public Long getL2() {
            return this.l2;
        }

        public void setL2(Long l2) {
            this.l2 = l2;
        }

        public double getD1() {
            return this.d1;
        }

        public void setD1(double d1) {
            this.d1 = d1;
        }

        public Double getD2() {
            return this.d2;
        }

        public void setD2(Double d2) {
            this.d2 = d2;
        }

        public float getF1() {
            return this.f1;
        }

        public void setF1(float f1) {
            this.f1 = f1;
        }

        public Float getF2() {
            return this.f2;
        }

        public void setF2(Float f2) {
            this.f2 = f2;
        }

        public boolean getB1() {
            return this.b1;
        }

        public void setB1(boolean b1) {
            this.b1 = b1;
        }

        public Boolean getB2() {
            return this.b2;
        }

        public void setB2(Boolean b2) {
            this.b2 = b2;
        }
    }

    public static class A {
        public int i1;
        public Integer i2;
        public short s1;
        public Short s2;
        public long l1;
        public Long l2;
        public double d1;
        public Double d2;
        public float f1;
        public Float f2;
        public boolean b1;
        public Boolean b2;
    }

    public static class MyBeanDictionaryMap
    extends BeanDictionaryMap {
        public MyBeanDictionaryMap() {
            this.addClass("StringArray", String[].class);
            this.addClass("String2dArray", String[][].class);
            this.addClass("IntArray", int[].class);
            this.addClass("Int2dArray", int[][].class);
            this.addClass("S", S.class);
            this.addClass("R1", R1.class);
            this.addClass("R2", R2.class);
            this.addClass("LinkedList", LinkedList.class);
            this.addClass("TreeMap", TreeMap.class);
            this.addCollectionClass("LinkedListOfInts", LinkedList.class, Integer.class);
            this.addCollectionClass("LinkedListOfR1", LinkedList.class, R1.class);
            this.addCollectionClass("LinkedListOfCalendar", LinkedList.class, Calendar.class);
        }
    }
}

