/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Beanp;
import org.junit.Assert;
import org.junit.Test;

public class BeanMapErrorsTest {
    @Test
    public void beanPropertyMethodNotInBeanProperties() {
        BeanContext bc = BeanContext.DEFAULT;
        try {
            bc.getClassMeta(A1.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapErrorsTest$A1: Found @Beanp(\"f2\") but name was not found in @Bean(properties)", (Object)e.getMessage());
        }
    }

    @Test
    public void beanPropertyMethodNotInBeanProperties_usingConfig() {
        BeanContext bc = BeanContext.create().applyAnnotations(new Class[]{B1.class}).build();
        try {
            bc.getClassMeta(B1.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapErrorsTest$B1: Found @Beanp(\"f2\") but name was not found in @Bean(properties)", (Object)e.getMessage());
        }
    }

    @Test
    public void beanPropertyFieldNotInBeanProperties() {
        BeanContext bc = BeanContext.DEFAULT;
        try {
            bc.getClassMeta(A2.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapErrorsTest$A2: Found @Beanp(\"f2\") but name was not found in @Bean(properties)", (Object)e.getMessage());
        }
    }

    @Test
    public void beanPropertyFieldNotInBeanProperties_usingBeanConfig() {
        BeanContext bc = BeanContext.create().applyAnnotations(new Class[]{B2.class}).build();
        try {
            bc.getClassMeta(B2.class);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"org.apache.juneau.BeanMapErrorsTest$B2: Found @Beanp(\"f2\") but name was not found in @Bean(properties)", (Object)e.getMessage());
        }
    }

    @BeanConfig(applyBean={@Bean(on="B2", bpi="f1")}, applyBeanp={@Beanp(on="B2.f2", value="f2")})
    public static class B2 {
        public int f1;
        public int f2;
    }

    @Bean(bpi="f1")
    public static class A2 {
        public int f1;
        @Beanp(value="f2")
        public int f2;
    }

    @BeanConfig(applyBean={@Bean(on="B1", bpi="f1")}, applyBeanp={@Beanp(on="B1.f2", value="f2")})
    public static class B1 {
        public int f1;

        public int f2() {
            return -1;
        }
    }

    @Bean(bpi="f1")
    public static class A1 {
        public int f1;

        @Beanp(value="f2")
        public int f2() {
            return -1;
        }
    }
}

