/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.LinkedList;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.junit.Assert;
import org.junit.Test;

public class BeanFilterTest {
    @Test
    public void testSubTypes() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().build();
        JsonParser p = JsonParser.DEFAULT;
        A1 a1 = new A1();
        a1.f1 = "f1";
        a1.fb = new B2();
        ((B2)a1.fb).f2 = "f2";
        String r = s.serialize((Object)a1);
        Assert.assertEquals((Object)"{_type:'A1',f0:'f0',fb:{_type:'B2',f0b:'f0b',f2:'f2'},f1:'f1'}", (Object)r);
        A a = (A)p.parse(r, A.class);
        Assert.assertTrue((boolean)(a instanceof A1));
        Assert.assertTrue((boolean)(a.fb instanceof B2));
        Assert.assertEquals((Object)"f1", (Object)((A1)a).f1);
        Assert.assertEquals((Object)"f2", (Object)((B2)a.fb).f2);
        r = "{f0:'f0',f1:'f1',_type:'A1',fb:{f0b:'f0b',f2:'f2',_type:'B2'}}";
        a = (A)p.parse(r, A.class);
        Assert.assertTrue((boolean)(a instanceof A1));
        Assert.assertTrue((boolean)(a.fb instanceof B2));
        Assert.assertEquals((Object)"f1", (Object)((A1)a).f1);
        Assert.assertEquals((Object)"f2", (Object)((B2)a.fb).f2);
    }

    @Test
    public void testSubTypes_usingConfig() throws Exception {
        JsonSerializer s = SimpleJsonSerializer.DEFAULT.builder().addBeanTypes().addRootType().applyAnnotations(new Class[]{E.class}).build();
        JsonParser p = JsonParser.create().applyAnnotations(new Class[]{E1.class}).build();
        E1 e1 = new E1();
        e1.f1 = "f1";
        e1.fb = new F2();
        ((F2)e1.fb).f2 = "f2";
        String r = s.serialize((Object)e1);
        Assert.assertEquals((Object)"{_type:'E1',f0:'f0',fb:{_type:'F2',f0b:'f0b',f2:'f2'},f1:'f1'}", (Object)r);
        E e = (E)p.parse(r, E.class);
        Assert.assertTrue((boolean)(e instanceof E1));
        Assert.assertTrue((boolean)(e.fb instanceof F2));
        Assert.assertEquals((Object)"f1", (Object)((E1)e).f1);
        Assert.assertEquals((Object)"f2", (Object)((F2)e.fb).f2);
        r = "{f0:'f0',f1:'f1',_type:'E1',fb:{f0b:'f0b',f2:'f2',_type:'F2'}}";
        e = (E)p.parse(r, E.class);
        Assert.assertTrue((boolean)(e instanceof E1));
        Assert.assertTrue((boolean)(e.fb instanceof F2));
        Assert.assertEquals((Object)"f1", (Object)((E1)e).f1);
        Assert.assertEquals((Object)"f2", (Object)((F2)e.fb).f2);
    }

    @Test
    public void testParentClassFilter() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().beanFilters(new Class[]{C1.class}).build();
        C2 c1 = new C2();
        String r = s.serialize((Object)c1);
        Assert.assertEquals((Object)"{f0:'f0'}", (Object)r);
        LinkedList<C2> l = new LinkedList<C2>();
        l.add(new C2());
        r = s.serialize(l);
        Assert.assertEquals((Object)"[{f0:'f0'}]", (Object)r);
    }

    @Test
    public void testParentClassFilter2() throws Exception {
        JsonSerializer s = JsonSerializer.create().ssq().beanFilters(new Class[]{D1.class}).build();
        D2 d1 = new D2();
        String r = s.serialize((Object)d1);
        Assert.assertEquals((Object)"{f0:'f0'}", (Object)r);
        LinkedList<D2> l = new LinkedList<D2>();
        l.add(new D2());
        r = s.serialize(l);
        Assert.assertEquals((Object)"[{f0:'f0'}]", (Object)r);
    }

    public class D2
    extends D1 {
        public String f1;

        public D2() {
            this.f1 = "f1";
        }
    }

    public class D1 {
        public String f0 = "f0";
    }

    public static class C2
    extends C1 {
        public String f1 = "f1";
    }

    public static class C1 {
        public String f0 = "f0";
    }

    public static class F2
    extends F {
        public String f2;
    }

    public static class F1
    extends F {
        public String f1;
    }

    public static abstract class F {
        public String f0b = "f0b";
    }

    public static class E2
    extends E {
        public String f2;
    }

    public static class E1
    extends E {
        public String f1;
    }

    @BeanConfig(applyBean={@Bean(on="E", dictionary={E1.class, E2.class}), @Bean(on="E1", typeName="E1"), @Bean(on="E2", typeName="E2"), @Bean(on="F", dictionary={F1.class, F2.class}), @Bean(on="F1", typeName="F1"), @Bean(on="F2", typeName="F2")})
    public static abstract class E {
        public String f0 = "f0";
        public F fb;
    }

    @Bean(typeName="B2")
    public static class B2
    extends B {
        public String f2;
    }

    @Bean(typeName="B1")
    public static class B1
    extends B {
        public String f1;
    }

    @Bean(dictionary={B1.class, B2.class})
    public static abstract class B {
        public String f0b = "f0b";
    }

    @Bean(typeName="A2")
    public static class A2
    extends A {
        public String f2;
    }

    @Bean(typeName="A1")
    public static class A1
    extends A {
        public String f1;
    }

    @Bean(dictionary={A1.class, A2.class})
    public static abstract class A {
        public String f0 = "f0";
        public B fb;
    }
}

