/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.junit.Assert;
import org.junit.Test;

public class BeanContextTest {
    BeanContext bc = BeanContext.DEFAULT;

    @Test
    public void normalCachableBean() throws ExecutableException {
        ClassMeta cm2;
        ClassMeta cm1 = this.bc.getClassMeta(A1.class);
        Assert.assertTrue((cm1 == (cm2 = this.bc.getClassMeta(A1.class)) ? 1 : 0) != 0);
    }

    @Test
    public void lambdaExpressionsNotCached() throws ExecutableException {
        ClassMeta cm2;
        BeanContext bc = BeanContext.DEFAULT;
        A2 fi = x -> System.out.println(x);
        ClassMeta cm1 = bc.getClassMeta(fi.getClass());
        Assert.assertTrue((cm1 != (cm2 = bc.getClassMeta(fi.getClass())) ? 1 : 0) != 0);
    }

    @Test
    public void proxiesNotCached() throws ExecutableException {
        ClassMeta cm2;
        A1 a1 = (A1)this.bc.createBeanSession().getBeanMeta(A1.class).newBean(null);
        ClassMeta cm1 = this.bc.getClassMeta(a1.getClass());
        Assert.assertTrue((cm1 != (cm2 = this.bc.getClassMeta(a1.getClass())) ? 1 : 0) != 0);
    }

    static interface A2 {
        public void foo(int var1);
    }

    public static interface A1 {
        public int getF1();

        public void setF1(int var1);
    }
}

