/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonParserBuilder;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.MapSwap;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;
import org.junit.Test;

public class BeanConfigTest {
    @Test
    public void testBasic() throws Exception {
        BeanMap bm4;
        BeanMap m4;
        BeanMap bm3;
        BeanSession session = BeanContext.DEFAULT.createSession();
        Person p1 = new Person();
        p1.setName("John Doe");
        p1.setAge(25);
        Address a = new Address("101 Main St.", "Las Vegas", "NV", "89101");
        AddressablePerson p2 = new AddressablePerson();
        p2.setName("Jane Doe");
        p2.setAge(21);
        p2.setAddress(a);
        LinkedHashMap<String, Object> m1 = new LinkedHashMap<String, Object>();
        m1.put("name", p1.getName());
        m1.put("age", new Integer(p1.getAge()));
        LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>();
        m2.put("street", a.getStreet());
        m2.put("city", a.getCity());
        m2.put("state", a.getState());
        m2.put("zip", a.getZip());
        LinkedHashMap<String, Object> m3 = new LinkedHashMap<String, Object>();
        m3.put("name", p2.getName());
        m3.put("age", new Integer(p2.getAge()));
        m3.put("address", p2.getAddress());
        BeanMap pm1 = session.toBeanMap((Object)p1);
        if (pm1.size() != m1.size()) {
            Assert.fail((String)("Bean Map size failed for: " + p1 + " / " + pm1.size() + " / " + m1.size()));
        }
        if (!pm1.keySet().equals(m1.keySet())) {
            Assert.fail((String)("Bean Map key set equality failed for: " + p1 + " / " + pm1.keySet() + " / " + m1.keySet()));
        }
        if (!m1.keySet().equals(pm1.keySet())) {
            Assert.fail((String)("Bean Map key set reverse equality failed for: " + p1 + " / " + pm1.keySet() + " / " + m1.keySet()));
        }
        if (!pm1.equals(m1)) {
            Assert.fail((String)("Bean Map equality failed for: " + p1 + " / " + pm1 + " / " + m1));
        }
        if (!m1.equals(pm1)) {
            Assert.fail((String)("Bean Map reverse equality failed for: " + p1 + " / " + pm1 + " / " + m1));
        }
        BeanMap bm1 = null;
        try {
            bm1 = session.newBeanMap(Address.class);
            Assert.fail((String)"Address returned as a new bean type, but shouldn't be since it doesn't have a default constructor.");
        }
        catch (BeanRuntimeException beanRuntimeException) {
            // empty catch block
        }
        bm1 = session.toBeanMap((Object)new Address("street", "city", "state", "zip"));
        BeanMap bm2 = session.newBeanMap(Integer.class);
        if (bm2 != null) {
            Assert.fail((String)"java.lang.Integer incorrectly desingated as bean type.");
        }
        if ((bm3 = session.newBeanMap(Class.class)) != null) {
            Assert.fail((String)"java.lang.Class incorrectly desingated as bean type.");
        }
        if ((m4 = bm1).keySet().size() != m2.size()) {
            Assert.fail((String)("Bean Adapter map's key set has wrong size: " + a + " / " + m4.keySet().size() + " / " + m2.size()));
        }
        Iterator<Object> iter = m4.keySet().iterator();
        HashSet<Object> temp = new HashSet<Object>();
        int count = 0;
        while (iter.hasNext()) {
            temp.add(iter.next());
            ++count;
        }
        if (count != m2.size()) {
            Assert.fail((String)("Iteration count over bean adpater key set failed: " + a + " / " + count + " / " + m2.size()));
        }
        if (!m2.keySet().equals(temp)) {
            Assert.fail((String)("Iteration over bean adpater key set failed: " + a + " / " + m4.keySet() + " / " + m2.keySet()));
        }
        if ((bm4 = session.toBeanMap((Object)p2)) == null) {
            Assert.fail((String)("Failed to identify class as bean type: " + p2.getClass()));
            return;
        }
        BeanMap m5 = bm4;
        Set es1 = m5.entrySet();
        if (!es1.equals(m3.entrySet())) {
            Assert.fail((String)("Entry set equality failed: " + p2 + " / " + es1 + " / " + m3.entrySet()));
        }
        if (!m3.entrySet().equals(es1)) {
            Assert.fail((String)("Entry set reverse equality failed: " + p2 + " / " + es1 + " / " + m3.entrySet()));
        }
        iter = es1.iterator();
        temp = new HashSet();
        count = 0;
        while (iter.hasNext()) {
            temp.add(iter.next());
            ++count;
        }
        if (count != m3.size()) {
            Assert.fail((String)("Iteration count over bean adpater entry set failed: " + a + " / " + count + " / " + m3.size()));
        }
        if (!m3.entrySet().equals(temp)) {
            Assert.fail((String)("Iteration over bean adpater entry set failed: " + a + " / " + es1 + " / " + m3.entrySet()));
        }
    }

    @Test
    public void testBeanContextConvertToType() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        Object[] o = null;
        Assert.assertEquals((Object)new Integer(0), (Object)session.convertToType(o, Integer.TYPE));
        Assert.assertEquals((Object)new Short(0), (Object)session.convertToType(o, Short.TYPE));
        Assert.assertEquals((Object)new Long(0L), (Object)session.convertToType(o, Long.TYPE));
        Assert.assertEquals((Object)new Float(0.0f), (Object)session.convertToType(o, Float.TYPE));
        Assert.assertEquals((Object)new Double(0.0), (Object)session.convertToType(o, Double.TYPE));
        Assert.assertEquals((Object)new Byte(0), (Object)session.convertToType(o, Byte.TYPE));
        Assert.assertEquals((Object)new Character('\u0000'), (Object)session.convertToType(o, Character.TYPE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)session.convertToType(o, Boolean.TYPE));
        o = "1";
        Assert.assertEquals((Object)new Integer(1), (Object)session.convertToType((Object)o, Integer.class));
        Assert.assertEquals((Object)new Short(1), (Object)session.convertToType((Object)o, Short.class));
        Assert.assertEquals((Object)new Long(1L), (Object)session.convertToType((Object)o, Long.class));
        Assert.assertEquals((Object)new Float(1.0f), (Object)session.convertToType((Object)o, Float.class));
        Assert.assertEquals((Object)new Double(1.0), (Object)session.convertToType((Object)o, Double.class));
        Assert.assertEquals((Object)new Byte(1), (Object)session.convertToType((Object)o, Byte.class));
        Assert.assertEquals((Object)new Character('1'), (Object)session.convertToType((Object)o, Character.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)session.convertToType((Object)o, Boolean.class));
        Assert.assertEquals((Object)new Integer(1), (Object)session.convertToType((Object)o, Integer.TYPE));
        Assert.assertEquals((Object)new Short(1), (Object)session.convertToType((Object)o, Short.TYPE));
        Assert.assertEquals((Object)new Long(1L), (Object)session.convertToType((Object)o, Long.TYPE));
        Assert.assertEquals((Object)new Float(1.0f), (Object)session.convertToType((Object)o, Float.TYPE));
        Assert.assertEquals((Object)new Double(1.0), (Object)session.convertToType((Object)o, Double.TYPE));
        Assert.assertEquals((Object)new Byte(1), (Object)session.convertToType((Object)o, Byte.TYPE));
        Assert.assertEquals((Object)new Character('1'), (Object)session.convertToType((Object)o, Character.TYPE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)session.convertToType((Object)o, Boolean.TYPE));
        o = new Integer(1);
        Assert.assertEquals((Object)new Integer(1), (Object)session.convertToType((Object)o, Integer.TYPE));
        Assert.assertEquals((Object)new Short(1), (Object)session.convertToType((Object)o, Short.TYPE));
        Assert.assertEquals((Object)new Long(1L), (Object)session.convertToType((Object)o, Long.TYPE));
        Assert.assertEquals((Object)new Float(1.0f), (Object)session.convertToType((Object)o, Float.TYPE));
        Assert.assertEquals((Object)new Double(1.0), (Object)session.convertToType((Object)o, Double.TYPE));
        Assert.assertEquals((Object)new Byte(1), (Object)session.convertToType((Object)o, Byte.TYPE));
        Assert.assertEquals((Object)new Character('1'), (Object)session.convertToType((Object)o, Character.TYPE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)session.convertToType((Object)o, Boolean.TYPE));
        o = new Integer(0);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)session.convertToType((Object)o, Boolean.TYPE));
        o = "{name:'x',age:123}";
        Assert.assertEquals((Object)"x", (Object)((Person)session.convertToType((Object)o, Person.class)).getName());
        Assert.assertEquals((long)123L, (long)((Person)session.convertToType((Object)o, Person.class)).getAge());
        o = "{name:'x',age:123}";
        Assert.assertEquals((Object)"x", (Object)((ReadOnlyPerson)session.convertToType((Object)o, ReadOnlyPerson.class)).getName());
        Assert.assertEquals((long)123L, (long)((ReadOnlyPerson)session.convertToType((Object)o, ReadOnlyPerson.class)).getAge());
        o = UUID.randomUUID();
        Assert.assertEquals((Object)o, (Object)session.convertToType((Object)o.toString(), UUID.class));
        o = "xxx";
        File file = (File)session.convertToType((Object)o, File.class);
        Assert.assertEquals((Object)"xxx", (Object)file.getName());
        o = new ObjectList(new Object[]{1, 2, 3});
        Assert.assertEquals((long)1L, (long)((int[])session.convertToType((Object)o, int[].class))[0]);
        o = new ObjectList(new Object[]{new ReadOnlyPerson("x", 123)});
        Assert.assertEquals((Object)"x", (Object)((ReadOnlyPerson[])session.convertToType((Object)o, ReadOnlyPerson[].class))[0].getName());
        o = new ObjectList().append(new Object[]{new ObjectList(new Object[]{new ReadOnlyPerson("x", 123)})});
        Assert.assertEquals((Object)"x", (Object)((ReadOnlyPerson[][])session.convertToType((Object)o, ReadOnlyPerson[][].class))[0][0].getName());
        o = new String[]{"1", "2", "3"};
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer[])session.convertToType((Object)o, Integer[].class))[0]);
        Assert.assertEquals((long)1L, (long)((int[])session.convertToType((Object)o, int[].class))[0]);
        o = new Integer[]{1, 2, 3};
        Assert.assertEquals((Object)new Integer(1), ((LinkedList)session.convertToType((Object)o, LinkedList.class)).get(0));
        o = AMap.create((Object)1, (Object)"foo");
        Assert.assertEquals((Object)"foo", ((TreeMap)session.convertToType((Object)o, TreeMap.class)).firstEntry().getValue());
        o = "{1:'foo'}";
        Assert.assertEquals((Object)"foo", ((TreeMap)session.convertToType((Object)o, TreeMap.class)).firstEntry().getValue());
        Assert.assertEquals((Object)"foo", ((Map)session.convertToType((Object)o, Map.class)).values().iterator().next());
        o = new Object[]{"a", 1, false};
        Assert.assertEquals((Object)"['a',1,false]", (Object)session.convertToType((Object)o, String.class));
        o = new Object[][]{{"a", 1, false}};
        Assert.assertEquals((Object)"[['a',1,false]]", (Object)session.convertToType((Object)o, String.class));
    }

    @Test
    public void testReadOnlyProperties() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        ReadOnlyPerson o = new ReadOnlyPerson("x", 123);
        Assert.assertEquals((Object)"{name:'x',age:123}", (Object)session.convertToType((Object)o, String.class));
        o = new ObjectList(new Object[]{new ObjectMap((CharSequence)"{name:'x',age:1}"), new ObjectMap((CharSequence)"{name:'y',age:2}")});
        Assert.assertEquals((long)1L, (long)((ReadOnlyPerson[])session.convertToType((Object)o, ReadOnlyPerson[].class))[0].getAge());
    }

    @Test
    public void testReadOnlyProperties_usingConfig() throws Exception {
        BeanSession session = BeanContext.DEFAULT.builder().applyAnnotations(new Class[]{ReadOnlyPerson2.class}).build().createSession();
        ReadOnlyPerson2 o = new ReadOnlyPerson2("x", 123);
        Assert.assertEquals((Object)"{name:'x',age:123}", (Object)session.convertToType((Object)o, String.class));
        o = new ObjectList(new Object[]{new ObjectMap((CharSequence)"{name:'x',age:1}"), new ObjectMap((CharSequence)"{name:'y',age:2}")});
        Assert.assertEquals((long)1L, (long)((ReadOnlyPerson2[])session.convertToType((Object)o, ReadOnlyPerson2[].class))[0].getAge());
    }

    @Test
    public void testEnums() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        String[] o = "ENUM2";
        Assert.assertEquals((Object)((Object)TestEnum.ENUM2), (Object)session.convertToType((Object)o, TestEnum.class));
        Assert.assertEquals((Object)"ENUM2", (Object)session.convertToType((Object)TestEnum.ENUM2, String.class));
        o = new String[]{"ENUM2"};
        Assert.assertEquals((Object)((Object)TestEnum.ENUM2), (Object)((Object)((TestEnum[])session.convertToType((Object)o, TestEnum[].class))[0]));
    }

    @Test
    public void testProxyHandler() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createBeanSession();
        A f1 = (A)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{A.class}, (InvocationHandler)new AHandler());
        BeanMap bm1 = session.toBeanMap((Object)f1);
        if (bm1 == null) {
            Assert.fail((String)("Failed to obtain bean adapter for proxy: " + f1));
            return;
        }
        BeanMap bm2 = session.newBeanMap(A.class);
        if (bm2 == null) {
            Assert.fail((String)("Failed to create dynamic proxy bean for interface: " + A.class.getName()));
            return;
        }
        bm2.put("a", (Object)"Hello");
        bm2.put("b", (Object)new Integer(50));
        f1.setA("Hello");
        f1.setB(50);
        if (!bm2.get((Object)"a").equals("Hello")) {
            Assert.fail((String)("Failed to set string property 'a' on dynamic proxy bean.  " + bm2));
        }
        if (!bm2.get((Object)"b").equals(new Integer(50))) {
            Assert.fail((String)("Failed to set string property 'b' on dynamic proxy bean.  " + bm2));
        }
        if (!bm1.equals((Object)bm2)) {
            Assert.fail((String)("Failed equality test of dynamic proxies beans: " + bm1 + " / " + bm2));
        }
        if (!bm2.equals((Object)bm1)) {
            Assert.fail((String)("Failed reverse equality test of dynamic proxies beans: " + bm1 + " / " + bm2));
        }
    }

    @Test
    public void testFluentStyleSetters() throws Exception {
        B2 t = new B2().init();
        BeanMap m = BeanContext.DEFAULT.createSession().toBeanMap((Object)t);
        m.put("f1", (Object)2);
        Assert.assertEquals((long)t.f1, (long)2L);
    }

    @Test
    public void testClassMetaCaching() throws Exception {
        JsonParserBuilder p1 = JsonParser.create();
        JsonParserBuilder p2 = JsonParser.create();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beansRequireDefaultConstructor();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beansRequireDefaultConstructor();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beansRequireSerializable();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beansRequireSerializable();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beansRequireSettersForGetters();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beansRequireSettersForGetters();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beansRequireSomeProperties(false);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beansRequireSomeProperties(false);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanMapPutReturnsOldValue();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanMapPutReturnsOldValue();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanConstructorVisibility(Visibility.DEFAULT);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanConstructorVisibility(Visibility.DEFAULT);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanConstructorVisibility(Visibility.NONE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanConstructorVisibility(Visibility.NONE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanConstructorVisibility(Visibility.PRIVATE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanConstructorVisibility(Visibility.PRIVATE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanConstructorVisibility(Visibility.PROTECTED);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanConstructorVisibility(Visibility.PROTECTED);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanClassVisibility(Visibility.DEFAULT);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanClassVisibility(Visibility.DEFAULT);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanClassVisibility(Visibility.NONE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanClassVisibility(Visibility.NONE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanClassVisibility(Visibility.PRIVATE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanClassVisibility(Visibility.PRIVATE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanClassVisibility(Visibility.PROTECTED);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanClassVisibility(Visibility.PROTECTED);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanFieldVisibility(Visibility.DEFAULT);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanFieldVisibility(Visibility.DEFAULT);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanFieldVisibility(Visibility.NONE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanFieldVisibility(Visibility.NONE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanFieldVisibility(Visibility.PRIVATE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanFieldVisibility(Visibility.PRIVATE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanFieldVisibility(Visibility.PROTECTED);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanFieldVisibility(Visibility.PROTECTED);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanMethodVisibility(Visibility.DEFAULT);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanMethodVisibility(Visibility.DEFAULT);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanMethodVisibility(Visibility.NONE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanMethodVisibility(Visibility.NONE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanMethodVisibility(Visibility.PRIVATE);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanMethodVisibility(Visibility.PRIVATE);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanMethodVisibility(Visibility.PROTECTED);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanMethodVisibility(Visibility.PROTECTED);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.useJavaBeanIntrospector();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.useJavaBeanIntrospector();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.useInterfaceProxies(false);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.useInterfaceProxies(false);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.ignoreUnknownBeanProperties();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.ignoreUnknownBeanProperties();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.ignoreUnknownNullBeanProperties(false);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.ignoreUnknownNullBeanProperties(false);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.ignorePropertiesWithoutSetters(false);
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.ignorePropertiesWithoutSetters(false);
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.ignoreInvocationExceptionsOnGetters();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.ignoreInvocationExceptionsOnGetters();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.ignoreInvocationExceptionsOnSetters();
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.ignoreInvocationExceptionsOnSetters();
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.notBeanPackages(new String[]{"foo"});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.notBeanPackages(new String[]{"foo"});
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.notBeanPackages(new String[]{"bar"});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.notBeanPackages(new String[]{"bar"});
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.notBeanPackages(new String[]{"baz"});
        p1.notBeanPackages(new String[]{"bing"});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.notBeanPackages(new String[]{"bing"});
        p2.notBeanPackages(new String[]{"baz"});
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.notBeanPackagesRemove(new String[]{"bar"});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.notBeanPackagesRemove(new String[]{"bar"});
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.pojoSwaps(new Class[]{DummyPojoSwapA.class});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.pojoSwaps(new Class[]{DummyPojoSwapA.class});
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.pojoSwaps(new Class[]{DummyPojoSwapB.class, DummyPojoSwapC.class});
        p2.pojoSwaps(new Class[]{DummyPojoSwapC.class, DummyPojoSwapB.class});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1 = JsonParser.create();
        p2 = JsonParser.create();
        p1.beanFilters(new Class[]{DummyBeanFilterA.class});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
        p2.beanFilters(new Class[]{DummyBeanFilterA.class});
        this.assertSameCache((ParserBuilder)p1, (ParserBuilder)p2);
        p1.beanFilters(new Class[]{DummyBeanFilterB.class, DummyBeanFilterC.class});
        p2.beanFilters(new Class[]{DummyBeanFilterC.class, DummyBeanFilterB.class});
        this.assertDifferentCache((ParserBuilder)p1, (ParserBuilder)p2);
    }

    private void assertSameCache(ParserBuilder p1b, ParserBuilder p2b) {
        Parser p1 = p1b.build();
        Parser p2 = p2b.build();
        Assert.assertTrue((boolean)p1.hasSameCache((BeanContext)p2));
        Assert.assertTrue((p1.hashCode() == p2.hashCode() ? 1 : 0) != 0);
    }

    private void assertDifferentCache(ParserBuilder p1b, ParserBuilder p2b) {
        Parser p1 = p1b.build();
        Parser p2 = p2b.build();
        Assert.assertFalse((boolean)p1.hasSameCache((BeanContext)p2));
        Assert.assertFalse((p1.hashCode() == p2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNotABeanNonStaticInnerClass() throws Exception {
        BeanContext bc = BeanContext.DEFAULT;
        ClassMeta cm = bc.getClassMeta(C1.class);
        Assert.assertFalse((boolean)cm.canCreateNewInstance());
    }

    @Test(timeout=1000L)
    public void testAddingToArrayProperty() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        BeanMap bm = session.newBeanMap(D.class);
        for (int i = 0; i < 5000; ++i) {
            bm.add("f1", (Object)i);
            bm.add("f2", (Object)i);
            bm.add("f3", (Object)i);
            bm.add("f4", (Object)i);
        }
        D d = (D)bm.getBean();
        Assert.assertEquals((long)d.f1.length, (long)5000L);
        Assert.assertEquals((long)d.f2.length, (long)5000L);
        Assert.assertEquals((long)d.f3.length, (long)5003L);
        Assert.assertEquals((long)d.f4.length, (long)5003L);
    }

    @Test
    public void testClassClassMeta() throws Exception {
        ClassMeta cm = BeanContext.DEFAULT.getClassMeta(Class.class);
        Assert.assertNotNull((Object)cm);
        cm = BeanContext.DEFAULT.getClassMeta(Class[].class);
        Assert.assertNotNull((Object)cm);
    }

    @Test
    public void testBlanks() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        Assert.assertEquals((long)0L, (long)((Integer)session.convertToType((Object)"", Integer.TYPE)).intValue());
        Assert.assertNull((Object)session.convertToType((Object)"", Integer.class));
        Assert.assertEquals((Object)false, (Object)((Boolean)session.convertToType((Object)"", Boolean.TYPE)));
        Assert.assertEquals(null, (Object)session.convertToType((Object)"", Boolean.class));
    }

    public class D {
        public int[] f1;
        private int[] f2;
        public int[] f3 = new int[]{1, 2, 3};
        private int[] f4 = new int[]{1, 2, 3};

        public int[] getF2() {
            return this.f2;
        }

        public void setF2(int[] f2) {
            this.f2 = f2;
        }

        public int[] getF4() {
            return this.f4;
        }

        public void setF4(int[] f4) {
            this.f4 = f4;
        }
    }

    public class C1 {
        public int f1;
    }

    public static class C {
    }

    public static class DummyBeanFilterC
    extends BeanFilterBuilder<C> {
    }

    public static class DummyBeanFilterB
    extends BeanFilterBuilder<B> {
    }

    public static class DummyBeanFilterA
    extends BeanFilterBuilder<A> {
    }

    public static class DummyPojoSwapC
    extends MapSwap<C> {
    }

    public static class DummyPojoSwapB
    extends MapSwap<B> {
    }

    public static class DummyPojoSwapA
    extends MapSwap<A> {
    }

    public static class B2
    extends B {
        @Override
        public B2 setF1(int f1) {
            this.f1 = f1;
            return this;
        }

        public B2 init() {
            this.f1 = 1;
            return this;
        }
    }

    public static class B {
        int f1;

        public int getF1() {
            return this.f1;
        }

        public B setF1(int f1) {
            this.f1 = f1;
            return this;
        }
    }

    public static class AHandler
    implements InvocationHandler {
        private Map map = new HashMap();

        public AHandler() {
            this.map.put("a", "");
            this.map.put("b", new Integer(0));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getA")) {
                return this.map.get("a");
            }
            if (methodName.equals("setA")) {
                this.map.put("a", args[0]);
                return null;
            }
            if (methodName.equals("getB")) {
                return this.map.get("b");
            }
            if (methodName.equals("setB")) {
                this.map.put("b", args[0]);
                return null;
            }
            if (methodName.equals("toString")) {
                return this.map.toString();
            }
            return null;
        }
    }

    public static interface A {
        public String getA();

        public void setA(String var1);

        public int getB();

        public void setB(int var1);
    }

    public static enum TestEnum {
        ENUM1,
        ENUM2,
        ENUM3;

    }

    @BeanConfig(applyBean={@Bean(on="ReadOnlyPerson2", bpi="name,age")}, applyBeanc={@Beanc(on="ReadOnlyPerson2(String,int)", properties="name,age")})
    public static class ReadOnlyPerson2 {
        private final String name;
        private final int age;

        public ReadOnlyPerson2(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public String toString() {
            return "toString():name=" + this.name + ",age=" + this.age;
        }
    }

    @Bean(bpi="name,age")
    public static class ReadOnlyPerson {
        private final String name;
        private final int age;

        @Beanc(properties="name,age")
        public ReadOnlyPerson(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public String toString() {
            return "toString():name=" + this.name + ",age=" + this.age;
        }
    }

    public static class AddressablePerson
    extends Person {
        private Address address = null;

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address addr) {
            this.address = addr;
        }

        @Override
        public String toString() {
            return super.toString() + "@" + this.address;
        }
    }

    public static class Address {
        protected String street;
        protected String city;
        protected String state;
        protected String zip;

        public Address(String street, String city, String state, String zip) {
            this.street = street;
            this.city = city;
            this.state = state;
            this.zip = zip;
        }

        public String getStreet() {
            return this.street;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getZip() {
            return this.zip;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Address a = (Address)o;
            String v1 = this.getStreet();
            String v2 = a.getStreet();
            if (v1 == null ? v2 != null : !v1.equals(v2)) {
                return false;
            }
            v1 = this.getCity();
            v2 = a.getCity();
            if (v1 == null ? v2 != null : !v1.equals(v2)) {
                return false;
            }
            v1 = this.getState();
            v2 = a.getState();
            if (v1 == null ? v2 != null : !v1.equals(v2)) {
                return false;
            }
            v1 = this.getZip();
            v2 = a.getZip();
            return v1 == null ? v2 == null : v1.equals(v2);
        }

        public int hashCode() {
            int code = 0;
            if (this.street != null) {
                code ^= this.street.hashCode();
            }
            if (this.city != null) {
                code ^= this.city.hashCode();
            }
            if (this.state != null) {
                code ^= this.state.hashCode();
            }
            if (this.zip != null) {
                code ^= this.zip.hashCode();
            }
            return code;
        }

        public String toString() {
            return "Address(street: " + this.getStreet() + ", city: " + this.getCity() + ", state: " + this.getState() + ", zip: " + this.getZip() + ")";
        }
    }

    public static class Person {
        private String name = null;
        private int age = -1;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String toString() {
            return "Person(name: " + this.getName() + ", age: " + this.getAge() + ")";
        }
    }
}

