/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyNamerULC;
import org.apache.juneau.XVar;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.CC;
import org.apache.juneau.annotation.CS;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.PojoSwap;
import org.junit.Assert;
import org.junit.Test;

public class BeanConfigAnnotationTest {
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof List) {
                return ((List)t).stream().map(TO_STRING).collect(Collectors.joining(","));
            }
            if (t.getClass().isArray()) {
                return this.apply(ArrayUtils.toList((Object)t, Object.class));
            }
            if (t instanceof ObjectMap) {
                return ((ObjectMap)t).toString();
            }
            if (t instanceof Map) {
                return ((Map)t).entrySet().stream().map(TO_STRING).collect(Collectors.joining(","));
            }
            if (t instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)t;
                return this.apply(e.getKey()) + "=" + this.apply(e.getValue());
            }
            if (t instanceof BeanFilter) {
                return ((BeanFilter)t).getBeanClass().getSimpleName();
            }
            if (t instanceof Class) {
                return ((Class)t).getSimpleName();
            }
            if (t instanceof ClassInfo) {
                return ((ClassInfo)t).getSimpleName();
            }
            if (t instanceof PropertyNamer) {
                return ((PropertyNamer)t).getClass().getSimpleName();
            }
            if (t instanceof TimeZone) {
                return ((TimeZone)t).getID();
            }
            return t.toString();
        }
    };
    static VarResolverSession sr = VarResolver.create().vars(new Class[]{XVar.class}).build().createSession();
    static ClassInfo a = ClassInfo.of(A.class);
    static ClassInfo b = ClassInfo.of(B.class);
    static ClassInfo c = ClassInfo.of(C.class);

    private static void check(String expected, Object o) {
        Assert.assertEquals((Object)expected, (Object)TO_STRING.apply(o));
    }

    @Test
    public void basic() throws Exception {
        AnnotationList al = a.getAnnotationList(null);
        JsonSerializerSession bc = JsonSerializer.create().applyAnnotations(al, sr).build().createSession();
        BeanConfigAnnotationTest.check("PRIVATE", bc.getBeanClassVisibility());
        BeanConfigAnnotationTest.check("PRIVATE", bc.getBeanConstructorVisibility());
        BeanConfigAnnotationTest.check("A1,A3", bc.getBeanDictionaryClasses());
        BeanConfigAnnotationTest.check("PRIVATE", bc.getBeanFieldVisibility());
        BeanConfigAnnotationTest.check("A1,A3", bc.getBeanFilters());
        BeanConfigAnnotationTest.check("true", bc.isBeanMapPutReturnsOldValue());
        BeanConfigAnnotationTest.check("PRIVATE", bc.getBeanMethodVisibility());
        BeanConfigAnnotationTest.check("true", bc.isBeansRequireDefaultConstructor());
        BeanConfigAnnotationTest.check("true", bc.isBeansRequireSerializable());
        BeanConfigAnnotationTest.check("true", bc.isBeansRequireSettersForGetters());
        BeanConfigAnnotationTest.check("true", bc.isBeansRequireSomeProperties());
        BeanConfigAnnotationTest.check("foo", bc.getBeanTypePropertyName());
        BeanConfigAnnotationTest.check("org.apache.juneau.BeanConfigAnnotationTest$A1=[foo]", bc.getBpi());
        BeanConfigAnnotationTest.check("org.apache.juneau.BeanConfigAnnotationTest$A1=[bar]", bc.getBpx());
        BeanConfigAnnotationTest.check("org.apache.juneau.BeanConfigAnnotationTest$A1=[baz]", bc.getBpro());
        BeanConfigAnnotationTest.check("org.apache.juneau.BeanConfigAnnotationTest$A1=[qux]", bc.getBpwo());
        BeanConfigAnnotationTest.check("true", bc.isDebug());
        BeanConfigAnnotationTest.check("true", bc.isDetectRecursions());
        BeanConfigAnnotationTest.check("A1={foo:1}", bc.getExamples());
        BeanConfigAnnotationTest.check("true", bc.isFluentSetters());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreInvocationExceptionsOnGetters());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreInvocationExceptionsOnSetters());
        BeanConfigAnnotationTest.check("true", bc.isIgnorePropertiesWithoutSetters());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreRecursions());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreUnknownBeanProperties());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreUnknownNullBeanProperties());
        BeanConfigAnnotationTest.check("org.apache.juneau.BeanConfigAnnotationTest$A1=A1", bc.getImplClasses());
        BeanConfigAnnotationTest.check("1", bc.getInitialDepth());
        BeanConfigAnnotationTest.check("en_US", bc.getLocale());
        BeanConfigAnnotationTest.check("1", bc.getMaxDepth());
        BeanConfigAnnotationTest.check("application/json", bc.getMediaType());
        BeanConfigAnnotationTest.check("A1,A3", bc.getNotBeanClasses());
        BeanConfigAnnotationTest.check("foo1,foo3", bc.getNotBeanPackagesNames());
        BeanConfigAnnotationTest.check("AB1<String,Integer>,AB3<String,Integer>", bc.getPojoSwaps());
        BeanConfigAnnotationTest.check("PropertyNamerULC", bc.getPropertyNamer());
        BeanConfigAnnotationTest.check("true", bc.isSortProperties());
        BeanConfigAnnotationTest.check("GMT", bc.getTimeZone());
        BeanConfigAnnotationTest.check("true", bc.isUseEnumNames());
        BeanConfigAnnotationTest.check("true", bc.isUseInterfaceProxies());
        BeanConfigAnnotationTest.check("true", bc.isUseJavaBeanIntrospector());
    }

    @Test
    public void noValues() throws Exception {
        AnnotationList al = b.getAnnotationList(null);
        JsonSerializer bc = JsonSerializer.create().applyAnnotations(al, sr).build();
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanClassVisibility());
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanConstructorVisibility());
        BeanConfigAnnotationTest.check("", bc.getBeanDictionaryClasses());
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanFieldVisibility());
        BeanConfigAnnotationTest.check("", bc.getBeanFilters());
        BeanConfigAnnotationTest.check("false", bc.isBeanMapPutReturnsOldValue());
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanMethodVisibility());
        BeanConfigAnnotationTest.check("false", bc.isBeansRequireDefaultConstructor());
        BeanConfigAnnotationTest.check("false", bc.isBeansRequireSerializable());
        BeanConfigAnnotationTest.check("false", bc.isBeansRequireSettersForGetters());
        BeanConfigAnnotationTest.check("true", bc.isBeansRequireSomeProperties());
        BeanConfigAnnotationTest.check("_type", bc.getBeanTypePropertyName());
        BeanConfigAnnotationTest.check("", bc.getBpi());
        BeanConfigAnnotationTest.check("", bc.getBpx());
        BeanConfigAnnotationTest.check("", bc.getBpro());
        BeanConfigAnnotationTest.check("", bc.getBpwo());
        BeanConfigAnnotationTest.check("false", bc.isDebug());
        BeanConfigAnnotationTest.check("false", bc.isDetectRecursions());
        BeanConfigAnnotationTest.check("", bc.getExamples());
        BeanConfigAnnotationTest.check("false", bc.isFluentSetters());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreInvocationExceptionsOnGetters());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreInvocationExceptionsOnSetters());
        BeanConfigAnnotationTest.check("true", bc.isIgnorePropertiesWithoutSetters());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreRecursions());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreUnknownBeanProperties());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreUnknownNullBeanProperties());
        BeanConfigAnnotationTest.check("", bc.getImplClasses());
        BeanConfigAnnotationTest.check("0", bc.getInitialDepth());
        BeanConfigAnnotationTest.check(Locale.getDefault().toString(), bc.getLocale());
        BeanConfigAnnotationTest.check("100", bc.getMaxDepth());
        BeanConfigAnnotationTest.check(null, bc.getMediaType());
        BeanConfigAnnotationTest.check("java.lang,java.lang.annotation,java.lang.ref,java.lang.reflect,java.io,java.net", bc.getNotBeanPackagesNames());
        BeanConfigAnnotationTest.check("", bc.getPojoSwaps());
        BeanConfigAnnotationTest.check("PropertyNamerDefault", bc.getPropertyNamer());
        BeanConfigAnnotationTest.check("false", bc.isSortProperties());
        BeanConfigAnnotationTest.check(null, bc.getTimeZone());
        BeanConfigAnnotationTest.check("false", bc.isUseEnumNames());
        BeanConfigAnnotationTest.check("true", bc.isUseInterfaceProxies());
        BeanConfigAnnotationTest.check("false", bc.isUseJavaBeanIntrospector());
    }

    @Test
    public void noAnnotation() throws Exception {
        AnnotationList al = c.getAnnotationList(null);
        JsonSerializer bc = JsonSerializer.create().applyAnnotations(al, sr).build();
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanClassVisibility());
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanConstructorVisibility());
        BeanConfigAnnotationTest.check("", bc.getBeanDictionaryClasses());
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanFieldVisibility());
        BeanConfigAnnotationTest.check("", bc.getBeanFilters());
        BeanConfigAnnotationTest.check("false", bc.isBeanMapPutReturnsOldValue());
        BeanConfigAnnotationTest.check("PUBLIC", bc.getBeanMethodVisibility());
        BeanConfigAnnotationTest.check("false", bc.isBeansRequireDefaultConstructor());
        BeanConfigAnnotationTest.check("false", bc.isBeansRequireSerializable());
        BeanConfigAnnotationTest.check("false", bc.isBeansRequireSettersForGetters());
        BeanConfigAnnotationTest.check("true", bc.isBeansRequireSomeProperties());
        BeanConfigAnnotationTest.check("_type", bc.getBeanTypePropertyName());
        BeanConfigAnnotationTest.check("", bc.getBpi());
        BeanConfigAnnotationTest.check("", bc.getBpx());
        BeanConfigAnnotationTest.check("", bc.getBpro());
        BeanConfigAnnotationTest.check("", bc.getBpwo());
        BeanConfigAnnotationTest.check("false", bc.isDebug());
        BeanConfigAnnotationTest.check("false", bc.isDetectRecursions());
        BeanConfigAnnotationTest.check("", bc.getExamples());
        BeanConfigAnnotationTest.check("false", bc.isFluentSetters());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreInvocationExceptionsOnGetters());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreInvocationExceptionsOnSetters());
        BeanConfigAnnotationTest.check("true", bc.isIgnorePropertiesWithoutSetters());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreRecursions());
        BeanConfigAnnotationTest.check("false", bc.isIgnoreUnknownBeanProperties());
        BeanConfigAnnotationTest.check("true", bc.isIgnoreUnknownNullBeanProperties());
        BeanConfigAnnotationTest.check("", bc.getImplClasses());
        BeanConfigAnnotationTest.check("0", bc.getInitialDepth());
        BeanConfigAnnotationTest.check(Locale.getDefault().toString(), bc.getLocale());
        BeanConfigAnnotationTest.check("100", bc.getMaxDepth());
        BeanConfigAnnotationTest.check(null, bc.getMediaType());
        BeanConfigAnnotationTest.check("java.lang,java.lang.annotation,java.lang.ref,java.lang.reflect,java.io,java.net", bc.getNotBeanPackagesNames());
        BeanConfigAnnotationTest.check("", bc.getPojoSwaps());
        BeanConfigAnnotationTest.check("PropertyNamerDefault", bc.getPropertyNamer());
        BeanConfigAnnotationTest.check("false", bc.isSortProperties());
        BeanConfigAnnotationTest.check(null, bc.getTimeZone());
        BeanConfigAnnotationTest.check("false", bc.isUseEnumNames());
        BeanConfigAnnotationTest.check("true", bc.isUseInterfaceProxies());
        BeanConfigAnnotationTest.check("false", bc.isUseJavaBeanIntrospector());
    }

    static class C {
        C() {
        }
    }

    @BeanConfig
    static class B {
        B() {
        }
    }

    @BeanConfig(beanClassVisibility="$X{PRIVATE}", beanConstructorVisibility="$X{PRIVATE}", dictionary={A1.class, A2.class}, dictionary_replace={A1.class, A2.class, A3.class}, dictionary_remove={A2.class}, beanFieldVisibility="$X{PRIVATE}", beanFilters={A1.class, A2.class}, beanFilters_replace={A1.class, A2.class, A3.class}, beanFilters_remove={A2.class}, beanMapPutReturnsOldValue="$X{true}", beanMethodVisibility="$X{PRIVATE}", beansRequireDefaultConstructor="$X{true}", beansRequireSerializable="$X{true}", beansRequireSettersForGetters="$X{true}", beansRequireSomeProperties="$X{true}", beanTypePropertyName="$X{foo}", bpiMap={@CS(k=A1.class, v="$X{foo}")}, bpxMap={@CS(k=A1.class, v="$X{bar}")}, bproMap={@CS(k=A1.class, v="$X{baz}")}, bpwoMap={@CS(k=A1.class, v="$X{qux}")}, debug="$X{true}", detectRecursions="$X{true}", examples={"$X{A1}: {foo:1}"}, fluentSetters="$X{true}", ignoreInvocationExceptionsOnGetters="$X{true}", ignoreInvocationExceptionsOnSetters="$X{true}", ignorePropertiesWithoutSetters="$X{true}", ignoreRecursions="$X{true}", ignoreUnknownBeanProperties="$X{true}", ignoreUnknownNullBeanProperties="$X{true}", implClasses={@CC(k=A1.class, v=A1.class)}, initialDepth="$X{1}", locale="$X{en-US}", maxDepth="$X{1}", mediaType="$X{text/foo}", notBeanClasses={A1.class, A2.class}, notBeanClasses_replace={A1.class, A2.class, A3.class}, notBeanClasses_remove={A2.class}, notBeanPackages={"$X{foo1}", "$X{foo2}"}, notBeanPackages_replace={"$X{foo1}", "$X{foo2}", "$X{foo3}"}, notBeanPackages_remove={"$X{foo2}"}, pojoSwaps={AB1.class, AB2.class}, pojoSwaps_replace={AB1.class, AB2.class, AB3.class}, pojoSwaps_remove={AB2.class}, propertyNamer=PropertyNamerULC.class, sortProperties="$X{true}", timeZone="$X{z}", useEnumNames="$X{true}", useInterfaceProxies="$X{true}", useJavaBeanIntrospector="$X{true}")
    static class A {
        A() {
        }
    }

    public static class AB3
    extends PojoSwap<String, Integer> {
    }

    public static class AB2
    extends PojoSwap<String, Integer> {
    }

    public static class AB1
    extends PojoSwap<String, Integer> {
    }

    @Bean(typeName="A3")
    public static class A3 {
        public int foo;
    }

    @Bean(typeName="A2")
    public static class A2 {
        public int foo;
    }

    @Bean(typeName="A1")
    public static class A1 {
        public int foo;

        public String toString() {
            return SimpleJson.DEFAULT.toString((Object)this);
        }
    }
}

