/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.testutils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationsTest {
    @Test
    public void testBeanWithExplicitProperties() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        BeanMap bm = null;
        bm = session.newBeanMap(Person1.class).load("{age:21,name:'foobar'}");
        Assert.assertNotNull((Object)bm);
        Assert.assertNotNull((Object)bm.getBean());
        Assert.assertEquals((Object)bm.get((Object)"age"), (Object)21);
        Assert.assertEquals((Object)bm.get((Object)"name"), (Object)"foobar");
        bm.put("age", (Object)65);
        bm.put("name", (Object)"futbol");
        Assert.assertEquals((Object)bm.get((Object)"age"), (Object)65);
        Assert.assertEquals((Object)bm.get((Object)"name"), (Object)"futbol");
    }

    @Test
    public void testBeanWithExplicitProperties_usingConfig() throws Exception {
        BeanSession session = BeanContext.DEFAULT.builder().applyAnnotations(new Class[]{Person1a.class}).build().createSession();
        BeanMap bm = null;
        bm = session.newBeanMap(Person1a.class).load("{age:21,name:'foobar'}");
        Assert.assertNotNull((Object)bm);
        Assert.assertNotNull((Object)bm.getBean());
        Assert.assertEquals((Object)bm.get((Object)"age"), (Object)21);
        Assert.assertEquals((Object)bm.get((Object)"name"), (Object)"foobar");
        bm.put("age", (Object)65);
        bm.put("name", (Object)"futbol");
        Assert.assertEquals((Object)bm.get((Object)"age"), (Object)65);
        Assert.assertEquals((Object)bm.get((Object)"name"), (Object)"futbol");
    }

    @Test
    public void testForOnlyPublicFields() throws Exception {
        BeanSession session = BeanContext.DEFAULT.createSession();
        BeanMap bm = null;
        bm = session.newBeanMap(A.class).load("{publicField:123}");
        Assert.assertNotNull((String)"F1", (Object)bm);
        Assert.assertNotNull((String)"F2", (Object)bm.getBean());
        TestUtils.assertObjectEquals("{publicField:123}", bm.getBean());
    }

    public static class A {
        public int publicField;
        protected int protectedField;
        private int privateField;
        int defaultField;
    }

    @BeanConfig(applyBean={@Bean(on="Person1a", bpi="age,name")})
    public static class Person1a {
        public int age;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @Bean(bpi="age,name")
    public static class Person1 {
        public int age;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

