/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.yaml.proto;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.KeywordSet;
import org.apache.juneau.serializer.SerializerWriter;

public final class YamlWriter
extends SerializerWriter {
    private static final AsciiSet encodedChars = new AsciiSet("\n\t\b\f\r'\"\\");
    private static final KeywordSet reservedWords = new KeywordSet("y", "Y", "yes", "Yes", "YES", "n", "N", "no", "No", "NO", "true", "True", "TRUE", "false", "False", "FALSE", "on", "On", "ON", "off", "Off", "OFF");
    private static final AsciiSet validAttrChars = new AsciiSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_");
    private static final AsciiSet validFirstAttrChars = new AsciiSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_");
    private final AsciiSet ec = encodedChars;

    protected YamlWriter(Writer out, char quoteChar, boolean trimStrings, UriResolver uriResolver) {
        super(out, true, Integer.MAX_VALUE, trimStrings, quoteChar, uriResolver);
    }

    public YamlWriter stringValue(String s) throws IOException {
        int i;
        char c;
        if (s == null) {
            return this;
        }
        boolean doConvert = false;
        for (i = 0; i < s.length() && !doConvert; doConvert |= this.ec.contains(c), ++i) {
            c = s.charAt(i);
        }
        this.q();
        if (!doConvert) {
            this.out.append(s);
        } else {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if (this.ec.contains(c)) {
                    if (c == '\n') {
                        this.out.append('\\').append('n');
                        continue;
                    }
                    if (c == '\t') {
                        this.out.append('\\').append('t');
                        continue;
                    }
                    if (c == '\b') {
                        this.out.append('\\').append('b');
                        continue;
                    }
                    if (c == '\f') {
                        this.out.append('\\').append('f');
                        continue;
                    }
                    if (c == this.quoteChar) {
                        this.out.append('\\').append(this.quoteChar);
                        continue;
                    }
                    if (c == '\\') {
                        this.out.append('\\').append('\\');
                        continue;
                    }
                    if (c == '\r') continue;
                    this.out.append(c);
                    continue;
                }
                this.out.append(c);
            }
        }
        this.q();
        return this;
    }

    public YamlWriter attr(String s) throws IOException {
        boolean doConvert = false;
        if (s == null) {
            s = "~";
            doConvert = false;
        } else {
            if (!doConvert) {
                char c;
                for (int i = 0; i < s.length() && !doConvert; doConvert |= !(i != 0 ? validAttrChars.contains(c) : validFirstAttrChars.contains(c)), ++i) {
                    c = s.charAt(i);
                }
            }
            if (!doConvert && (s.isEmpty() || reservedWords.contains(s))) {
                doConvert = true;
            }
        }
        if (doConvert) {
            this.stringValue(s);
        } else {
            this.out.append(s);
        }
        return this;
    }

    public SerializerWriter uriValue(Object uri) throws IOException {
        return this.stringValue(this.uriResolver.resolve(uri));
    }

    @Override
    public YamlWriter cr(int depth) throws IOException {
        super.cr(depth);
        return this;
    }

    @Override
    public YamlWriter cre(int depth) throws IOException {
        super.cre(depth);
        return this;
    }

    public YamlWriter smi(int depth) throws IOException {
        if (depth > this.maxIndent) {
            super.s();
        }
        return this;
    }

    @Override
    public YamlWriter appendln(int indent, String text) throws IOException {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public YamlWriter appendln(String text) throws IOException {
        super.appendln(text);
        return this;
    }

    @Override
    public YamlWriter append(int indent, String text) throws IOException {
        super.append(indent, text);
        return this;
    }

    @Override
    public YamlWriter append(int indent, char c) throws IOException {
        super.append(indent, c);
        return this;
    }

    @Override
    public YamlWriter s() throws IOException {
        super.s();
        return this;
    }

    public YamlWriter s(int indent) throws IOException {
        if (indent <= this.maxIndent) {
            super.s();
        }
        return this;
    }

    @Override
    public YamlWriter q() throws IOException {
        super.q();
        return this;
    }

    @Override
    public YamlWriter i(int indent) throws IOException {
        super.i(indent);
        return this;
    }

    @Override
    public YamlWriter nl(int indent) throws IOException {
        super.nl(indent);
        return this;
    }

    @Override
    public YamlWriter append(Object text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public YamlWriter append(String text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public YamlWriter appendIf(boolean b, String text) throws IOException {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public YamlWriter appendIf(boolean b, char c) throws IOException {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public YamlWriter append(char c) throws IOException {
        super.append(c);
        return this;
    }
}

