/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlSerializerSession
extends WriterSerializerSession {
    final boolean autoDetectNamespaces;
    final boolean enableNamespaces;
    final boolean addNamespaceUrlsToRoot;
    final boolean addBeanTypeProperties;
    Namespace defaultNamespace;
    final Namespace xsNamespace;
    Namespace[] namespaces = new Namespace[0];

    protected XmlSerializerSession(XmlSerializerContext ctx, SerializerSessionArgs args) {
        super(ctx, args);
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.enableNamespaces = ctx.enableNamespaces;
            this.autoDetectNamespaces = ctx.autoDetectNamespaces;
            this.addNamespaceUrlsToRoot = ctx.addNamespaceUrlsToRoot;
            this.addNamespaces(ctx.namespaces);
            this.defaultNamespace = XmlSerializerSession.findDefaultNamespace(ctx.defaultNamespace);
            this.xsNamespace = ctx.xsNamespace;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.enableNamespaces = p.getBoolean("XmlSerializer.enableNamespaces", ctx.enableNamespaces);
            this.autoDetectNamespaces = p.getBoolean("XmlSerializer.autoDetectNamespaces", ctx.autoDetectNamespaces);
            this.addNamespaceUrlsToRoot = p.getBoolean("XmlSerializer.addNamespaceUrisToRoot", ctx.addNamespaceUrlsToRoot);
            this.namespaces = p.containsKey("XmlSerializer.namespaces.list") ? NamespaceFactory.parseNamespaces(p.get("XmlSerializer.namespaces.list")) : ctx.namespaces;
            this.defaultNamespace = XmlSerializerSession.findDefaultNamespace(p.containsKey("XmlSerializer.defaultNamespace") ? p.getString("XmlSerializer.defaultNamespace") : ctx.defaultNamespace);
            this.xsNamespace = p.containsKey("XmlSerializer.xsNamespace") ? NamespaceFactory.parseNamespace(p.get("XmlSerializer.xsNamespace")) : ctx.xsNamespace;
            this.addBeanTypeProperties = p.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
    }

    private static Namespace findDefaultNamespace(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.startsWith(s, '{')) {
            return NamespaceFactory.parseNamespace(s);
        }
        if (!s.startsWith("http://")) {
            return NamespaceFactory.get(s, "http://unknown");
        }
        return NamespaceFactory.get(null, s);
    }

    private void addNamespaces(Namespace ... namespaces) {
        for (Namespace ns : namespaces) {
            this.addNamespace(ns);
        }
    }

    private void addNamespace(Namespace ns) {
        if (ns == this.defaultNamespace) {
            return;
        }
        for (Namespace n : this.namespaces) {
            if (n != ns) continue;
            return;
        }
        if (this.defaultNamespace != null && (ns.uri.equals(this.defaultNamespace.uri) || ns.name.equals(this.defaultNamespace.name))) {
            this.defaultNamespace = ns;
        } else {
            this.namespaces = ArrayUtils.append(this.namespaces, ns);
        }
    }

    @Override
    protected boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    protected boolean isHtmlMode() {
        return false;
    }

    public final XmlWriter getXmlWriter(SerializerPipe out) throws Exception {
        Object output = out.getRawOutput();
        if (output instanceof XmlWriter) {
            return (XmlWriter)output;
        }
        XmlWriter w = new XmlWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver(), this.enableNamespaces, this.defaultNamespace);
        out.setWriter(w);
        return w;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        if (this.enableNamespaces && this.autoDetectNamespaces) {
            this.findNsfMappings(o);
        }
        this.serializeAnything(this.getXmlWriter(out), o, this.getExpectedRootType(o), null, null, this.enableNamespaces && this.addNamespaceUrlsToRoot, XmlFormat.DEFAULT, false, false, null);
    }

    protected final void findNsfMappings(Object o) throws SerializeException {
        Namespace ns;
        ClassMeta<?> aType = null;
        aType = this.push(null, o, null);
        if (aType != null && (ns = aType.getExtendedMeta(XmlClassMeta.class).getNamespace()) != null) {
            if (ns.uri != null) {
                this.addNamespace(ns);
            } else {
                ns = null;
            }
        }
        if (aType != null && !aType.isPrimitive()) {
            BeanMap<Object> bm = null;
            if (aType.isBeanMap()) {
                bm = (BeanMap<Object>)o;
            } else if (aType.isBean()) {
                bm = this.toBeanMap(o);
            } else if (aType.isDelegate()) {
                ClassMeta innerType = ((Delegate)o).getClassMeta();
                Namespace ns2 = innerType.getExtendedMeta(XmlClassMeta.class).getNamespace();
                if (ns2 != null) {
                    if (ns2.uri != null) {
                        this.addNamespace(ns2);
                    } else {
                        ns2 = null;
                    }
                }
                if (innerType.isBean()) {
                    for (BeanPropertyMeta bpm : innerType.getBeanMeta().getPropertyMetas()) {
                        ns2 = bpm.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                        if (ns2 == null || ns2.uri == null) continue;
                        this.addNamespace(ns2);
                    }
                } else if (innerType.isMap()) {
                    for (Object o2 : ((Map)o).values()) {
                        this.findNsfMappings(o2);
                    }
                } else if (innerType.isCollection()) {
                    for (Object o2 : (Collection)o) {
                        this.findNsfMappings(o2);
                    }
                }
            } else if (aType.isMap()) {
                for (BeanPropertyValue o2 : ((Map)o).values()) {
                    this.findNsfMappings(o2);
                }
            } else if (aType.isCollection()) {
                for (BeanPropertyValue o2 : (Collection)o) {
                    this.findNsfMappings(o2);
                }
            } else if (aType.isArray() && !aType.getElementType().isPrimitive()) {
                for (Object o2 : (Object[])o) {
                    this.findNsfMappings(o2);
                }
            }
            if (bm != null) {
                for (BeanPropertyValue p : bm.getValues(this.isTrimNulls(), new BeanPropertyValue[0])) {
                    Namespace ns3 = p.getMeta().getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                    if (ns3 != null && ns3.uri != null) {
                        this.addNamespace(ns3);
                    }
                    try {
                        this.findNsfMappings(p.getValue());
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        this.pop();
    }

    protected XmlWriter serializeAnything(XmlWriter out, Object o, ClassMeta<?> eType, String elementName, Namespace elementNamespace, boolean addNamespaceUris, XmlFormat format, boolean isMixed, boolean preserveWhitespace, BeanPropertyMeta pMeta) throws Exception {
        boolean isRaw;
        JsonType type = null;
        int i = isMixed ? 0 : this.indent;
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        aType = this.push(elementName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (o != null) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
                eType = aType;
            }
            sType = aType;
            PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
            if (swap != null) {
                o = swap.swap(this, o);
                sType = swap.getSwapClassMeta(this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta(this);
        }
        boolean isExpectedType = true;
        if (o == null || !eType.same(aType)) {
            isExpectedType = eType.isNumber() ? aType.isNumber() : (eType.isMap() ? aType.isMap() : (eType.isCollectionOrArray() ? aType.isCollectionOrArray() : false));
        }
        String resolvedDictionaryName = isExpectedType ? null : aType.getDictionaryName();
        String dictionaryName = aType.getDictionaryName();
        if (dictionaryName == null) {
            dictionaryName = sType.getDictionaryName();
        }
        if (o != null && sType.isChar() && ((Character)o).charValue() == '\u0000') {
            o = null;
        }
        boolean isCollapsed = false;
        boolean bl = isRaw = (sType.isReader() || sType.isInputStream()) && o != null;
        if (o == null) {
            type = JsonType.NULL;
        } else if (sType.isCharSequence() || sType.isChar()) {
            type = JsonType.STRING;
        } else if (sType.isNumber()) {
            type = JsonType.NUMBER;
        } else if (sType.isBoolean()) {
            type = JsonType.BOOLEAN;
        } else if (sType.isMapOrBean()) {
            isCollapsed = sType.getExtendedMeta(XmlClassMeta.class).getFormat() == XmlFormat.COLLAPSED;
            type = JsonType.OBJECT;
        } else if (sType.isCollectionOrArray()) {
            isCollapsed = format == XmlFormat.COLLAPSED && !addNamespaceUris;
            type = JsonType.ARRAY;
        } else {
            type = JsonType.STRING;
        }
        if (format.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT) && type.isOneOf(JsonType.NULL, JsonType.STRING, JsonType.NUMBER, JsonType.BOOLEAN)) {
            isCollapsed = true;
        }
        if (elementName == null && dictionaryName != null) {
            elementName = dictionaryName;
            isExpectedType = true;
        }
        if (this.enableNamespaces) {
            if (elementNamespace == null) {
                elementNamespace = sType.getExtendedMeta(XmlClassMeta.class).getNamespace();
            }
            if (elementNamespace == null) {
                elementNamespace = aType.getExtendedMeta(XmlClassMeta.class).getNamespace();
            }
            if (elementNamespace != null && elementNamespace.uri == null) {
                elementNamespace = null;
            }
            if (elementNamespace == null) {
                elementNamespace = this.defaultNamespace;
            }
        } else {
            elementNamespace = null;
        }
        boolean cr = o != null && (sType.isMapOrBean() || sType.isCollectionOrArray()) && !isMixed;
        String en = elementName;
        if (en == null && !isRaw) {
            en = type.toString();
            type = null;
        }
        boolean encodeEn = elementName != null;
        String ns = elementNamespace == null ? null : elementNamespace.name;
        String dns = null;
        String elementNs = null;
        if (this.enableNamespaces) {
            dns = elementName == null && this.defaultNamespace != null ? this.defaultNamespace.name : null;
            String string = elementNs = elementName == null ? dns : ns;
            if (elementName == null) {
                elementNamespace = null;
            }
        }
        if (!isCollapsed) {
            if (en != null) {
                out.oTag(i, elementNs, en, encodeEn);
                if (addNamespaceUris) {
                    out.attr((String)null, "xmlns", (Object)this.defaultNamespace.getUri());
                    for (Namespace n : this.namespaces) {
                        out.attr("xmlns", n.getName(), (Object)n.getUri());
                    }
                }
                if (!isExpectedType) {
                    if (resolvedDictionaryName != null) {
                        out.attr(dns, this.getBeanTypePropertyName(eType), (Object)resolvedDictionaryName);
                    } else if (type != null && type != JsonType.STRING) {
                        out.attr(dns, this.getBeanTypePropertyName(eType), (Object)type);
                    }
                }
            } else {
                out.i(i);
            }
            if (o == null && (sType.isBoolean() || sType.isNumber()) && !sType.isNullable()) {
                o = sType.getPrimitiveDefault();
            }
            if (o != null && !sType.isMapOrBean() && en != null) {
                out.append('>');
            }
            if (cr && !sType.isMapOrBean()) {
                out.nl(i + 1);
            }
        }
        ContentResult rc = ContentResult.CR_ELEMENTS;
        if (o != null) {
            if (sType.isUri() || pMeta != null && pMeta.isUri()) {
                out.textUri(o);
            } else if (sType.isCharSequence() || sType.isChar()) {
                if (format == XmlFormat.XMLTEXT) {
                    out.append(o);
                } else {
                    out.text(o, preserveWhitespace);
                }
            } else if (sType.isNumber() || sType.isBoolean()) {
                out.append(o);
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                rc = o instanceof BeanMap ? this.serializeBeanMap(out, (BeanMap)o, elementNamespace, isCollapsed, isMixed) : this.serializeMap(out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), isMixed);
            } else if (sType.isBean()) {
                rc = this.serializeBeanMap(out, this.toBeanMap(o), elementNamespace, isCollapsed, isMixed);
            } else if (sType.isCollection() || wType != null && wType.isCollection()) {
                if (isCollapsed) {
                    --this.indent;
                }
                this.serializeCollection(out, o, sType, eType, pMeta, isMixed);
                if (isCollapsed) {
                    ++this.indent;
                }
            } else if (sType.isArray()) {
                if (isCollapsed) {
                    --this.indent;
                }
                this.serializeCollection(out, o, sType, eType, pMeta, isMixed);
                if (isCollapsed) {
                    ++this.indent;
                }
            } else if (sType.isReader() || sType.isInputStream()) {
                IOUtils.pipe(o, (Writer)out);
            } else if (format == XmlFormat.XMLTEXT) {
                out.append(this.toString(o));
            } else {
                out.text(this.toString(o));
            }
        }
        this.pop();
        if (!isCollapsed) {
            if (en != null) {
                if (rc == ContentResult.CR_EMPTY) {
                    if (this.isHtmlMode()) {
                        out.append('>').eTag(elementNs, en, encodeEn);
                    } else {
                        out.append('/').append('>');
                    }
                } else if (rc == ContentResult.CR_VOID || o == null) {
                    out.append('/').append('>');
                } else {
                    out.ie(cr && rc != ContentResult.CR_MIXED ? i : 0).eTag(elementNs, en, encodeEn);
                }
            }
            if (!isMixed) {
                out.nl(i);
            }
        }
        return out;
    }

    private ContentResult serializeMap(XmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, boolean isMixed) throws Exception {
        m = this.sort(m);
        ClassMeta<?> keyType = eKeyType == null ? sType.getKeyType() : eKeyType;
        ClassMeta<?> valueType = eValueType == null ? sType.getValueType() : eValueType;
        boolean hasChildren = false;
        for (Map.Entry e : m.entrySet()) {
            Object k = e.getKey();
            if (k == null) {
                k = "\u0000";
            } else {
                k = this.generalize(k, keyType);
                if (this.isTrimStrings() && k instanceof String) {
                    k = k.toString().trim();
                }
            }
            Object value = e.getValue();
            if (!hasChildren) {
                hasChildren = true;
                out.append('>').nlIf(!isMixed, this.indent);
            }
            this.serializeAnything(out, value, valueType, this.toString(k), null, false, XmlFormat.DEFAULT, isMixed, false, null);
        }
        return hasChildren ? ContentResult.CR_ELEMENTS : ContentResult.CR_EMPTY;
    }

    private ContentResult serializeBeanMap(XmlWriter out, BeanMap<?> m, Namespace elementNs, boolean isCollapsed, boolean isMixed) throws Exception {
        boolean hasChildren = false;
        BeanMeta<?> bm = m.getMeta();
        List<BeanPropertyValue> lp = m.getValues(this.isTrimNulls(), new BeanPropertyValue[0]);
        XmlBeanMeta xbm = bm.getExtendedMeta(XmlBeanMeta.class);
        Set<String> attrs = xbm.getAttrPropertyNames();
        Set<String> elements = xbm.getElementPropertyNames();
        Set<String> collapsedElements = xbm.getCollapsedPropertyNames();
        String attrsProperty = xbm.getAttrsPropertyName();
        String contentProperty = xbm.getContentPropertyName();
        XmlFormat cf = null;
        Object content = null;
        ClassMeta<?> contentType = null;
        for (BeanPropertyValue p : lp) {
            Namespace ns;
            String n = p.getName();
            if (!attrs.contains(n) && !attrs.contains("*") && !n.equals(attrsProperty)) continue;
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String string = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, string, value)) continue;
            Namespace namespace = ns = this.enableNamespaces && pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace() != elementNs ? pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace() : null;
            if (pMeta.isUri()) {
                out.attrUri(ns, string, value);
                continue;
            }
            if (n.equals(attrsProperty)) {
                if (value instanceof BeanMap) {
                    BeanMap bm2 = (BeanMap)value;
                    for (BeanPropertyValue beanPropertyValue : bm2.getValues(true, new BeanPropertyValue[0])) {
                        String key2 = beanPropertyValue.getName();
                        Object value2 = beanPropertyValue.getValue();
                        Throwable t2 = beanPropertyValue.getThrown();
                        if (t2 != null) {
                            this.onBeanGetterException(pMeta, t);
                        }
                        out.attr(ns, key2, value2);
                    }
                    continue;
                }
                Map m2 = (Map)value;
                for (Map.Entry entry : m2.entrySet()) {
                    out.attr(ns, this.toString(entry.getKey()), entry.getValue());
                }
                continue;
            }
            out.attr(ns, string, value);
        }
        boolean hasContent = false;
        boolean preserveWhitespace = false;
        boolean isVoidElement = xbm.getContentFormat() == XmlFormat.VOID;
        for (BeanPropertyValue p : lp) {
            BeanPropertyMeta beanPropertyMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String n = p.getName();
            if (n.equals(contentProperty)) {
                content = p.getValue();
                contentType = p.getClassMeta();
                hasContent = true;
                cf = xbm.getContentFormat();
                if (cf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT)) {
                    isMixed = true;
                }
                if (cf.isOneOf(XmlFormat.MIXED_PWS, XmlFormat.TEXT_PWS)) {
                    preserveWhitespace = true;
                }
                if (contentType.isCollection() && ((Collection)content).isEmpty()) {
                    hasContent = false;
                    continue;
                }
                if (!contentType.isArray() || Array.getLength(content) != 0) continue;
                hasContent = false;
                continue;
            }
            if (!elements.contains(n) && !collapsedElements.contains(n) && !elements.contains("*") && !collapsedElements.contains("*")) continue;
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(beanPropertyMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            if (!hasChildren) {
                hasChildren = true;
                out.appendIf(!isCollapsed, '>').nlIf(!isMixed, this.indent);
            }
            XmlBeanPropertyMeta xmlBeanPropertyMeta = beanPropertyMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
            this.serializeAnything(out, value, cMeta, key, xmlBeanPropertyMeta.getNamespace(), false, xmlBeanPropertyMeta.getXmlFormat(), isMixed, false, beanPropertyMeta);
        }
        if (!hasContent) {
            return hasChildren ? ContentResult.CR_ELEMENTS : (isVoidElement ? ContentResult.CR_VOID : ContentResult.CR_EMPTY);
        }
        out.append('>').nlIf(!isMixed, this.indent);
        if (content != null) {
            if (contentType != null) {
                List<Object> c;
                if (contentType.isCollection()) {
                    c = (List<Object>)content;
                    for (Object e : c) {
                        this.serializeAnything(out, e, contentType.getElementType(), null, null, false, cf, isMixed, preserveWhitespace, null);
                    }
                } else if (contentType.isArray()) {
                    c = XmlSerializerSession.toList(Object[].class, content);
                    for (Object e : c) {
                        this.serializeAnything(out, e, contentType.getElementType(), null, null, false, cf, isMixed, preserveWhitespace, null);
                    }
                } else {
                    this.serializeAnything(out, content, contentType, null, null, false, cf, isMixed, preserveWhitespace, null);
                }
            }
        } else if (!this.isTrimNulls()) {
            if (!isMixed) {
                out.i(this.indent);
            }
            out.text(content);
            if (!isMixed) {
                out.nl(this.indent);
            }
        }
        return isMixed ? ContentResult.CR_MIXED : ContentResult.CR_ELEMENTS;
    }

    private XmlWriter serializeCollection(XmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, BeanPropertyMeta ppMeta, boolean isMixed) throws Exception {
        ClassMeta<Object> seType = sType.getElementType();
        if (seType == null) {
            seType = this.object();
        }
        ClassMeta<?> eeType = eType.getElementType();
        Collection<Object> c = sType.isCollection() ? (List<Object>)in : XmlSerializerSession.toList(sType.getInnerClass(), in);
        c = this.sort(c);
        String type2 = null;
        if (sType != eType) {
            type2 = sType.getDictionaryName();
        }
        String eName = type2;
        Namespace eNs = null;
        if (ppMeta != null) {
            XmlBeanPropertyMeta xbpm = ppMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
            eName = xbpm.getChildName();
            eNs = xbpm.getNamespace();
        }
        for (Object value : c) {
            this.serializeAnything(out, value, eeType, eName, eNs, false, XmlFormat.DEFAULT, isMixed, false, null);
        }
        return out;
    }

    static enum ContentResult {
        CR_VOID,
        CR_EMPTY,
        CR_MIXED,
        CR_ELEMENTS;

    }

    static enum JsonType {
        STRING("string"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        ARRAY("array"),
        OBJECT("object"),
        NULL("null");

        private final String value;

        private JsonType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        boolean isOneOf(JsonType ... types) {
            for (JsonType type : types) {
                if (type != this) continue;
                return true;
            }
            return false;
        }
    }
}

