/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ReaderParser;

public final class PojoIntrospector {
    private final Object o;
    private final ReaderParser p;

    public PojoIntrospector(Object o, ReaderParser p) {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        this.o = o;
        this.p = p;
    }

    public PojoIntrospector(Object o) {
        this(o, null);
    }

    public Object invokeMethod(Method method, Reader args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, ParseException, IOException {
        if (this.o == null) {
            return null;
        }
        Object[] params = args == null ? null : this.p.parseArgs(args, method.getGenericParameterTypes());
        return method.invoke(this.o, params);
    }

    public Object invokeMethod(String method, String args) throws NoSuchMethodException, IllegalArgumentException, InvocationTargetException, IllegalAccessException, ParseException, IOException {
        if (this.o == null) {
            return null;
        }
        Method m = this.p.getBeanContext().createSession().getClassMeta(this.o.getClass()).getPublicMethods().get(method);
        if (m == null) {
            throw new NoSuchMethodException(method);
        }
        return this.invokeMethod(m, args == null ? null : new StringReader(args));
    }
}

