/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;

public class ManifestFile
extends ObjectMap {
    private static final long serialVersionUID = 1L;

    public ManifestFile(File f) throws IOException {
        Manifest mf = new Manifest();
        FileInputStream fis = new FileInputStream(f);
        try {
            mf.read(fis);
            this.load(mf);
        }
        catch (IOException e) {
            throw new IOException("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read(f), e);
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public ManifestFile(Manifest f) {
        this.load(f);
    }

    public ManifestFile(Class<?> c) throws IOException {
        String className = c.getSimpleName() + ".class";
        String classPath = c.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest mf = new Manifest(new URL(manifestPath).openStream());
            this.load(mf);
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load(Manifest mf) {
        for (Map.Entry<Object, Object> e : mf.getMainAttributes().entrySet()) {
            this.put(e.getKey().toString(), e.getValue().toString());
        }
    }
}

