/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.serializer.SerializerContext;

public class UonSerializerContext
extends SerializerContext {
    public static final String UON_encodeChars = "UonSerializer.encodeChars";
    public static final String UON_addBeanTypeProperties = "UonSerializer.addBeanTypeProperties";
    public static final String UON_paramFormat = "UonSerializer.paramFormat";
    final boolean encodeChars;
    final boolean addBeanTypeProperties;
    final boolean plainTextParams;

    public UonSerializerContext(PropertyStore ps) {
        super(ps);
        this.encodeChars = ps.getProperty(UON_encodeChars, Boolean.TYPE, false);
        this.addBeanTypeProperties = ps.getProperty(UON_addBeanTypeProperties, Boolean.TYPE, ps.getProperty("Serializer.addBeanTypeProperties", Boolean.TYPE, true));
        this.plainTextParams = ps.getProperty(UON_paramFormat, String.class, "UON").equals("PLAINTEXT");
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("UonSerializerContext", new ObjectMap().append("encodeChars", this.encodeChars).append("addBeanTypeProperties", this.addBeanTypeProperties).append("plainTextParams", this.plainTextParams));
    }

    public boolean plainTextParams() {
        return this.plainTextParams;
    }
}

