/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.uon.UonSerializerBuilder;
import org.apache.juneau.uon.UonSerializerContext;
import org.apache.juneau.uon.UonSerializerSession;

public class UonSerializer
extends WriterSerializer {
    public static final UonSerializer DEFAULT = new UonSerializer(PropertyStore.create());
    public static final UonSerializer DEFAULT_READABLE = new Readable(PropertyStore.create());
    public static final UonSerializer DEFAULT_ENCODING = new Encoding(PropertyStore.create());
    private final UonSerializerContext ctx = this.createContext(UonSerializerContext.class);

    public UonSerializer(PropertyStore propertyStore) {
        this(propertyStore, "text/uon", new String[0]);
    }

    public UonSerializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore, produces, accept);
    }

    @Override
    public UonSerializerBuilder builder() {
        return new UonSerializerBuilder(this.propertyStore);
    }

    @Override
    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new UonSerializerSession(this.ctx, null, args);
    }

    public static class Encoding
    extends UonSerializer {
        public Encoding(PropertyStore propertyStore) {
            super(propertyStore.copy().append("UonSerializer.encodeChars", true));
        }
    }

    public static class Readable
    extends UonSerializer {
        public Readable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.useWhitespace", true));
        }
    }
}

