/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.Reader;
import java.io.Writer;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringBuilderWriter;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;

public abstract class MenuItemWidget
extends Widget {
    @Override
    public String getScript(RestRequest req) throws Exception {
        return this.loadScript("MenuItemWidget.js");
    }

    @Override
    public String getStyle(RestRequest req) throws Exception {
        return this.loadStyle("MenuItemWidget.css");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHtml(RestRequest req) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='menu-item'>\n\t<a class='link' onclick='menuClick(this)'>" + this.getLabel(req) + "</a>" + "\n\t<div class='popup-content'>\n");
        Object o = this.getContent(req);
        if (o instanceof Reader) {
            IOUtils.pipe((Reader)o, (Writer)new StringBuilderWriter(sb));
        } else if (o instanceof CharSequence) {
            sb.append((CharSequence)o);
        } else {
            SerializerSessionArgs args = new SerializerSessionArgs(req.getProperties(), null, req.getLocale(), null, null, req.getUriContext());
            WriterSerializerSession session = HtmlSerializer.DEFAULT.createSession(args);
            try {
                session.indent = 2;
                session.serialize(sb, o);
            }
            finally {
                session.close();
            }
        }
        sb.append("\n\t</div>\n</div>");
        return sb.toString();
    }

    public abstract String getLabel(RestRequest var1) throws Exception;

    public abstract Object getContent(RestRequest var1) throws Exception;
}

