/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class DefaultHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        String accept;
        SerializerGroup g = res.getSerializerGroup();
        SerializerMatch sm = g.getSerializerMatch(accept = req.getHeaders().getString("Accept", ""));
        if (sm != null) {
            Serializer s = sm.getSerializer();
            MediaType mediaType = res.getMediaType();
            if (mediaType == null) {
                mediaType = sm.getMediaType();
            }
            res.setContentType(mediaType.toString());
            try {
                PrintWriter w;
                ObjectMap p = res.getProperties();
                if (req.isPlainText()) {
                    res.setContentType("text/plain");
                }
                p.append("mediaType", mediaType).append("characterEncoding", res.getCharacterEncoding());
                SerializerSession session = s.createSession(new SerializerSessionArgs(p, req.getJavaMethod(), req.getLocale(), req.getHeaders().getTimeZone(), mediaType, req.getUriContext()));
                for (Map.Entry<String, String> h : session.getResponseHeaders().entrySet()) {
                    res.setHeader(h.getKey(), h.getValue());
                }
                if (!session.isWriterSerializer()) {
                    if (req.isPlainText()) {
                        w = res.getNegotiatedWriter();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        session.serialize(baos, output);
                        ((Writer)w).write(StringUtils.toHex(baos.toByteArray()));
                        ((Writer)w).close();
                    }
                    ServletOutputStream os = res.getNegotiatedOutputStream();
                    session.serialize(os, output);
                    os.close();
                }
                w = res.getNegotiatedWriter();
                session.serialize(w, output);
                ((Writer)w).close();
            }
            catch (SerializeException e) {
                throw new RestException(500, (Throwable)e);
            }
        } else {
            throw new RestException(406, "Unsupported media-type in request header ''Accept'': ''{0}''\n\tSupported media-types: {1}", req.getHeaders().getString("Accept", ""), g.getSupportedMediaTypes());
        }
        return true;
    }
}

