/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;

public final class RestCallException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int responseCode;
    private String response;
    private String responseStatusMessage;
    HttpResponseException e;
    private HttpResponse httpResponse;
    private String serverExceptionName;
    private String serverExceptionMessage;
    private String serverExceptionTrace;

    public RestCallException(String msg) {
        super(msg);
    }

    public RestCallException(Exception e) {
        super(e.getLocalizedMessage(), e);
        Pattern p;
        Matcher m;
        if (e instanceof FileNotFoundException) {
            this.responseCode = 404;
        } else if (e.getMessage() != null && (m = (p = Pattern.compile("[^\\d](\\d{3})[^\\d]")).matcher(e.getMessage())).find()) {
            this.responseCode = Integer.parseInt(m.group(1));
        }
        this.setStackTrace(e.getStackTrace());
    }

    public RestCallException(String msg, HttpResponse response) throws ParseException, IOException {
        super(String.format("%s%nstatus='%s'%nResponse: %n%s%n", msg, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)IOUtils.UTF8)));
    }

    public RestCallException(int responseCode, String responseMsg, String method, URI url, String response) {
        super(String.format("HTTP method '%s' call to '%s' caused response code '%s,%s'.%nResponse: %n%s%n", method, url, responseCode, responseMsg, response));
        this.responseCode = responseCode;
        this.responseStatusMessage = responseMsg;
        this.response = response;
    }

    protected RestCallException setServerException(Header exceptionName, Header exceptionMessage, Header exceptionTrace) {
        if (exceptionName != null) {
            this.serverExceptionName = exceptionName.getValue();
        }
        if (exceptionMessage != null) {
            this.serverExceptionMessage = exceptionMessage.getValue();
        }
        if (exceptionTrace != null) {
            this.serverExceptionTrace = exceptionTrace.getValue();
        }
        return this;
    }

    protected void throwServerException(ClassLoader cl) throws Throwable {
        if (this.serverExceptionName != null) {
            Throwable t = null;
            try {
                Class<?> exceptionClass = cl.loadClass(this.serverExceptionName);
                Constructor<?> c = ClassUtils.findPublicConstructor(exceptionClass, String.class);
                if (c != null) {
                    t = (Throwable)c.newInstance(this.serverExceptionMessage);
                }
                if (t == null && (c = ClassUtils.findPublicConstructor(exceptionClass, new Class[0])) != null) {
                    t = (Throwable)c.newInstance(new Object[0]);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (t != null) {
                throw t;
            }
        }
    }

    protected RestCallException setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.response;
    }

    public String getResponseStatusMessage() {
        return this.responseStatusMessage;
    }

    @Override
    public synchronized RestCallException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }
}

