/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PartType;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public final class RestResponse
extends HttpServletResponseWrapper {
    private final RestRequest request;
    private Object output;
    private boolean isNullOutput;
    private ObjectMap properties;
    SerializerGroup serializerGroup;
    UrlEncodingSerializer urlEncodingSerializer;
    private EncoderGroup encoders;
    private ServletOutputStream os;
    private PrintWriter w;

    RestResponse(RestContext context, RestRequest req, HttpServletResponse res) {
        super(res);
        this.request = req;
        for (Map.Entry<String, Object> e : context.getDefaultResponseHeaders().entrySet()) {
            this.setHeader(e.getKey(), e.getValue().toString());
        }
        try {
            String passThroughHeaders = req.getHeader("x-response-headers");
            if (passThroughHeaders != null) {
                UrlEncodingParser p = context.getUrlEncodingParser();
                ObjectMap m = p.parse(PartType.HEADER, passThroughHeaders, context.getBeanContext().getClassMeta(ObjectMap.class));
                for (Map.Entry<String, Object> e : m.entrySet()) {
                    this.setHeader(e.getKey(), e.getValue().toString());
                }
            }
        }
        catch (Exception e1) {
            throw new RestException(400, "Invalid format for header 'x-response-headers'.  Must be in URL-encoded format.", new Object[0]).initCause(e1);
        }
    }

    final void init(ObjectMap properties, String defaultCharset, SerializerGroup mSerializers, UrlEncodingSerializer mUrlEncodingSerializer, EncoderGroup encoders) {
        this.properties = properties;
        this.serializerGroup = mSerializers;
        this.urlEncodingSerializer = mUrlEncodingSerializer;
        this.encoders = encoders;
        String h = this.request.getHeader("accept-charset");
        String charset = null;
        if (h == null) {
            charset = defaultCharset;
        } else {
            for (MediaTypeRange r : MediaTypeRange.parse(h)) {
                if (!(r.getQValue().floatValue() > 0.0f)) continue;
                MediaType mt = r.getMediaType();
                if (mt.getType().equals("*")) {
                    charset = defaultCharset;
                } else if (Charset.isSupported(mt.getType())) {
                    charset = mt.getType();
                }
                if (charset != null) break;
            }
        }
        if (charset == null) {
            throw new RestException(406, "No supported charsets in header ''Accept-Charset'': ''{0}''", this.request.getHeader("Accept-Charset"));
        }
        super.setCharacterEncoding(charset);
    }

    public SerializerGroup getSerializerGroup() {
        return this.serializerGroup;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.serializerGroup.getSupportedMediaTypes();
    }

    public List<String> getSupportedEncodings() throws RestServletException {
        return this.encoders.getSupportedEncodings();
    }

    public RestResponse setOutput(Object output) {
        this.output = output;
        this.isNullOutput = output == null;
        return this;
    }

    public RestResponse setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public RestResponse setOutputs(Object ... output) {
        this.output = output;
        return this;
    }

    public Object getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null || this.isNullOutput;
    }

    public RestResponse sendPlainText(String text) throws IOException {
        this.setContentType("text/plain");
        this.getNegotiatedWriter().write(text);
        return this;
    }

    public ServletOutputStream getNegotiatedOutputStream() throws IOException {
        if (this.os == null) {
            Encoder encoder = null;
            String ae = this.request.getHeader("Accept-Encoding");
            if (ae != null && !ae.isEmpty()) {
                EncoderMatch match;
                EncoderMatch encoderMatch = match = this.encoders != null ? this.encoders.getEncoderMatch(ae) : null;
                if (match == null) {
                    if (ae.matches(".*(identity|\\*)\\s*;\\s*q\\s*=\\s*(0(?!\\.)|0\\.0).*")) {
                        throw new RestException(406, "Unsupported encoding in request header ''Accept-Encoding'': ''{0}''\n\tSupported codings: {1}", ae, this.encoders.getSupportedEncodings());
                    }
                } else {
                    encoder = match.getEncoder();
                    String encoding = match.getEncoding().toString();
                    if (!encoding.equals("identity")) {
                        this.setHeader("content-encoding", encoding);
                    }
                }
            }
            this.os = this.getOutputStream();
            if (encoder != null) {
                final OutputStream os2 = encoder.getOutputStream((OutputStream)this.os);
                this.os = new ServletOutputStream(){

                    public final void write(byte[] b, int off, int len) throws IOException {
                        os2.write(b, off, len);
                    }

                    public final void write(int b) throws IOException {
                        os2.write(b);
                    }

                    public final void flush() throws IOException {
                        os2.flush();
                    }

                    public final void close() throws IOException {
                        os2.close();
                    }

                    public boolean isReady() {
                        return true;
                    }

                    public void setWriteListener(WriteListener arg0) {
                        throw new NoSuchMethodError();
                    }
                };
            }
        }
        return this.os;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = super.getOutputStream();
        }
        return this.os;
    }

    public boolean getOutputStreamCalled() {
        return this.os != null;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getWriter(true);
    }

    public PrintWriter getDirectWriter(String contentType) throws IOException {
        this.setContentType(contentType);
        this.setHeader("x-content-type-options", "nosniff");
        return this.getWriter();
    }

    public PrintWriter getNegotiatedWriter() throws IOException {
        return this.getWriter(false);
    }

    private PrintWriter getWriter(boolean raw) throws IOException {
        if (this.w != null) {
            return this.w;
        }
        if (this.request.isPlainText()) {
            this.setHeader("Content-Type", "text/plain");
        }
        try {
            ServletOutputStream out = raw ? this.getOutputStream() : this.getNegotiatedOutputStream();
            this.w = new PrintWriter(new OutputStreamWriter((OutputStream)out, this.getCharacterEncoding()));
            return this.w;
        }
        catch (UnsupportedEncodingException e) {
            String ce = this.getCharacterEncoding();
            this.setCharacterEncoding("UTF-8");
            throw new RestException(406, "Unsupported charset in request header ''Accept-Charset'': ''{0}''", ce);
        }
    }

    public MediaType getMediaType() {
        return MediaType.forString(this.getContentType());
    }

    public void sendRedirect(String uri) throws IOException {
        char c;
        char c2 = c = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (c != '/' && uri.indexOf("://") == -1) {
            uri = this.request.getContextPath() + '/' + uri;
        }
        super.sendRedirect(uri);
    }

    public UrlEncodingSerializer getUrlEncodingSerializer() {
        return this.urlEncodingSerializer;
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            super.setContentType(value);
        } else {
            super.setHeader(name, value);
        }
    }

    public RestResponse setHtmlHeader(Object value) {
        return this.setProperty("HtmlDocSerializer.header", value);
    }

    public RestResponse setHtmlLinks(String[] value) {
        this.properties.put("HtmlDocSerializer.links.list", value);
        return this;
    }

    public RestResponse setHtmlNav(Object value) {
        this.properties.put("HtmlDocSerializer.nav", value);
        return this;
    }

    public RestResponse setHtmlAside(Object value) {
        this.properties.put("HtmlDocSerializer.aside", value);
        return this;
    }

    public RestResponse setHtmlFooter(Object value) {
        this.properties.put("HtmlDocSerializer.footer", value);
        return this;
    }

    public RestResponse setHtmlStyle(Object value) {
        this.properties.put("HtmlDocSerializer.style.list", value);
        return this;
    }

    public RestResponse setHtmlStylesheet(Object value) {
        this.properties.put("HtmlDocSerializer.stylesheet", value);
        return this;
    }

    public RestResponse setHtmlScript(Object value) {
        this.properties.put("HtmlDocSerializer.script.list", value);
        return this;
    }

    public RestResponse setHtmlNoWrap(boolean value) {
        this.properties.put("HtmlDocSerializer.nowrap", value);
        return this;
    }

    public RestResponse setHtmlNoResultsMessage(Object value) {
        this.properties.put("HtmlDocSerializer.noResultsMessage", value);
        return this;
    }

    public RestResponse setHtmlTemplate(Class<? extends HtmlDocTemplate> value) {
        this.properties.put("HtmlDocSerializer.template", value);
        return this;
    }

    public RestResponse setHtmlTemplate(HtmlDocTemplate value) {
        this.properties.put("HtmlDocSerializer.template", value);
        return this;
    }

    public void flushBuffer() throws IOException {
        if (this.w != null) {
            this.w.flush();
        }
        if (this.os != null) {
            this.os.flush();
        }
        super.flushBuffer();
    }
}

